/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.states;

import java.util.Arrays;
import java.util.function.Consumer;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.states.AnimationState;
import mchorse.bbs_mod.forms.states.AnimationStates;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.editors.states.UIAnimationStateList;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIKeybind;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.ui.utils.presets.UICopyPasteController;
import mchorse.bbs_mod.ui.utils.presets.UIPresetContextMenu;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.presets.PresetManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIAnimationStatesOverlayPanel
extends UIOverlayPanel {
    public UIList<AnimationState> list;
    public UIScrollView editor;
    public UITextbox id;
    public UIToggle main;
    public UIKeybind keybind;
    public UITrackpad duration;
    public UITrackpad fadeIn;
    public UITrackpad fadeOut;
    public UIToggle looping;
    public UITrackpad offset;
    protected AnimationStates states;
    protected AnimationState state;
    private Consumer<AnimationState> callback;
    private UICopyPasteController copyPasteController = new UICopyPasteController(PresetManager.ANIMATION_STATES, "_CopyAnimationStates").consumer((data, x, y) -> {
        AnimationState state = new AnimationState("");
        state.fromData(data);
        this.states.preNotify();
        this.states.add(state);
        this.states.sync();
        this.states.postNotify();
        this.pickItem(state, true);
        this.list.update();
    }).supplier(() -> {
        MapType map = this.list.getCurrentFirst().toData().asMap();
        map.remove("id");
        return map;
    }).canCopy(() -> !this.list.isDeselected());

    public UIAnimationStatesOverlayPanel(AnimationStates states, AnimationState current, Consumer<AnimationState> consumer) {
        super(UIKeys.FORMS_EDITOR_STATES_MANAGER_TITLE);
        this.states = states;
        this.callback = consumer;
        this.list = new UIAnimationStateList(l -> this.pickItem((AnimationState)l.get(0), false));
        this.list.context((ContextMenuManager menu) -> {
            menu.custom(new UIPresetContextMenu(this.copyPasteController).labels(UIKeys.FORMS_EDITOR_STATES_MANAGER_CONTEXT_COPY, UIKeys.FORMS_EDITOR_STATES_MANAGER_CONTEXT_PASTE));
            menu.action(Icons.ADD, UIKeys.FORMS_EDITOR_STATES_MANAGER_CONTEXT_ADD, this::addState);
            if (!this.list.getList().isEmpty()) {
                menu.action(Icons.REMOVE, UIKeys.FORMS_EDITOR_STATES_MANAGER_CONTEXT_REMOVE, 0xFF3333, this::removeState);
            }
        });
        this.list.background();
        this.id = new UITextbox(t -> this.state.customId.set(t));
        this.main = new UIToggle(UIKeys.FORMS_EDITOR_STATES_MANAGER_MAIN, b -> this.state.main.set(b.getValue()));
        this.keybind = new UIKeybind(keybind -> this.state.keybind.set(keybind.getMainKey()));
        this.keybind.single();
        this.duration = new UITrackpad(v -> this.state.duration.set(v.intValue())).integer().limit(0.0);
        this.fadeIn = new UITrackpad(v -> this.state.fadeIn.set(v.intValue())).integer().limit(0.0);
        this.fadeIn.tooltip(UIKeys.CAMERA_PANELS_ENVELOPES_START_D);
        this.fadeOut = new UITrackpad(v -> this.state.fadeOut.set(v.intValue())).integer().limit(0.0);
        this.fadeOut.tooltip(UIKeys.CAMERA_PANELS_ENVELOPES_END_D);
        this.looping = new UIToggle(UIKeys.FORMS_EDITOR_STATES_MANAGER_LOOPING, b -> this.state.looping.set(b.getValue()));
        this.offset = new UITrackpad(v -> this.state.offset.set(v.intValue())).integer().limit(0.0);
        this.offset.tooltip(UIKeys.FORMS_EDITOR_STATES_MANAGER_OFFSET);
        this.editor = UI.scrollView(UI.label(UIKeys.FORMS_EDITOR_STATES_MANAGER_ID), this.id, this.main, this.keybind, UI.label(UIKeys.FORMS_EDITOR_STATES_MANAGER_DURATION).marginTop(6), this.duration, UI.label(IKey.comp(Arrays.asList(UIKeys.CAMERA_PANELS_ENVELOPES_START_D, IKey.constant(" / "), UIKeys.CAMERA_PANELS_ENVELOPES_END_D))).marginTop(6), UI.row(this.fadeIn, this.fadeOut), this.looping.marginTop(6), this.offset);
        this.list.relative(this.content).w(120).h(1.0f);
        this.list.setList(states.getList());
        this.list.setCurrentScroll(current);
        this.editor.relative(this.content).x(120).w(1.0f, -120).h(1.0f).column(5).vertical().stretch().scroll().padding(10);
        this.content.add(this.editor, this.list);
        this.pickItem(this.list.getCurrentFirst(), false);
    }

    protected void addState() {
        this.pickItem(this.states.addState(), true);
        this.list.update();
    }

    protected void removeState() {
        int index = this.list.getIndex();
        this.states.removeState(index);
        this.pickItem(CollectionUtils.getSafe(this.list.getList(), Math.max(index - 1, 0)), true);
        this.list.update();
    }

    protected void pickItem(AnimationState state, boolean select) {
        this.state = state;
        if (this.callback != null) {
            this.callback.accept(state);
        }
        this.editor.setVisible(state != null);
        if (state != null) {
            this.fillData(state);
            if (select) {
                this.list.setCurrentScroll(state);
            }
            this.resize();
        } else {
            this.list.deselect();
        }
    }

    protected void fillData(AnimationState state) {
        this.id.setText((String)state.customId.get());
        this.main.setValue((Boolean)state.main.get());
        this.keybind.setKeyCombo(new KeyCombo(IKey.EMPTY, (Integer)state.keybind.get()));
        this.duration.setValue(((Integer)state.duration.get()).intValue());
        this.fadeIn.setValue(((Integer)state.fadeIn.get()).intValue());
        this.fadeOut.setValue(((Integer)state.fadeOut.get()).intValue());
        this.looping.setValue((Boolean)state.looping.get());
        this.offset.setValue(((Integer)state.offset.get()).intValue());
    }

    @Override
    public void applyUndoData(MapType data) {
        super.applyUndoData(data);
        int selected = data.getInt("selected");
        this.pickItem((AnimationState)CollectionUtils.getSafe(this.states.getList(), selected), true);
        this.list.update();
    }

    @Override
    public void collectUndoData(MapType data) {
        super.collectUndoData(data);
        data.putInt("selected", this.list.getIndex());
    }
}

