/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIStringOverlayPanel;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIStructureOverlayPanel
extends UIStringOverlayPanel {
    private UIIcon saveButton = new UIIcon(Icons.DOWNLOAD, b -> this.saveStructure());
    private String currentSelectedStructure = "";

    public UIStructureOverlayPanel(IKey title, Consumer<Link> callback) {
        super(title, true, UIStructureOverlayPanel.getStructureFiles(), str -> {
            if (callback != null) {
                callback.accept(str.isEmpty() ? null : Link.create(str));
            }
        }, UIStructureOverlayPanel.displayFormatter());
        this.saveButton.tooltip(IKey.raw("Guardar estructura"));
        this.icons.add((IUIElement)this.saveButton);
        this.updateSaveButtonVisibility();
    }

    @Override
    protected void accept(String string) {
        this.currentSelectedStructure = string;
        this.updateSaveButtonVisibility();
        super.accept(string);
    }

    /*
     * Unable to fully structure code
     */
    private void updateSaveButtonVisibility() {
        if (this.currentSelectedStructure.isEmpty()) ** GOTO lbl-1000
        if (UIStructureOverlayPanel.isFromWorld(this.currentSelectedStructure)) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        isWorldStructure = v0;
        this.saveButton.setVisible(isWorldStructure);
    }

    private void saveStructure() {
        if (this.currentSelectedStructure.isEmpty()) {
            return;
        }
        try {
            File assetsStructuresDir;
            Link sourceLink = Link.create(this.currentSelectedStructure);
            File sourceFile = BBSMod.getProvider().getFile(sourceLink);
            if (sourceFile == null || !sourceFile.exists()) {
                System.err.println("[BBS] No se pudo encontrar el archivo fuente: " + this.currentSelectedStructure);
                return;
            }
            String fileName = sourceLink.path;
            if (fileName.startsWith("structures/")) {
                fileName = fileName.substring("structures/".length());
            }
            if (!(assetsStructuresDir = new File(BBSMod.getAssetsFolder(), "structures")).exists()) {
                assetsStructuresDir.mkdirs();
            }
            File destFile = new File(assetsStructuresDir, fileName);
            Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            System.out.println("[BBS] Estructura guardada: " + sourceFile.getAbsolutePath() + " -> " + destFile.getAbsolutePath());
            this.strings.list.clear();
            this.strings.list.add(UIStructureOverlayPanel.getStructureFiles());
            this.strings.list.sort();
            this.strings.list.update();
        }
        catch (IOException e) {
            System.err.println("[BBS] Error al guardar estructura: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean isFromWorld(String linkString) {
        if (linkString == null || linkString.isEmpty()) {
            return false;
        }
        try {
            Link link = Link.create(linkString);
            File worldFolder = BBSMod.getWorldFolder();
            if (worldFolder == null) {
                return false;
            }
            String rel = link.path.substring("structures/".length());
            File candidate1 = new File(worldFolder, "generated/minecraft/structures/" + rel);
            File candidate2 = new File(worldFolder, "generated/structures/" + rel);
            return candidate1.exists() || candidate2.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Function<String, String> displayFormatter() {
        return s -> {
            String name;
            if (s == null || s.isEmpty()) {
                return s;
            }
            int slash = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
            String string = name = slash >= 0 ? s.substring(slash + 1) : s;
            if (name.toLowerCase().endsWith(".nbt")) {
                name = name.substring(0, name.length() - 4);
            }
            return "structures/" + name;
        };
    }

    private static Set<String> getStructureFiles() {
        HashSet<String> locations = new HashSet<String>();
        try {
            for (Link link : BBSMod.getProvider().getLinksFromPath(Link.assets("structures"))) {
                String pathLower = link.path.toLowerCase();
                if (!pathLower.endsWith(".nbt")) continue;
                locations.add(link.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return locations;
    }
}

