/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.buttons;

import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIClickable;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.framework.elements.utils.ITextColoring;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIToggle
extends UIClickable<UIToggle>
implements ITextColoring {
    public IKey label;
    public int color = -1;
    public boolean textShadow = true;
    private boolean value;

    public UIToggle(IKey label, Consumer<UIToggle> callback) {
        this(label, false, callback);
    }

    public UIToggle(IKey label, boolean value, Consumer<UIToggle> callback) {
        super(callback);
        this.label = label;
        this.value = value;
        this.h(14);
    }

    @Override
    public void setColor(int color, boolean shadow) {
        this.color(color, shadow);
    }

    public UIToggle label(IKey label) {
        this.label = label;
        return this;
    }

    public UIToggle setValue(boolean value) {
        this.value = value;
        return this;
    }

    public UIToggle color(int color) {
        return this.color(color, true);
    }

    public UIToggle color(int color, boolean textShadow) {
        this.color = color;
        this.textShadow = textShadow;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    protected void click(int mouseWheel) {
        this.value = !this.value;
        super.click(mouseWheel);
    }

    @Override
    protected UIToggle get() {
        return this;
    }

    @Override
    protected void renderSkin(UIContext context) {
        FontRenderer font = context.batcher.getFont();
        String label = font.limitToWidth(this.label.get(), this.area.w - 18);
        context.batcher.text(label, this.area.x, this.area.my(font.getHeight()), this.color, this.textShadow);
        int w = 16;
        int h = 10;
        int x = this.area.ex() - w - 2;
        int y = this.area.my();
        int color = (Integer)BBSSettings.primaryColor.get();
        if (this.hover) {
            color = Colors.mulRGB(color, 0.85f);
        }
        context.batcher.box(x, y - h / 2, x + w, y - h / 2 + h, -16777216);
        context.batcher.box(x + 1, y - h / 2 + 1, x + w - 1, y - h / 2 + h - 1, 0xFF000000 | (this.value ? color : (this.hover ? 0x3A3A3A : 0x444444)));
        if (this.value) {
            context.batcher.gradientHBox(x + 1, y - h / 2 + 1, x + w / 2, y - h / 2 + h - 1, Colors.setA(-1, 0.33f), Colors.setA(-1, 0.0f));
        } else {
            context.batcher.gradientHBox(x + w / 2, y - h / 2 + 1, x + w - 1, y - h / 2 + h - 1, 0, -2013265920);
        }
        if (!this.isEnabled()) {
            context.batcher.box(x, y - h / 2, x + w, y - h / 2 + h, -2013265920);
        }
        context.batcher.box((x += this.value ? w - 2 : 2) - 4, y - 8, x + 4, y + 8, -16777216);
        context.batcher.box(x - 3, y - 7, x + 3, y + 7, -1);
        context.batcher.box(x - 2, y - 6, x + 3, y + 7, -7829368);
        context.batcher.box(x - 2, y - 6, x + 2, y + 6, -5592406);
        if (!this.isEnabled()) {
            context.batcher.box(x - 4, y - 8, x + 4, y + 8, -2013265920);
            context.batcher.outlinedIcon(Icons.LOCKED, this.area.ex() - w / 2 - 2, y, 0.5f, 0.5f);
        }
    }
}

