/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input;

import java.util.function.Consumer;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.color.UIColorPicker;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.utils.Direction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIColor
extends UIElement {
    public UIColorPicker picker;
    public boolean label = true;
    public Direction direction;
    private UIElement target;

    public UIColor(Consumer<Integer> callback) {
        this.picker = new UIColorPicker(callback);
        this.picker.wh(200, 85);
        this.direction(Direction.BOTTOM).h(20);
    }

    public UIColor withTarget(UIElement target) {
        this.target = target;
        return this;
    }

    public UIColor withAlpha() {
        this.picker.editAlpha();
        return this;
    }

    public UIColor direction(Direction direction) {
        this.direction = direction;
        this.picker.anchor(1.0f - direction.anchorX, 1.0f - direction.anchorY);
        return this;
    }

    public UIColor onTop() {
        return this.direction(Direction.TOP);
    }

    public UIColor noLabel() {
        this.label = false;
        return this;
    }

    public void setColor(int color) {
        this.picker.setColor(color);
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.area.isInside(context) && context.mouseButton == 0) {
            if (!this.picker.hasParent()) {
                int x = context.globalX(this.area.x(this.direction.anchorX) + 2 * this.direction.factorX);
                int y = context.globalY(this.area.y(this.direction.anchorY) + 2 * this.direction.factorY);
                UIElement target = this.target == null ? context.menu.overlay : this.target;
                target.add((IUIElement)this.picker);
                this.picker.setup(x, y);
                this.picker.bounds(context.menu.main, 2);
                this.picker.resize();
            } else {
                this.picker.removeFromParent();
            }
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    public void render(UIContext context) {
        int padding = 0;
        this.picker.renderRect(context.batcher, this.area.x, this.area.y, this.area.ex(), this.area.ey());
        if (this.area.isInside(context)) {
            this.area.render(context.batcher, 0x22000000, padding);
        }
        if (this.label) {
            FontRenderer font = context.batcher.getFont();
            String label = this.picker.color.stringify(this.picker.editAlpha);
            context.batcher.textCard(label, this.area.mx(font.getWidth(label)), this.area.my(font.getHeight() - 1), -1, 0x44000000, 1.0f);
        }
        this.renderLockedArea(context);
        super.render(context);
    }
}

