/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIIntegerKeyframeFactory
extends UIKeyframeFactory<Integer> {
    private UITrackpad value = new UITrackpad(this::setValue).integer();
    private UITrackpad lx = new UITrackpad(v -> BaseValue.edit(this.keyframe, kf -> {
        kf.lx = v.floatValue();
    }));
    private UITrackpad ly = new UITrackpad(v -> BaseValue.edit(this.keyframe, kf -> {
        kf.ly = v.floatValue();
    }));
    private UITrackpad rx = new UITrackpad(v -> BaseValue.edit(this.keyframe, kf -> {
        kf.rx = v.floatValue();
    }));
    private UITrackpad ry = new UITrackpad(v -> BaseValue.edit(this.keyframe, kf -> {
        kf.ry = v.floatValue();
    }));

    public UIIntegerKeyframeFactory(Keyframe<Integer> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        this.value.setValue(keyframe.getValue().intValue());
        this.lx.setValue(keyframe.lx);
        this.ly.setValue(keyframe.ly);
        this.rx.setValue(keyframe.rx);
        this.ry.setValue(keyframe.ry);
        this.scroll.add(this.value, UI.row(new UIIcon(Icons.LEFT_HANDLE, null).tooltip(UIKeys.KEYFRAMES_LEFT_HANDLE), this.lx, this.ly), UI.row(new UIIcon(Icons.RIGHT_HANDLE, null).tooltip(UIKeys.KEYFRAMES_RIGHT_HANDLE), this.rx, this.ry));
    }

    @Override
    public void update() {
        super.update();
        this.value.setValue(((Integer)this.keyframe.getValue()).intValue());
        this.lx.setValue(this.keyframe.lx);
        this.ly.setValue(this.keyframe.ly);
        this.rx.setValue(this.keyframe.rx);
        this.ry.setValue(this.keyframe.ry);
    }
}

