/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.utils;

import java.util.function.Consumer;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.utils.Scroll;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIDraggable
extends UIElement {
    private Consumer<UIContext> callback;
    private Consumer<UIContext> render;
    private boolean dragging;
    private boolean hover;

    public UIDraggable(Consumer<UIContext> callback) {
        this.callback = callback;
    }

    public UIDraggable hoverOnly() {
        this.hover = true;
        return this;
    }

    public UIDraggable rendering(Consumer<UIContext> render) {
        this.render = render;
        return this;
    }

    @Override
    protected boolean subMouseClicked(UIContext context) {
        if (this.area.isInside(context) && context.mouseButton == 0) {
            this.dragging = true;
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    protected boolean subMouseReleased(UIContext context) {
        this.dragging = false;
        return super.subMouseReleased(context);
    }

    @Override
    public void render(UIContext context) {
        super.render(context);
        if (!this.hover || this.area.isInside(context) || this.dragging) {
            if (this.render != null) {
                this.render.accept(context);
            } else {
                Scroll.bar(context.batcher, this.area.x, this.area.y, this.area.ex(), this.area.ey(), -2013265920);
            }
        }
        if (this.dragging && this.callback != null) {
            this.callback.accept(context);
        }
    }
}

