/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.utils;

import mchorse.bbs_mod.math.Constant;
import mchorse.bbs_mod.math.molang.expressions.MolangValue;
import mchorse.bbs_mod.particles.components.appearance.colors.Gradient;
import mchorse.bbs_mod.particles.components.appearance.colors.Solid;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UIColor;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSection;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIGradientEditor
extends UIElement {
    private UIParticleSchemeSection section;
    private UIColor color;
    private Gradient gradient;
    private Gradient.ColorStop current;
    private int dragging = -1;
    private int lastX;
    private Area a = new Area();
    private Area b = new Area();
    private Color c = new Color();

    public UIGradientEditor(UIParticleSchemeSection section, UIColor color) {
        this.section = section;
        this.color = color;
        this.context((ContextMenuManager menu) -> {
            menu.action(Icons.ADD, UIKeys.SNOWSTORM_LIGHTING_CONTEXT_ADD_STOP, this::addColorStop);
            if (this.gradient.stops.size() > 1) {
                menu.action(Icons.REMOVE, UIKeys.SNOWSTORM_LIGHTING_CONTEXT_REMOVE_STOP, this::removeColorStop);
            }
        });
        this.h(20);
    }

    private Color fillColor(Solid solid) {
        this.c.r = (float)solid.r.get();
        this.c.g = (float)solid.g.get();
        this.c.b = (float)solid.b.get();
        this.c.a = (float)solid.a.get();
        return this.c;
    }

    private Area fillBound(Gradient.ColorStop stop) {
        int x = this.a.x(stop.stop / this.gradient.range);
        this.b.set(x - 3, this.a.ey() - 7, 6, 10);
        return this.b;
    }

    private void fillStop(Gradient.ColorStop stop) {
        this.current = stop;
        this.color.setColor(this.fillColor(stop.color).getARGBColor());
    }

    public void setColor(int color) {
        this.c.set(color);
        ((MolangValue)this.current.color.r).expression.set(this.c.r);
        ((MolangValue)this.current.color.g).expression.set(this.c.g);
        ((MolangValue)this.current.color.b).expression.set(this.c.b);
        ((MolangValue)this.current.color.a).expression.set(this.c.a);
    }

    public void setGradient(Gradient gradient) {
        this.gradient = gradient;
        if (this.gradient.stops.isEmpty()) {
            this.gradient.stops.add(new Gradient.ColorStop(0.0f, new Solid()));
        }
        this.fillStop(this.gradient.stops.get(0));
        this.color.setColor(this.fillColor(this.current.color).getARGBColor());
    }

    private void addColorStop() {
        float x = (float)(this.getContext().mouseX - this.area.x) / (float)this.area.w * this.gradient.range;
        x = MathUtils.clamp(x, 0.0f, this.gradient.range);
        Solid color = new Solid();
        Gradient.ColorStop stop = new Gradient.ColorStop(x, color);
        color.r = new MolangValue(null, new Constant(1.0));
        color.g = new MolangValue(null, new Constant(1.0));
        color.b = new MolangValue(null, new Constant(1.0));
        color.a = new MolangValue(null, new Constant(1.0));
        this.gradient.stops.add(stop);
        this.gradient.sort();
        this.fillStop(stop);
    }

    private void removeColorStop() {
        int index = this.gradient.stops.indexOf(this.current);
        this.gradient.stops.remove(index);
        index = MathUtils.clamp(index, 0, this.gradient.stops.size() - 1);
        this.fillStop(this.gradient.stops.get(index));
    }

    @Override
    public void resize() {
        super.resize();
        this.a.copy(this.area);
        this.a.offset(-1);
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        Area outside = new Area();
        outside.copy(this.area);
        outside.offset(5);
        if (outside.isInside(context) && context.mouseButton == 0) {
            for (Gradient.ColorStop stop : this.gradient.stops) {
                Area area = this.fillBound(stop);
                if (!area.isInside(context)) continue;
                this.dragging = 0;
                this.lastX = context.mouseX;
                this.fillStop(stop);
                return true;
            }
            return true;
        }
        return super.subMouseClicked(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        if (this.dragging != -1) {
            this.section.dirty();
        }
        this.dragging = -1;
        return super.subMouseReleased(context);
    }

    @Override
    public void render(UIContext context) {
        int i;
        if (this.dragging == 0 && Math.abs(context.mouseX - this.lastX) > 3) {
            this.dragging = 1;
        } else if (this.dragging == 1) {
            float x = (float)(context.mouseX - this.area.x) / (float)this.area.w * this.gradient.range;
            this.current.stop = MathUtils.clamp(x, 0.0f, this.gradient.range);
            this.gradient.sort();
        }
        this.area.render(context.batcher, -16777216);
        int size = this.gradient.stops.size();
        context.batcher.iconArea(Icons.CHECKBOARD, this.a.x, this.a.y, this.a.w, this.a.h);
        Gradient.ColorStop first = this.gradient.stops.get(0);
        if (first.stop > 0.0f) {
            int x1 = this.a.x(first.stop / this.gradient.range);
            int rgba1 = this.fillColor(first.color).getARGBColor();
            context.batcher.box(this.a.x, this.a.y, x1, this.a.ey(), rgba1);
        }
        for (i = 0; i < size; ++i) {
            Gradient.ColorStop stop = this.gradient.stops.get(i);
            Gradient.ColorStop next = i + 1 < size ? this.gradient.stops.get(i + 1) : stop;
            int x1 = this.a.x(stop.stop / this.gradient.range);
            int x2 = this.a.x((next == stop ? this.gradient.range : next.stop) / this.gradient.range);
            int rgba1 = this.fillColor(stop.color).getARGBColor();
            int rgba2 = this.fillColor(next.color).getARGBColor();
            context.batcher.gradientHBox(x1, this.a.y, x2, this.a.ey(), rgba1, rgba2);
        }
        for (i = 0; i < size; ++i) {
            Gradient.ColorStop stop = this.gradient.stops.get(i);
            Area area = this.fillBound(stop);
            int handleColor = this.fillColor(stop.color).getARGBColor();
            context.batcher.box(area.x, area.y, area.ex(), area.ey(), this.current == stop ? -1 : -16777216);
            context.batcher.box(area.x + 1, area.y + 1, area.ex() - 1, area.ey() - 1, handleColor);
        }
        super.render(context);
    }
}

