/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.clips;

import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.interps.Interpolation;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.interps.Lerps;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;

public class Envelope
extends ValueGroup {
    public final ValueBoolean enabled = new ValueBoolean("enabled");
    public final ValueInt mode = new ValueInt("mode", 0, 0, 2);
    public final ValueFloat fadeIn = new ValueFloat("fadeIn", Float.valueOf(10.0f));
    public final ValueFloat fadeOut = new ValueFloat("fadeOut", Float.valueOf(10.0f));
    public final Interpolation pre = new Interpolation("pre", Interpolations.MAP);
    public final Interpolation post = new Interpolation("post", Interpolations.MAP);
    public final ValueBoolean keyframes = new ValueBoolean("keyframes");
    public final KeyframeChannel<Double> channel = new KeyframeChannel<Double>("channel", KeyframeFactories.DOUBLE);

    public Envelope(String id) {
        super(id);
        this.add(this.enabled);
        this.add(this.mode);
        this.add(this.fadeIn);
        this.add(this.fadeOut);
        this.add(this.pre);
        this.add(this.post);
        this.add(this.keyframes);
        this.add(this.channel);
        this.channel.insert(0.0f, 0.0);
        this.channel.insert(BBSSettings.getDefaultDuration(), 1.0);
    }

    public float getStartX(int duration) {
        return 0.0f;
    }

    public float getStartDuration(int duration) {
        if ((Integer)this.mode.get() == 1) {
            return ((Float)this.fadeIn.get()).floatValue() <= 0.0f ? (float)duration : ((Float)this.fadeIn.get()).floatValue();
        }
        if ((Integer)this.mode.get() == 2) {
            return 0.0f;
        }
        return ((Float)this.fadeIn.get()).floatValue();
    }

    public float getEndX(int duration) {
        return duration;
    }

    public float getEndDuration(int duration) {
        if ((Integer)this.mode.get() == 1) {
            return duration;
        }
        if ((Integer)this.mode.get() == 2) {
            return (float)duration - (((Float)this.fadeOut.get()).floatValue() <= 0.0f ? (float)duration : ((Float)this.fadeOut.get()).floatValue());
        }
        return (float)duration - ((Float)this.fadeOut.get()).floatValue();
    }

    public float factorEnabled(int duration, float tick) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return 1.0f;
        }
        return this.factor(duration, tick);
    }

    public float factor(int duration, float tick) {
        float envelope = 0.0f;
        if (((Boolean)this.keyframes.get()).booleanValue()) {
            if (!this.channel.isEmpty()) {
                envelope = this.channel.interpolate(tick).floatValue();
            }
        } else {
            float lowOut = this.getStartDuration(duration);
            envelope = Lerps.envelope(tick, this.getStartX(duration), lowOut, this.getEndDuration(duration), this.getEndX(duration));
            envelope = (float)(tick <= lowOut ? this.pre : this.post).interpolate(IInterp.context.set(0.0, 1.0, envelope));
        }
        return envelope;
    }

    public void breakDown(Clip original, int offset) {
        this.fadeIn.set(Float.valueOf(0.0f));
        original.envelope.fadeOut.set(Float.valueOf(0.0f));
        this.channel.moveX(-offset);
    }

    @Override
    public void fromData(BaseType data) {
        MapType map;
        super.fromData(data);
        if (data.isMap() && (map = data.asMap()).has("interpolation")) {
            BaseType interpolation = map.get("interpolation");
            this.pre.fromData(interpolation);
            this.post.fromData(interpolation);
        }
    }
}

