/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.iris;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.internal.Strings;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.graphics.texture.TextureManager;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.DataPath;
import mchorse.bbs_mod.utils.iris.IrisTextureWrapper;
import mchorse.bbs_mod.utils.iris.IrisTextureWrapperLoader;
import mchorse.bbs_mod.utils.iris.ShaderCurves;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.shaderpack.LanguageMap;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.option.menu.OptionMenuContainer;
import net.irisshaders.iris.shaderpack.option.menu.OptionMenuElement;
import net.irisshaders.iris.shaderpack.option.menu.OptionMenuElementScreen;
import net.irisshaders.iris.shaderpack.option.menu.OptionMenuLinkElement;
import net.irisshaders.iris.shaderpack.option.menu.OptionMenuOptionElement;
import net.irisshaders.iris.shaderpack.properties.ShaderProperties;
import net.irisshaders.iris.uniforms.custom.cached.CachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.FloatCachedUniform;
import net.irisshaders.iris.uniforms.custom.cached.IntCachedUniform;
import net.irisshaders.iris.vertices.NormI8;
import net.irisshaders.iris.vertices.NormalHelper;
import net.irisshaders.iris.vertices.views.TriView;
import net.minecraft.class_1044;

@Environment(value=EnvType.CLIENT)
public class IrisUtils {
    private static Set<Texture> textureSet = new HashSet<Texture>();
    private static ShaderProperties properties;

    public static void setShaderProperties(ShaderProperties shaderProperties) {
        properties = shaderProperties;
    }

    public static List<String> getSliderProperties() {
        return properties == null ? Collections.emptyList() : properties.getSliderOptions();
    }

    public static Map<String, String> getShadersLanguageMap(String language) {
        if (Iris.getCurrentPack().isPresent()) {
            HashMap<String, String> map = new HashMap<String, String>();
            ShaderPack shaderPack = (ShaderPack)Iris.getCurrentPack().get();
            LanguageMap languageMap = shaderPack.getLanguageMap();
            Map target = languageMap.getTranslations(language);
            Map fallback = languageMap.getTranslations("en_us");
            String prefix = "option.";
            HashMap<String, DataPath> pathMap = new HashMap<String, DataPath>();
            IrisUtils.collectPaths(pathMap, shaderPack.getMenuContainer(), shaderPack.getMenuContainer().mainScreen, Collections.emptyList());
            IrisUtils.fillInPaths(map, fallback, pathMap, "option.");
            IrisUtils.fillInPaths(map, target, pathMap, "option.");
            return map;
        }
        return Collections.emptyMap();
    }

    private static void fillInPaths(Map<String, String> map, Map<String, String> language, Map<String, DataPath> pathMap, String prefix) {
        if (language == null) {
            return;
        }
        for (Map.Entry<String, String> entry : language.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            String optionId = entry.getKey().substring(prefix.length());
            DataPath path = pathMap.get(optionId);
            String value = entry.getValue();
            if (path != null) {
                ArrayList<String> translations = new ArrayList<String>();
                int c = path.strings.size();
                for (int i = 0; i < c; ++i) {
                    String string = path.strings.get(i);
                    if (i == c - 1) {
                        translations.add(value);
                        continue;
                    }
                    translations.add(language.getOrDefault("screen." + string, string));
                }
                value = Strings.join(translations, (String)" > ");
            }
            map.put(entry.getKey(), value);
        }
    }

    private static void collectPaths(Map<String, DataPath> pathMap, OptionMenuContainer container, OptionMenuElementScreen mainScreen, List<String> prefix) {
        for (OptionMenuElement element : mainScreen.elements) {
            if (element instanceof OptionMenuOptionElement) {
                OptionMenuOptionElement option = (OptionMenuOptionElement)element;
                ArrayList<String> strings = new ArrayList<String>(prefix);
                strings.add(option.optionId);
                pathMap.put(option.optionId, new DataPath(strings));
                continue;
            }
            if (!(element instanceof OptionMenuLinkElement)) continue;
            OptionMenuLinkElement link = (OptionMenuLinkElement)element;
            OptionMenuElementScreen screen = (OptionMenuElementScreen)container.subScreens.get(link.targetScreenId);
            if (screen == null) continue;
            ArrayList<String> strings = new ArrayList<String>(prefix);
            strings.add(link.targetScreenId);
            IrisUtils.collectPaths(pathMap, container, screen, strings);
        }
    }

    public static void setup() {
        try {
            Method acceptSpecular;
            Method acceptNormal;
            Class<?> pbrTypeClass;
            Class<?> loaderInterface;
            Class<?> registryClass;
            try {
                registryClass = Class.forName("net.irisshaders.iris.pbr.loader.PBRTextureLoaderRegistry");
                loaderInterface = Class.forName("net.irisshaders.iris.pbr.loader.PBRTextureLoader");
            }
            catch (ClassNotFoundException e) {
                registryClass = Class.forName("net.irisshaders.iris.texture.pbr.loader.PBRTextureLoaderRegistry");
                loaderInterface = Class.forName("net.irisshaders.iris.texture.pbr.loader.PBRTextureLoader");
            }
            Object registryInstance = registryClass.getField("INSTANCE").get(null);
            Method register = registryClass.getMethod("register", Class.class, loaderInterface);
            try {
                pbrTypeClass = Class.forName("net.irisshaders.iris.pbr.texture.PBRType");
            }
            catch (ClassNotFoundException e1) {
                try {
                    pbrTypeClass = Class.forName("net.irisshaders.iris.pbr.PBRType");
                }
                catch (ClassNotFoundException e2) {
                    pbrTypeClass = Class.forName("net.irisshaders.iris.texture.pbr.PBRType");
                }
            }
            Class<?> singleColorClass = Class.forName("net.irisshaders.iris.targets.backed.NativeImageBackedSingleColorTexture");
            Method loadMethod = null;
            for (Method m2 : loaderInterface.getMethods()) {
                if (!m2.getName().equals("load") || m2.getParameterTypes().length != 3) continue;
                loadMethod = m2;
                break;
            }
            Method finalLoadMethod = loadMethod;
            Class<?> consumerClass = loadMethod != null ? loadMethod.getParameterTypes()[2] : null;
            Method acceptGeneric = null;
            if (consumerClass != null) {
                Method aNormal = null;
                Method aSpec = null;
                for (Method mth : consumerClass.getMethods()) {
                    Class<?>[] pts = mth.getParameterTypes();
                    if (pts.length == 1 && class_1044.class.isAssignableFrom(pts[0])) {
                        String nm = mth.getName().toLowerCase();
                        if (nm.contains("normal")) {
                            aNormal = mth;
                        }
                        if (!nm.contains("specular")) continue;
                        aSpec = mth;
                        continue;
                    }
                    if (pts.length != 2 || !pts[0].isEnum() || !class_1044.class.isAssignableFrom(pts[1])) continue;
                    acceptGeneric = mth;
                }
                acceptNormal = aNormal;
                acceptSpecular = aSpec;
            } else {
                acceptNormal = null;
                acceptSpecular = null;
            }
            Method getDefaultValue = pbrTypeClass.getMethod("getDefaultValue", new Class[0]);
            Enum normalEnum = Enum.valueOf(pbrTypeClass.asSubclass(Enum.class), "NORMAL");
            Enum specularEnum = Enum.valueOf(pbrTypeClass.asSubclass(Enum.class), "SPECULAR");
            Object[] defaults = new Object[2];
            Method finalAcceptGeneric = acceptGeneric;
            Object proxy = Proxy.newProxyInstance(loaderInterface.getClassLoader(), new Class[]{loaderInterface}, (p, m, args) -> {
                if (finalLoadMethod != null && m.getName().equals("load") && args != null && args.length == 3) {
                    Object textureObj = args[0];
                    Object consumer = args[2];
                    if (defaults[0] == null || defaults[1] == null) {
                        Object normalDefault = getDefaultValue.invoke(normalEnum, new Object[0]);
                        Object specDefault = getDefaultValue.invoke(specularEnum, new Object[0]);
                        Constructor<?> chosenN = null;
                        Constructor<?> chosenS = null;
                        for (Constructor<?> c : singleColorClass.getConstructors()) {
                            Class<?>[] pt = c.getParameterTypes();
                            if (pt.length != 1) continue;
                            if (chosenN == null) {
                                chosenN = c;
                            }
                            if (chosenS != null) continue;
                            chosenS = c;
                        }
                        defaults[0] = chosenN != null ? chosenN.newInstance(normalDefault) : null;
                        Object object = defaults[1] = chosenS != null ? (Object)chosenS.newInstance(specDefault) : null;
                    }
                    if (textureObj instanceof IrisTextureWrapper) {
                        IrisTextureWrapper wrapper = (IrisTextureWrapper)((Object)((Object)textureObj));
                        IrisTextureWrapperLoader helper = new IrisTextureWrapperLoader();
                        Link normalKey = helper.createPrefixedCopy(wrapper.texture, "_n.png");
                        Link specularKey = helper.createPrefixedCopy(wrapper.texture, "_s.png");
                        IrisTextureWrapper normalWrapper = new IrisTextureWrapper(normalKey, (class_1044)defaults[0], wrapper.index);
                        IrisTextureWrapper specWrapper = new IrisTextureWrapper(specularKey, (class_1044)defaults[1], wrapper.index);
                        if (acceptNormal != null) {
                            acceptNormal.invoke(consumer, new Object[]{normalWrapper});
                        }
                        if (acceptSpecular != null) {
                            acceptSpecular.invoke(consumer, new Object[]{specWrapper});
                        }
                        if (finalAcceptGeneric != null) {
                            finalAcceptGeneric.invoke(consumer, new Object[]{normalEnum, normalWrapper});
                            finalAcceptGeneric.invoke(consumer, new Object[]{specularEnum, specWrapper});
                        }
                    }
                    return null;
                }
                return null;
            });
            register.invoke(registryInstance, IrisTextureWrapper.class, proxy);
        }
        catch (Throwable t) {
            System.err.println("[BBS] PBRTextureLoader registration failed; wrappers disabled: " + String.valueOf(t));
        }
    }

    public static void trackTexture(Texture texture) {
        TextureManager textures = BBSModClient.getTextures();
        Texture error = textures.getError();
        if (texture != error && !textureSet.contains(texture)) {
            Link key = CollectionUtils.getKey(textures.textures, texture);
            if (key == null && texture.getParent() != null) {
                key = CollectionUtils.getKey(textures.animatedTextures, texture.getParent());
            }
            if (key != null) {
                int index = -1;
                if (texture.getParent() != null) {
                    index = texture.getParent().textures.indexOf(texture);
                }
                try {
                    Class<?>[] p;
                    Class<?> trackerClass;
                    try {
                        trackerClass = Class.forName("net.irisshaders.iris.pbr.TextureTracker");
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            trackerClass = Class.forName("net.irisshaders.iris.texture.TextureTracker");
                        }
                        catch (ClassNotFoundException e2) {
                            trackerClass = Class.forName("net.irisshaders.iris.texture.tracking.TextureTracker");
                        }
                    }
                    Object tracker = trackerClass.getField("INSTANCE").get(null);
                    Method trackMethod = null;
                    for (Method m : trackerClass.getMethods()) {
                        p = m.getParameterTypes();
                        if (!m.getName().equals("trackTexture") || p.length != 2 || p[0] != Integer.TYPE) continue;
                        trackMethod = m;
                        break;
                    }
                    if (trackMethod == null) {
                        for (Method m : trackerClass.getDeclaredMethods()) {
                            p = m.getParameterTypes();
                            if (!m.getName().equals("trackTexture") || p.length != 2 || p[0] != Integer.TYPE) continue;
                            trackMethod = m;
                            break;
                        }
                    }
                    if (trackMethod != null) {
                        trackMethod.invoke(tracker, new Object[]{texture.id, new IrisTextureWrapper(key, index)});
                    }
                }
                catch (Throwable t) {
                    System.err.println("[BBS] TextureTracker not available or changed; skipping tracking: " + String.valueOf(t));
                }
            }
            textureSet.add(texture);
        }
    }

    public static boolean isShaderPackEnabled() {
        return IrisApi.getInstance().isShaderPackInUse();
    }

    public static boolean isShadowPass() {
        return IrisApi.getInstance().isRenderingShadowPass();
    }

    public static float[] calculateTangents(float[] v, float[] n, float[] u) {
        int max;
        int min = Math.min(v.length / 9, Math.min(u.length / 6, n.length / 9));
        if (min != (max = Math.max(v.length / 9, Math.max(u.length / 6, n.length / 9)))) {
            return v;
        }
        return IrisUtils.calculateTangents(new float[v.length / 3 * 4], v, n, u);
    }

    public static float[] calculateTangents(float[] t, float[] v, float[] n, float[] u) {
        int max;
        int min = Math.min(v.length / 9, Math.min(u.length / 6, n.length / 9));
        if (min != (max = Math.max(v.length / 9, Math.max(u.length / 6, n.length / 9)))) {
            return t;
        }
        SuperTriangle triangle = new SuperTriangle();
        int c = v.length / 9;
        for (int i = 0; i < c; ++i) {
            int ot = i * 12;
            int oi = i * 9;
            int ou = i * 6;
            float x0 = v[oi + 0];
            float y0 = v[oi + 1];
            float z0 = v[oi + 2];
            float u0 = u[ou + 0];
            float v0 = u[ou + 1];
            float x1 = v[oi + 3];
            float y1 = v[oi + 4];
            float z1 = v[oi + 5];
            float u1 = u[ou + 2];
            float v1 = u[ou + 3];
            float x2 = v[oi + 6];
            float y2 = v[oi + 7];
            float z2 = v[oi + 7];
            float u2 = u[ou + 4];
            float v2 = u[ou + 5];
            int t1 = NormalHelper.computeTangent((float)n[oi + 0], (float)n[oi + 1], (float)n[oi + 2], (TriView)triangle.set(x0, y0, z0, u0, v0, x1, y1, z1, u1, v1, x2, y2, z2, u2, v2));
            int t2 = NormalHelper.computeTangent((float)n[oi + 3], (float)n[oi + 4], (float)n[oi + 5], (TriView)triangle.set(x0, y0, z0, u0, v0, x1, y1, z1, u1, v1, x2, y2, z2, u2, v2));
            int t3 = NormalHelper.computeTangent((float)n[oi + 6], (float)n[oi + 7], (float)n[oi + 8], (TriView)triangle.set(x0, y0, z0, u0, v0, x1, y1, z1, u1, v1, x2, y2, z2, u2, v2));
            t[ot + 0] = NormI8.unpackX((int)t1);
            t[ot + 1] = NormI8.unpackY((int)t1);
            t[ot + 2] = NormI8.unpackZ((int)t1);
            t[ot + 3] = NormI8.unpackW((int)t1);
            t[ot + 4] = NormI8.unpackX((int)t2);
            t[ot + 5] = NormI8.unpackY((int)t2);
            t[ot + 6] = NormI8.unpackZ((int)t2);
            t[ot + 7] = NormI8.unpackW((int)t2);
            t[ot + 8] = NormI8.unpackX((int)t3);
            t[ot + 9] = NormI8.unpackY((int)t3);
            t[ot + 10] = NormI8.unpackZ((int)t3);
            t[ot + 11] = NormI8.unpackW((int)t3);
        }
        return t;
    }

    public static void addUniforms(List<CachedUniform> list, Map<String, ShaderCurves.ShaderVariable> variableMap) {
        for (ShaderCurves.ShaderVariable value : variableMap.values()) {
            if (value.integer) {
                list.add((CachedUniform)new IntCachedUniform(value.uniformName, UniformUpdateFrequency.PER_FRAME, () -> (int)value.getValue()));
                continue;
            }
            list.add((CachedUniform)new FloatCachedUniform(value.uniformName, UniformUpdateFrequency.PER_FRAME, value::getValue));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SuperTriangle
    implements TriView {
        private float x0;
        private float y0;
        private float z0;
        private float u0;
        private float v0;
        private float x1;
        private float y1;
        private float z1;
        private float u1;
        private float v1;
        private float x2;
        private float y2;
        private float z2;
        private float u2;
        private float v2;

        public SuperTriangle set(float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2) {
            this.x0 = x0;
            this.y0 = y0;
            this.z0 = z0;
            this.u0 = u0;
            this.v0 = v0;
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.u1 = u1;
            this.v1 = v1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
            this.u2 = u2;
            this.v2 = v2;
            return this;
        }

        public float x(int i) {
            return i == 0 ? this.x0 : (i == 1 ? this.x1 : this.x2);
        }

        public float y(int i) {
            return i == 0 ? this.y0 : (i == 1 ? this.y1 : this.y2);
        }

        public float z(int i) {
            return i == 0 ? this.z0 : (i == 1 ? this.z1 : this.z2);
        }

        public float u(int i) {
            return i == 0 ? this.u0 : (i == 1 ? this.u1 : this.u2);
        }

        public float v(int i) {
            return i == 0 ? this.v0 : (i == 1 ? this.v1 : this.v2);
        }
    }
}

