/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.watchdog;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.watchdog.IWatchDogListener;
import mchorse.bbs_mod.utils.watchdog.WatchDogEvent;

public class WatchDogProxy
implements IWatchDogListener {
    private List<IWatchDogListener> listeners = new ArrayList<IWatchDogListener>();
    private List<Pair<Path, WatchDogEvent>> queue = new ArrayList<Pair<Path, WatchDogEvent>>();
    private int tick;

    public void register(IWatchDogListener listener) {
        this.listeners.add(listener);
    }

    public void tick() {
        if (this.tick == 0) {
            for (Pair<Path, WatchDogEvent> pair : this.queue) {
                for (IWatchDogListener listener : this.listeners) {
                    listener.accept((Path)pair.a, (WatchDogEvent)((Object)pair.b));
                }
            }
        }
        --this.tick;
    }

    @Override
    public void accept(Path path, WatchDogEvent event) {
        for (IWatchDogListener listener : this.listeners) {
            listener.accept(path, event);
        }
    }
}

