/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod;

import java.util.HashSet;
import mchorse.bbs_mod.settings.SettingsBuilder;
import mchorse.bbs_mod.settings.values.core.ValueLink;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.settings.values.ui.ValueColors;
import mchorse.bbs_mod.settings.values.ui.ValueEditorLayout;
import mchorse.bbs_mod.settings.values.ui.ValueLanguage;
import mchorse.bbs_mod.settings.values.ui.ValueOnionSkin;
import mchorse.bbs_mod.settings.values.ui.ValueStringKeys;
import mchorse.bbs_mod.settings.values.ui.ValueVideoSettings;
import mchorse.bbs_mod.utils.MathUtils;

public class BBSSettings {
    public static ValueColors favoriteColors;
    public static ValueStringKeys disabledSheets;
    public static ValueLanguage language;
    public static ValueInt primaryColor;
    public static ValueBoolean enableTrackpadIncrements;
    public static ValueBoolean enableTrackpadScrolling;
    public static ValueInt userIntefaceScale;
    public static ValueInt tooltipStyle;
    public static ValueFloat fov;
    public static ValueBoolean hsvColorPicker;
    public static ValueBoolean forceQwerty;
    public static ValueBoolean freezeModels;
    public static ValueFloat axesScale;
    public static ValueBoolean uniformScale;
    public static ValueBoolean clickSound;
    public static ValueBoolean gizmos;
    public static ValueBoolean enableCursorRendering;
    public static ValueBoolean enableMouseButtonRendering;
    public static ValueBoolean enableKeystrokeRendering;
    public static ValueInt keystrokeOffset;
    public static ValueInt keystrokeMode;
    public static ValueLink backgroundImage;
    public static ValueInt backgroundColor;
    public static ValueBoolean chromaSkyEnabled;
    public static ValueInt chromaSkyColor;
    public static ValueBoolean chromaSkyTerrain;
    public static ValueFloat chromaSkyBillboard;
    public static ValueInt scrollbarShadow;
    public static ValueInt scrollbarWidth;
    public static ValueFloat scrollingSensitivity;
    public static ValueFloat scrollingSensitivityHorizontal;
    public static ValueBoolean scrollingSmoothness;
    public static ValueBoolean multiskinMultiThreaded;
    public static ValueString videoEncoderPath;
    public static ValueBoolean videoEncoderLog;
    public static ValueVideoSettings videoSettings;
    public static ValueFloat editorCameraSpeed;
    public static ValueFloat editorCameraAngleSpeed;
    public static ValueInt duration;
    public static ValueBoolean editorLoop;
    public static ValueInt editorJump;
    public static ValueInt editorGuidesColor;
    public static ValueBoolean editorRuleOfThirds;
    public static ValueBoolean editorCenterLines;
    public static ValueBoolean editorCrosshair;
    public static ValueBoolean editorSeconds;
    public static ValueInt editorPeriodicSave;
    public static ValueBoolean editorHorizontalFlight;
    public static ValueEditorLayout editorLayoutSettings;
    public static ValueOnionSkin editorOnionSkin;
    public static ValueBoolean editorSnapToMarkers;
    public static ValueBoolean editorClipPreview;
    public static ValueBoolean editorRewind;
    public static ValueBoolean editorHorizontalClipEditor;
    public static ValueBoolean editorMinutesBackup;
    public static ValueFloat recordingCountdown;
    public static ValueBoolean recordingSwipeDamage;
    public static ValueBoolean recordingOverlays;
    public static ValueInt recordingPoseTransformOverlays;
    public static ValueBoolean recordingCameraPreview;
    public static ValueBoolean renderAllModelBlocks;
    public static ValueBoolean clickModelBlocks;
    public static ValueBoolean modelBlockGizmosEnabled;
    public static ValueBoolean modelBlockCategoriesPanelEnabled;
    public static ValueBoolean gizmoDynamic;
    public static ValueFloat gizmoScale;
    public static ValueInt gizmoDesign;
    public static ValueBoolean gizmoPlanes;
    public static ValueBoolean visualizeStructures;
    public static ValueBoolean structureOptimization;
    public static ValueString entitySelectorsPropertyWhitelist;
    public static ValueBoolean damageControl;
    public static ValueBoolean shaderCurvesEnabled;
    public static ValueBoolean audioWaveformVisible;
    public static ValueInt audioWaveformDensity;
    public static ValueFloat audioWaveformWidth;
    public static ValueInt audioWaveformHeight;
    public static ValueBoolean audioWaveformFilename;
    public static ValueBoolean audioWaveformTime;
    public static ValueBoolean boneAnchoringEnabled;
    public static ValueBoolean anchorOverrideEnabled;
    public static ValueString cdnUrl;
    public static ValueString cdnToken;

    public static int primaryColor() {
        return BBSSettings.primaryColor(-2013265920);
    }

    public static int primaryColor(int alpha) {
        return (Integer)primaryColor.get() | alpha;
    }

    public static int getDefaultDuration() {
        return duration == null ? 30 : (Integer)duration.get();
    }

    public static float getFov() {
        return fov == null ? MathUtils.toRad(50.0f) : MathUtils.toRad(((Float)fov.get()).floatValue());
    }

    public static void register(SettingsBuilder builder) {
        HashSet<String> defaultFilters = new HashSet<String>();
        defaultFilters.add("item_off_hand");
        defaultFilters.add("item_head");
        defaultFilters.add("item_chest");
        defaultFilters.add("item_legs");
        defaultFilters.add("item_feet");
        defaultFilters.add("vX");
        defaultFilters.add("vY");
        defaultFilters.add("vZ");
        defaultFilters.add("grounded");
        defaultFilters.add("stick_rx");
        defaultFilters.add("stick_ry");
        defaultFilters.add("trigger_l");
        defaultFilters.add("trigger_r");
        defaultFilters.add("extra1_x");
        defaultFilters.add("extra1_y");
        defaultFilters.add("extra2_x");
        defaultFilters.add("extra2_y");
        builder.category("appearance");
        language = new ValueLanguage("language");
        builder.register(language);
        primaryColor = builder.getInt("primary_color", 35071).color();
        enableTrackpadIncrements = builder.getBoolean("trackpad_increments", true);
        enableTrackpadScrolling = builder.getBoolean("trackpad_scrolling", true);
        userIntefaceScale = builder.getInt("ui_scale", 2, 0, 4);
        tooltipStyle = builder.getInt("tooltip_style", 1);
        fov = builder.getFloat("fov", 40.0f, 0.0f, 180.0f);
        hsvColorPicker = builder.getBoolean("hsv_color_picker", true);
        forceQwerty = builder.getBoolean("force_qwerty", false);
        freezeModels = builder.getBoolean("freeze_models", false);
        axesScale = builder.getFloat("axes_scale", 1.0f, 0.0f, 2.0f);
        uniformScale = builder.getBoolean("uniform_scale", false);
        clickSound = builder.getBoolean("click_sound", false);
        gizmos = builder.getBoolean("gizmos", true);
        favoriteColors = new ValueColors("favorite_colors");
        disabledSheets = new ValueStringKeys("disabled_sheets");
        disabledSheets.set(defaultFilters);
        builder.register(favoriteColors);
        builder.register(disabledSheets);
        builder.category("tutorials");
        enableCursorRendering = builder.getBoolean("cursor", false);
        enableMouseButtonRendering = builder.getBoolean("mouse_buttons", false);
        enableKeystrokeRendering = builder.getBoolean("keystrokes", false);
        keystrokeOffset = builder.getInt("keystrokes_offset", 10, 0, 20);
        keystrokeMode = builder.getInt("keystrokes_position", 1);
        builder.category("background");
        backgroundImage = builder.getRL("image", null);
        backgroundColor = builder.getInt("color", -1157627904).colorAlpha();
        builder.category("chroma_sky");
        chromaSkyEnabled = builder.getBoolean("enabled", false);
        chromaSkyColor = builder.getInt("color", -1157627904).color();
        chromaSkyTerrain = builder.getBoolean("terrain", true);
        chromaSkyBillboard = builder.getFloat("billboard", 0.0f, 0.0f, 256.0f);
        builder.category("scrollbars");
        scrollbarShadow = builder.getInt("shadow", -2013265920).colorAlpha();
        scrollbarWidth = builder.getInt("width", 4, 2, 10);
        scrollingSensitivity = builder.getFloat("sensitivity", 1.0f, 0.0f, 10.0f);
        scrollingSensitivityHorizontal = builder.getFloat("sensitivity_horizontal", 1.0f, 0.0f, 10.0f);
        scrollingSmoothness = builder.getBoolean("smoothness", true);
        builder.category("multiskin");
        multiskinMultiThreaded = builder.getBoolean("multithreaded", true);
        builder.category("video");
        videoEncoderPath = builder.getString("encoder_path", "ffmpeg");
        videoEncoderLog = builder.getBoolean("log", true);
        videoSettings = new ValueVideoSettings("settings");
        builder.register(videoSettings);
        builder.category("editor");
        editorCameraSpeed = builder.getFloat("speed", 1.0f, 0.1f, 100.0f);
        editorCameraAngleSpeed = builder.getFloat("angle_speed", 1.0f, 0.1f, 100.0f);
        duration = builder.getInt("duration", 30, 1, 1000);
        editorJump = builder.getInt("jump", 5, 1, 1000);
        editorLoop = builder.getBoolean("loop", false);
        editorGuidesColor = builder.getInt("guides_color", -859045888).colorAlpha();
        editorRuleOfThirds = builder.getBoolean("rule_of_thirds", false);
        editorCenterLines = builder.getBoolean("center_lines", false);
        editorCrosshair = builder.getBoolean("crosshair", false);
        editorSeconds = builder.getBoolean("seconds", false);
        editorPeriodicSave = builder.getInt("periodic_save", 60, 0, 3600);
        editorHorizontalFlight = builder.getBoolean("horizontal_flight", false);
        editorLayoutSettings = new ValueEditorLayout("layout");
        builder.register(editorLayoutSettings);
        editorOnionSkin = new ValueOnionSkin("onion_skin");
        builder.register(editorOnionSkin);
        editorSnapToMarkers = builder.getBoolean("snap_to_markers", false);
        editorClipPreview = builder.getBoolean("clip_preview", true);
        editorRewind = builder.getBoolean("rewind", true);
        editorHorizontalClipEditor = builder.getBoolean("horizontal_clip_editor", true);
        editorMinutesBackup = builder.getBoolean("minutes_backup", true);
        builder.category("recording");
        recordingCountdown = builder.getFloat("countdown", 1.5f, 0.0f, 30.0f);
        recordingSwipeDamage = builder.getBoolean("swipe_damage", false);
        recordingOverlays = builder.getBoolean("overlays", true);
        recordingPoseTransformOverlays = builder.getInt("pose_transform_overlays", 0, 0, 42);
        recordingCameraPreview = builder.getBoolean("camera_preview", true);
        builder.category("model_blocks");
        renderAllModelBlocks = builder.getBoolean("render_all", true);
        clickModelBlocks = builder.getBoolean("click", true);
        modelBlockCategoriesPanelEnabled = builder.getBoolean("categories_panel_enabled", false);
        builder.category("gizmos");
        modelBlockGizmosEnabled = builder.getBoolean("enabled", false);
        gizmoDynamic = builder.getBoolean("dynamic", false);
        gizmoScale = builder.getFloat("scale", 1.0f, 0.1f, 4.0f);
        gizmoDesign = builder.getInt("design", 0);
        gizmoPlanes = builder.getBoolean("planes", false);
        builder.category("structures");
        structureOptimization = builder.getBoolean("structure_optimization", true);
        visualizeStructures = builder.getBoolean("visualize_structures", false);
        builder.category("entity_selectors");
        entitySelectorsPropertyWhitelist = builder.getString("whitelist", "CustomName,Name");
        builder.category("dc");
        damageControl = builder.getBoolean("enabled", true);
        builder.category("shader_curves");
        shaderCurvesEnabled = builder.getBoolean("enabled", true);
        builder.category("audio");
        audioWaveformVisible = builder.getBoolean("waveform_visible", true);
        audioWaveformDensity = builder.getInt("waveform_density", 20, 10, 100);
        audioWaveformWidth = builder.getFloat("waveform_width", 0.8f, 0.0f, 1.0f);
        audioWaveformHeight = builder.getInt("waveform_height", 24, 10, 40);
        audioWaveformFilename = builder.getBoolean("waveform_filename", false);
        audioWaveformTime = builder.getBoolean("waveform_time", false);
        builder.category("pose_track_selection");
        boneAnchoringEnabled = builder.getBoolean("bone_anchoring_enabled", false);
        anchorOverrideEnabled = builder.getBoolean("anchor_override_enabled", false);
        builder.category("cdn");
        cdnUrl = builder.getString("url", "");
        cdnToken = builder.getString("token", "");
    }
}

