/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.camera.clips.misc.CurveClip;
import mchorse.bbs_mod.camera.clips.misc.SubtitleClip;
import mchorse.bbs_mod.camera.controller.CameraWorkCameraController;
import mchorse.bbs_mod.camera.controller.ICameraController;
import mchorse.bbs_mod.camera.controller.PlayCameraController;
import mchorse.bbs_mod.events.ModelBlockEntityUpdateCallback;
import mchorse.bbs_mod.forms.renderers.utils.RecolorVertexConsumer;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.graphics.texture.TextureFormat;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.dashboard.UIDashboard;
import mchorse.bbs_mod.ui.dashboard.panels.UIDashboardPanel;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.UISubtitleRenderer;
import mchorse.bbs_mod.ui.framework.UIBaseMenu;
import mchorse.bbs_mod.ui.framework.UIScreen;
import mchorse.bbs_mod.ui.framework.elements.utils.Batcher2D;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.VideoRecorder;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.iris.IrisUtils;
import mchorse.bbs_mod.utils.iris.ShaderCurves;
import mchorse.bbs_mod.utils.sodium.SodiumUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.impl.client.rendering.WorldRenderContextImpl;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.uniforms.custom.cached.CachedUniform;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_6364;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class BBSRendering {
    public static final Set<ModelBlockEntity> capturedModelBlocks = new HashSet<ModelBlockEntity>();
    public static boolean canRender;
    public static boolean renderingWorld;
    public static int lastAction;
    public static final Matrix4f camera;
    private static boolean customSize;
    private static boolean iris;
    private static boolean sodium;
    private static boolean optifine;
    private static int width;
    private static int height;
    private static boolean toggleFramebuffer;
    private static class_276 framebuffer;
    private static class_276 clientFramebuffer;
    private static Texture texture;

    public static int getMotionBlur() {
        return BBSRendering.getMotionBlur(((Integer)BBSSettings.videoSettings.frameRate.get()).intValue(), BBSRendering.getMotionBlurFactor());
    }

    public static int getMotionBlur(double fps, int target) {
        int i = 0;
        while (fps < (double)target) {
            fps *= 2.0;
            ++i;
        }
        return i;
    }

    public static int getMotionBlurFactor() {
        return BBSRendering.getMotionBlurFactor((Integer)BBSSettings.videoSettings.motionBlur.get());
    }

    public static int getMotionBlurFactor(int integer) {
        return integer == 0 ? 0 : (int)Math.pow(2.0, 6 + integer);
    }

    public static int getVideoWidth() {
        return width == 0 ? (Integer)BBSSettings.videoSettings.width.get() : width;
    }

    public static int getVideoHeight() {
        return height == 0 ? (Integer)BBSSettings.videoSettings.height.get() : height;
    }

    public static int getVideoFrameRate() {
        int frameRate = (Integer)BBSSettings.videoSettings.frameRate.get();
        return frameRate * (1 << BBSRendering.getMotionBlur(frameRate, BBSRendering.getMotionBlurFactor()));
    }

    public static File getVideoFolder() {
        File movies = new File(BBSMod.getSettingsFolder().getParentFile(), "movies");
        File exportPath = new File((String)BBSSettings.videoSettings.path.get());
        if (exportPath.isDirectory()) {
            movies = exportPath;
        }
        movies.mkdirs();
        return movies;
    }

    public static boolean canReplaceFramebuffer() {
        return customSize && renderingWorld;
    }

    public static boolean isCustomSize() {
        return customSize;
    }

    public static void setCustomSize(boolean customSize) {
        BBSRendering.setCustomSize(customSize, 0, 0);
    }

    public static void setCustomSize(boolean customSize, int w, int h) {
        BBSRendering.customSize = customSize;
        width = !customSize ? 0 : w;
        int n = height = !customSize ? 0 : h;
        if (!customSize) {
            BBSRendering.resizeExtraFramebuffers();
        }
    }

    public static Texture getTexture() {
        if (texture == null) {
            texture = new Texture();
            texture.setFormat(TextureFormat.RGB_U8);
            texture.setFilter(9728);
        }
        return texture;
    }

    public static void startTick() {
        capturedModelBlocks.clear();
    }

    public static void setup() {
        iris = FabricLoader.getInstance().isModLoaded("iris");
        sodium = FabricLoader.getInstance().isModLoaded("sodium");
        optifine = FabricLoader.getInstance().isModLoaded("optifabric");
        ModelBlockEntityUpdateCallback.EVENT.register(entity -> {
            if (entity.method_10997().method_8608()) {
                capturedModelBlocks.add(entity);
            }
        });
        if (!iris) {
            return;
        }
        try {
            IrisUtils.setup();
        }
        catch (Throwable t) {
            System.err.println("[BBS] Iris integration setup failed; continuing without PBR hooks: " + String.valueOf(t));
        }
    }

    public static class_276 getFramebuffer() {
        return framebuffer;
    }

    public static void setupFramebuffer() {
        class_1041 window = class_310.method_1551().method_22683();
        framebuffer = new class_6364(window.method_4489(), window.method_4506());
    }

    public static void resizeExtraFramebuffers() {
        HashSet<class_276> buffers = new HashSet<class_276>();
        class_310 mc = class_310.method_1551();
        buffers.add(mc.field_1769.method_22990());
        buffers.add(mc.field_1769.method_29360());
        buffers.add(mc.field_1769.method_29361());
        buffers.add(mc.field_1769.method_29362());
        buffers.add(mc.field_1769.method_29363());
        buffers.add(mc.field_1769.method_29364());
        for (class_276 buffer : buffers) {
            BBSRendering.resizeFramebuffer(buffer);
        }
    }

    public static void resizeFramebuffer(class_276 framebuffer) {
        if (framebuffer == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        int w = mc.method_22683().method_4489();
        int h = mc.method_22683().method_4506();
        if (framebuffer.field_1482 == w && framebuffer.field_1481 == h) {
            return;
        }
        framebuffer.method_1234(w, h, class_310.field_1703);
    }

    public static void toggleFramebuffer(boolean toggleFramebuffer) {
        if (toggleFramebuffer == BBSRendering.toggleFramebuffer) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_1041 window = mc.method_22683();
        BBSRendering.toggleFramebuffer = toggleFramebuffer;
        if (toggleFramebuffer) {
            int w = mc.method_22683().method_4489();
            int h = mc.method_22683().method_4506();
            BBSRendering.resizeExtraFramebuffers();
            if (BBSRendering.framebuffer.field_1482 != w || BBSRendering.framebuffer.field_1481 != h) {
                framebuffer.method_1234(w, h, class_310.field_1703);
            }
            clientFramebuffer = mc.method_1522();
            BBSRendering.reassignFramebuffer(framebuffer);
            framebuffer.method_1235(true);
        } else {
            BBSRendering.reassignFramebuffer(clientFramebuffer);
            mc.method_1522().method_1235(true);
            if (width != 0) {
                framebuffer.method_1237(window.method_4489(), window.method_4506());
            }
        }
    }

    private static void reassignFramebuffer(class_276 framebuffer) {
        class_310.method_1551().field_1689 = framebuffer;
    }

    public static void onWorldRenderBegin() {
        class_310 mc = class_310.method_1551();
        BBSModClient.getFilms().startRenderFrame(mc.method_60646().method_60637(false));
        UIBaseMenu menu = UIScreen.getCurrentMenu();
        if (menu != null) {
            menu.startRenderFrame(mc.method_60646().method_60637(false));
        }
        renderingWorld = true;
        if (!customSize) {
            return;
        }
        BBSRendering.toggleFramebuffer(true);
    }

    public static void onWorldRenderEnd() {
        class_310 mc = class_310.method_1551();
        ICameraController iCameraController = BBSModClient.getCameraController().getCurrent();
        if (iCameraController instanceof PlayCameraController) {
            PlayCameraController controller = (PlayCameraController)iCameraController;
            class_332 drawContext = new class_332(mc, mc.method_22940().method_23000());
            Batcher2D batcher = new Batcher2D(drawContext);
            UISubtitleRenderer.renderSubtitles(batcher.getContext().method_51448(), batcher, SubtitleClip.getSubtitles(controller.getContext()));
        }
        if (!customSize) {
            renderingWorld = false;
            return;
        }
        UIBaseMenu currentMenu = UIScreen.getCurrentMenu();
        if (currentMenu instanceof UIDashboard) {
            UIDashboard dashboard = (UIDashboard)currentMenu;
            UIDashboardPanel uIDashboardPanel = dashboard.getPanels().panel;
            if (uIDashboardPanel instanceof UIFilmPanel) {
                UIFilmPanel panel = (UIFilmPanel)uIDashboardPanel;
                UISubtitleRenderer.renderSubtitles(currentMenu.context.batcher.getContext().method_51448(), currentMenu.context.batcher, SubtitleClip.getSubtitles(panel.getRunner().getContext()));
            }
        }
        renderingWorld = false;
    }

    public static void onRenderBeforeScreen() {
        Texture texture = BBSRendering.getTexture();
        texture.bind();
        texture.setSize(BBSRendering.framebuffer.field_1482, BBSRendering.framebuffer.field_1481);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)BBSRendering.framebuffer.field_1482, (int)BBSRendering.framebuffer.field_1481);
        texture.unbind();
        BBSRendering.toggleFramebuffer(false);
    }

    public static void onRenderChunkLayer(class_4587 stack) {
        WorldRenderContextImpl worldRenderContext = new WorldRenderContextImpl();
        class_310 mc = class_310.method_1551();
        worldRenderContext.prepare(mc.field_1769, mc.method_60646(), false, mc.field_1773.method_19418(), mc.field_1773, mc.field_1773.method_22974(), RenderSystem.getProjectionMatrix(), RenderSystem.getModelViewMatrix(), (class_4597)mc.method_22940().method_23000(), mc.method_16011(), false, mc.field_1687);
        if (!BBSRendering.isIrisShadersEnabled()) {
            BBSRendering.renderCoolStuff((WorldRenderContext)worldRenderContext);
        }
    }

    public static void onRenderChunkLayer(Matrix4f positionMatrix, Matrix4f projectionMatrix) {
        WorldRenderContextImpl worldRenderContext = new WorldRenderContextImpl();
        class_310 mc = class_310.method_1551();
        worldRenderContext.prepare(mc.field_1769, mc.method_60646(), false, mc.field_1773.method_19418(), mc.field_1773, mc.field_1773.method_22974(), positionMatrix, projectionMatrix, (class_4597)mc.method_22940().method_23000(), mc.method_16011(), false, mc.field_1687);
        if (BBSRendering.isIrisShadersEnabled()) {
            BBSRendering.renderCoolStuff((WorldRenderContext)worldRenderContext);
        }
    }

    public static void renderHud(class_332 drawContext, float tickDelta) {
        Batcher2D batcher2D = new Batcher2D(drawContext);
        VideoRecorder videoRecorder = BBSModClient.getVideoRecorder();
        BBSModClient.getFilms().renderHud(batcher2D, tickDelta);
        if (videoRecorder.isRecording() && ((Boolean)BBSSettings.recordingOverlays.get()).booleanValue() && UIScreen.getCurrentMenu() == null) {
            int count = videoRecorder.getCounter();
            String label = UIKeys.FILM_VIDEO_RECORDING.format(count, BBSModClient.getKeyRecordVideo().method_16007().getString()).get();
            int x = 5;
            int y = 5;
            int w = batcher2D.getFont().getWidth(label);
            batcher2D.box(x, y, x + 18 + w + 3, y + 16, -2013265920);
            batcher2D.icon(Icons.SPHERE, -52429, x, y);
            batcher2D.textShadow(label, x + 18, y + 4);
        }
    }

    public static void renderCoolStuff(WorldRenderContext worldRenderContext) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof UIScreen) {
            UIScreen screen = (UIScreen)class_4372;
            screen.renderInWorld(worldRenderContext);
        }
        BBSModClient.getFilms().render(worldRenderContext);
    }

    public static boolean isOptifinePresent() {
        return optifine;
    }

    public static boolean isRenderingWorld() {
        return renderingWorld;
    }

    public static boolean isIrisShadersEnabled() {
        if (!iris) {
            return false;
        }
        return IrisUtils.isShaderPackEnabled();
    }

    public static boolean isIrisShadowPass() {
        if (!iris) {
            return false;
        }
        return IrisUtils.isShadowPass();
    }

    public static void trackTexture(Texture texture) {
        if (!iris) {
            return;
        }
        IrisUtils.trackTexture(texture);
    }

    public static float[] calculateTangents(float[] t, float[] v, float[] n, float[] u) {
        if (!iris) {
            return t;
        }
        return IrisUtils.calculateTangents(t, v, n, u);
    }

    public static float[] calculateTangents(float[] v, float[] n, float[] u) {
        if (!iris) {
            return v;
        }
        return IrisUtils.calculateTangents(v, n, u);
    }

    public static void addUniforms(List<CachedUniform> list, Map<String, ShaderCurves.ShaderVariable> variableMap) {
        if (!iris) {
            return;
        }
        IrisUtils.addUniforms(list, variableMap);
    }

    public static List<String> getShadersSliderOptions() {
        if (!iris) {
            return Collections.emptyList();
        }
        return IrisUtils.getSliderProperties();
    }

    public static Map<String, String> getShadersLanguageMap(String language) {
        if (!iris) {
            return Collections.emptyMap();
        }
        return IrisUtils.getShadersLanguageMap(language);
    }

    public static Long getTimeOfDay() {
        ICameraController iCameraController = BBSModClient.getCameraController().getCurrent();
        if (iCameraController instanceof CameraWorkCameraController) {
            Double v;
            CameraWorkCameraController controller = (CameraWorkCameraController)iCameraController;
            Map<String, Double> values = CurveClip.getValues(controller.getContext());
            Double d = v = values != null ? values.get("sun_rotation") : null;
            if (v != null) {
                return (long)(v * 1000.0);
            }
        }
        return null;
    }

    public static Double getBrightness() {
        ICameraController iCameraController = BBSModClient.getCameraController().getCurrent();
        if (iCameraController instanceof CameraWorkCameraController) {
            Double v;
            CameraWorkCameraController controller = (CameraWorkCameraController)iCameraController;
            Map<String, Double> values = CurveClip.getValues(controller.getContext());
            Double d = v = values != null ? values.get("brightness") : null;
            if (v != null) {
                return v;
            }
        }
        return null;
    }

    public static Double getWeather() {
        ICameraController iCameraController = BBSModClient.getCameraController().getCurrent();
        if (iCameraController instanceof CameraWorkCameraController) {
            Double v;
            CameraWorkCameraController controller = (CameraWorkCameraController)iCameraController;
            Map<String, Double> values = CurveClip.getValues(controller.getContext());
            Double d = v = values != null ? values.get("weather") : null;
            if (v != null) {
                return v;
            }
        }
        return null;
    }

    public static Function<class_4588, class_4588> getColorConsumer(Color color) {
        if (sodium) {
            return b -> SodiumUtils.createVertexBuffer(b, color);
        }
        return b -> new RecolorVertexConsumer((class_4588)b, color);
    }

    static {
        camera = new Matrix4f();
    }
}

