/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.render;

import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.data.model.ModelGroup;
import mchorse.bbs_mod.cubic.render.CubicCubeRenderer;
import mchorse.bbs_mod.cubic.render.vao.ModelVAO;
import mchorse.bbs_mod.cubic.render.vao.ModelVAORenderer;
import mchorse.bbs_mod.obj.shapes.ShapeKeys;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_4587;
import net.minecraft.class_5944;

@Environment(value=EnvType.CLIENT)
public class CubicVAORenderer
extends CubicCubeRenderer {
    private class_5944 program;
    private ModelInstance model;
    private Link defaultTexture;

    public CubicVAORenderer(class_5944 program, ModelInstance model, int light, int overlay, StencilMap stencilMap, ShapeKeys shapeKeys, Link defaultTexture) {
        super(light, overlay, stencilMap, shapeKeys);
        this.program = program;
        this.model = model;
        this.defaultTexture = defaultTexture;
    }

    @Override
    public boolean renderGroup(class_287 builder, class_4587 stack, ModelGroup group, Model model) {
        ModelVAO modelVAO = this.model.getVaos().get(group);
        if (modelVAO != null && group.visible) {
            if (group.textureOverride != null) {
                BBSModClient.getTextures().bindTexture(group.textureOverride);
            } else if (this.defaultTexture != null) {
                BBSModClient.getTextures().bindTexture(this.defaultTexture);
            } else {
                BBSModClient.getTextures().bindTexture(this.model.texture);
            }
            float r = this.r * group.color.r;
            float g = this.g * group.color.g;
            float b = this.b * group.color.b;
            float a = this.a * group.color.a;
            int light = this.light;
            if (this.stencilMap != null) {
                light = this.stencilMap.increment ? group.index : 0;
            } else {
                int u = (int)Lerps.lerp(light & 0xFFFF, 240.0f, MathUtils.clamp(group.lighting, 0.0f, 1.0f));
                int v = light >> 16 & 0xFFFF;
                light = u | v << 16;
            }
            ModelVAORenderer.render(this.program, modelVAO, stack, r, g, b, a, light, this.overlay);
        }
        return false;
    }
}

