/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.renderers.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1920;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_6539;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class VirtualBlockRenderView
implements class_1920 {
    private final Map<class_2338, class_2680> states = new HashMap<class_2338, class_2680>();
    private final Map<class_2338, Integer> localBlockLight = new HashMap<class_2338, Integer>();
    private int bottomY = 0;
    private int topY = 256;
    private class_2960 biomeOverrideId = null;
    private class_1959 biomeOverride = null;
    private class_2338 worldAnchor = class_2338.field_10980;
    private int baseDx = 0;
    private int baseDy = 0;
    private int baseDz = 0;
    private boolean lightsEnabled = true;
    private int lightIntensity = 15;
    private boolean forceMaxSkyLight = false;

    public VirtualBlockRenderView(List<Entry> entries) {
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        ArrayList<class_2338> emitters = new ArrayList<class_2338>();
        ArrayList<Integer> emitterLevels = new ArrayList<Integer>();
        for (Entry entry : entries) {
            int lum;
            this.states.put(entry.pos, entry.state == null ? class_2246.field_10124.method_9564() : entry.state);
            class_2680 st = this.states.get(entry.pos);
            int n = lum = st == null ? 0 : st.method_26213();
            if (lum > 0) {
                emitters.add(entry.pos);
                emitterLevels.add(lum);
            }
            if (entry.pos.method_10264() < minY) {
                minY = entry.pos.method_10264();
            }
            if (entry.pos.method_10264() <= maxY) continue;
            maxY = entry.pos.method_10264();
        }
        if (minY != Integer.MAX_VALUE && maxY != Integer.MIN_VALUE) {
            this.bottomY = minY;
            this.topY = maxY;
        }
        if (!emitters.isEmpty() && !this.states.isEmpty()) {
            for (Map.Entry entry : this.states.entrySet()) {
                class_2338 tp = (class_2338)entry.getKey();
                int max = 0;
                for (int i = 0; i < emitters.size(); ++i) {
                    int dist;
                    class_2338 sp = (class_2338)emitters.get(i);
                    int L = (Integer)emitterLevels.get(i);
                    int contrib = L - (dist = Math.abs(sp.method_10263() - tp.method_10263()) + Math.abs(sp.method_10264() - tp.method_10264()) + Math.abs(sp.method_10260() - tp.method_10260()));
                    if (contrib <= max || (max = contrib) < 15) continue;
                    max = 15;
                    break;
                }
                if (max <= 0) continue;
                this.localBlockLight.put(tp, max);
            }
        }
    }

    public VirtualBlockRenderView setWorldAnchor(class_2338 anchor, int baseDx, int baseDy, int baseDz) {
        this.worldAnchor = anchor == null ? class_2338.field_10980 : anchor;
        this.baseDx = baseDx;
        this.baseDy = baseDy;
        this.baseDz = baseDz;
        return this;
    }

    public VirtualBlockRenderView setBiomeOverride(String biomeId) {
        if (biomeId == null || biomeId.isEmpty()) {
            this.biomeOverrideId = null;
            this.biomeOverride = null;
            return this;
        }
        try {
            this.biomeOverrideId = class_2960.method_60654((String)biomeId);
            if (class_310.method_1551().field_1687 != null) {
                class_2378 reg = class_310.method_1551().field_1687.method_30349().method_30530(class_7924.field_41236);
                this.biomeOverride = (class_1959)reg.method_10223(this.biomeOverrideId);
            } else {
                this.biomeOverride = null;
            }
        }
        catch (Throwable t) {
            this.biomeOverrideId = null;
            this.biomeOverride = null;
        }
        return this;
    }

    public VirtualBlockRenderView setLightsEnabled(boolean enabled) {
        this.lightsEnabled = enabled;
        return this;
    }

    public VirtualBlockRenderView setLightIntensity(int level) {
        if (level < 1) {
            level = 1;
        }
        if (level > 15) {
            level = 15;
        }
        this.lightIntensity = level;
        return this;
    }

    public VirtualBlockRenderView setForceMaxSkyLight(boolean force) {
        this.forceMaxSkyLight = force;
        return this;
    }

    public class_2586 method_8321(class_2338 pos) {
        return null;
    }

    public class_2680 method_8320(class_2338 pos) {
        class_2680 state = this.states.get(pos);
        return state != null ? state : class_2246.field_10124.method_9564();
    }

    public class_3610 method_8316(class_2338 pos) {
        return class_3612.field_15906.method_15785();
    }

    public int method_8317(class_2338 pos) {
        if (!this.lightsEnabled) {
            return 0;
        }
        class_2680 s = this.method_8320(pos);
        int lum = s == null ? 0 : s.method_26213();
        return Math.min(lum, this.lightIntensity);
    }

    public int method_8315() {
        return 15;
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        if (class_310.method_1551().field_1687 != null) {
            return class_310.method_1551().field_1687.method_24852(direction, shaded);
        }
        return 1.0f;
    }

    public class_3568 method_22336() {
        if (class_310.method_1551().field_1687 != null) {
            return class_310.method_1551().field_1687.method_22336();
        }
        return null;
    }

    public int method_23752(class_2338 pos, class_6539 colorResolver) {
        if (this.biomeOverride != null) {
            int wx = this.worldAnchor.method_10263() + this.baseDx + pos.method_10263();
            int wz = this.worldAnchor.method_10260() + this.baseDz + pos.method_10260();
            return colorResolver.getColor(this.biomeOverride, (double)wx, (double)wz);
        }
        if (class_310.method_1551().field_1687 != null) {
            class_2338 worldPos = this.worldAnchor.method_10069(this.baseDx + pos.method_10263(), this.baseDy + pos.method_10264(), this.baseDz + pos.method_10260());
            return class_310.method_1551().field_1687.method_23752(worldPos, colorResolver);
        }
        return 0xFFFFFF;
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        if (this.forceMaxSkyLight || class_310.method_1551().field_1687 == null) {
            if (type == class_1944.field_9284) {
                return 15;
            }
            return this.lightsEnabled ? Math.min(this.localBlockLight.getOrDefault(pos, 0), this.lightIntensity) : 0;
        }
        int worldLevel = 0;
        class_2338 worldPos = this.worldAnchor.method_10069(this.baseDx + pos.method_10263(), this.baseDy + pos.method_10264(), this.baseDz + pos.method_10260());
        worldLevel = class_310.method_1551().field_1687.method_8314(type, worldPos);
        if (type == class_1944.field_9282) {
            int local = this.lightsEnabled ? Math.min(this.localBlockLight.getOrDefault(pos, 0), this.lightIntensity) : 0;
            return Math.max(worldLevel, local);
        }
        return worldLevel;
    }

    public int method_22335(class_2338 pos, int ambientDarkness) {
        if (this.forceMaxSkyLight || class_310.method_1551().field_1687 == null) {
            return 15;
        }
        class_2338 worldPos = this.worldAnchor.method_10069(this.baseDx + pos.method_10263(), this.baseDy + pos.method_10264(), this.baseDz + pos.method_10260());
        int worldBase = class_310.method_1551().field_1687.method_22335(worldPos, ambientDarkness);
        int localBlock = this.lightsEnabled ? Math.min(this.localBlockLight.getOrDefault(pos, 0), this.lightIntensity) : 0;
        return Math.max(worldBase, localBlock);
    }

    public boolean method_8311(class_2338 pos) {
        if (this.forceMaxSkyLight || class_310.method_1551().field_1687 == null) {
            return true;
        }
        class_2338 worldPos = this.worldAnchor.method_10069(this.baseDx + pos.method_10263(), this.baseDy + pos.method_10264(), this.baseDz + pos.method_10260());
        return class_310.method_1551().field_1687.method_8311(worldPos);
    }

    public int method_31607() {
        return this.bottomY;
    }

    public int method_31600() {
        return this.topY;
    }

    public int method_31605() {
        return this.topY - this.bottomY + 1;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Entry {
        public final class_2680 state;
        public final class_2338 pos;

        public Entry(class_2680 state, class_2338 pos) {
            this.state = state;
            this.pos = pos;
        }
    }
}

