/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.gizmos;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BiFunction;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.UIRenderingContext;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class BoneGizmoSystem {
    private static final BoneGizmoSystem INSTANCE = new BoneGizmoSystem();
    private Mode mode = Mode.TRANSLATE;
    private Mode hoveredSubMode = null;
    private Mode activeSubMode = null;
    private Plane hoveredPlane = null;
    private Plane activePlane = null;
    private Axis hoveredAxis = null;
    private Axis activeAxis = null;
    private boolean dragging = false;
    private boolean lastMouseDown = false;
    private boolean lastCtrlPressedWhileDragging = false;
    private boolean lastShiftPressedWhileDragging = false;
    private int dragStartX = 0;
    private int dragStartY = 0;
    private Transform dragStart = new Transform();
    private UIPropTransform target;
    private float rotateSign = 1.0f;
    private boolean useRotation2 = false;
    private float gizmoScale = 0.2f;
    private float minGizmoScale = 0.6f;
    private float maxGizmoScale = 10.0f;
    private float scaleSlope = 0.75f;
    private static final double[] CURSOR_X = new double[1];
    private static final double[] CURSOR_Y = new double[1];
    private final Timer wrapChecker = new Timer(30L);
    private int lastX = 0;
    private int lastY = 0;
    private float accumDx = 0.0f;
    private float accumDy = 0.0f;
    private int centerX;
    private int centerY;
    private int handleLen = 100;
    private int handleThickness = 5;
    private int hitRadius = 10;
    private int ringRX = 50;
    private int ringRY = 70;
    private int ringRZ = 90;
    private int endXx;
    private int endXy;
    private int endYx;
    private int endYy;
    private int endZx;
    private int endZy;

    public static BoneGizmoSystem get() {
        return INSTANCE;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        this.hoveredSubMode = null;
        this.activeSubMode = null;
        this.hoveredPlane = null;
        this.activePlane = null;
    }

    public void toggleRotationChannel() {
        this.useRotation2 = !this.useRotation2;
    }

    public boolean isUsingRotation2() {
        return this.useRotation2;
    }

    public void update(UIContext input, Area viewport, UIPropTransform target) {
        this.target = target;
        if (viewport == null) {
            return;
        }
        this.centerX = viewport.mx();
        this.centerY = viewport.my();
        this.hoveredAxis = this.detectHoveredAxis(input.mouseX, input.mouseY);
        boolean mouseDown = Window.isMouseButtonPressed(1);
        if (!this.dragging && mouseDown && !this.lastMouseDown && this.hoveredAxis != null) {
            this.dragging = true;
            this.activeAxis = this.hoveredAxis;
            this.activeSubMode = this.mode == Mode.UNIVERSAL ? (this.hoveredSubMode != null ? this.hoveredSubMode : Mode.ROTATE) : this.mode;
            this.activePlane = this.hoveredPlane;
            this.dragStartX = input.mouseX;
            this.dragStartY = input.mouseY;
            this.lastX = input.mouseX;
            this.lastY = input.mouseY;
            this.accumDx = 0.0f;
            this.accumDy = 0.0f;
            this.lastCtrlPressedWhileDragging = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
            this.lastShiftPressedWhileDragging = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
            if (this.target != null && this.target.getTransform() != null) {
                this.dragStart.copy(this.target.getTransform());
            }
        }
        if (this.dragging && !mouseDown && this.lastMouseDown) {
            this.dragging = false;
            this.activeAxis = null;
        }
        if (this.dragging && this.target != null && this.target.getTransform() != null) {
            Mode op;
            boolean shiftChanged;
            boolean warped = false;
            if (this.wrapChecker.isTime()) {
                GLFW.glfwGetCursorPos((long)Window.getWindow(), (double[])CURSOR_X, (double[])CURSOR_Y);
                class_310 mc = class_310.method_1551();
                int w = mc.method_22683().method_4480();
                int h = mc.method_22683().method_4507();
                double rawX = CURSOR_X[0];
                double rawY = CURSOR_Y[0];
                double fx = Math.ceil((double)w / (double)input.menu.width);
                double fy = Math.ceil((double)h / (double)input.menu.height);
                int border = 5;
                int borderPadding = border + 1;
                if (rawX <= (double)border) {
                    Window.moveCursor(w - borderPadding, (int)mc.field_1729.method_1604());
                    this.lastX = input.menu.width - (int)((double)borderPadding / fx);
                    this.wrapChecker.mark();
                    warped = true;
                } else if (rawX >= (double)(w - border)) {
                    Window.moveCursor(borderPadding, (int)mc.field_1729.method_1604());
                    this.lastX = (int)((double)borderPadding / fx);
                    this.wrapChecker.mark();
                    warped = true;
                }
                if (rawY <= (double)border) {
                    Window.moveCursor((int)mc.field_1729.method_1603(), h - borderPadding);
                    this.lastY = input.menu.height - (int)((double)borderPadding / fy);
                    this.wrapChecker.mark();
                    warped = true;
                } else if (rawY >= (double)(h - border)) {
                    Window.moveCursor((int)mc.field_1729.method_1603(), borderPadding);
                    this.lastY = (int)((double)borderPadding / fy);
                    this.wrapChecker.mark();
                    warped = true;
                }
            }
            boolean ctrlNow = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
            boolean shiftNow = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
            boolean ctrlChanged = ctrlNow != this.lastCtrlPressedWhileDragging;
            boolean bl = shiftChanged = ctrlNow && shiftNow != this.lastShiftPressedWhileDragging;
            if (ctrlChanged || shiftChanged) {
                Transform current = this.target.getTransform();
                if (current != null) {
                    if (this.useRotation2) {
                        this.dragStart.rotate2.x = current.rotate2.x;
                        this.dragStart.rotate2.y = current.rotate2.y;
                        this.dragStart.rotate2.z = current.rotate2.z;
                    } else {
                        this.dragStart.rotate.x = current.rotate.x;
                        this.dragStart.rotate.y = current.rotate.y;
                        this.dragStart.rotate.z = current.rotate.z;
                    }
                }
                this.accumDx = 0.0f;
                this.accumDy = 0.0f;
                this.lastCtrlPressedWhileDragging = ctrlNow;
                this.lastShiftPressedWhileDragging = shiftNow;
            }
            if (!warped) {
                int stepX = input.mouseX - this.lastX;
                int stepY = input.mouseY - this.lastY;
                this.accumDx += (float)stepX;
                this.accumDy += (float)stepY;
                this.lastX = input.mouseX;
                this.lastY = input.mouseY;
            }
            float factor = switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0.02f;
                case 2 -> 0.01f;
                case 1 -> 0.3f;
                case 4 -> 0.02f;
                case 3 -> {
                    Mode opInner;
                    Mode v2 = opInner = this.activeSubMode != null ? this.activeSubMode : Mode.TRANSLATE;
                    if (opInner == Mode.TRANSLATE) {
                        yield 0.02f;
                    }
                    if (opInner == Mode.SCALE) {
                        yield 0.01f;
                    }
                    yield 0.3f;
                }
            };
            float delta = this.accumDx * factor;
            Transform t = this.target.getTransform();
            Mode mode = this.mode == Mode.UNIVERSAL ? (this.activeSubMode != null ? this.activeSubMode : Mode.ROTATE) : (op = this.mode);
            if (op == Mode.TRANSLATE) {
                float x = t.translate.x;
                float y = t.translate.y;
                float z = t.translate.z;
                if (this.activePlane == null) {
                    if (this.activeAxis == Axis.X) {
                        x = this.dragStart.translate.x + delta;
                    }
                    if (this.activeAxis == Axis.Y) {
                        y = this.dragStart.translate.y - this.accumDy * factor;
                    }
                    if (this.activeAxis == Axis.Z) {
                        z = this.dragStart.translate.z + delta;
                    }
                } else {
                    switch (this.activePlane.ordinal()) {
                        case 0: {
                            x = this.dragStart.translate.x + delta;
                            y = this.dragStart.translate.y - this.accumDy * factor;
                            break;
                        }
                        case 2: {
                            z = this.dragStart.translate.z + delta;
                            x = this.dragStart.translate.x - this.accumDy * factor;
                            break;
                        }
                        case 1: {
                            z = this.dragStart.translate.z + delta;
                            y = this.dragStart.translate.y - this.accumDy * factor;
                        }
                    }
                }
                this.target.setT(null, x, y, z);
                this.target.setTransform(t);
            } else if (op == Mode.SCALE) {
                float x = t.scale.x;
                float y = t.scale.y;
                float z = t.scale.z;
                if (this.activeAxis == Axis.X) {
                    x = this.clampScale(this.dragStart.scale.x + delta);
                }
                if (this.activeAxis == Axis.Y) {
                    y = this.clampScale(this.dragStart.scale.y + delta);
                }
                if (this.activeAxis == Axis.Z) {
                    z = this.clampScale(this.dragStart.scale.z + delta);
                }
                this.target.setS(null, x, y, z);
                this.target.setTransform(t);
            } else if (op == Mode.ROTATE) {
                float rz;
                float ry;
                float rx;
                if (this.useRotation2) {
                    rx = (float)Math.toDegrees(this.dragStart.rotate2.x);
                    ry = (float)Math.toDegrees(this.dragStart.rotate2.y);
                    rz = (float)Math.toDegrees(this.dragStart.rotate2.z);
                } else {
                    rx = (float)Math.toDegrees(this.dragStart.rotate.x);
                    ry = (float)Math.toDegrees(this.dragStart.rotate.y);
                    rz = (float)Math.toDegrees(this.dragStart.rotate.z);
                }
                boolean xyHeld = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
                boolean zyHeld = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
                if (zyHeld) {
                    float zDelta = this.accumDx * factor * 10.0f;
                    float yDelta = -this.accumDy * factor * 10.0f;
                    rz += zDelta;
                    ry += yDelta;
                } else if (xyHeld) {
                    float yDelta = this.accumDx * factor * 10.0f;
                    float xDelta = -this.accumDy * factor * 10.0f;
                    ry += yDelta;
                    rx += xDelta;
                } else {
                    if (this.activeAxis == Axis.X) {
                        rx += delta * 10.0f;
                    }
                    if (this.activeAxis == Axis.Y) {
                        ry += delta * 10.0f;
                    }
                    if (this.activeAxis == Axis.Z) {
                        rz += delta * 10.0f;
                    }
                }
                if (this.useRotation2) {
                    this.target.setR2(null, rx, ry, rz);
                } else {
                    this.target.setR(null, rx, ry, rz);
                }
                this.target.setTransform(t);
            }
        }
        this.lastMouseDown = mouseDown;
    }

    public void update(UIContext input, Area viewport, Matrix4f origin, Matrix4f projection, Matrix4f view, UIPropTransform target) {
        this.target = target;
        if (viewport == null) {
            return;
        }
        if (origin != null && projection != null && view != null) {
            if (((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
                this.hoveredAxis = this.detectHoveredAxis3D(input, viewport, origin, projection, view);
                Matrix4f mvp = new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)view).mul((Matrix4fc)origin);
                Vector4f cp = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                mvp.transform(cp);
                if (cp.w != 0.0f) {
                    float ndcXc = cp.x / cp.w;
                    float ndcYc = cp.y / cp.w;
                    this.centerX = viewport.x + (int)((ndcXc + 1.0f) * 0.5f * (float)viewport.w);
                    this.centerY = viewport.y + (int)((-ndcYc + 1.0f) * 0.5f * (float)viewport.h);
                }
                if (((Boolean)BBSSettings.gizmoDynamic.get()).booleanValue()) {
                    try {
                        Vector4f camW4 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                        Vector4f camWorld = new Matrix4f((Matrix4fc)view).invert(new Matrix4f()).transform(camW4);
                        camWorld.div(camWorld.w);
                        Vector4f pivotW4 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                        Vector4f pivotWorld = new Matrix4f((Matrix4fc)origin).transform(pivotW4);
                        pivotWorld.div(pivotWorld.w);
                        float dx = camWorld.x - pivotWorld.x;
                        float dy = camWorld.y - pivotWorld.y;
                        float dz = camWorld.z - pivotWorld.z;
                        float dist = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
                        float s = dist * this.scaleSlope;
                        if (s < this.minGizmoScale) {
                            s = this.minGizmoScale;
                        }
                        if (s > this.maxGizmoScale) {
                            s = this.maxGizmoScale;
                        }
                        this.gizmoScale = s;
                    }
                    catch (Throwable t) {
                        this.gizmoScale = 1.0f;
                    }
                } else {
                    this.gizmoScale = this.clampScale(((Float)BBSSettings.gizmoScale.get()).floatValue());
                }
                boolean mouseDown = Window.isMouseButtonPressed(0);
                if (!this.dragging && mouseDown && !this.lastMouseDown && this.hoveredAxis != null) {
                    this.dragging = true;
                    this.activeAxis = this.hoveredAxis;
                    this.activeSubMode = this.mode == Mode.UNIVERSAL ? (this.hoveredSubMode != null ? this.hoveredSubMode : Mode.ROTATE) : this.mode;
                    this.activePlane = this.hoveredPlane;
                    this.dragStartX = input.mouseX;
                    this.dragStartY = input.mouseY;
                    this.lastX = input.mouseX;
                    this.lastY = input.mouseY;
                    this.accumDx = 0.0f;
                    this.accumDy = 0.0f;
                    this.lastCtrlPressedWhileDragging = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
                    this.lastShiftPressedWhileDragging = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
                    if (this.target != null && this.target.getTransform() != null) {
                        this.dragStart.copy(this.target.getTransform());
                    }
                    try {
                        float nx = (float)((double)(input.mouseX - viewport.x) / (double)viewport.w * 2.0 - 1.0);
                        float ny = (float)(-((double)(input.mouseY - viewport.y) / (double)viewport.h * 2.0 - 1.0));
                        Matrix4f invPV = new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)view).invert(new Matrix4f());
                        Vector4f nearClip = new Vector4f(nx, ny, -1.0f, 1.0f);
                        Vector4f farClip = new Vector4f(nx, ny, 1.0f, 1.0f);
                        Vector4f nearWorld = invPV.transform(new Vector4f((Vector4fc)nearClip));
                        Vector4f farWorld = invPV.transform(new Vector4f((Vector4fc)farClip));
                        nearWorld.div(nearWorld.w);
                        farWorld.div(farWorld.w);
                        Matrix4f invOrigin = new Matrix4f((Matrix4fc)origin).invert(new Matrix4f());
                        Vector4f nearLocal4 = invOrigin.transform(new Vector4f((Vector4fc)nearWorld));
                        Vector4f farLocal4 = invOrigin.transform(new Vector4f((Vector4fc)farWorld));
                        Vector3f rayO = new Vector3f(nearLocal4.x, nearLocal4.y, nearLocal4.z);
                        Vector3f rayF = new Vector3f(farLocal4.x, farLocal4.y, farLocal4.z);
                        Vector3f rayD = rayF.sub((Vector3fc)rayO, new Vector3f());
                        rayD.normalize();
                        Vector3f n = switch (this.activeAxis) {
                            default -> throw new MatchException(null, null);
                            case Axis.X -> new Vector3f(1.0f, 0.0f, 0.0f);
                            case Axis.Y -> new Vector3f(0.0f, 1.0f, 0.0f);
                            case Axis.Z -> new Vector3f(0.0f, 0.0f, 1.0f);
                        };
                        float denom = n.x * rayD.x + n.y * rayD.y + n.z * rayD.z;
                        this.rotateSign = denom >= 0.0f ? -1.0f : 1.0f;
                    }
                    catch (Throwable t) {
                        this.rotateSign = 1.0f;
                    }
                }
                if (this.dragging && !mouseDown && this.lastMouseDown) {
                    this.dragging = false;
                    this.activeAxis = null;
                    if (this.target != null && this.target.getTransform() != null) {
                        this.dragStart.copy(this.target.getTransform());
                    }
                    this.accumDx = 0.0f;
                    this.accumDy = 0.0f;
                    this.lastX = input.mouseX;
                    this.lastY = input.mouseY;
                }
                if (this.dragging && this.target != null && this.target.getTransform() != null) {
                    boolean shiftChanged;
                    boolean ctrlNow = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
                    boolean shiftNow = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
                    boolean ctrlChanged = ctrlNow != this.lastCtrlPressedWhileDragging;
                    boolean bl = shiftChanged = ctrlNow && shiftNow != this.lastShiftPressedWhileDragging;
                    if (ctrlChanged || shiftChanged) {
                        Transform current = this.target.getTransform();
                        if (current != null) {
                            if (this.useRotation2) {
                                this.dragStart.rotate2.x = current.rotate2.x;
                                this.dragStart.rotate2.y = current.rotate2.y;
                                this.dragStart.rotate2.z = current.rotate2.z;
                            } else {
                                this.dragStart.rotate.x = current.rotate.x;
                                this.dragStart.rotate.y = current.rotate.y;
                                this.dragStart.rotate.z = current.rotate.z;
                            }
                        }
                        this.accumDx = 0.0f;
                        this.accumDy = 0.0f;
                        this.lastCtrlPressedWhileDragging = ctrlNow;
                        this.lastShiftPressedWhileDragging = shiftNow;
                    }
                    int stepX = input.mouseX - this.lastX;
                    int stepY = input.mouseY - this.lastY;
                    this.accumDx += (float)stepX;
                    this.accumDy += (float)stepY;
                    this.lastX = input.mouseX;
                    this.lastY = input.mouseY;
                    Mode op = this.mode == Mode.UNIVERSAL ? (this.activeSubMode != null ? this.activeSubMode : Mode.ROTATE) : this.mode;
                    float factor = switch (op.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 0 -> 0.02f;
                        case 2 -> 0.01f;
                        case 1 -> 0.3f;
                        case 3 -> 0.02f;
                        case 4 -> 0.02f;
                    };
                    float delta = this.accumDx * factor;
                    Transform t = this.target.getTransform();
                    if (op == Mode.TRANSLATE) {
                        float x = t.translate.x;
                        float y = t.translate.y;
                        float z = t.translate.z;
                        if (this.activePlane == null) {
                            if (this.activeAxis == Axis.X) {
                                x = this.dragStart.translate.x + delta;
                            }
                            if (this.activeAxis == Axis.Y) {
                                y = this.dragStart.translate.y - this.accumDy * factor;
                            }
                            if (this.activeAxis == Axis.Z) {
                                z = this.dragStart.translate.z + delta;
                            }
                        } else {
                            switch (this.activePlane.ordinal()) {
                                case 0: {
                                    x = this.dragStart.translate.x + delta;
                                    y = this.dragStart.translate.y - this.accumDy * factor;
                                    break;
                                }
                                case 2: {
                                    z = this.dragStart.translate.z + delta;
                                    x = this.dragStart.translate.x - this.accumDy * factor;
                                    break;
                                }
                                case 1: {
                                    z = this.dragStart.translate.z + delta;
                                    y = this.dragStart.translate.y - this.accumDy * factor;
                                }
                            }
                        }
                        this.target.setT(null, x, y, z);
                        this.target.setTransform(t);
                    } else if (op == Mode.SCALE) {
                        float x = t.scale.x;
                        float y = t.scale.y;
                        float z = t.scale.z;
                        if (this.activeAxis == Axis.X) {
                            x = this.clampScale(this.dragStart.scale.x + delta);
                        }
                        if (this.activeAxis == Axis.Y) {
                            y = this.clampScale(this.dragStart.scale.y + delta);
                        }
                        if (this.activeAxis == Axis.Z) {
                            z = this.clampScale(this.dragStart.scale.z + delta);
                        }
                        this.target.setS(null, x, y, z);
                        this.target.setTransform(t);
                    } else if (op == Mode.ROTATE) {
                        float rz;
                        float ry;
                        float rx;
                        if (this.useRotation2) {
                            rx = (float)Math.toDegrees(this.dragStart.rotate2.x);
                            ry = (float)Math.toDegrees(this.dragStart.rotate2.y);
                            rz = (float)Math.toDegrees(this.dragStart.rotate2.z);
                        } else {
                            rx = (float)Math.toDegrees(this.dragStart.rotate.x);
                            ry = (float)Math.toDegrees(this.dragStart.rotate.y);
                            rz = (float)Math.toDegrees(this.dragStart.rotate.z);
                        }
                        boolean xyHeld = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
                        boolean zyHeld = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
                        if (zyHeld) {
                            float zDelta = this.accumDx * factor * 10.0f;
                            float yDelta = -this.accumDy * factor * 10.0f;
                            rz += zDelta;
                            ry += yDelta;
                        } else if (xyHeld) {
                            float yDelta = this.accumDx * factor * 10.0f;
                            float xDelta = -this.accumDy * factor * 10.0f;
                            ry += yDelta;
                            rx += xDelta;
                        } else {
                            float d = delta * this.rotateSign * 10.0f;
                            if (this.activeAxis == Axis.X) {
                                rx += d;
                            }
                            if (this.activeAxis == Axis.Y) {
                                ry += d;
                            }
                            if (this.activeAxis == Axis.Z) {
                                rz += d;
                            }
                        }
                        if (this.useRotation2) {
                            this.target.setR2(null, rx, ry, rz);
                        } else {
                            this.target.setR(null, rx, ry, rz);
                        }
                        this.target.setTransform(t);
                    } else if (op == Mode.PIVOT) {
                        float x = t.pivot.x;
                        float y = t.pivot.y;
                        float z = t.pivot.z;
                        if (this.activePlane == null) {
                            if (this.activeAxis == Axis.X) {
                                x = this.dragStart.pivot.x + delta;
                            }
                            if (this.activeAxis == Axis.Y) {
                                y = this.dragStart.pivot.y - this.accumDy * factor;
                            }
                            if (this.activeAxis == Axis.Z) {
                                z = this.dragStart.pivot.z + delta;
                            }
                        } else {
                            switch (this.activePlane.ordinal()) {
                                case 0: {
                                    x = this.dragStart.pivot.x + delta;
                                    y = this.dragStart.pivot.y - this.accumDy * factor;
                                    break;
                                }
                                case 2: {
                                    z = this.dragStart.pivot.z + delta;
                                    x = this.dragStart.pivot.x - this.accumDy * factor;
                                    break;
                                }
                                case 1: {
                                    z = this.dragStart.pivot.z + delta;
                                    y = this.dragStart.pivot.y - this.accumDy * factor;
                                }
                            }
                        }
                        this.target.setP(null, x, y, z);
                        this.target.setTransform(t);
                    }
                }
                this.lastMouseDown = Window.isMouseButtonPressed(0);
                return;
            }
            Matrix4f mvp = new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)view).mul((Matrix4fc)origin);
            Vector4f p = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            mvp.transform(p);
            if (p.w != 0.0f) {
                float ndcX = p.x / p.w;
                float ndcY = p.y / p.w;
                int px = viewport.x + (int)((ndcX + 1.0f) * 0.5f * (float)viewport.w);
                int py = viewport.y + (int)((-ndcY + 1.0f) * 0.5f * (float)viewport.h);
                this.centerX = px;
                this.centerY = py;
                float axisLen = 0.6f;
                Vector4f p0World = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
                origin.transform(p0World);
                boolean useLocal = this.target != null && this.target.isLocal();
                Vector4f dx = new Vector4f(axisLen, 0.0f, 0.0f, useLocal ? 0.0f : 0.0f);
                Vector4f dy = new Vector4f(0.0f, axisLen, 0.0f, useLocal ? 0.0f : 0.0f);
                Vector4f dz = new Vector4f(0.0f, 0.0f, axisLen, useLocal ? 0.0f : 0.0f);
                if (useLocal) {
                    origin.transform(dx);
                    origin.transform(dy);
                    origin.transform(dz);
                    dx.x += p0World.x;
                    dx.y += p0World.y;
                    dx.z += p0World.z;
                    dx.w = 1.0f;
                    dy.x += p0World.x;
                    dy.y += p0World.y;
                    dy.z += p0World.z;
                    dy.w = 1.0f;
                    dz.x += p0World.x;
                    dz.y += p0World.y;
                    dz.z += p0World.z;
                    dz.w = 1.0f;
                } else {
                    dx.x = p0World.x + axisLen;
                    dx.y = p0World.y;
                    dx.z = p0World.z;
                    dx.w = 1.0f;
                    dy.x = p0World.x;
                    dy.y = p0World.y + axisLen;
                    dy.z = p0World.z;
                    dy.w = 1.0f;
                    dz.x = p0World.x;
                    dz.y = p0World.y;
                    dz.z = p0World.z + axisLen;
                    dz.w = 1.0f;
                }
                Vector4f sx = new Vector4f((Vector4fc)dx);
                Vector4f sy = new Vector4f((Vector4fc)dy);
                Vector4f sz = new Vector4f((Vector4fc)dz);
                Matrix4f pv = new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)view);
                pv.transform(sx);
                pv.transform(sy);
                pv.transform(sz);
                if (sx.w != 0.0f) {
                    float ndcXx = sx.x / sx.w;
                    float ndcXy = sx.y / sx.w;
                    this.endXx = viewport.x + (int)((ndcXx + 1.0f) * 0.5f * (float)viewport.w);
                    this.endXy = viewport.y + (int)((-ndcXy + 1.0f) * 0.5f * (float)viewport.h);
                }
                if (sy.w != 0.0f) {
                    float ndcYx = sy.x / sy.w;
                    float ndcYy = sy.y / sy.w;
                    this.endYx = viewport.x + (int)((ndcYx + 1.0f) * 0.5f * (float)viewport.w);
                    this.endYy = viewport.y + (int)((-ndcYy + 1.0f) * 0.5f * (float)viewport.h);
                }
                if (sz.w != 0.0f) {
                    float ndcZx = sz.x / sz.w;
                    float ndcZy = sz.y / sz.w;
                    this.endZx = viewport.x + (int)((ndcZx + 1.0f) * 0.5f * (float)viewport.w);
                    this.endZy = viewport.y + (int)((-ndcZy + 1.0f) * 0.5f * (float)viewport.h);
                }
            } else {
                this.centerX = viewport.mx();
                this.centerY = viewport.my();
                this.endXx = this.centerX + this.handleLen;
                this.endXy = this.centerY;
                this.endYx = this.centerX;
                this.endYy = this.centerY - this.handleLen;
                this.endZx = this.centerX;
                this.endZy = this.centerY + this.handleLen;
            }
        } else {
            this.centerX = viewport.mx();
            this.centerY = viewport.my();
            this.endXx = this.centerX + this.handleLen;
            this.endXy = this.centerY;
            this.endYx = this.centerX;
            this.endYy = this.centerY - this.handleLen;
            this.endZx = this.centerX;
            this.endZy = this.centerY + this.handleLen;
        }
        this.hoveredAxis = this.detectHoveredAxis(input.mouseX, input.mouseY);
        boolean mouseDown = Window.isMouseButtonPressed(0);
        if (!this.dragging && mouseDown && !this.lastMouseDown && this.hoveredAxis != null) {
            this.dragging = true;
            this.activeAxis = this.hoveredAxis;
            this.dragStartX = input.mouseX;
            this.dragStartY = input.mouseY;
            this.lastX = input.mouseX;
            this.lastY = input.mouseY;
            this.accumDx = 0.0f;
            this.accumDy = 0.0f;
            if (this.target != null && this.target.getTransform() != null) {
                this.dragStart.copy(this.target.getTransform());
            }
        }
        if (this.dragging && !mouseDown && this.lastMouseDown) {
            this.dragging = false;
            this.activeAxis = null;
        }
        if (this.dragging && this.target != null && this.target.getTransform() != null) {
            Mode op;
            boolean warped = false;
            if (this.wrapChecker.isTime()) {
                GLFW.glfwGetCursorPos((long)Window.getWindow(), (double[])CURSOR_X, (double[])CURSOR_Y);
                class_310 mc = class_310.method_1551();
                int w = mc.method_22683().method_4480();
                int h = mc.method_22683().method_4507();
                double rawX = CURSOR_X[0];
                double rawY = CURSOR_Y[0];
                double fx = Math.ceil((double)w / (double)input.menu.width);
                double fy = Math.ceil((double)h / (double)input.menu.height);
                int border = 5;
                int borderPadding = border + 1;
                if (rawX <= (double)border) {
                    Window.moveCursor(w - borderPadding, (int)mc.field_1729.method_1604());
                    this.lastX = input.menu.width - (int)((double)borderPadding / fx);
                    this.wrapChecker.mark();
                    warped = true;
                } else if (rawX >= (double)(w - border)) {
                    Window.moveCursor(borderPadding, (int)mc.field_1729.method_1604());
                    this.lastX = (int)((double)borderPadding / fx);
                    this.wrapChecker.mark();
                    warped = true;
                }
                if (rawY <= (double)border) {
                    Window.moveCursor((int)mc.field_1729.method_1603(), h - borderPadding);
                    this.lastY = input.menu.height - (int)((double)borderPadding / fy);
                    this.wrapChecker.mark();
                    warped = true;
                } else if (rawY >= (double)(h - border)) {
                    Window.moveCursor((int)mc.field_1729.method_1603(), borderPadding);
                    this.lastY = (int)((double)borderPadding / fy);
                    this.wrapChecker.mark();
                    warped = true;
                }
            }
            if (!warped) {
                int stepX = input.mouseX - this.lastX;
                int stepY = input.mouseY - this.lastY;
                this.accumDx += (float)stepX;
                this.accumDy += (float)stepY;
                this.lastX = input.mouseX;
                this.lastY = input.mouseY;
            }
            float factor = switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0.02f;
                case 2 -> 0.01f;
                case 1 -> 0.3f;
                case 4 -> 0.02f;
                case 3 -> {
                    Mode opInner;
                    Mode v4 = opInner = this.activeSubMode != null ? this.activeSubMode : Mode.TRANSLATE;
                    if (opInner == Mode.TRANSLATE) {
                        yield 0.02f;
                    }
                    if (opInner == Mode.SCALE) {
                        yield 0.01f;
                    }
                    yield 0.3f;
                }
            };
            float delta = this.accumDx * factor;
            Transform t = this.target.getTransform();
            Mode mode = this.mode == Mode.UNIVERSAL ? (this.activeSubMode != null ? this.activeSubMode : Mode.TRANSLATE) : (op = this.mode);
            if (op == Mode.TRANSLATE) {
                x = t.translate.x;
                float y = t.translate.y;
                float z = t.translate.z;
                if (this.activePlane == null) {
                    if (this.activeAxis == Axis.X) {
                        x = this.dragStart.translate.x + delta;
                    }
                    if (this.activeAxis == Axis.Y) {
                        y = this.dragStart.translate.y - this.accumDy * factor;
                    }
                    if (this.activeAxis == Axis.Z) {
                        z = this.dragStart.translate.z + delta;
                    }
                } else {
                    switch (this.activePlane.ordinal()) {
                        case 0: {
                            x = this.dragStart.translate.x + delta;
                            y = this.dragStart.translate.y - this.accumDy * factor;
                            break;
                        }
                        case 2: {
                            z = this.dragStart.translate.z + delta;
                            x = this.dragStart.translate.x - this.accumDy * factor;
                            break;
                        }
                        case 1: {
                            y = this.dragStart.translate.y + delta;
                            z = this.dragStart.translate.z - this.accumDy * factor;
                        }
                    }
                }
                this.target.setT(null, x, y, z);
                this.target.setTransform(t);
            } else if (op == Mode.SCALE) {
                x = t.scale.x;
                float y = t.scale.y;
                float z = t.scale.z;
                if (this.activeAxis == Axis.X) {
                    x = this.clampScale(this.dragStart.scale.x + delta);
                }
                if (this.activeAxis == Axis.Y) {
                    y = this.clampScale(this.dragStart.scale.y + delta);
                }
                if (this.activeAxis == Axis.Z) {
                    z = this.clampScale(this.dragStart.scale.z + delta);
                }
                this.target.setS(null, x, y, z);
                this.target.setTransform(t);
            } else if (op == Mode.ROTATE) {
                float rz;
                float ry;
                float rx;
                if (this.useRotation2) {
                    rx = (float)Math.toDegrees(this.dragStart.rotate2.x);
                    ry = (float)Math.toDegrees(this.dragStart.rotate2.y);
                    rz = (float)Math.toDegrees(this.dragStart.rotate2.z);
                } else {
                    rx = (float)Math.toDegrees(this.dragStart.rotate.x);
                    ry = (float)Math.toDegrees(this.dragStart.rotate.y);
                    rz = (float)Math.toDegrees(this.dragStart.rotate.z);
                }
                boolean xyHeld3D = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_XY);
                boolean zyHeld3D = this.isComboHeld(Keys.GIZMOS_FREE_ROTATE_ZY);
                if (zyHeld3D) {
                    float zDelta = this.accumDx * factor * 10.0f;
                    float yDelta = -this.accumDy * factor * 10.0f;
                    rz += zDelta;
                    ry += yDelta;
                } else if (xyHeld3D) {
                    float yDelta = this.accumDx * factor * 10.0f;
                    float xDelta = -this.accumDy * factor * 10.0f;
                    ry += yDelta;
                    rx += xDelta;
                } else {
                    if (this.activeAxis == Axis.X) {
                        rx += delta * 10.0f;
                    }
                    if (this.activeAxis == Axis.Y) {
                        ry += delta * 10.0f;
                    }
                    if (this.activeAxis == Axis.Z) {
                        rz += delta * 10.0f;
                    }
                }
                if (this.useRotation2) {
                    this.target.setR2(null, rx, ry, rz);
                } else {
                    this.target.setR(null, rx, ry, rz);
                }
                this.target.setTransform(t);
            }
        }
        this.lastMouseDown = mouseDown;
    }

    private boolean isComboHeld(KeyCombo combo) {
        if (combo == null) {
            return false;
        }
        for (int key : combo.keys) {
            if (Window.isKeyPressed(key)) continue;
            return false;
        }
        return true;
    }

    private float clampScale(float v) {
        return Math.max(0.001f, v);
    }

    public void render3D(class_4587 stack) {
        boolean showZ;
        class_287 builder = new class_287(new class_9799(1536), class_293.class_5596.field_27379, class_290.field_1576);
        int design = (Integer)BBSSettings.gizmoDesign.get();
        boolean blockbench = design == 2;
        boolean thinDesign = design == 1 || blockbench;
        float baseLength = blockbench ? 0.35f : 0.25f;
        float length = baseLength * this.gizmoScale;
        float thickness = (blockbench ? 0.01f : (thinDesign ? 0.012f : 0.02f)) * this.gizmoScale;
        float outlinePad = (thinDesign ? 0.0f : 0.01f) * this.gizmoScale;
        float slabThick = (blockbench ? 0.01f : (thinDesign ? 0.012f : 0.018f)) * this.gizmoScale;
        float cubeSmall = 0.022f * this.gizmoScale;
        float cubeBig = 0.045f * this.gizmoScale;
        float connectFudge = this.mode == Mode.TRANSLATE ? 0.03f : (this.mode == Mode.SCALE ? slabThick : cubeBig + thickness);
        boolean showX = !this.dragging || this.activePlane == null && this.activeAxis == Axis.X;
        boolean showY = !this.dragging || this.activePlane == null && this.activeAxis == Axis.Y;
        boolean bl = showZ = !this.dragging || this.activePlane == null && this.activeAxis == Axis.Z;
        if (this.mode == Mode.SCALE) {
            if (showX) {
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, length + connectFudge, 0.0f, 0.0f, thickness + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, length + connectFudge, 0.0f, 0.0f, thickness, 1.0f, 0.0f, 0.0f, 1.0f);
            }
            if (showY) {
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, 0.0f, length + connectFudge, 0.0f, thickness + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, 0.0f, length + connectFudge, 0.0f, thickness, 0.0f, 1.0f, 0.0f, 1.0f);
            }
            if (showZ) {
                Draw.fillBox(builder, stack, -(thickness + outlinePad) / 2.0f, -(thickness + outlinePad) / 2.0f, 0.0f, (thickness + outlinePad) / 2.0f, (thickness + outlinePad) / 2.0f, length + connectFudge, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBox(builder, stack, -thickness / 2.0f, -thickness / 2.0f, 0.0f, thickness / 2.0f, thickness / 2.0f, length + connectFudge, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
        if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT) {
            float txZ;
            float headLen = (blockbench ? 0.06f : 0.08f) * this.gizmoScale;
            float headWidth = (blockbench ? 0.04f : 0.06f) * this.gizmoScale;
            float headRadius = headWidth * 0.5f;
            float sphereR = 0.045f * this.gizmoScale;
            float lengthBar = length + connectFudge;
            float barEnd = lengthBar - (this.mode == Mode.PIVOT ? sphereR : headLen) - 0.002f;
            boolean hx = this.hoveredAxis == Axis.X;
            boolean hy = this.hoveredAxis == Axis.Y;
            boolean hz = this.hoveredAxis == Axis.Z;
            float txX = hx ? thickness * 1.5f : thickness;
            float txY = hy ? thickness * 1.5f : thickness;
            float f = txZ = hz ? thickness * 1.5f : thickness;
            if (showX) {
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, barEnd, 0.0f, 0.0f, txX + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, barEnd, 0.0f, 0.0f, txX, 1.0f, 0.0f, 0.0f, 1.0f);
            }
            if (showY) {
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, 0.0f, barEnd, 0.0f, txY + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, 0.0f, barEnd, 0.0f, txY, 0.0f, 1.0f, 0.0f, 1.0f);
            }
            if (showZ) {
                Draw.fillBox(builder, stack, -(txZ + outlinePad) / 2.0f, -(txZ + outlinePad) / 2.0f, 0.0f, (txZ + outlinePad) / 2.0f, (txZ + outlinePad) / 2.0f, barEnd, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBox(builder, stack, -txZ / 2.0f, -txZ / 2.0f, 0.0f, txZ / 2.0f, txZ / 2.0f, barEnd, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT && blockbench) {
                if (showX) {
                    this.drawCone3D(builder, stack, 'X', lengthBar, headLen + outlinePad * 0.5f, headRadius + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.drawCone3D(builder, stack, 'X', lengthBar, headLen, headRadius, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (showY) {
                    this.drawCone3D(builder, stack, 'Y', lengthBar, headLen + outlinePad * 0.5f, headRadius + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.drawCone3D(builder, stack, 'Y', lengthBar, headLen, headRadius, 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (showZ) {
                    this.drawCone3D(builder, stack, 'Z', lengthBar, headLen + outlinePad * 0.5f, headRadius + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.drawCone3D(builder, stack, 'Z', lengthBar, headLen, headRadius, 0.0f, 0.0f, 1.0f, 1.0f);
                }
            } else {
                if (showX) {
                    this.drawSphere3D(builder, stack, 'X', lengthBar, sphereR + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.drawSphere3D(builder, stack, 'X', lengthBar, sphereR, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (showY) {
                    this.drawSphere3D(builder, stack, 'Y', lengthBar, sphereR + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.drawSphere3D(builder, stack, 'Y', lengthBar, sphereR, 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (showZ) {
                    this.drawSphere3D(builder, stack, 'Z', lengthBar, sphereR + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.drawSphere3D(builder, stack, 'Z', lengthBar, sphereR, 0.0f, 0.0f, 1.0f, 1.0f);
                }
            }
            this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall + outlinePad, 0.0f, 0.0f, 0.0f);
            if (blockbench && this.mode == Mode.PIVOT) {
                this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall, 0.105882354f, 0.73333335f, 0.9607843f);
            } else {
                this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall, 1.0f, 1.0f, 1.0f);
            }
            if (hx && showX) {
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, barEnd, 0.0f, 0.0f, thickness * 2.0f, 1.0f, 1.0f, 1.0f, 0.25f);
                if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT && blockbench) {
                    this.drawCone3D(builder, stack, 'X', lengthBar, headLen, headRadius, 1.0f, 1.0f, 1.0f, 0.35f);
                } else {
                    this.drawSphere3D(builder, stack, 'X', lengthBar, sphereR, 1.0f, 1.0f, 1.0f, 0.35f);
                }
            }
            if (hy && showY) {
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, 0.0f, barEnd, 0.0f, thickness * 2.0f, 1.0f, 1.0f, 1.0f, 0.25f);
                if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT && blockbench) {
                    this.drawCone3D(builder, stack, 'Y', lengthBar, headLen, headRadius, 1.0f, 1.0f, 1.0f, 0.35f);
                } else {
                    this.drawSphere3D(builder, stack, 'Y', lengthBar, sphereR, 1.0f, 1.0f, 1.0f, 0.35f);
                }
            }
            if (hz && showZ) {
                Draw.fillBox(builder, stack, -thickness, -thickness, 0.0f, thickness, thickness, barEnd, 1.0f, 1.0f, 1.0f, 0.25f);
                if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT && blockbench) {
                    this.drawCone3D(builder, stack, 'Z', lengthBar, headLen, headRadius, 1.0f, 1.0f, 1.0f, 0.35f);
                } else {
                    this.drawSphere3D(builder, stack, 'Z', lengthBar, sphereR, 1.0f, 1.0f, 1.0f, 0.35f);
                }
            }
            if (((Boolean)BBSSettings.gizmoPlanes.get()).booleanValue()) {
                boolean showPlaneYZ;
                float offset = 0.08f * this.gizmoScale;
                float planeHalf = 0.02f * this.gizmoScale;
                float planeThick = 0.004f * this.gizmoScale;
                boolean hXY = this.hoveredPlane == Plane.XY || this.activePlane == Plane.XY;
                boolean hZX = this.hoveredPlane == Plane.ZX || this.activePlane == Plane.ZX;
                boolean hYZ = this.hoveredPlane == Plane.YZ || this.activePlane == Plane.YZ;
                boolean showPlaneXY = !this.dragging || this.activePlane == Plane.XY;
                boolean showPlaneZX = !this.dragging || this.activePlane == Plane.ZX;
                boolean bl2 = showPlaneYZ = !this.dragging || this.activePlane == Plane.YZ;
                if (!thinDesign && showPlaneXY) {
                    Draw.fillBox(builder, stack, offset - planeHalf, offset - planeHalf, -planeThick, offset + planeHalf, offset + planeHalf, planeThick, 0.0f, 0.0f, 0.0f, 1.0f);
                }
                if (showPlaneXY) {
                    Draw.fillBox(builder, stack, offset - (planeHalf - 0.002f), offset - (planeHalf - 0.002f), -(planeThick - 0.002f), offset + (planeHalf - 0.002f), offset + (planeHalf - 0.002f), planeThick - 0.002f, 0.0f, 0.0f, 1.0f, 1.0f);
                }
                if (hXY && showPlaneXY) {
                    Draw.fillBox(builder, stack, offset - (planeHalf + 0.004f), offset - (planeHalf + 0.004f), -(planeThick + 0.004f), offset + (planeHalf + 0.004f), offset + (planeHalf + 0.004f), planeThick + 0.004f, 1.0f, 1.0f, 1.0f, 0.3f);
                }
                if (!thinDesign && showPlaneZX) {
                    Draw.fillBox(builder, stack, offset - planeHalf, -planeThick, offset - planeHalf, offset + planeHalf, planeThick, offset + planeHalf, 0.0f, 0.0f, 0.0f, 1.0f);
                }
                if (showPlaneZX) {
                    Draw.fillBox(builder, stack, offset - (planeHalf - 0.002f), -(planeThick - 0.002f), offset - (planeHalf - 0.002f), offset + (planeHalf - 0.002f), planeThick - 0.002f, offset + (planeHalf - 0.002f), 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (hZX && showPlaneZX) {
                    Draw.fillBox(builder, stack, offset - (planeHalf + 0.004f), -(planeThick + 0.004f), offset - (planeHalf + 0.004f), offset + (planeHalf + 0.004f), planeThick + 0.004f, offset + (planeHalf + 0.004f), 1.0f, 1.0f, 1.0f, 0.3f);
                }
                if (!thinDesign && showPlaneYZ) {
                    Draw.fillBox(builder, stack, -planeThick, offset - planeHalf, offset - planeHalf, planeThick, offset + planeHalf, offset + planeHalf, 0.0f, 0.0f, 0.0f, 1.0f);
                }
                if (showPlaneYZ) {
                    Draw.fillBox(builder, stack, -(planeThick - 0.002f), offset - (planeHalf - 0.002f), offset - (planeHalf - 0.002f), planeThick - 0.002f, offset + (planeHalf - 0.002f), offset + (planeHalf - 0.002f), 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (hYZ && showPlaneYZ) {
                    Draw.fillBox(builder, stack, -(planeThick + 0.004f), offset - (planeHalf + 0.004f), offset - (planeHalf + 0.004f), planeThick + 0.004f, offset + (planeHalf + 0.004f), offset + (planeHalf + 0.004f), 1.0f, 1.0f, 1.0f, 0.3f);
                }
            }
        } else if (this.mode == Mode.SCALE) {
            boolean hz;
            boolean hx = this.hoveredAxis == Axis.X;
            boolean hy = this.hoveredAxis == Axis.Y;
            boolean bl3 = hz = this.hoveredAxis == Axis.Z;
            if (showX) {
                stack.method_22903();
                stack.method_46416(length, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -(slabThick + outlinePad), -(cubeBig + outlinePad), -(cubeBig + outlinePad), slabThick + outlinePad, cubeBig + outlinePad, cubeBig + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBox(builder, stack, -slabThick, -cubeBig, -cubeBig, slabThick, cubeBig, cubeBig, 1.0f, 0.0f, 0.0f, 1.0f);
                stack.method_22909();
            }
            if (showY) {
                stack.method_22903();
                stack.method_46416(0.0f, length, 0.0f);
                Draw.fillBox(builder, stack, -(cubeBig + outlinePad), -(slabThick + outlinePad), -(cubeBig + outlinePad), cubeBig + outlinePad, slabThick + outlinePad, cubeBig + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBox(builder, stack, -cubeBig, -slabThick, -cubeBig, cubeBig, slabThick, cubeBig, 0.0f, 1.0f, 0.0f, 1.0f);
                stack.method_22909();
            }
            if (showZ) {
                stack.method_22903();
                stack.method_46416(0.0f, 0.0f, length);
                Draw.fillBox(builder, stack, -(cubeBig + outlinePad), -(cubeBig + outlinePad), -(slabThick + outlinePad), cubeBig + outlinePad, cubeBig + outlinePad, slabThick + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                Draw.fillBox(builder, stack, -cubeBig, -cubeBig, -slabThick, cubeBig, cubeBig, slabThick, 0.0f, 0.0f, 1.0f, 1.0f);
                stack.method_22909();
            }
            if (hx && showX) {
                stack.method_22903();
                stack.method_46416(length, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -(slabThick + 0.006f), -(cubeBig + 0.01f), -(cubeBig + 0.01f), slabThick + 0.006f, cubeBig + 0.01f, cubeBig + 0.01f, 1.0f, 1.0f, 1.0f, 0.3f);
                stack.method_22909();
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, length + connectFudge, 0.0f, 0.0f, thickness * 1.6f, 1.0f, 1.0f, 1.0f, 0.25f);
            }
            if (hy && showY) {
                stack.method_22903();
                stack.method_46416(0.0f, length, 0.0f);
                Draw.fillBox(builder, stack, -(cubeBig + 0.01f), -(slabThick + 0.006f), -(cubeBig + 0.01f), cubeBig + 0.01f, slabThick + 0.006f, cubeBig + 0.01f, 1.0f, 1.0f, 1.0f, 0.3f);
                stack.method_22909();
                Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, 0.0f, 0.0f, length + connectFudge, 0.0f, thickness * 1.6f, 1.0f, 1.0f, 1.0f, 0.25f);
            }
            if (hz && showZ) {
                stack.method_22903();
                stack.method_46416(0.0f, 0.0f, length);
                Draw.fillBox(builder, stack, -(cubeBig + 0.01f), -(cubeBig + 0.01f), -(slabThick + 0.006f), cubeBig + 0.01f, cubeBig + 0.01f, slabThick + 0.006f, 1.0f, 1.0f, 1.0f, 0.3f);
                stack.method_22909();
                Draw.fillBox(builder, stack, -thickness, -thickness, 0.0f, thickness, thickness, length + connectFudge, 1.0f, 1.0f, 1.0f, 0.25f);
            }
            this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall + outlinePad, 0.0f, 0.0f, 0.0f);
            this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall, 1.0f, 1.0f, 1.0f);
        } else if (this.mode == Mode.UNIVERSAL) {
            boolean showPlaneYZ;
            float txZ;
            boolean hy;
            boolean hx;
            Mode usingSub;
            Mode mode = usingSub = this.dragging ? this.activeSubMode : null;
            boolean bl4 = this.dragging ? this.activeAxis == Axis.X : (hx = this.hoveredAxis == Axis.X);
            boolean bl5 = this.dragging ? this.activeAxis == Axis.Y : (hy = this.hoveredAxis == Axis.Y);
            boolean hz = this.dragging ? this.activeAxis == Axis.Z : this.hoveredAxis == Axis.Z;
            float lengthBar = 0.28f;
            float headLen = 0.08f;
            float headRadius = 0.03f;
            float txX = hx ? thickness * 1.5f : thickness;
            float txY = hy ? thickness * 1.5f : thickness;
            float f = txZ = hz ? thickness * 1.5f : thickness;
            if (usingSub == null || usingSub == Mode.SCALE) {
                float slabGap = 0.02f;
                float slabOffX = lengthBar + slabGap;
                float slabOffY = lengthBar + slabGap;
                float slabOffZ = lengthBar + slabGap;
                if (showX) {
                    stack.method_22903();
                    stack.method_46416(slabOffX, 0.0f, 0.0f);
                    Draw.fillBox(builder, stack, -(slabThick + outlinePad), -(cubeBig + outlinePad), -(cubeBig + outlinePad), slabThick + outlinePad, cubeBig + outlinePad, cubeBig + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    Draw.fillBox(builder, stack, -slabThick, -cubeBig, -cubeBig, slabThick, cubeBig, cubeBig, 1.0f, 0.0f, 0.0f, 0.75f);
                    if (hx) {
                        Draw.fillBox(builder, stack, -(slabThick + 0.006f), -(cubeBig + 0.01f), -(cubeBig + 0.01f), slabThick + 0.006f, cubeBig + 0.01f, cubeBig + 0.01f, 1.0f, 1.0f, 1.0f, 0.3f);
                    }
                    stack.method_22909();
                }
                if (showY) {
                    stack.method_22903();
                    stack.method_46416(0.0f, slabOffY, 0.0f);
                    Draw.fillBox(builder, stack, -(cubeBig + outlinePad), -(slabThick + outlinePad), -(cubeBig + outlinePad), cubeBig + outlinePad, slabThick + outlinePad, cubeBig + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    Draw.fillBox(builder, stack, -cubeBig, -slabThick, -cubeBig, cubeBig, slabThick, cubeBig, 0.0f, 1.0f, 0.0f, 0.75f);
                    if (hy) {
                        Draw.fillBox(builder, stack, -(cubeBig + 0.01f), -(slabThick + 0.006f), -(cubeBig + 0.01f), cubeBig + 0.01f, slabThick + 0.006f, cubeBig + 0.01f, 1.0f, 1.0f, 1.0f, 0.3f);
                    }
                    stack.method_22909();
                }
                if (showZ) {
                    stack.method_22903();
                    stack.method_46416(0.0f, 0.0f, slabOffZ);
                    Draw.fillBox(builder, stack, -(cubeBig + outlinePad), -(cubeBig + outlinePad), -(slabThick + outlinePad), cubeBig + outlinePad, cubeBig + outlinePad, slabThick + outlinePad, 0.0f, 0.0f, 0.0f, 1.0f);
                    Draw.fillBox(builder, stack, -cubeBig, -cubeBig, -slabThick, cubeBig, cubeBig, slabThick, 0.0f, 0.0f, 1.0f, 0.75f);
                    if (hz) {
                        Draw.fillBox(builder, stack, -(cubeBig + 0.01f), -(cubeBig + 0.01f), -(slabThick + 0.006f), cubeBig + 0.01f, cubeBig + 0.01f, slabThick + 0.006f, 1.0f, 1.0f, 1.0f, 0.3f);
                    }
                    stack.method_22909();
                }
            }
            if (usingSub == null || usingSub == Mode.ROTATE) {
                float radius = 0.22f;
                float thicknessRing = (Integer)BBSSettings.gizmoDesign.get() == 1 ? 0.006f : 0.01f;
                float sweep = 360.0f;
                RenderSystem.disableCull();
                this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, 0.022f + outlinePad, 0.0f, 0.0f, 0.0f);
                this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, 0.022f, 1.0f, 1.0f, 1.0f);
                if (showZ) {
                    this.drawRingArc3D(builder, stack, 'Z', radius, thicknessRing + outlinePad, 0.0f, 0.0f, 0.0f, 0.0f, sweep, false);
                    this.drawRingArc3D(builder, stack, 'Z', radius, thicknessRing, 0.0f, 0.0f, 1.0f, 0.0f, sweep, hz);
                }
                if (showX) {
                    this.drawRingArc3D(builder, stack, 'X', radius, thicknessRing + outlinePad, 0.0f, 0.0f, 0.0f, 0.0f, sweep, false);
                    this.drawRingArc3D(builder, stack, 'X', radius, thicknessRing, 1.0f, 0.0f, 0.0f, 0.0f, sweep, hx);
                }
                if (showY) {
                    this.drawRingArc3D(builder, stack, 'Y', radius, thicknessRing + outlinePad, 0.0f, 0.0f, 0.0f, 0.0f, sweep, false);
                    this.drawRingArc3D(builder, stack, 'Y', radius, thicknessRing, 0.0f, 1.0f, 0.0f, 0.0f, sweep, hy);
                }
                RenderSystem.enableCull();
            }
            float offset = 0.08f;
            float planeHalf = 0.02f;
            float planeThick = 0.004f;
            boolean hXY = this.hoveredPlane == Plane.XY || this.activePlane == Plane.XY;
            boolean hZX = this.hoveredPlane == Plane.ZX || this.activePlane == Plane.ZX;
            boolean hYZ = this.hoveredPlane == Plane.YZ || this.activePlane == Plane.YZ;
            boolean showPlaneXY = !this.dragging || this.activePlane == Plane.XY;
            boolean showPlaneZX = !this.dragging || this.activePlane == Plane.ZX;
            boolean bl6 = showPlaneYZ = !this.dragging || this.activePlane == Plane.YZ;
            if (!thinDesign && showPlaneXY) {
                Draw.fillBox(builder, stack, offset - planeHalf, offset - planeHalf, -planeThick, offset + planeHalf, offset + planeHalf, planeThick, 0.0f, 0.0f, 0.0f, 1.0f);
            }
            if (showPlaneXY) {
                Draw.fillBox(builder, stack, offset - (planeHalf - 0.002f), offset - (planeHalf - 0.002f), -(planeThick - 0.002f), offset + (planeHalf - 0.002f), offset + (planeHalf - 0.002f), planeThick - 0.002f, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            if (hXY && showPlaneXY) {
                Draw.fillBox(builder, stack, offset - (planeHalf + 0.004f), offset - (planeHalf + 0.004f), -(planeThick + 0.004f), offset + (planeHalf + 0.004f), offset + (planeHalf + 0.004f), planeThick + 0.004f, 1.0f, 1.0f, 1.0f, 0.3f);
            }
            if (!thinDesign && showPlaneZX) {
                Draw.fillBox(builder, stack, offset - planeHalf, -planeThick, offset - planeHalf, offset + planeHalf, planeThick, offset + planeHalf, 0.0f, 0.0f, 0.0f, 1.0f);
            }
            if (showPlaneZX) {
                Draw.fillBox(builder, stack, offset - (planeHalf - 0.002f), -(planeThick - 0.002f), offset - (planeHalf - 0.002f), offset + (planeHalf - 0.002f), planeThick - 0.002f, offset + (planeHalf - 0.002f), 0.0f, 1.0f, 0.0f, 1.0f);
            }
            if (hZX && showPlaneZX) {
                Draw.fillBox(builder, stack, offset - (planeHalf + 0.004f), -(planeThick + 0.004f), offset - (planeHalf + 0.004f), offset + (planeHalf + 0.004f), planeThick + 0.004f, offset + (planeHalf + 0.004f), 1.0f, 1.0f, 1.0f, 0.3f);
            }
            if (!thinDesign && showPlaneYZ) {
                Draw.fillBox(builder, stack, -planeThick, offset - planeHalf, offset - planeHalf, planeThick, offset + planeHalf, offset + planeHalf, 0.0f, 0.0f, 0.0f, 1.0f);
            }
            if (showPlaneYZ) {
                Draw.fillBox(builder, stack, -(planeThick - 0.002f), offset - (planeHalf - 0.002f), offset - (planeHalf - 0.002f), planeThick - 0.002f, offset + (planeHalf - 0.002f), offset + (planeHalf - 0.002f), 1.0f, 0.0f, 0.0f, 1.0f);
            }
            if (hYZ && showPlaneYZ) {
                Draw.fillBox(builder, stack, -(planeThick + 0.004f), offset - (planeHalf + 0.004f), offset - (planeHalf + 0.004f), planeThick + 0.004f, offset + (planeHalf + 0.004f), offset + (planeHalf + 0.004f), 1.0f, 1.0f, 1.0f, 0.3f);
            }
        } else if (this.mode == Mode.ROTATE) {
            float radius = 0.22f * this.gizmoScale;
            float sweep = 360.0f;
            float offZ = 0.0f;
            float offX = 0.0f;
            float offY = 0.0f;
            boolean hx = this.hoveredAxis == Axis.X;
            boolean hy = this.hoveredAxis == Axis.Y;
            boolean hz = this.hoveredAxis == Axis.Z;
            RenderSystem.disableCull();
            this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall + outlinePad, 0.0f, 0.0f, 0.0f);
            this.drawEndCube(builder, stack, 0.0f, 0.0f, 0.0f, cubeSmall, 1.0f, 1.0f, 1.0f);
            if (showZ) {
                this.drawRingArc3D(builder, stack, 'Z', radius, thickness + outlinePad, 0.0f, 0.0f, 0.0f, offZ, sweep, false);
                this.drawRingArc3D(builder, stack, 'Z', radius, thickness, 0.0f, 0.0f, 1.0f, offZ, sweep, hz);
            }
            if (showX) {
                this.drawRingArc3D(builder, stack, 'X', radius, thickness + outlinePad, 0.0f, 0.0f, 0.0f, offX, sweep, false);
                this.drawRingArc3D(builder, stack, 'X', radius, thickness, 1.0f, 0.0f, 0.0f, offX, sweep, hx);
            }
            if (showY) {
                this.drawRingArc3D(builder, stack, 'Y', radius, thickness + outlinePad, 0.0f, 0.0f, 0.0f, offY, sweep, false);
                this.drawRingArc3D(builder, stack, 'Y', radius, thickness, 0.0f, 1.0f, 0.0f, offY, sweep, hy);
            }
        }
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        class_286.method_43433((class_9801)builder.method_60800());
        if (this.mode == Mode.ROTATE) {
            RenderSystem.enableCull();
        }
        RenderSystem.enableDepthTest();
    }

    private void drawEndCube(class_287 builder, class_4587 stack, float x, float y, float z, float s, float r, float g, float b) {
        stack.method_22903();
        stack.method_46416(x, y, z);
        Draw.fillBox(builder, stack, -s, -s, -s, s, s, s, r, g, b, 1.0f);
        stack.method_22909();
    }

    private void drawRingArc3D(class_287 builder, class_4587 stack, char axis, float radius, float thickness, float r, float g, float b, float startDeg, float sweepDeg, boolean highlight) {
        int segU = 96;
        int segV = 24;
        double u0 = Math.toRadians(startDeg);
        double uStep = Math.toRadians((double)sweepDeg / (double)segU);
        double vStep = Math.PI * 2 / (double)segV;
        float tubeR = thickness * 0.5f;
        Matrix4f mat = stack.method_23760().method_23761();
        for (int iu = 0; iu < segU; ++iu) {
            double u1 = u0 + uStep * (double)iu;
            double u2 = u0 + uStep * (double)(iu + 1);
            for (int iv = 0; iv < segV; ++iv) {
                float z22;
                float y22;
                float x22;
                float z21;
                float y21;
                float x21;
                float z12;
                float y12;
                float x12;
                float z11;
                float y11;
                float x11;
                double v1 = vStep * (double)iv;
                double v2 = vStep * (double)(iv + 1);
                if (axis == 'Z') {
                    x11 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.cos(u1));
                    y11 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.sin(u1));
                    z11 = (float)((double)tubeR * Math.sin(v1));
                    x12 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.cos(u1));
                    y12 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.sin(u1));
                    z12 = (float)((double)tubeR * Math.sin(v2));
                    x21 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.cos(u2));
                    y21 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.sin(u2));
                    z21 = (float)((double)tubeR * Math.sin(v1));
                    x22 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.cos(u2));
                    y22 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.sin(u2));
                    z22 = (float)((double)tubeR * Math.sin(v2));
                } else if (axis == 'X') {
                    y11 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.cos(u1));
                    z11 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.sin(u1));
                    x11 = (float)((double)tubeR * Math.sin(v1));
                    y12 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.cos(u1));
                    z12 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.sin(u1));
                    x12 = (float)((double)tubeR * Math.sin(v2));
                    y21 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.cos(u2));
                    z21 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.sin(u2));
                    x21 = (float)((double)tubeR * Math.sin(v1));
                    y22 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.cos(u2));
                    z22 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.sin(u2));
                    x22 = (float)((double)tubeR * Math.sin(v2));
                } else {
                    x11 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.cos(u1));
                    z11 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.sin(u1));
                    y11 = (float)((double)tubeR * Math.sin(v1));
                    x12 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.cos(u1));
                    z12 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.sin(u1));
                    y12 = (float)((double)tubeR * Math.sin(v2));
                    x21 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.cos(u2));
                    z21 = (float)(((double)radius + (double)tubeR * Math.cos(v1)) * Math.sin(u2));
                    y21 = (float)((double)tubeR * Math.sin(v1));
                    x22 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.cos(u2));
                    z22 = (float)(((double)radius + (double)tubeR * Math.cos(v2)) * Math.sin(u2));
                    y22 = (float)((double)tubeR * Math.sin(v2));
                }
                builder.method_22918(mat, x11, y11, z11).method_22915(r, g, b, 1.0f);
                builder.method_22918(mat, x12, y12, z12).method_22915(r, g, b, 1.0f);
                builder.method_22918(mat, x22, y22, z22).method_22915(r, g, b, 1.0f);
                builder.method_22918(mat, x11, y11, z11).method_22915(r, g, b, 1.0f);
                builder.method_22918(mat, x22, y22, z22).method_22915(r, g, b, 1.0f);
                builder.method_22918(mat, x21, y21, z21).method_22915(r, g, b, 1.0f);
            }
        }
        if (highlight) {
            float hr = tubeR;
            float ha = 0.5f;
            for (int iu = 0; iu < segU; ++iu) {
                double u1 = u0 + uStep * (double)iu;
                double u2 = u0 + uStep * (double)(iu + 1);
                for (int iv = 0; iv < segV; ++iv) {
                    float z22;
                    float y22;
                    float x22;
                    float z21;
                    float y21;
                    float x21;
                    float z12;
                    float y12;
                    float x12;
                    float z11;
                    float y11;
                    float x11;
                    double v1 = vStep * (double)iv;
                    double v2 = vStep * (double)(iv + 1);
                    if (axis == 'Z') {
                        x11 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.cos(u1));
                        y11 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.sin(u1));
                        z11 = (float)((double)hr * Math.sin(v1));
                        x12 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.cos(u1));
                        y12 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.sin(u1));
                        z12 = (float)((double)hr * Math.sin(v2));
                        x21 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.cos(u2));
                        y21 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.sin(u2));
                        z21 = (float)((double)hr * Math.sin(v1));
                        x22 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.cos(u2));
                        y22 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.sin(u2));
                        z22 = (float)((double)hr * Math.sin(v2));
                    } else if (axis == 'X') {
                        y11 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.cos(u1));
                        z11 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.sin(u1));
                        x11 = (float)((double)hr * Math.sin(v1));
                        y12 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.cos(u1));
                        z12 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.sin(u1));
                        x12 = (float)((double)hr * Math.sin(v2));
                        y21 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.cos(u2));
                        z21 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.sin(u2));
                        x21 = (float)((double)hr * Math.sin(v1));
                        y22 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.cos(u2));
                        z22 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.sin(u2));
                        x22 = (float)((double)hr * Math.sin(v2));
                    } else {
                        x11 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.cos(u1));
                        z11 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.sin(u1));
                        y11 = (float)((double)hr * Math.sin(v1));
                        x12 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.cos(u1));
                        z12 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.sin(u1));
                        y12 = (float)((double)hr * Math.sin(v2));
                        x21 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.cos(u2));
                        z21 = (float)(((double)radius + (double)hr * Math.cos(v1)) * Math.sin(u2));
                        y21 = (float)((double)hr * Math.sin(v1));
                        x22 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.cos(u2));
                        z22 = (float)(((double)radius + (double)hr * Math.cos(v2)) * Math.sin(u2));
                        y22 = (float)((double)hr * Math.sin(v2));
                    }
                    builder.method_22918(mat, x11, y11, z11).method_22915(1.0f, 1.0f, 1.0f, ha);
                    builder.method_22918(mat, x12, y12, z12).method_22915(1.0f, 1.0f, 1.0f, ha);
                    builder.method_22918(mat, x22, y22, z22).method_22915(1.0f, 1.0f, 1.0f, ha);
                    builder.method_22918(mat, x11, y11, z11).method_22915(1.0f, 1.0f, 1.0f, ha);
                    builder.method_22918(mat, x22, y22, z22).method_22915(1.0f, 1.0f, 1.0f, ha);
                    builder.method_22918(mat, x21, y21, z21).method_22915(1.0f, 1.0f, 1.0f, ha);
                }
            }
        }
    }

    private void drawArrowHead3D(class_287 builder, class_4587 stack, char axis, float baseLen, float headLen, float headWidth, float thickness, float r, float g, float b, float a) {
        if (axis == 'X') {
            Draw.fillBoxTo(builder, stack, baseLen, 0.0f, 0.0f, baseLen - headLen, headWidth / 2.0f, 0.0f, thickness + 0.004f, r, g, b, a);
            Draw.fillBoxTo(builder, stack, baseLen, 0.0f, 0.0f, baseLen - headLen, -headWidth / 2.0f, 0.0f, thickness + 0.004f, r, g, b, a);
        } else if (axis == 'Y') {
            Draw.fillBoxTo(builder, stack, 0.0f, baseLen, 0.0f, headWidth / 2.0f, baseLen - headLen, 0.0f, thickness + 0.004f, r, g, b, a);
            Draw.fillBoxTo(builder, stack, 0.0f, baseLen, 0.0f, -headWidth / 2.0f, baseLen - headLen, 0.0f, thickness + 0.004f, r, g, b, a);
        } else {
            Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, baseLen, 0.0f, headWidth / 2.0f, baseLen - headLen, thickness + 0.004f, r, g, b, a);
            Draw.fillBoxTo(builder, stack, 0.0f, 0.0f, baseLen, 0.0f, -headWidth / 2.0f, baseLen - headLen, thickness + 0.004f, r, g, b, a);
        }
    }

    private void drawCone3D(class_287 builder, class_4587 stack, char axis, float baseLen, float headLen, float radius, float r, float g, float b, float a) {
        float bz;
        float by;
        float bx;
        float az;
        float ay;
        float ax;
        Matrix4f mat = stack.method_23760().method_23761();
        int segments = 20;
        if (axis == 'X') {
            ax = baseLen;
            ay = 0.0f;
            az = 0.0f;
            bx = baseLen - headLen;
            by = 0.0f;
            bz = 0.0f;
        } else if (axis == 'Y') {
            ax = 0.0f;
            ay = baseLen;
            az = 0.0f;
            bx = 0.0f;
            by = baseLen - headLen;
            bz = 0.0f;
        } else {
            ax = 0.0f;
            ay = 0.0f;
            az = baseLen;
            bx = 0.0f;
            by = 0.0f;
            bz = baseLen - headLen;
        }
        for (int i = 0; i < segments; ++i) {
            float z2;
            float y2;
            float x2;
            float z1;
            float y1;
            float x1;
            double a1 = Math.PI * 2 * (double)i / (double)segments;
            double a2 = Math.PI * 2 * (double)(i + 1) / (double)segments;
            if (axis == 'X') {
                x1 = bx;
                y1 = (float)(Math.cos(a1) * (double)radius);
                z1 = (float)(Math.sin(a1) * (double)radius);
                x2 = bx;
                y2 = (float)(Math.cos(a2) * (double)radius);
                z2 = (float)(Math.sin(a2) * (double)radius);
            } else if (axis == 'Y') {
                x1 = (float)(Math.cos(a1) * (double)radius);
                y1 = by;
                z1 = (float)(Math.sin(a1) * (double)radius);
                x2 = (float)(Math.cos(a2) * (double)radius);
                y2 = by;
                z2 = (float)(Math.sin(a2) * (double)radius);
            } else {
                x1 = (float)(Math.cos(a1) * (double)radius);
                y1 = (float)(Math.sin(a1) * (double)radius);
                z1 = bz;
                x2 = (float)(Math.cos(a2) * (double)radius);
                y2 = (float)(Math.sin(a2) * (double)radius);
                z2 = bz;
            }
            builder.method_22918(mat, ax, ay, az).method_22915(r, g, b, a);
            builder.method_22918(mat, x1, y1, z1).method_22915(r, g, b, a);
            builder.method_22918(mat, x2, y2, z2).method_22915(r, g, b, a);
            float aa = Math.max(0.0f, a - 0.2f);
            builder.method_22918(mat, bx, by, bz).method_22915(r, g, b, aa);
            builder.method_22918(mat, x2, y2, z2).method_22915(r, g, b, aa);
            builder.method_22918(mat, x1, y1, z1).method_22915(r, g, b, aa);
        }
    }

    private void drawSphere3D(class_287 builder, class_4587 stack, char axis, float baseLen, float radius, float r, float g, float b, float a) {
        Matrix4f mat = stack.method_23760().method_23761();
        int segU = 24;
        int segV = 36;
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        if (axis == 'X') {
            cx = baseLen;
        } else if (axis == 'Y') {
            cy = baseLen;
        } else {
            cz = baseLen;
        }
        for (int iu = 0; iu < segU; ++iu) {
            double u1 = Math.PI * (double)iu / (double)segU;
            double u2 = Math.PI * (double)(iu + 1) / (double)segU;
            for (int iv = 0; iv < segV; ++iv) {
                double v1 = Math.PI * 2 * (double)iv / (double)segV;
                double v2 = Math.PI * 2 * (double)(iv + 1) / (double)segV;
                float x11 = cx + (float)((double)radius * Math.sin(u1) * Math.cos(v1));
                float y11 = cy + (float)((double)radius * Math.cos(u1));
                float z11 = cz + (float)((double)radius * Math.sin(u1) * Math.sin(v1));
                float x12 = cx + (float)((double)radius * Math.sin(u1) * Math.cos(v2));
                float y12 = cy + (float)((double)radius * Math.cos(u1));
                float z12 = cz + (float)((double)radius * Math.sin(u1) * Math.sin(v2));
                float x21 = cx + (float)((double)radius * Math.sin(u2) * Math.cos(v1));
                float y21 = cy + (float)((double)radius * Math.cos(u2));
                float z21 = cz + (float)((double)radius * Math.sin(u2) * Math.sin(v1));
                float x22 = cx + (float)((double)radius * Math.sin(u2) * Math.cos(v2));
                float y22 = cy + (float)((double)radius * Math.cos(u2));
                float z22 = cz + (float)((double)radius * Math.sin(u2) * Math.sin(v2));
                builder.method_22918(mat, x11, y11, z11).method_22915(r, g, b, a);
                builder.method_22918(mat, x21, y21, z21).method_22915(r, g, b, a);
                builder.method_22918(mat, x22, y22, z22).method_22915(r, g, b, a);
                builder.method_22918(mat, x11, y11, z11).method_22915(r, g, b, a);
                builder.method_22918(mat, x22, y22, z22).method_22915(r, g, b, a);
                builder.method_22918(mat, x12, y12, z12).method_22915(r, g, b, a);
            }
        }
    }

    private Axis detectHoveredAxis3D(UIContext input, Area viewport, Matrix4f origin, Matrix4f projection, Matrix4f view) {
        if (origin == null || projection == null || view == null) {
            return null;
        }
        this.hoveredPlane = null;
        float nx = (float)((double)(input.mouseX - viewport.x) / (double)viewport.w * 2.0 - 1.0);
        float ny = (float)(-((double)(input.mouseY - viewport.y) / (double)viewport.h * 2.0 - 1.0));
        Matrix4f invPV = new Matrix4f((Matrix4fc)projection).mul((Matrix4fc)view).invert(new Matrix4f());
        Vector4f nearClip = new Vector4f(nx, ny, -1.0f, 1.0f);
        Vector4f farClip = new Vector4f(nx, ny, 1.0f, 1.0f);
        Vector4f nearWorld = invPV.transform(new Vector4f((Vector4fc)nearClip));
        Vector4f farWorld = invPV.transform(new Vector4f((Vector4fc)farClip));
        nearWorld.div(nearWorld.w);
        farWorld.div(farWorld.w);
        Matrix4f invOrigin = new Matrix4f((Matrix4fc)origin).invert(new Matrix4f());
        Vector4f nearLocal4 = invOrigin.transform(new Vector4f((Vector4fc)nearWorld));
        Vector4f farLocal4 = invOrigin.transform(new Vector4f((Vector4fc)farWorld));
        Vector3f rayO = new Vector3f(nearLocal4.x, nearLocal4.y, nearLocal4.z);
        Vector3f rayF = new Vector3f(farLocal4.x, farLocal4.y, farLocal4.z);
        Vector3f rayD = rayF.sub((Vector3fc)rayO, new Vector3f());
        rayD.normalize();
        if (this.mode == Mode.ROTATE) {
            return this.detectHoveredAxis3DRotate(rayO, rayD);
        }
        if (this.mode == Mode.UNIVERSAL) {
            Axis rot = this.detectHoveredAxis3DRotate(rayO, rayD);
            if (rot != null) {
                this.hoveredSubMode = Mode.ROTATE;
                this.hoveredPlane = null;
                return rot;
            }
            float len = 0.25f * this.gizmoScale;
            float[] txS = this.rayBoxIntersect(rayO, rayD, new Vector3f(len - 0.02f * this.gizmoScale, -(0.045f * this.gizmoScale), -(0.045f * this.gizmoScale)), new Vector3f(len + 0.02f * this.gizmoScale, 0.045f * this.gizmoScale, 0.045f * this.gizmoScale));
            float[] tyS = this.rayBoxIntersect(rayO, rayD, new Vector3f(-(0.045f * this.gizmoScale), len - 0.02f * this.gizmoScale, -(0.045f * this.gizmoScale)), new Vector3f(0.045f * this.gizmoScale, len + 0.02f * this.gizmoScale, 0.045f * this.gizmoScale));
            float[] tzS = this.rayBoxIntersect(rayO, rayD, new Vector3f(-(0.045f * this.gizmoScale), -(0.045f * this.gizmoScale), len - 0.02f * this.gizmoScale), new Vector3f(0.045f * this.gizmoScale, 0.045f * this.gizmoScale, len + 0.02f * this.gizmoScale));
            float bt = Float.POSITIVE_INFINITY;
            Axis ba = null;
            if (txS != null && txS[0] >= 0.0f && txS[0] < bt) {
                bt = txS[0];
                ba = Axis.X;
            }
            if (tyS != null && tyS[0] >= 0.0f && tyS[0] < bt) {
                bt = tyS[0];
                ba = Axis.Y;
            }
            if (tzS != null && tzS[0] >= 0.0f && tzS[0] < bt) {
                bt = tzS[0];
                ba = Axis.Z;
            }
            if (ba != null) {
                this.hoveredSubMode = Mode.SCALE;
                this.hoveredPlane = null;
                return ba;
            }
            this.hoveredSubMode = null;
            this.hoveredPlane = null;
            return null;
        }
        int design = (Integer)BBSSettings.gizmoDesign.get();
        boolean blockbenchDesign = design == 2;
        float length = (blockbenchDesign ? 0.35f : 0.25f) * this.gizmoScale;
        float thickness = (this.mode == Mode.SCALE ? 0.045f : (blockbenchDesign && (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT) ? 0.025f : 0.015f)) * this.gizmoScale;
        float fudge = (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT ? 0.06f : (this.mode == Mode.SCALE ? 0.045f : 0.02f)) * this.gizmoScale;
        float[] tx = this.rayBoxIntersect(rayO, rayD, new Vector3f(0.0f, -thickness / 2.0f, -thickness / 2.0f), new Vector3f(length + fudge, thickness / 2.0f, thickness / 2.0f));
        float[] ty = this.rayBoxIntersect(rayO, rayD, new Vector3f(-thickness / 2.0f, 0.0f, -thickness / 2.0f), new Vector3f(thickness / 2.0f, length + fudge, thickness / 2.0f));
        float[] tz = this.rayBoxIntersect(rayO, rayD, new Vector3f(-thickness / 2.0f, -thickness / 2.0f, 0.0f), new Vector3f(thickness / 2.0f, thickness / 2.0f, length + fudge));
        float bestT = Float.POSITIVE_INFINITY;
        Axis best = null;
        if (tx != null && tx[0] >= 0.0f && tx[0] < bestT) {
            bestT = tx[0];
            best = Axis.X;
        }
        if (ty != null && ty[0] >= 0.0f && ty[0] < bestT) {
            bestT = ty[0];
            best = Axis.Y;
        }
        if (tz != null && tz[0] >= 0.0f && tz[0] < bestT) {
            bestT = tz[0];
            best = Axis.Z;
        }
        if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT) {
            float po = 0.08f * this.gizmoScale;
            float ps = 0.02f * this.gizmoScale;
            float pt = 0.004f * this.gizmoScale;
            float[] pXY = this.rayBoxIntersect(rayO, rayD, new Vector3f(po - ps, po - ps, -pt), new Vector3f(po + ps, po + ps, pt));
            float[] pZX = this.rayBoxIntersect(rayO, rayD, new Vector3f(po - ps, -pt, po - ps), new Vector3f(po + ps, pt, po + ps));
            float[] pYZ = this.rayBoxIntersect(rayO, rayD, new Vector3f(-pt, po - ps, po - ps), new Vector3f(pt, po + ps, po + ps));
            if (((Boolean)BBSSettings.gizmoPlanes.get()).booleanValue()) {
                if (pXY != null && pXY[0] >= 0.0f && pXY[0] < bestT) {
                    bestT = pXY[0];
                    best = Axis.X;
                    this.hoveredPlane = Plane.XY;
                }
                if (pZX != null && pZX[0] >= 0.0f && pZX[0] < bestT) {
                    bestT = pZX[0];
                    best = Axis.Z;
                    this.hoveredPlane = Plane.ZX;
                }
                if (pYZ != null && pYZ[0] >= 0.0f && pYZ[0] < bestT) {
                    bestT = pYZ[0];
                    best = Axis.Y;
                    this.hoveredPlane = Plane.YZ;
                }
            }
        }
        return best;
    }

    private Axis detectHoveredAxis3DRotate(Vector3f rayO, Vector3f rayD) {
        @Environment(value=EnvType.CLIENT)
        class Hit {
            Axis a;
            float t;

            Hit(BoneGizmoSystem this$0) {
            }
        }
        Hit[] all;
        float baseThickness;
        boolean thinDesign;
        float radius = 0.22f * this.gizmoScale;
        boolean bl = thinDesign = (Integer)BBSSettings.gizmoDesign.get() == 1;
        float thickness = baseThickness = (this.mode == Mode.ROTATE ? (thinDesign ? 0.008f : 0.015f) : (thinDesign ? 0.007f : 0.01f)) * this.gizmoScale;
        float band = thickness * 0.5f + 0.002f * this.gizmoScale;
        Hit hitBest = null;
        BiFunction<Vector3f, Character, Hit> check = (n, c) -> {
            float iz;
            float iy;
            float ix;
            float t;
            float denom = n.x * rayD.x + n.y * rayD.y + n.z * rayD.z;
            if ((double)Math.abs(denom) < 1.0E-5) {
                float dy;
                float dx;
                float ay;
                float ax;
                if (c.charValue() == 'Z') {
                    ax = rayO.x;
                    ay = rayO.y;
                    dx = rayD.x;
                    dy = rayD.y;
                } else if (c.charValue() == 'X') {
                    ax = rayO.y;
                    ay = rayO.z;
                    dx = rayD.y;
                    dy = rayD.z;
                } else {
                    ax = rayO.x;
                    ay = rayO.z;
                    dx = rayD.x;
                    dy = rayD.z;
                }
                float A = dx * dx + dy * dy;
                float B = 2.0f * (ax * dx + ay * dy);
                float C = ax * ax + ay * ay - radius * radius;
                float disc = B * B - 4.0f * A * C;
                if ((double)A > 1.0E-8 && disc >= 0.0f) {
                    float sqrt = (float)Math.sqrt(disc);
                    float t1 = (-B - sqrt) / (2.0f * A);
                    float t2 = (-B + sqrt) / (2.0f * A);
                    t = Float.POSITIVE_INFINITY;
                    if (t1 >= 0.0f) {
                        t = Math.min(t, t1);
                    }
                    if (t2 >= 0.0f) {
                        t = Math.min(t, t2);
                    }
                    if (!Float.isFinite(t)) {
                        return null;
                    }
                } else {
                    return null;
                }
                ix = rayO.x + rayD.x * t;
                iy = rayO.y + rayD.y * t;
                iz = rayO.z + rayD.z * t;
            } else {
                t = -(n.x * rayO.x + n.y * rayO.y + n.z * rayO.z) / denom;
                if (t < 0.0f) {
                    return null;
                }
                ix = rayO.x + rayD.x * t;
                iy = rayO.y + rayD.y * t;
                iz = rayO.z + rayD.z * t;
            }
            float radial = c.charValue() == 'Z' ? (float)Math.sqrt(ix * ix + iy * iy) : (c.charValue() == 'X' ? (float)Math.sqrt(iy * iy + iz * iz) : (float)Math.sqrt(ix * ix + iz * iz));
            if (radial >= radius - band && radial <= radius + band) {
                Hit h = new Hit(this);
                h.a = c.charValue() == 'Z' ? Axis.Z : (c.charValue() == 'X' ? Axis.X : Axis.Y);
                h.t = t;
                return h;
            }
            return null;
        };
        Hit hz = check.apply(new Vector3f(0.0f, 0.0f, 1.0f), Character.valueOf('Z'));
        Hit hx = check.apply(new Vector3f(1.0f, 0.0f, 0.0f), Character.valueOf('X'));
        Hit hy = check.apply(new Vector3f(0.0f, 1.0f, 0.0f), Character.valueOf('Y'));
        for (Hit h : all = new Hit[]{hz, hx, hy}) {
            if (h == null || hitBest != null && !(h.t < hitBest.t)) continue;
            hitBest = h;
        }
        return hitBest == null ? null : hitBest.a;
    }

    private boolean angleInArc(float angDeg, float startDeg, float sweepDeg) {
        float e;
        if (sweepDeg >= 359.9f) {
            return true;
        }
        float a = this.normalizeDeg(angDeg);
        float s = this.normalizeDeg(startDeg);
        if (s <= (e = this.normalizeDeg(startDeg + sweepDeg))) {
            return a >= s && a <= e;
        }
        return a >= s || a <= e;
    }

    private float normalizeDeg(float deg) {
        float d = deg % 360.0f;
        if (d < 0.0f) {
            d += 360.0f;
        }
        return d;
    }

    private float[] rayBoxIntersect(Vector3f ro, Vector3f rd, Vector3f min, Vector3f max) {
        float tzmax;
        float tzmin;
        float tymax;
        float tymin;
        float tmin = (min.x - ro.x) / rd.x;
        float tmax = (max.x - ro.x) / rd.x;
        if (tmin > tmax) {
            float tmp = tmin;
            tmin = tmax;
            tmax = tmp;
        }
        if ((tymin = (min.y - ro.y) / rd.y) > (tymax = (max.y - ro.y) / rd.y)) {
            float tmp = tymin;
            tymin = tymax;
            tymax = tmp;
        }
        if (tmin > tymax || tymin > tmax) {
            return null;
        }
        if (tymin > tmin) {
            tmin = tymin;
        }
        if (tymax < tmax) {
            tmax = tymax;
        }
        if ((tzmin = (min.z - ro.z) / rd.z) > (tzmax = (max.z - ro.z) / rd.z)) {
            float tmp = tzmin;
            tzmin = tzmax;
            tzmax = tmp;
        }
        if (tmin > tzmax || tzmin > tmax) {
            return null;
        }
        if (tzmin > tmin) {
            tmin = tzmin;
        }
        if (tzmax < tmax) {
            tmax = tzmax;
        }
        if (tmax < 0.0f) {
            return null;
        }
        return new float[]{tmin, tmax};
    }

    public void renderOverlay(UIRenderingContext context, Area viewport) {
        if (viewport == null) {
            return;
        }
        RenderSystem.disableDepthTest();
        GlStateManager._disableScissorTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (((Boolean)BBSSettings.modelBlockGizmosEnabled.get()).booleanValue()) {
            RenderSystem.enableDepthTest();
            context.batcher.flush();
            return;
        }
        int cx = this.centerX;
        int cy = this.centerY;
        float thickness = this.handleThickness;
        if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT) {
            showX = !this.dragging || this.activePlane == null && this.activeAxis == Axis.X;
            showY = !this.dragging || this.activePlane == null && this.activeAxis == Axis.Y;
            showZ = !this.dragging || this.activePlane == null && this.activeAxis == Axis.Z;
            int xColor = -52429;
            int yColor = -13369549;
            int zColor = -13408513;
            boolean hx = this.hoveredAxis == Axis.X;
            boolean hy = this.hoveredAxis == Axis.Y;
            boolean hz = this.hoveredAxis == Axis.Z;
            float txX = hx ? thickness + 2.0f : thickness;
            float txY = hy ? thickness + 2.0f : thickness;
            float txZ = hz ? thickness + 2.0f : thickness;
            int black = -16777216;
            if (showX) {
                context.batcher.line(cx, cy, this.endXx, this.endXy, txX + 3.0f, black);
                context.batcher.line(cx, cy, this.endXx, this.endXy, txX, xColor);
                this.drawSphereHandle(context, this.endXx, this.endXy, xColor, hx);
            }
            if (showY) {
                context.batcher.line(cx, cy, this.endYx, this.endYy, txY + 3.0f, black);
                context.batcher.line(cx, cy, this.endYx, this.endYy, txY, yColor);
                this.drawSphereHandle(context, this.endYx, this.endYy, yColor, hy);
            }
            if (showZ) {
                context.batcher.line(cx, cy, this.endZx, this.endZy, txZ + 3.0f, black);
                context.batcher.line(cx, cy, this.endZx, this.endZy, txZ, zColor);
                this.drawSphereHandle(context, this.endZx, this.endZy, zColor, hz);
            }
            if (((Boolean)BBSSettings.gizmoPlanes.get()).booleanValue()) {
                boolean showPlaneYZ;
                int[] cXY = this.planeCenterScreen(Plane.XY);
                int[] cZX = this.planeCenterScreen(Plane.ZX);
                int[] cYZ = this.planeCenterScreen(Plane.YZ);
                int ps = 7;
                boolean hXY = this.hoveredPlane == Plane.XY || this.activePlane == Plane.XY;
                boolean hZX = this.hoveredPlane == Plane.ZX || this.activePlane == Plane.ZX;
                boolean hYZ = this.hoveredPlane == Plane.YZ || this.activePlane == Plane.YZ;
                int colXY = -13408513;
                int colZX = -13369549;
                int colYZ = -52429;
                boolean showPlaneXY = !this.dragging || this.activePlane == Plane.XY;
                boolean showPlaneZX = !this.dragging || this.activePlane == Plane.ZX;
                boolean bl = showPlaneYZ = !this.dragging || this.activePlane == Plane.YZ;
                if (showPlaneXY) {
                    context.batcher.box(cXY[0] - ps, cXY[1] - ps, cXY[0] + ps, cXY[1] + ps, Colors.mulRGB(colXY, hXY ? 0.95f : 0.6f));
                }
                if (showPlaneZX) {
                    context.batcher.box(cZX[0] - ps, cZX[1] - ps, cZX[0] + ps, cZX[1] + ps, Colors.mulRGB(colZX, hZX ? 0.95f : 0.6f));
                }
                if (showPlaneYZ) {
                    context.batcher.box(cYZ[0] - ps, cYZ[1] - ps, cYZ[0] + ps, cYZ[1] + ps, Colors.mulRGB(colYZ, hYZ ? 0.95f : 0.6f));
                }
                if (hXY && showPlaneXY) {
                    context.batcher.box(cXY[0] - (ps + 2), cXY[1] - (ps + 2), cXY[0] + (ps + 2), cXY[1] + (ps + 2), -1);
                }
                if (hZX && showPlaneZX) {
                    context.batcher.box(cZX[0] - (ps + 2), cZX[1] - (ps + 2), cZX[0] + (ps + 2), cZX[1] + (ps + 2), -1);
                }
                if (hYZ && showPlaneYZ) {
                    context.batcher.box(cYZ[0] - (ps + 2), cYZ[1] - (ps + 2), cYZ[0] + (ps + 2), cYZ[1] + (ps + 2), -1);
                }
            }
            int halo = -1;
            if (hx && showX) {
                context.batcher.line(cx, cy, this.endXx, this.endXy, thickness + 4.0f, halo);
            }
            if (hy && showY) {
                context.batcher.line(cx, cy, this.endYx, this.endYy, thickness + 4.0f, halo);
            }
            if (hz && showZ) {
                context.batcher.line(cx, cy, this.endZx, this.endZy, thickness + 4.0f, halo);
            }
        } else if (this.mode == Mode.SCALE) {
            showX = !this.dragging || this.activeAxis == Axis.X;
            showY = !this.dragging || this.activeAxis == Axis.Y;
            showZ = !this.dragging || this.activeAxis == Axis.Z;
            int xColor = -52429;
            int yColor = -13369549;
            int zColor = -13408513;
            boolean hx = this.hoveredAxis == Axis.X;
            boolean hy = this.hoveredAxis == Axis.Y;
            boolean hz = this.hoveredAxis == Axis.Z;
            float txX = hx ? thickness + 2.0f : thickness;
            float txY = hy ? thickness + 2.0f : thickness;
            float txZ = hz ? thickness + 2.0f : thickness;
            int black = -16777216;
            if (showX) {
                context.batcher.line(cx, cy, this.endXx, this.endXy, txX + 3.0f, black);
                context.batcher.line(cx, cy, this.endXx, this.endXy, txX, xColor);
                this.drawCubeHandle(context, this.endXx, this.endXy, xColor);
            }
            if (showY) {
                context.batcher.line(cx, cy, this.endYx, this.endYy, txY + 3.0f, black);
                context.batcher.line(cx, cy, this.endYx, this.endYy, txY, yColor);
                this.drawCubeHandle(context, this.endYx, this.endYy, yColor);
            }
            if (showZ) {
                context.batcher.line(cx, cy, this.endZx, this.endZy, txZ + 3.0f, black);
                context.batcher.line(cx, cy, this.endZx, this.endZy, txZ, zColor);
                this.drawCubeHandle(context, this.endZx, this.endZy, zColor);
            }
            int halo = -1;
            if (hx && showX) {
                this.drawRing(context, this.endXx, this.endXy, 10, 4.0f, halo);
                context.batcher.line(cx, cy, this.endXx, this.endXy, thickness + 4.0f, halo);
            }
            if (hy && showY) {
                this.drawRing(context, this.endYx, this.endYy, 10, 4.0f, halo);
                context.batcher.line(cx, cy, this.endYx, this.endYy, thickness + 4.0f, halo);
            }
            if (hz && showZ) {
                this.drawRing(context, this.endZx, this.endZy, 10, 4.0f, halo);
                context.batcher.line(cx, cy, this.endZx, this.endZy, thickness + 4.0f, halo);
            }
        } else if (this.mode == Mode.ROTATE) {
            showX = !this.dragging || this.activeAxis == Axis.X;
            showY = !this.dragging || this.activeAxis == Axis.Y;
            showZ = !this.dragging || this.activeAxis == Axis.Z;
            int xColor = -52429;
            int yColor = -13369549;
            int zColor = -13408513;
            if (showX) {
                this.drawRing(context, cx, cy, this.ringRX, thickness, xColor);
            }
            if (showY) {
                this.drawRing(context, cx, cy, this.ringRY, thickness, yColor);
            }
            if (showZ) {
                this.drawRing(context, cx, cy, this.ringRZ, thickness, zColor);
            }
        } else if (this.mode == Mode.UNIVERSAL) {
            boolean hy;
            boolean hx;
            showX = !this.dragging || this.activeAxis == Axis.X;
            showY = !this.dragging || this.activeAxis == Axis.Y;
            boolean bl = showZ = !this.dragging || this.activeAxis == Axis.Z;
            Mode usingSub = this.dragging ? (this.activeSubMode != null ? this.activeSubMode : Mode.TRANSLATE) : null;
            int xColor = -52429;
            int yColor = -13369549;
            int zColor = -13408513;
            boolean bl2 = this.dragging ? this.activeAxis == Axis.X : (hx = this.hoveredAxis == Axis.X);
            boolean bl3 = this.dragging ? this.activeAxis == Axis.Y : (hy = this.hoveredAxis == Axis.Y);
            boolean hz = this.dragging ? this.activeAxis == Axis.Z : this.hoveredAxis == Axis.Z;
            float txX = hx ? thickness + 2.0f : thickness;
            float txY = hy ? thickness + 2.0f : thickness;
            float txZ = hz ? thickness + 2.0f : thickness;
            int black = -16777216;
            if (usingSub == null || usingSub == Mode.SCALE) {
                if (showX) {
                    this.drawCubeHandle(context, this.endXx, this.endXy, xColor);
                }
                if (showY) {
                    this.drawCubeHandle(context, this.endYx, this.endYy, yColor);
                }
                if (showZ) {
                    this.drawCubeHandle(context, this.endZx, this.endZy, zColor);
                }
            }
            if (usingSub == null || usingSub == Mode.ROTATE) {
                int xRing = -52429;
                int yRing = -13369549;
                int zRing = -13408513;
                if (showX) {
                    this.drawRing(context, cx, cy, this.ringRX, thickness, xRing);
                }
                if (showY) {
                    this.drawRing(context, cx, cy, this.ringRY, thickness, yRing);
                }
                if (showZ) {
                    this.drawRing(context, cx, cy, this.ringRZ, thickness, zRing);
                }
            }
            int halo = -1;
            if (hx && showX) {
                context.batcher.line(cx, cy, this.endXx, this.endXy, thickness + 4.0f, halo);
            }
            if (hy && showY) {
                context.batcher.line(cx, cy, this.endYx, this.endYy, thickness + 4.0f, halo);
            }
            if (hz && showZ) {
                context.batcher.line(cx, cy, this.endZx, this.endZy, thickness + 4.0f, halo);
            }
        }
        int half = 5;
        int designIdx = (Integer)BBSSettings.gizmoDesign.get();
        boolean bbMode = designIdx == 2 && this.mode == Mode.PIVOT;
        int pivotColor = 0xFF000000 | (bbMode ? 0x3366FF : -1);
        context.batcher.box(cx - half, cy - half, cx + half, cy + half, pivotColor);
        RenderSystem.enableDepthTest();
        context.batcher.flush();
    }

    public boolean isHoveringHandle() {
        return this.hoveredAxis != null;
    }

    private Axis detectHoveredAxis(int mx, int my) {
        if (this.mode == Mode.ROTATE) {
            int cx = this.centerX;
            int cy = this.centerY;
            double dx = mx - cx;
            double dy = my - cy;
            double d = Math.sqrt(dx * dx + dy * dy);
            int tol = Math.max(6, this.handleThickness * 2);
            if (Math.abs(d - (double)this.ringRX) <= (double)tol) {
                return Axis.X;
            }
            if (Math.abs(d - (double)this.ringRY) <= (double)tol) {
                return Axis.Y;
            }
            if (Math.abs(d - (double)this.ringRZ) <= (double)tol) {
                return Axis.Z;
            }
            return null;
        }
        int cx = this.centerX;
        int cy = this.centerY;
        int tol = Math.max(6, this.handleThickness + 4);
        if (this.mode == Mode.UNIVERSAL) {
            double dx = mx - cx;
            double dy = my - cy;
            double d = Math.sqrt(dx * dx + dy * dy);
            int tolRing = Math.max(6, this.handleThickness * 2);
            if (Math.abs(d - (double)this.ringRX) <= (double)tolRing) {
                this.hoveredSubMode = Mode.ROTATE;
                this.hoveredPlane = null;
                return Axis.X;
            }
            if (Math.abs(d - (double)this.ringRY) <= (double)tolRing) {
                this.hoveredSubMode = Mode.ROTATE;
                this.hoveredPlane = null;
                return Axis.Y;
            }
            if (Math.abs(d - (double)this.ringRZ) <= (double)tolRing) {
                this.hoveredSubMode = Mode.ROTATE;
                this.hoveredPlane = null;
                return Axis.Z;
            }
            if (this.isNear(mx, my, this.endXx, this.endXy, this.hitRadius)) {
                this.hoveredSubMode = Mode.SCALE;
                this.hoveredPlane = null;
                return Axis.X;
            }
            if (this.isNear(mx, my, this.endYx, this.endYy, this.hitRadius)) {
                this.hoveredSubMode = Mode.SCALE;
                this.hoveredPlane = null;
                return Axis.Y;
            }
            if (this.isNear(mx, my, this.endZx, this.endZy, this.hitRadius)) {
                this.hoveredSubMode = Mode.SCALE;
                this.hoveredPlane = null;
                return Axis.Z;
            }
            this.hoveredSubMode = null;
            this.hoveredPlane = null;
            return null;
        }
        if (this.mode == Mode.TRANSLATE || this.mode == Mode.PIVOT) {
            int[] cXY = this.planeCenterScreen(Plane.XY);
            int[] cZX = this.planeCenterScreen(Plane.ZX);
            int[] cYZ = this.planeCenterScreen(Plane.YZ);
            int pr = this.hitRadius;
            if (this.isNear(mx, my, cXY[0], cXY[1], pr)) {
                this.hoveredPlane = Plane.XY;
                this.hoveredSubMode = Mode.TRANSLATE;
                return Axis.X;
            }
            if (this.isNear(mx, my, cZX[0], cZX[1], pr)) {
                this.hoveredPlane = Plane.ZX;
                this.hoveredSubMode = Mode.TRANSLATE;
                return Axis.Z;
            }
            if (this.isNear(mx, my, cYZ[0], cYZ[1], pr)) {
                this.hoveredPlane = Plane.YZ;
                this.hoveredSubMode = Mode.TRANSLATE;
                return Axis.Y;
            }
            this.hoveredPlane = null;
        }
        if (this.isNearLine(mx, my, cx, cy, this.endXx, this.endXy, tol) || this.isNear(mx, my, this.endXx, this.endXy, this.hitRadius)) {
            return Axis.X;
        }
        if (this.isNearLine(mx, my, cx, cy, this.endYx, this.endYy, tol) || this.isNear(mx, my, this.endYx, this.endYy, this.hitRadius)) {
            return Axis.Y;
        }
        if (this.isNearLine(mx, my, cx, cy, this.endZx, this.endZy, tol) || this.isNear(mx, my, this.endZx, this.endZy, this.hitRadius)) {
            return Axis.Z;
        }
        return null;
    }

    private int[] planeCenterScreen(Plane p) {
        int[] nArray;
        float k = 0.55f;
        int cx = this.centerX;
        int cy = this.centerY;
        switch (p.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int[] nArray2 = new int[2];
                nArray2[0] = (int)((float)cx + (float)(this.endXx - cx) * k);
                nArray = nArray2;
                nArray2[1] = (int)((float)cy + (float)(this.endYy - cy) * k);
                break;
            }
            case 2: {
                int[] nArray3 = new int[2];
                nArray3[0] = (int)((float)cx + (float)(this.endXx - cx) * k);
                nArray = nArray3;
                nArray3[1] = (int)((float)cy + (float)(this.endZy - cy) * k);
                break;
            }
            case 1: {
                int[] nArray4 = new int[2];
                nArray4[0] = (int)((float)cx + (float)(this.endYx - cx) * k);
                nArray = nArray4;
                nArray4[1] = (int)((float)cy + (float)(this.endZy - cy) * k);
            }
        }
        return nArray;
    }

    private void drawRing(UIRenderingContext context, int cx, int cy, int radius, float thickness, int color) {
        int segments = 64;
        double step = Math.PI * 2 / (double)segments;
        float x1 = cx + radius;
        float y1 = cy;
        for (int i = 1; i <= segments; ++i) {
            double ang = step * (double)i;
            float x2 = (float)((double)cx + Math.cos(ang) * (double)radius);
            float y2 = (float)((double)cy + Math.sin(ang) * (double)radius);
            context.batcher.line(x1, y1, x2, y2, thickness + 2.0f, -16777216);
            context.batcher.line(x1, y1, x2, y2, thickness, color);
            x1 = x2;
            y1 = y2;
        }
    }

    private void drawCubeHandle(UIRenderingContext context, int x, int y, int color) {
        int size = 12;
        int half = size / 2;
        int fill = Colors.mulRGB(color, 0.8f);
        int border = Colors.setA(-1, 0.75f);
        int pad = 3;
        context.batcher.box(x - half - pad, y - half - pad, x + half + pad, y + half + pad, -16777216);
        context.batcher.box(x - half, y - half, x + half, y + half, fill);
        context.batcher.outline(x - half, y - half, x + half, y + half, border, 1);
    }

    private void drawArrowHandle(UIRenderingContext context, int cx, int cy, int ex, int ey, int color) {
        float dx = ex - cx;
        float dy = ey - cy;
        float len = (float)Math.sqrt(dx * dx + dy * dy);
        if (len < 1.0E-4f) {
            return;
        }
        float ndx = dx / len;
        float ndy = dy / len;
        float headLen = 16.0f;
        float headWidth = 12.0f;
        float bx = (float)ex - ndx * headLen;
        float by = (float)ey - ndy * headLen;
        float px = -ndy;
        float py = ndx;
        float lx = bx + px * (headWidth / 2.0f);
        float ly = by + py * (headWidth / 2.0f);
        float rx = bx - px * (headWidth / 2.0f);
        float ry = by - py * (headWidth / 2.0f);
        context.batcher.line(ex, ey, lx, ly, this.handleThickness + 4, -16777216);
        context.batcher.line(ex, ey, rx, ry, this.handleThickness + 4, -16777216);
        context.batcher.line(ex, ey, lx, ly, this.handleThickness + 1, color);
        context.batcher.line(ex, ey, rx, ry, this.handleThickness + 1, color);
    }

    private void drawSphereHandle(UIRenderingContext context, int x, int y, int color, boolean hovered) {
        int fill = Colors.mulRGB(color, 0.85f);
        int outline = -16777216;
        int border = Colors.setA(-1, 0.75f);
        int r = 8;
        this.drawRing(context, x, y, r + 2, 4.0f, outline);
        this.drawRing(context, x, y, r, 12.0f, fill);
        context.batcher.outline(x - r, y - r, x + r, y + r, border, 1);
        if (hovered) {
            this.drawRing(context, x, y, r + 4, 3.0f, -1);
        }
    }

    private boolean isNearLine(int mx, int my, int x1, int y1, int x2, int y2, int tol) {
        double vx = x2 - x1;
        double vy = y2 - y1;
        double wx = mx - x1;
        double wy = my - y1;
        double c1 = vx * wx + vy * wy;
        double c2 = vx * vx + vy * vy;
        double t = c2 > 0.0 ? Math.max(0.0, Math.min(1.0, c1 / c2)) : 0.0;
        double px = (double)x1 + t * vx;
        double py = (double)y1 + t * vy;
        double dx = (double)mx - px;
        double dy = (double)my - py;
        double d = Math.sqrt(dx * dx + dy * dy);
        return d <= (double)tol;
    }

    private boolean isNear(int mx, int my, int x, int y, int r) {
        int dx = mx - x;
        int dy = my - y;
        return dx * dx + dy * dy <= r * r;
    }

    public void cycleMode(boolean forward) {
        Mode[] order = new Mode[]{Mode.TRANSLATE, Mode.ROTATE, Mode.SCALE, Mode.PIVOT};
        int idx = 0;
        for (int i = 0; i < order.length; ++i) {
            if (order[i] != this.mode) continue;
            idx = i;
            break;
        }
        idx = forward ? (idx + 1) % order.length : (idx - 1 + order.length) % order.length;
        this.mode = order[idx];
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Mode {
        TRANSLATE,
        ROTATE,
        SCALE,
        UNIVERSAL,
        PIVOT;

    }

    @Environment(value=EnvType.CLIENT)
    private static enum Plane {
        XY,
        YZ,
        ZX;

    }
}

