/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.graphics.texture.AnimatedTexture;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.graphics.texture.TextureExtruder;
import mchorse.bbs_mod.resources.AssetProvider;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.resources.MultiLink;
import mchorse.bbs_mod.utils.resources.MultiLinkThread;
import mchorse.bbs_mod.utils.resources.Pixels;
import mchorse.bbs_mod.utils.watchdog.IWatchDogListener;
import mchorse.bbs_mod.utils.watchdog.WatchDogEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TextureManager
implements IWatchDogListener {
    public final Map<Link, Texture> textures = new HashMap<Link, Texture>();
    public final Map<Link, AnimatedTexture> animatedTextures = new HashMap<Link, AnimatedTexture>();
    public AssetProvider provider;
    private Texture error;
    private TextureExtruder extruder = new TextureExtruder();
    private int tick;

    public TextureManager(AssetProvider provider) {
        this.provider = provider;
    }

    public TextureExtruder getExtruder() {
        return this.extruder;
    }

    public Texture getError() {
        if (this.error == null) {
            try {
                Pixels pixels = Pixels.fromSize(16, 16);
                Color a = new Color().set(-16736288);
                Color b = new Color().set(-2097037);
                for (int x = 0; x < pixels.width; ++x) {
                    for (int y = 0; y < pixels.height; ++y) {
                        Color color = a;
                        if (x / 4 % 2 == 0 ^ y / 4 % 2 == 0) {
                            color = b;
                        }
                        pixels.setColor(x, y, color);
                    }
                }
                pixels.rewindBuffer();
                Texture texture = new Texture();
                texture.setFilter(9728);
                texture.uploadTexture(pixels);
                texture.unbind();
                this.error = texture;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.error;
    }

    public void bindTexture(Link texture) {
        this.bindTexture(texture, 0);
    }

    public void bindTexture(Link texture, int unit) {
        this.bindTexture(this.getTexture(texture), unit);
    }

    public void bindTexture(Texture texture) {
        this.bindTexture(texture, 0);
    }

    public void bindTexture(Texture texture, int unit) {
        BBSRendering.trackTexture(texture);
        RenderSystem.setShaderTexture((int)unit, (int)texture.id);
    }

    public void bind(Link texture) {
        this.getTexture(texture).bind();
    }

    public void bind(Link texture, int unit) {
        this.getTexture(texture).bind(unit);
    }

    public boolean has(Link link) {
        return this.getTexture(link) != this.getError();
    }

    public void delete(Link link) {
        AnimatedTexture animatedTexture;
        Texture texture = this.textures.remove(link);
        if (texture != null) {
            texture.delete();
        }
        if ((animatedTexture = this.animatedTextures.remove(link)) != null) {
            animatedTexture.delete();
        }
    }

    public Texture createTexture(Link link) {
        return this.createTexture(link, 9728);
    }

    public Texture createTexture(Link link, int filter) {
        Texture texture = this.textures.get(link);
        if (texture == null || texture == this.getError()) {
            texture = new Texture();
            texture.setFilter(filter);
            this.textures.put(link, texture);
        }
        return texture;
    }

    public Pixels getPixels(Link link) throws Exception {
        Pixels pixels;
        if (link instanceof MultiLink) {
            pixels = MultiLinkThread.getStreamForMultiLink((MultiLink)link);
        } else {
            try (InputStream asset = this.provider.getAsset(link);){
                pixels = Pixels.fromPNGStream(asset);
            }
        }
        return pixels;
    }

    public Texture getTexture(Link link) {
        return this.getTexture(link, 9728);
    }

    public Texture getTexture(Link link, int filter) {
        return this.getTexture(link, filter, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Texture getTexture(Link link, int filter, boolean silent) {
        Texture texture = this.get(link);
        if (texture != null) return texture;
        try {
            Pixels pixels = this.getPixels(link);
            if (pixels == null) {
                this.textures.put(link, this.getError());
                return this.getError();
            }
            if (!link.source.startsWith("http")) {
                try (InputStream stream = this.provider.getAsset(new Link(link.source, link.path + ".mcmeta"));){
                    AnimatedTexture animatedTexture = AnimatedTexture.load(stream, pixels);
                    texture = animatedTexture.getTexture(this.tick);
                    System.out.println("Animated texture \"" + String.valueOf(link) + "\" was loaded!");
                    this.animatedTextures.put(link, animatedTexture);
                    Texture texture2 = texture;
                    return texture2;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            texture = Texture.textureFromPixels(pixels, filter);
            System.out.println("Texture \"" + String.valueOf(link) + "\" was loaded!");
            this.textures.put(link, texture);
            return texture;
        }
        catch (Exception e) {
            if (!silent) {
                e.printStackTrace();
            }
            texture = this.getError();
            this.textures.put(link, texture);
        }
        return texture;
    }

    private Texture get(Link link) {
        if (this.animatedTextures.containsKey(link)) {
            Texture texture = this.animatedTextures.get(link).getTexture(this.tick);
            return texture == null ? this.error : texture;
        }
        return this.textures.get(link);
    }

    public void delete() {
        for (Texture texture : this.textures.values()) {
            texture.delete();
        }
        for (AnimatedTexture animatedTexture : this.animatedTextures.values()) {
            animatedTexture.delete();
        }
        this.textures.clear();
        this.animatedTextures.clear();
        this.extruder.deleteAll();
    }

    public void update() {
        ++this.tick;
    }

    @Override
    public void accept(Path path, WatchDogEvent event) {
        AnimatedTexture remove;
        Texture texture;
        Link link = BBSMod.getProvider().getLink(path.toFile());
        if (link == null) {
            return;
        }
        if (link.path.endsWith(".mcmeta")) {
            link = new Link(link.source, StringUtils.removeExtension(link.path));
        }
        if ((texture = this.textures.remove(link)) != null) {
            texture.delete();
        }
        if ((remove = this.animatedTextures.remove(link)) != null) {
            remove.delete();
        }
        this.extruder.delete(link);
    }
}

