/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.network;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.actions.ActionManager;
import mchorse.bbs_mod.actions.ActionPlayer;
import mchorse.bbs_mod.actions.ActionRecorder;
import mchorse.bbs_mod.actions.ActionState;
import mchorse.bbs_mod.actions.PlayerType;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ByteType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.entity.GunProjectileEntity;
import mchorse.bbs_mod.entity.IEntityFormProvider;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.FilmManager;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.items.GunProperties;
import mchorse.bbs_mod.morphing.Morph;
import mchorse.bbs_mod.network.ServerPacketCrusher;
import mchorse.bbs_mod.utils.DataPath;
import mchorse.bbs_mod.utils.EnumUtils;
import mchorse.bbs_mod.utils.PermissionUtils;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.repos.RepositoryOperation;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ServerNetwork {
    public static final int STATE_TRIGGER_MORPH = 0;
    public static final int STATE_TRIGGER_MAIN_HAND_ITEM = 1;
    public static final int STATE_TRIGGER_OFF_HAND_ITEM = 2;
    public static final class_2960 CLIENT_CLICKED_MODEL_BLOCK_PACKET = class_2960.method_60655((String)"bbs", (String)"c1");
    public static final class_2960 CLIENT_PLAYER_FORM_PACKET = class_2960.method_60655((String)"bbs", (String)"c2");
    public static final class_2960 CLIENT_PLAY_FILM_PACKET = class_2960.method_60655((String)"bbs", (String)"c3");
    public static final class_2960 CLIENT_MANAGER_DATA_PACKET = class_2960.method_60655((String)"bbs", (String)"c4");
    public static final class_2960 CLIENT_STOP_FILM_PACKET = class_2960.method_60655((String)"bbs", (String)"c5");
    public static final class_2960 CLIENT_HANDSHAKE = class_2960.method_60655((String)"bbs", (String)"c6");
    public static final class_2960 CLIENT_RECORDED_ACTIONS = class_2960.method_60655((String)"bbs", (String)"c7");
    public static final class_2960 CLIENT_ANIMATION_STATE_TRIGGER = class_2960.method_60655((String)"bbs", (String)"c8");
    public static final class_2960 CLIENT_CHEATS_PERMISSION = class_2960.method_60655((String)"bbs", (String)"c9");
    public static final class_2960 CLIENT_SHARED_FORM = class_2960.method_60655((String)"bbs", (String)"c10");
    public static final class_2960 CLIENT_ENTITY_FORM = class_2960.method_60655((String)"bbs", (String)"c11");
    public static final class_2960 CLIENT_ACTORS = class_2960.method_60655((String)"bbs", (String)"c12");
    public static final class_2960 CLIENT_GUN_PROPERTIES = class_2960.method_60655((String)"bbs", (String)"c13");
    public static final class_2960 CLIENT_PAUSE_FILM = class_2960.method_60655((String)"bbs", (String)"c14");
    public static final class_2960 CLIENT_SELECTED_SLOT = class_2960.method_60655((String)"bbs", (String)"c15");
    public static final class_2960 CLIENT_ANIMATION_STATE_MODEL_BLOCK_TRIGGER = class_2960.method_60655((String)"bbs", (String)"c16");
    public static final class_2960 CLIENT_REFRESH_MODEL_BLOCKS = class_2960.method_60655((String)"bbs", (String)"c17");
    public static final class_2960 SERVER_MODEL_BLOCK_FORM_PACKET = class_2960.method_60655((String)"bbs", (String)"s1");
    public static final class_2960 SERVER_MODEL_BLOCK_TRANSFORMS_PACKET = class_2960.method_60655((String)"bbs", (String)"s2");
    public static final class_2960 SERVER_PLAYER_FORM_PACKET = class_2960.method_60655((String)"bbs", (String)"s3");
    public static final class_2960 SERVER_MANAGER_DATA_PACKET = class_2960.method_60655((String)"bbs", (String)"s4");
    public static final class_2960 SERVER_ACTION_RECORDING = class_2960.method_60655((String)"bbs", (String)"s5");
    public static final class_2960 SERVER_TOGGLE_FILM = class_2960.method_60655((String)"bbs", (String)"s6");
    public static final class_2960 SERVER_ACTION_CONTROL = class_2960.method_60655((String)"bbs", (String)"s7");
    public static final class_2960 SERVER_FILM_DATA_SYNC = class_2960.method_60655((String)"bbs", (String)"s8");
    public static final class_2960 SERVER_PLAYER_TP = class_2960.method_60655((String)"bbs", (String)"s9");
    public static final class_2960 SERVER_ANIMATION_STATE_TRIGGER = class_2960.method_60655((String)"bbs", (String)"s10");
    public static final class_2960 SERVER_SHARED_FORM = class_2960.method_60655((String)"bbs", (String)"s11");
    public static final class_2960 SERVER_ZOOM = class_2960.method_60655((String)"bbs", (String)"s12");
    public static final class_2960 SERVER_PAUSE_FILM = class_2960.method_60655((String)"bbs", (String)"s13");
    private static ServerPacketCrusher crusher = new ServerPacketCrusher();

    public static class_8710.class_9154<BufPayload> idFor(class_2960 identifier) {
        return new class_8710.class_9154(identifier);
    }

    public static void reset() {
        crusher.reset();
    }

    public static void setup() {
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_MODEL_BLOCK_FORM_PACKET), BufPayload.codecFor(ServerNetwork.idFor(SERVER_MODEL_BLOCK_FORM_PACKET)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_MODEL_BLOCK_TRANSFORMS_PACKET), BufPayload.codecFor(ServerNetwork.idFor(SERVER_MODEL_BLOCK_TRANSFORMS_PACKET)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_PLAYER_FORM_PACKET), BufPayload.codecFor(ServerNetwork.idFor(SERVER_PLAYER_FORM_PACKET)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_MANAGER_DATA_PACKET), BufPayload.codecFor(ServerNetwork.idFor(SERVER_MANAGER_DATA_PACKET)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_ACTION_RECORDING), BufPayload.codecFor(ServerNetwork.idFor(SERVER_ACTION_RECORDING)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_TOGGLE_FILM), BufPayload.codecFor(ServerNetwork.idFor(SERVER_TOGGLE_FILM)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_ACTION_CONTROL), BufPayload.codecFor(ServerNetwork.idFor(SERVER_ACTION_CONTROL)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_FILM_DATA_SYNC), BufPayload.codecFor(ServerNetwork.idFor(SERVER_FILM_DATA_SYNC)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_PLAYER_TP), BufPayload.codecFor(ServerNetwork.idFor(SERVER_PLAYER_TP)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_ANIMATION_STATE_TRIGGER), BufPayload.codecFor(ServerNetwork.idFor(SERVER_ANIMATION_STATE_TRIGGER)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_SHARED_FORM), BufPayload.codecFor(ServerNetwork.idFor(SERVER_SHARED_FORM)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_ZOOM), BufPayload.codecFor(ServerNetwork.idFor(SERVER_ZOOM)));
        PayloadTypeRegistry.playC2S().register(ServerNetwork.idFor(SERVER_PAUSE_FILM), BufPayload.codecFor(ServerNetwork.idFor(SERVER_PAUSE_FILM)));
        try {
            Class<?> envTypeClass = Class.forName("net.fabricmc.api.EnvType");
            Class<?> loaderClass = Class.forName("net.fabricmc.loader.api.FabricLoader");
            Object loader = loaderClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Object envType = loaderClass.getMethod("getEnvironmentType", new Class[0]).invoke(loader, new Object[0]);
            Object serverEnum = envTypeClass.getField("SERVER").get(null);
            if (envType == serverEnum) {
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_CLICKED_MODEL_BLOCK_PACKET), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_CLICKED_MODEL_BLOCK_PACKET)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_PLAYER_FORM_PACKET), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_PLAYER_FORM_PACKET)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_PLAY_FILM_PACKET), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_PLAY_FILM_PACKET)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_MANAGER_DATA_PACKET), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_MANAGER_DATA_PACKET)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_STOP_FILM_PACKET), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_STOP_FILM_PACKET)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_HANDSHAKE), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_HANDSHAKE)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_RECORDED_ACTIONS), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_RECORDED_ACTIONS)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_ANIMATION_STATE_TRIGGER), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_ANIMATION_STATE_TRIGGER)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_CHEATS_PERMISSION), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_CHEATS_PERMISSION)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_SHARED_FORM), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_SHARED_FORM)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_ENTITY_FORM), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_ENTITY_FORM)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_ACTORS), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_ACTORS)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_GUN_PROPERTIES), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_GUN_PROPERTIES)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_PAUSE_FILM), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_PAUSE_FILM)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_SELECTED_SLOT), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_SELECTED_SLOT)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_ANIMATION_STATE_MODEL_BLOCK_TRIGGER), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_ANIMATION_STATE_MODEL_BLOCK_TRIGGER)));
                PayloadTypeRegistry.playS2C().register(ServerNetwork.idFor(CLIENT_REFRESH_MODEL_BLOCKS), BufPayload.codecFor(ServerNetwork.idFor(CLIENT_REFRESH_MODEL_BLOCKS)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_MODEL_BLOCK_FORM_PACKET), (payload, context) -> ServerNetwork.handleModelBlockFormPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_MODEL_BLOCK_TRANSFORMS_PACKET), (payload, context) -> ServerNetwork.handleModelBlockTransformsPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_PLAYER_FORM_PACKET), (payload, context) -> ServerNetwork.handlePlayerFormPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_MANAGER_DATA_PACKET), (payload, context) -> ServerNetwork.handleManagerDataPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_ACTION_RECORDING), (payload, context) -> ServerNetwork.handleActionRecording(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_TOGGLE_FILM), (payload, context) -> ServerNetwork.handleToggleFilm(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_ACTION_CONTROL), (payload, context) -> ServerNetwork.handleActionControl(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_FILM_DATA_SYNC), (payload, context) -> ServerNetwork.handleSyncData(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_PLAYER_TP), (payload, context) -> ServerNetwork.handleTeleportPlayer(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_ANIMATION_STATE_TRIGGER), (payload, context) -> ServerNetwork.handleAnimationStateTriggerPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_SHARED_FORM), (payload, context) -> ServerNetwork.handleSharedFormPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_ZOOM), (payload, context) -> ServerNetwork.handleZoomPacket(context.server(), context.player(), payload.asPacketByteBuf()));
        ServerPlayNetworking.registerGlobalReceiver(ServerNetwork.idFor(SERVER_PAUSE_FILM), (payload, context) -> ServerNetwork.handlePauseFilmPacket(context.server(), context.player(), payload.asPacketByteBuf()));
    }

    private static void handleModelBlockFormPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            class_2338 pos = buf.method_10811();
            try {
                MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
                server.execute(() -> {
                    class_1937 world = player.method_37908();
                    class_2586 be = world.method_8321(pos);
                    if (be instanceof ModelBlockEntity) {
                        ModelBlockEntity modelBlock = (ModelBlockEntity)be;
                        modelBlock.updateForm(data, world);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void handleModelBlockTransformsPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            try {
                MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
                server.execute(() -> {
                    class_1799 stack = player.method_6118(class_1304.field_6173).method_7972();
                    if (stack.method_7909() == BBSMod.MODEL_BLOCK_ITEM) {
                        class_9279 beComponent = (class_9279)stack.method_57824(class_9334.field_49611);
                        class_2487 beNbt = beComponent != null ? beComponent.method_57463() : new class_2487();
                        beNbt.method_10566("Properties", DataStorageUtils.toNbt(data));
                        stack.method_57379(class_9334.field_49611, (Object)class_9279.method_57456((class_2487)beNbt));
                    } else if (stack.method_7909() == BBSMod.GUN_ITEM) {
                        class_9279 customComponent = (class_9279)stack.method_57824(class_9334.field_49628);
                        class_2487 customNbt = customComponent != null ? customComponent.method_57463() : new class_2487();
                        customNbt.method_10566("GunData", DataStorageUtils.toNbt(data));
                        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customNbt));
                    }
                    player.method_5673(class_1304.field_6173, stack);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    private static void handlePlayerFormPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            Form form = null;
            try {
                BaseType patt0$temp = DataStorageUtils.readFromBytes(bytes);
                if (patt0$temp instanceof MapType) {
                    MapType data = (MapType)patt0$temp;
                    form = (Form)BBSMod.getForms().fromData(data);
                }
            }
            catch (Exception data) {
                // empty catch block
            }
            Form finalForm = form;
            server.execute(() -> {
                Morph.getMorph((class_1297)player).setForm(FormUtils.copy(finalForm));
                ServerNetwork.sendMorphToTracked(player, finalForm);
            });
        });
    }

    private static void handleManagerDataPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
            int callbackId = packetByteBuf.readInt();
            RepositoryOperation op = RepositoryOperation.values()[packetByteBuf.readInt()];
            FilmManager films = BBSMod.getFilms();
            if (op == RepositoryOperation.LOAD) {
                String id = data.getString("id");
                Film film = (Film)films.load(id);
                ServerNetwork.sendManagerData(player, callbackId, op, film.toData());
            } else if (op == RepositoryOperation.SAVE) {
                films.save(data.getString("id"), data.getMap("data"));
            } else if (op == RepositoryOperation.RENAME) {
                films.rename(data.getString("from"), data.getString("to"));
            } else if (op == RepositoryOperation.DELETE) {
                films.delete(data.getString("id"));
            } else if (op == RepositoryOperation.KEYS) {
                ListType list = DataStorageUtils.stringListToData(films.getKeys());
                ServerNetwork.sendManagerData(player, callbackId, op, list);
            } else if (op == RepositoryOperation.ADD_FOLDER) {
                ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.addFolder(data.getString("folder"))));
            } else if (op == RepositoryOperation.RENAME_FOLDER) {
                ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.renameFolder(data.getString("from"), data.getString("to"))));
            } else if (op == RepositoryOperation.DELETE_FOLDER) {
                ServerNetwork.sendManagerData(player, callbackId, op, new ByteType(films.deleteFolder(data.getString("folder"))));
            }
        });
    }

    private static void handleActionRecording(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = buf.method_19772();
        int replayId = buf.readInt();
        int tick = buf.readInt();
        int countdown = buf.readInt();
        boolean recording = buf.readBoolean();
        server.execute(() -> {
            if (recording) {
                Film film = (Film)BBSMod.getFilms().load(filmId);
                if (film != null) {
                    BBSMod.getActions().startRecording(film, player, 0, countdown, replayId);
                }
            } else {
                ActionRecorder recorder = BBSMod.getActions().stopRecording(player);
                Clips clips = recorder.composeClips();
                ServerNetwork.sendRecordedActions(player, filmId, replayId, tick, clips);
            }
        });
    }

    private static void handleToggleFilm(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        String filmId = buf.method_19772();
        boolean withCamera = buf.readBoolean();
        server.execute(() -> {
            ActionPlayer actionPlayer = BBSMod.getActions().getPlayer(filmId);
            if (actionPlayer != null) {
                BBSMod.getActions().stop(filmId);
                for (class_3222 otherPlayer : server.method_3760().method_14571()) {
                    ServerNetwork.sendStopFilm(otherPlayer, filmId);
                }
            } else {
                ServerNetwork.sendPlayFilm(player, player.method_51469(), filmId, withCamera);
            }
        });
    }

    private static void handleActionControl(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        ActionManager actions = BBSMod.getActions();
        String filmId = buf.method_19772();
        ActionState state = EnumUtils.getValue(buf.readByte(), ActionState.values(), ActionState.STOP);
        int tick = buf.readInt();
        server.execute(() -> {
            if (state == ActionState.SEEK) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                }
            } else if (state == ActionState.PLAY) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                    actionPlayer.playing = true;
                }
            } else if (state == ActionState.PAUSE) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer != null) {
                    actionPlayer.goTo(tick);
                    actionPlayer.playing = false;
                }
            } else if (state == ActionState.RESTART) {
                ActionPlayer actionPlayer = actions.getPlayer(filmId);
                if (actionPlayer == null) {
                    Film film = (Film)BBSMod.getFilms().load(filmId);
                    if (film != null) {
                        actionPlayer = actions.play(player, player.method_51469(), film, tick, PlayerType.FILM_EDITOR);
                    }
                } else {
                    actions.stop(filmId);
                    actionPlayer = actions.play(player, player.method_51469(), actionPlayer.film, tick, PlayerType.FILM_EDITOR);
                }
                if (actionPlayer != null) {
                    actionPlayer.syncing = true;
                    actionPlayer.playing = false;
                    if (tick != 0) {
                        actionPlayer.goTo(0, tick);
                    }
                }
                ServerNetwork.sendStopFilm(player, filmId);
            } else if (state == ActionState.STOP) {
                actions.stop(filmId);
            }
        });
    }

    private static void handleSyncData(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            String filmId = packetByteBuf.method_19772();
            ArrayList<String> path = new ArrayList<String>();
            int c = buf.readInt();
            for (int i = 0; i < c; ++i) {
                path.add(buf.method_19772());
            }
            BaseType data = DataStorageUtils.readFromBytes(bytes);
            server.execute(() -> BBSMod.getActions().syncData(filmId, new DataPath(path), data));
        });
    }

    private static void handleTeleportPlayer(MinecraftServer server, class_3222 player, class_2540 buf) {
        if (!PermissionUtils.arePanelsAllowed(server, player)) {
            return;
        }
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        float yaw = buf.readFloat();
        float bodyYaw = buf.readFloat();
        float pitch = buf.readFloat();
        server.execute(() -> {
            player.method_5859(x, y, z);
            player.method_36456(yaw);
            player.method_5847(yaw);
            player.method_5636(bodyYaw);
            player.method_36457(pitch);
        });
    }

    private static void handleAnimationStateTriggerPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        String string = buf.method_19772();
        int type = buf.readInt();
        class_2540 newBuf = PacketByteBufs.create();
        newBuf.method_53002(player.method_5628());
        newBuf.method_10814(string);
        newBuf.method_53002(type);
        BufPayload payload = BufPayload.from(newBuf, ServerNetwork.idFor(CLIENT_ANIMATION_STATE_TRIGGER));
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerPlayNetworking.send((class_3222)otherPlayer, (class_8710)payload);
        }
        server.execute(() -> {});
    }

    private static void handleSharedFormPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        crusher.receive(buf, (bytes, packetByteBuf) -> {
            UUID playerUuid = packetByteBuf.method_10790();
            MapType data = (MapType)DataStorageUtils.readFromBytes(bytes);
            server.execute(() -> {
                class_3222 otherPlayer = server.method_3760().method_14602(playerUuid);
                if (otherPlayer != null) {
                    ServerNetwork.sendSharedForm(otherPlayer, data);
                }
            });
        });
    }

    private static void handleZoomPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        boolean zoom = buf.readBoolean();
        class_1799 main = player.method_6047();
        if (main.method_7909() == BBSMod.GUN_ITEM) {
            String command;
            GunProperties properties = GunProperties.get(main);
            String string = command = zoom ? properties.cmdZoomOn : properties.cmdZoomOff;
            if (!command.isEmpty()) {
                server.method_3734().method_44252(player.method_5671(), command);
            }
        }
    }

    private static void handlePauseFilmPacket(MinecraftServer server, class_3222 player, class_2540 buf) {
        String filmId = buf.method_19772();
        ActionPlayer actionPlayer = BBSMod.getActions().getPlayer(filmId);
        if (actionPlayer != null) {
            actionPlayer.toggle();
        }
        for (class_3222 playerEntity : server.method_3760().method_14571()) {
            ServerNetwork.sendPauseFilm(playerEntity, filmId);
        }
    }

    public static void sendMorph(class_3222 player, int playerId, Form form) {
        crusher.send((class_1657)player, CLIENT_PLAYER_FORM_PACKET, (BaseType)FormUtils.toData(form), packetByteBuf -> packetByteBuf.method_53002(playerId));
    }

    public static void sendMorphToTracked(class_3222 player, Form form) {
        ServerNetwork.sendMorph(player, player.method_5628(), form);
        for (class_3222 otherPlayer : PlayerLookup.tracking((class_1297)player)) {
            ServerNetwork.sendMorph(otherPlayer, player.method_5628(), form);
        }
    }

    public static void sendClickedModelBlock(class_3222 player, class_2338 pos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_CLICKED_MODEL_BLOCK_PACKET)));
    }

    public static void sendPlayFilm(class_3222 player, class_3218 world, String filmId, boolean withCamera) {
        try {
            Film film = (Film)BBSMod.getFilms().load(filmId);
            if (film != null) {
                BBSMod.getActions().play(player, world, film, 0);
                BaseType data = film.toData();
                crusher.send(world.method_18456().stream().map(p -> p).toList(), CLIENT_PLAY_FILM_PACKET, data, packetByteBuf -> {
                    packetByteBuf.method_10814(filmId);
                    packetByteBuf.method_52964(withCamera);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendPlayFilm(class_3222 player, String filmId, boolean withCamera) {
        try {
            Film film = (Film)BBSMod.getFilms().load(filmId);
            if (film != null) {
                BBSMod.getActions().play(player, player.method_51469(), film, 0);
                crusher.send((class_1657)player, CLIENT_PLAY_FILM_PACKET, film.toData(), packetByteBuf -> {
                    packetByteBuf.method_10814(filmId);
                    packetByteBuf.method_52964(withCamera);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendStopFilm(class_3222 player, String filmId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(filmId);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_STOP_FILM_PACKET)));
    }

    public static void sendManagerData(class_3222 player, int callbackId, RepositoryOperation op, BaseType data) {
        crusher.send((class_1657)player, CLIENT_MANAGER_DATA_PACKET, data, packetByteBuf -> {
            packetByteBuf.method_53002(callbackId);
            packetByteBuf.method_53002(op.ordinal());
        });
    }

    public static void sendRecordedActions(class_3222 player, String filmId, int replayId, int tick, Clips clips) {
        crusher.send((class_1657)player, CLIENT_RECORDED_ACTIONS, clips.toData(), packetByteBuf -> {
            packetByteBuf.method_10814(filmId);
            packetByteBuf.method_53002(replayId);
            packetByteBuf.method_53002(tick);
        });
    }

    public static void sendHandshake(MinecraftServer server, PacketSender packetSender) {
        packetSender.sendPacket((class_8710)BufPayload.from(ServerNetwork.createHandshakeBuf(server), ServerNetwork.idFor(CLIENT_HANDSHAKE)));
    }

    public static void sendHandshake(MinecraftServer server, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(ServerNetwork.createHandshakeBuf(server), ServerNetwork.idFor(CLIENT_HANDSHAKE)));
    }

    private static class_2540 createHandshakeBuf(MinecraftServer server) {
        class_2540 buf = PacketByteBufs.create();
        String id = "";
        if (server.method_3724()) {
            id = "";
        }
        buf.method_10814(id);
        return buf;
    }

    public static void sendCheatsPermission(class_3222 player, boolean cheats) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_52964(cheats);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_CHEATS_PERMISSION)));
    }

    public static void sendSharedForm(class_3222 player, MapType data) {
        crusher.send((class_1657)player, CLIENT_SHARED_FORM, (BaseType)data, packetByteBuf -> {});
    }

    public static void sendEntityForm(class_3222 player, IEntityFormProvider actor) {
        crusher.send((class_1657)player, CLIENT_ENTITY_FORM, (BaseType)FormUtils.toData(actor.getForm()), packetByteBuf -> packetByteBuf.method_53002(actor.getEntityId()));
    }

    public static void sendActors(class_3222 player, String filmId, Map<String, class_1309> actors) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(filmId);
        buf.method_53002(actors.size());
        for (Map.Entry<String, class_1309> entry : actors.entrySet()) {
            buf.method_10814(entry.getKey());
            buf.method_53002(entry.getValue().method_5628());
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_ACTORS)));
    }

    public static void sendGunProperties(class_3222 player, GunProjectileEntity projectile) {
        class_2540 buf = PacketByteBufs.create();
        GunProperties properties = projectile.getProperties();
        buf.method_53002(projectile.getEntityId());
        properties.toNetwork(buf);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_GUN_PROPERTIES)));
    }

    public static void sendPauseFilm(class_3222 player, String filmId) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(filmId);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_PAUSE_FILM)));
    }

    public static void sendSelectedSlot(class_3222 player, int slot) {
        player.method_31548().field_7545 = slot;
        class_2540 buf = PacketByteBufs.create();
        buf.method_53002(slot);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_SELECTED_SLOT)));
    }

    public static void sendModelBlockState(class_3222 player, class_2338 pos, String trigger) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.method_10814(trigger);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_ANIMATION_STATE_MODEL_BLOCK_TRIGGER)));
    }

    public static void sendReloadModelBlocks(class_3222 player, int tickRandom) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_53002(tickRandom);
        ServerPlayNetworking.send((class_3222)player, (class_8710)BufPayload.from(buf, ServerNetwork.idFor(CLIENT_REFRESH_MODEL_BLOCKS)));
    }

    public record BufPayload(byte[] data, class_8710.class_9154<BufPayload> id) implements class_8710
    {
        public static BufPayload from(class_2540 buf, class_8710.class_9154<BufPayload> id) {
            byte[] bytes = new byte[buf.readableBytes()];
            buf.method_52979(bytes);
            return new BufPayload(bytes, id);
        }

        public class_2540 asPacketByteBuf() {
            class_2540 out = PacketByteBufs.create();
            out.method_52983(this.data);
            return out;
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return this.id;
        }

        public static class_9139<class_9129, BufPayload> codecFor(final class_8710.class_9154<BufPayload> id) {
            return new class_9139<class_9129, BufPayload>(){

                public BufPayload decode(class_9129 byteBuf) {
                    byte[] bytes = new byte[byteBuf.readableBytes()];
                    byteBuf.method_52979(bytes);
                    return new BufPayload(bytes, (class_8710.class_9154<BufPayload>)id);
                }

                public void encode(class_9129 byteBuf, BufPayload payload) {
                    byteBuf.method_52983(payload.data);
                }
            };
        }
    }
}

