/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.resources.packs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mchorse.bbs_mod.resources.ISourcePack;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.resources.packs.ExternalAssetsSourcePack;
import mchorse.bbs_mod.utils.DataPath;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class InternalAssetsSourcePack
implements ISourcePack {
    private String prefix;
    private String internalPrefix;
    private Class clazz;
    private boolean isForge;
    private List<String> zipCache = new ArrayList<String>();

    public InternalAssetsSourcePack() {
        this("assets", "assets/bbs/assets", InternalAssetsSourcePack.class);
    }

    public InternalAssetsSourcePack(String prefix, String internalPrefix, Class clazz) {
        this.prefix = prefix;
        this.internalPrefix = internalPrefix;
        this.clazz = clazz;
        try {
            Class.forName("net.minecraftforge.common.MinecraftForge");
            this.isForge = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean hasAsset(Link link) {
        return this.clazz.getClassLoader().getResource(this.internalPrefix + "/" + link.path) != null;
    }

    @Override
    public InputStream getAsset(Link link) throws IOException {
        return this.clazz.getClassLoader().getResourceAsStream(this.internalPrefix + "/" + link.path);
    }

    @Override
    public File getFile(Link link) {
        return null;
    }

    @Override
    public Link getLink(File file) {
        return null;
    }

    @Override
    public void getLinksFromPath(Collection<Link> links, Link link, boolean recursive) {
        if (this.isForge) {
            this.stupidWorkaround(links, link, recursive);
            return;
        }
        URL url = this.clazz.getProtectionDomain().getCodeSource().getLocation();
        try {
            File file = Paths.get(url.toURI()).toFile();
            if (file.isDirectory()) {
                this.getLinksFromFolder(this.getResourcesFolder(file), link, links, recursive);
            } else if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                this.getLinksFromZipFile(file, link, links, recursive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stupidWorkaround(links, link, recursive);
        }
    }

    private void stupidWorkaround(Collection<Link> links, Link link, boolean recursive) {
        String version = "";
        for (ModContainer allMod : FabricLoader.getInstance().getAllMods()) {
            if (!allMod.getMetadata().getId().equals("bbs")) continue;
            version = allMod.getMetadata().getVersion().getFriendlyString();
            break;
        }
        if (version.isEmpty()) {
            return;
        }
        File mods = new File(FabricLoader.getInstance().getGameDir().toFile(), "mods");
        if (mods.isDirectory()) {
            for (File file : mods.listFiles()) {
                String name = file.getName();
                if (!name.startsWith("bbs") || !name.contains(version) || !name.endsWith(".jar")) continue;
                this.getLinksFromZipFile(file, link, links, recursive);
            }
        }
    }

    private File getResourcesFolder(File file) {
        File resources;
        if (new File(file, this.internalPrefix).exists()) {
            return file;
        }
        for (File subFile : file.getParentFile().listFiles()) {
            if (!new File(subFile, this.internalPrefix).exists()) continue;
            return subFile;
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && (resources = new File(file.getParentFile().getParentFile().getParentFile(), "resources/client/")).isDirectory()) {
            return resources;
        }
        return file;
    }

    private void getLinksFromFolder(File folder, Link link, Collection<Link> links, boolean recursive) {
        File file = new File(folder, this.internalPrefix + "/" + link.path);
        ExternalAssetsSourcePack.getLinksFromPathRecursively(file, links, link, link.path, recursive ? 9999 : 1);
    }

    private void getLinksFromZipFile(File file, Link link, Collection<Link> links, boolean recursive) {
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.zipCache.isEmpty()) {
                Enumeration<? extends ZipEntry> it = zipFile.entries();
                while (it.hasMoreElements()) {
                    String name = it.nextElement().getName();
                    if (!name.startsWith(this.internalPrefix)) continue;
                    this.zipCache.add(name);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.handleLinksFromZipFile(link, links, recursive);
    }

    private void handleLinksFromZipFile(Link link, Collection<Link> links, boolean recursive) {
        DataPath assetsPath = new DataPath(this.internalPrefix + "/");
        for (String zipName : this.zipCache) {
            DataPath fullPath;
            DataPath zipPath = new DataPath(zipName);
            if (zipPath.equals(fullPath = new DataPath(String.valueOf(assetsPath) + "/" + link.path)) || !zipPath.startsWith(fullPath)) continue;
            for (int i = 0; i < assetsPath.size(); ++i) {
                zipPath.strings.remove(0);
                fullPath.strings.remove(0);
            }
            if (!recursive && zipPath.size() != fullPath.size() + 1) continue;
            links.add(new Link(this.prefix, String.valueOf(zipPath) + (zipPath.folder ? "/" : "")));
        }
    }
}

