/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips.renderer;

import java.util.HashMap;
import java.util.Map;
import mchorse.bbs_mod.camera.clips.misc.AudioClientClip;
import mchorse.bbs_mod.ui.film.clips.renderer.IUIClipRenderer;
import mchorse.bbs_mod.ui.film.clips.renderer.UIAudioClipRenderer;
import mchorse.bbs_mod.ui.film.clips.renderer.UIClipRenderer;
import mchorse.bbs_mod.utils.clips.Clip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIClipRenderers {
    private UIClipRenderer defaultRenderer;
    private Map<Class, IUIClipRenderer> renderers = new HashMap<Class, IUIClipRenderer>();

    public UIClipRenderers() {
        this.defaultRenderer = new UIClipRenderer();
        this.register(AudioClientClip.class, new UIAudioClipRenderer());
    }

    public void register(Class key, IUIClipRenderer renderer) {
        this.renderers.put(key, renderer);
    }

    public <T extends Clip> IUIClipRenderer<T> get(T clip) {
        IUIClipRenderer renderer = this.renderers.get(clip.getClass());
        return renderer == null ? this.defaultRenderer : renderer;
    }
}

