/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.replays;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.blocks.entities.ModelBlockEntity;
import mchorse.bbs_mod.blocks.entities.ModelProperties;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.clips.CameraClipContext;
import mchorse.bbs_mod.camera.clips.modifiers.EntityClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.ListType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.film.replays.Replays;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.forms.AnchorForm;
import mchorse.bbs_mod.forms.forms.BodyPart;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.utils.Anchor;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.IExpression;
import mchorse.bbs_mod.math.MathBuilder;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.core.ValueForm;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.replays.UIReplaysEditor;
import mchorse.bbs_mod.ui.film.replays.overlays.UIReplaysOverlayPanel;
import mchorse.bbs_mod.ui.forms.UIFormPalette;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UISearchList;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIStringList;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIConfirmOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UINumberOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIPromptOverlayPanel;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.RayTracing;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.colors.Colors;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

@Environment(value=EnvType.CLIENT)
public class UIReplayList
extends UIList<Replay> {
    private static String LAST_PROCESS = "v";
    private static String LAST_OFFSET = "0";
    private static List<String> LAST_PROCESS_PROPERTIES = Arrays.asList("x");
    public UIFilmPanel panel;
    public UIReplaysOverlayPanel overlay;
    private boolean groupCategoriesEnabled = true;
    private Map<String, Boolean> expandedGroups = new HashMap<String, Boolean>();
    private List<Row> groupedRows = new ArrayList<Row>();
    private static final String EMPTY_GROUP_LABEL = "(sin grupo)";
    private int groupedDragFrom = -1;
    private long groupedDragTime;
    private int groupedDragStartX;
    private int groupedDragStartY;
    private boolean groupedDragHolding;

    public UIReplayList(Consumer<List<Replay>> callback, UIReplaysOverlayPanel overlay, UIFilmPanel panel) {
        super(callback);
        this.overlay = overlay;
        this.panel = panel;
        this.multi().sorting();
        this.context((ContextMenuManager menu) -> {
            int duration;
            MapType copyReplay;
            menu.action(Icons.ADD, UIKeys.SCENE_REPLAYS_CONTEXT_ADD, this::addReplay);
            if (this.isSelected()) {
                menu.action(Icons.COPY, UIKeys.SCENE_REPLAYS_CONTEXT_COPY, this::copyReplay);
            }
            if ((copyReplay = Window.getClipboardMap("_CopyReplay")) != null) {
                menu.action(Icons.PASTE, UIKeys.SCENE_REPLAYS_CONTEXT_PASTE, () -> this.pasteReplay(copyReplay));
            }
            if ((duration = ((Film)this.panel.getData()).camera.calculateDuration()) > 0) {
                menu.action(Icons.PLAY, UIKeys.SCENE_REPLAYS_CONTEXT_FROM_CAMERA, () -> this.fromCamera(duration));
            }
            menu.action(Icons.BLOCK, UIKeys.SCENE_REPLAYS_CONTEXT_FROM_MODEL_BLOCK, this::fromModelBlock);
            if (this.isSelected()) {
                boolean shift = Window.isShiftPressed();
                MapType data = Window.getClipboardMap("_CopyKeyframes");
                menu.action(Icons.ALL_DIRECTIONS, UIKeys.SCENE_REPLAYS_CONTEXT_PROCESS, this::processReplays);
                menu.action(Icons.TIME, UIKeys.SCENE_REPLAYS_CONTEXT_OFFSET_TIME, this::offsetTimeReplays);
                menu.action(Icons.FOLDER, UIKeys.SCENE_REPLAYS_GROUP_OPTIONS, () -> this.getContext().replaceContextMenu(submenu -> {
                    submenu.action(Icons.ADD, UIKeys.SCENE_REPLAYS_GROUP_ASSIGN, () -> {
                        UIPromptOverlayPanel prompt = new UIPromptOverlayPanel(UIKeys.SCENE_REPLAYS_GROUP_ASSIGN_TITLE, UIKeys.SCENE_REPLAYS_GROUP_ASSIGN_DESCRIPTION, text -> {
                            String g = text == null ? "" : text.trim();
                            for (Replay replay : this.getCurrent()) {
                                replay.group.set(g);
                            }
                            this.update();
                        });
                        UIOverlay.addOverlay(this.getContext(), prompt);
                    });
                    submenu.action(Icons.EDIT, UIKeys.SCENE_REPLAYS_GROUP_RENAME, () -> {
                        String current = this.getCurrentFirst() != null ? (String)((Replay)this.getCurrentFirst()).group.get() : "";
                        Consumer<String> doRename = oldName -> {
                            UIPromptOverlayPanel renamePrompt = new UIPromptOverlayPanel(UIKeys.SCENE_REPLAYS_GROUP_RENAME_TITLE, UIKeys.SCENE_REPLAYS_GROUP_RENAME_DESCRIPTION, newName -> {
                                String nn = newName == null ? "" : newName.trim();
                                this.renameGroup((String)oldName, nn);
                            });
                            UIOverlay.addOverlay(this.getContext(), renamePrompt);
                        };
                        if (current != null && !current.isEmpty()) {
                            doRename.accept(current);
                        } else {
                            this.openGroupPickerPanel(UIKeys.SCENE_REPLAYS_GROUP_PICK_TITLE, doRename);
                        }
                    });
                    submenu.action(Icons.X, UIKeys.SCENE_REPLAYS_GROUP_UNLINK, () -> {
                        for (Replay r : this.getCurrent()) {
                            r.group.set("");
                        }
                        this.update();
                    });
                    submenu.action(Icons.CLOSE, UIKeys.SCENE_REPLAYS_GROUP_DELETE_KEEP, () -> {
                        String current = this.getCurrentFirst() != null ? (String)((Replay)this.getCurrentFirst()).group.get() : "";
                        Consumer<String> deleteOnly = g -> {
                            UIConfirmOverlayPanel confirmPanel = new UIConfirmOverlayPanel(UIKeys.SCENE_REPLAYS_GROUP_DELETE_KEEP_TITLE, UIKeys.SCENE_REPLAYS_GROUP_DELETE_KEEP_DESCRIPTION.format(g), confirm -> {
                                if (confirm.booleanValue()) {
                                    this.deleteGroupOnly((String)g);
                                }
                            });
                            UIOverlay.addOverlay(this.getContext(), confirmPanel);
                        };
                        if (current != null && !current.isEmpty()) {
                            deleteOnly.accept(current);
                        } else {
                            this.openGroupPickerPanel(UIKeys.SCENE_REPLAYS_GROUP_PICK_TITLE, deleteOnly);
                        }
                    });
                    submenu.action(Icons.REMOVE, UIKeys.SCENE_REPLAYS_GROUP_DELETE_ALL, () -> {
                        String current = this.getCurrentFirst() != null ? (String)((Replay)this.getCurrentFirst()).group.get() : "";
                        Consumer<String> deleteWithReplays = g -> {
                            UIConfirmOverlayPanel confirmPanel = new UIConfirmOverlayPanel(UIKeys.SCENE_REPLAYS_GROUP_DELETE_ALL_TITLE, UIKeys.SCENE_REPLAYS_GROUP_DELETE_ALL_DESCRIPTION.format(g), confirm -> {
                                if (confirm.booleanValue()) {
                                    this.deleteGroupWithReplays((String)g);
                                }
                            });
                            UIOverlay.addOverlay(this.getContext(), confirmPanel);
                        };
                        if (current != null && !current.isEmpty()) {
                            deleteWithReplays.accept(current);
                        } else {
                            this.openGroupPickerPanel(UIKeys.SCENE_REPLAYS_GROUP_PICK_TITLE, deleteWithReplays);
                        }
                    });
                }));
                if (data != null) {
                    menu.action(Icons.PASTE, UIKeys.SCENE_REPLAYS_CONTEXT_PASTE_KEYFRAMES, () -> this.pasteToReplays(data));
                }
                menu.action(Icons.DUPE, UIKeys.SCENE_REPLAYS_CONTEXT_DUPE, () -> {
                    if (Window.isShiftPressed() || shift) {
                        this.dupeReplay();
                    } else {
                        UINumberOverlayPanel numberPanel = new UINumberOverlayPanel(UIKeys.SCENE_REPLAYS_CONTEXT_DUPE, UIKeys.SCENE_REPLAYS_CONTEXT_DUPE_DESCRIPTION, n -> {
                            int i = 0;
                            while ((double)i < n) {
                                this.dupeReplay();
                                ++i;
                            }
                        });
                        numberPanel.value.limit(1.0).integer();
                        numberPanel.value.setValue(1.0);
                        UIOverlay.addOverlay(this.getContext(), numberPanel);
                    }
                });
                menu.action(Icons.REMOVE, UIKeys.SCENE_REPLAYS_CONTEXT_REMOVE, this::removeReplay);
            }
        });
        for (String g : this.collectGroups()) {
            this.expandedGroups.putIfAbsent(g, true);
        }
        this.expandedGroups.putIfAbsent(EMPTY_GROUP_LABEL, true);
    }

    @Override
    protected void handleSwap(int from, int to) {
        Film data = (Film)this.panel.getData();
        Replays replays = data.replays;
        Replay value = (Replay)replays.getList().get(from);
        data.preNotify(1);
        replays.remove(value);
        replays.add(to, value);
        replays.sync();
        for (Replay replay : replays.getList()) {
            KeyframeChannel channel;
            BaseValue baseValue = replay.properties.get("anchor");
            if (!(baseValue instanceof KeyframeChannel) || (channel = (KeyframeChannel)baseValue).getFactory() != KeyframeFactories.ANCHOR) continue;
            KeyframeChannel keyframeChannel = channel;
            for (Keyframe keyframe : keyframeChannel.getKeyframes()) {
                ((Anchor)keyframe.getValue()).replay = MathUtils.remapIndex(((Anchor)keyframe.getValue()).replay, from, to);
            }
        }
        for (Clip clip : data.camera.get()) {
            if (!(clip instanceof EntityClip)) continue;
            EntityClip entityClip = (EntityClip)clip;
            entityClip.selector.set(MathUtils.remapIndex((Integer)entityClip.selector.get(), from, to));
        }
        data.postNotify(1);
        this.setList(replays.getList());
        this.updateFilmEditor();
        this.pick(to);
    }

    private void pasteToReplays(MapType data) {
        UIReplaysEditor replayEditor = this.panel.replayEditor;
        List selectedReplays = replayEditor.replays.replays.getCurrent();
        if (data == null) {
            return;
        }
        Map<String, UIKeyframes.PastedKeyframes> parsedKeyframes = UIKeyframes.parseKeyframes(data);
        if (parsedKeyframes.isEmpty()) {
            return;
        }
        UINumberOverlayPanel offsetPanel = new UINumberOverlayPanel(UIKeys.SCENE_REPLAYS_CONTEXT_PASTE_KEYFRAMES_TITLE, UIKeys.SCENE_REPLAYS_CONTEXT_PASTE_KEYFRAMES_DESCRIPTION, n -> {
            int tick = this.panel.getCursor();
            for (Replay replay : selectedReplays) {
                int randomOffset = (int)((double)n.intValue() * Math.random());
                for (Map.Entry entry : parsedKeyframes.entrySet()) {
                    String id = (String)entry.getKey();
                    UIKeyframes.PastedKeyframes pastedKeyframes = (UIKeyframes.PastedKeyframes)entry.getValue();
                    KeyframeChannel channel = (KeyframeChannel)replay.keyframes.get(id);
                    if (channel == null || pastedKeyframes.factory != null && channel.getFactory() != pastedKeyframes.factory) {
                        channel = replay.properties.getOrCreate((Form)replay.form.get(), id);
                    }
                    if (channel == null || pastedKeyframes.factory != null && channel.getFactory() != pastedKeyframes.factory) continue;
                    float min = 2.1474836E9f;
                    for (Keyframe kf : pastedKeyframes.keyframes) {
                        min = Math.min(kf.getTick(), min);
                    }
                    for (Keyframe kf : pastedKeyframes.keyframes) {
                        float finalTick = (float)tick + (kf.getTick() - min) + (float)randomOffset;
                        int index = channel.insert(finalTick, kf.getValue());
                        Keyframe inserted = channel.get(index);
                        inserted.copy(kf);
                        inserted.setTick(finalTick);
                    }
                    channel.sort();
                }
            }
        });
        UIOverlay.addOverlay(this.getContext(), offsetPanel);
    }

    private void processReplays() {
        UITextbox expression = new UITextbox(t -> {
            LAST_PROCESS = t;
        });
        UIStringList properties = new UIStringList(null);
        UIConfirmOverlayPanel panel = new UIConfirmOverlayPanel(UIKeys.SCENE_REPLAYS_CONTEXT_PROCESS_TITLE, UIKeys.SCENE_REPLAYS_CONTEXT_PROCESS_DESCRIPTION, b -> {
            if (b.booleanValue()) {
                int index;
                IExpression parse;
                MathBuilder builder = new MathBuilder();
                int min = Integer.MAX_VALUE;
                builder.register("i");
                builder.register("o");
                builder.register("v");
                builder.register("ki");
                try {
                    parse = builder.parse(expression.getText());
                }
                catch (Exception e) {
                    return;
                }
                LAST_PROCESS_PROPERTIES = new ArrayList(properties.getCurrent());
                Iterator iterator = this.current.iterator();
                while (iterator.hasNext()) {
                    index = (Integer)iterator.next();
                    min = Math.min(min, index);
                }
                iterator = this.current.iterator();
                while (iterator.hasNext()) {
                    index = (Integer)iterator.next();
                    Replay replay = (Replay)this.list.get(index);
                    builder.variables.get("i").set(index);
                    builder.variables.get("o").set(index - min);
                    for (String s : properties.getCurrent()) {
                        KeyframeChannel channel = (KeyframeChannel)replay.keyframes.get(s);
                        List keyframes = channel.getKeyframes();
                        for (int i = 0; i < keyframes.size(); ++i) {
                            Keyframe<Object> kf = keyframes.get(i);
                            builder.variables.get("v").set(kf.getFactory().getY(kf.getValue()));
                            builder.variables.get("ki").set(i);
                            kf.setValue(kf.getFactory().yToValue(parse.doubleValue()), true);
                        }
                    }
                }
            }
        });
        for (KeyframeChannel<?> channel : ((Replay)this.getCurrentFirst()).keyframes.getChannels()) {
            if (!KeyframeFactories.isNumeric(channel.getFactory())) continue;
            properties.add(channel.getId());
        }
        properties.background().multi().sort();
        properties.relative(expression).y(-5).w(1.0f).h(144).anchor(0.0f, 1.0f);
        if (!LAST_PROCESS_PROPERTIES.isEmpty()) {
            properties.setCurrentScroll(LAST_PROCESS_PROPERTIES.get(0));
        }
        for (String property : LAST_PROCESS_PROPERTIES) {
            properties.addIndex(properties.getList().indexOf(property));
        }
        expression.setText(LAST_PROCESS);
        expression.tooltip(UIKeys.SCENE_REPLAYS_CONTEXT_PROCESS_EXPRESSION_TOOLTIP);
        expression.relative(panel.confirm).y(-1.0f, -5).w(1.0f).h(20);
        panel.confirm.w(1.0f, -10);
        panel.content.add(expression, properties);
        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 240, 300);
    }

    private void offsetTimeReplays() {
        UITextbox tick = new UITextbox(t -> {
            LAST_OFFSET = t;
        });
        UIConfirmOverlayPanel panel = new UIConfirmOverlayPanel(UIKeys.SCENE_REPLAYS_CONTEXT_OFFSET_TIME_TITLE, UIKeys.SCENE_REPLAYS_CONTEXT_OFFSET_TIME_DESCRIPTION, b -> {
            if (b.booleanValue()) {
                int index;
                MathBuilder builder = new MathBuilder();
                int min = Integer.MAX_VALUE;
                builder.register("i");
                builder.register("o");
                IExpression parse = null;
                try {
                    parse = builder.parse(tick.getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Iterator iterator = this.current.iterator();
                while (iterator.hasNext()) {
                    index = (Integer)iterator.next();
                    min = Math.min(min, index);
                }
                iterator = this.current.iterator();
                while (iterator.hasNext()) {
                    index = (Integer)iterator.next();
                    Replay replay = (Replay)this.list.get(index);
                    builder.variables.get("i").set(index);
                    builder.variables.get("o").set(index - min);
                    float tickv = parse == null ? 0.0f : (float)parse.doubleValue();
                    BaseValue.edit(replay, r -> r.shift(tickv));
                }
            }
        });
        tick.setText(LAST_OFFSET);
        tick.tooltip(UIKeys.SCENE_REPLAYS_CONTEXT_OFFSET_TIME_EXPRESSION_TOOLTIP);
        tick.relative(panel.confirm).y(-1.0f, -5).w(1.0f).h(20);
        panel.confirm.w(1.0f, -10);
        panel.content.add((IUIElement)tick);
        UIOverlay.addOverlay(this.getContext(), panel);
    }

    private void copyReplay() {
        MapType replays = new MapType();
        ListType replayList = new ListType();
        replays.put("replays", replayList);
        for (Replay replay : this.getCurrent()) {
            replayList.add(replay.toData());
        }
        Window.setClipboard(replays, "_CopyReplay");
    }

    private void pasteReplay(MapType data) {
        Film film = (Film)this.panel.getData();
        ListType replays = data.getList("replays");
        Replay last = null;
        for (BaseType replayType : replays) {
            Replay replay = film.replays.addReplay();
            BaseValue.edit(replay, r -> r.fromData(replayType));
            last = replay;
        }
        if (last != null) {
            this.update();
            this.panel.replayEditor.setReplay(last);
            this.updateFilmEditor();
        }
    }

    public void openFormEditor(ValueForm form, boolean editing, Consumer<Form> consumer) {
        UIElement target = this.panel;
        if (this.getRoot() != null) {
            target = this.getParentContainer();
        }
        UIFormPalette palette = UIFormPalette.open(target, editing, (Form)form.get(), f -> {
            for (Replay replay : this.getCurrent()) {
                replay.form.set(FormUtils.copy(f));
            }
            this.updateFilmEditor();
            if (consumer != null) {
                consumer.accept((Form)f);
            } else {
                this.overlay.pickEdit.setForm((Form)f);
            }
        });
        palette.updatable();
    }

    private void addReplay() {
        class_638 world = class_310.method_1551().field_1687;
        Camera camera = this.panel.getCamera();
        class_3965 blockHitResult = RayTracing.rayTrace((class_1937)world, camera, 64.0);
        class_243 p = blockHitResult.method_17784();
        Vector3d position = new Vector3d(p.field_1352, p.field_1351, p.field_1350);
        if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
            position.set((Vector3fc)camera.getLookDirection()).mul(5.0).add((Vector3dc)camera.position);
        }
        this.addReplay(position, camera.rotation.x, camera.rotation.y + (float)Math.PI);
    }

    private void fromCamera(int duration) {
        Position position = new Position();
        Clips camera = ((Film)this.panel.getData()).camera;
        CameraClipContext context = new CameraClipContext();
        Film film = (Film)this.panel.getData();
        Replay replay = film.replays.addReplay();
        context.clips = camera;
        for (int i = 0; i < duration; ++i) {
            context.clipData.clear();
            context.setup(i, 0.0f);
            for (Clip clip : context.clips.getClips(i)) {
                context.apply(clip, position);
            }
            context.currentLayer = 0;
            float yaw = position.angle.yaw - 180.0f;
            replay.keyframes.x.insert(i, position.point.x);
            replay.keyframes.y.insert(i, position.point.y);
            replay.keyframes.z.insert(i, position.point.z);
            replay.keyframes.yaw.insert(i, Double.valueOf(yaw));
            replay.keyframes.headYaw.insert(i, Double.valueOf(yaw));
            replay.keyframes.bodyYaw.insert(i, Double.valueOf(yaw));
            replay.keyframes.pitch.insert(i, Double.valueOf(position.angle.pitch));
        }
        this.update();
        this.panel.replayEditor.setReplay(replay);
        this.updateFilmEditor();
        this.openFormEditor(replay.form, false, null);
    }

    private void fromModelBlock() {
        ArrayList<ModelBlockEntity> modelBlocks = new ArrayList<ModelBlockEntity>(BBSRendering.capturedModelBlocks);
        UISearchList<String> search = new UISearchList<String>(new UIStringList(null));
        UIList<String> list = search.list;
        UIConfirmOverlayPanel panel = new UIConfirmOverlayPanel(UIKeys.SCENE_REPLAYS_CONTEXT_FROM_MODEL_BLOCK_TITLE, UIKeys.SCENE_REPLAYS_CONTEXT_FROM_MODEL_BLOCK_DESCRIPTION, b -> {
            int index;
            ModelBlockEntity modelBlock;
            if (b.booleanValue() && (modelBlock = (ModelBlockEntity)((Object)((Object)CollectionUtils.getSafe(modelBlocks, index = list.getIndex())))) != null) {
                this.fromModelBlock(modelBlock);
            }
        });
        modelBlocks.sort(Comparator.comparing(ModelBlockEntity::getName));
        for (ModelBlockEntity modelBlock : modelBlocks) {
            list.add(modelBlock.getName());
        }
        list.background();
        search.relative(panel.confirm).y(-5).w(1.0f).h(164).anchor(0.0f, 1.0f);
        panel.confirm.w(1.0f, -10);
        panel.content.add((IUIElement)search);
        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 240, 300);
    }

    private void fromModelBlock(ModelBlockEntity modelBlock) {
        Film film = (Film)this.panel.getData();
        Replay replay = film.replays.addReplay();
        class_2338 blockPos = modelBlock.method_11016();
        ModelProperties properties = modelBlock.getProperties();
        Transform transform = properties.getTransform().copy();
        double x = (double)((float)blockPos.method_10263() + transform.translate.x) + 0.5;
        double y = (float)blockPos.method_10264() + transform.translate.y;
        double z = (double)((float)blockPos.method_10260() + transform.translate.z) + 0.5;
        transform.translate.set(0.0f, 0.0f, 0.0f);
        replay.shadow.set(properties.isShadow());
        replay.form.set(FormUtils.copy(properties.getForm()));
        replay.keyframes.x.insert(0.0f, x);
        replay.keyframes.y.insert(0.0f, y);
        replay.keyframes.z.insert(0.0f, z);
        if (!transform.isDefault()) {
            if (transform.rotate.x == 0.0f && transform.rotate.z == 0.0f && transform.rotate2.x == 0.0f && transform.rotate2.y == 0.0f && transform.rotate2.z == 0.0f && transform.scale.x == 1.0f && transform.scale.y == 1.0f && transform.scale.z == 1.0f) {
                double yaw = -Math.toDegrees(transform.rotate.y);
                replay.keyframes.yaw.insert(0.0f, yaw);
                replay.keyframes.headYaw.insert(0.0f, yaw);
                replay.keyframes.bodyYaw.insert(0.0f, yaw);
            } else {
                AnchorForm form = new AnchorForm();
                BodyPart part = new BodyPart("");
                part.setForm((Form)replay.form.get());
                form.transform.set(transform);
                form.parts.addBodyPart(part);
                replay.form.set(form);
            }
        }
        this.update();
        this.panel.replayEditor.setReplay(replay);
        this.updateFilmEditor();
    }

    public void addReplay(Vector3d position, float pitch, float yaw) {
        Film film = (Film)this.panel.getData();
        Replay replay = film.replays.addReplay();
        replay.keyframes.x.insert(0.0f, position.x);
        replay.keyframes.y.insert(0.0f, position.y);
        replay.keyframes.z.insert(0.0f, position.z);
        replay.keyframes.pitch.insert(0.0f, Double.valueOf(pitch));
        replay.keyframes.yaw.insert(0.0f, Double.valueOf(yaw));
        replay.keyframes.headYaw.insert(0.0f, Double.valueOf(yaw));
        replay.keyframes.bodyYaw.insert(0.0f, Double.valueOf(yaw));
        this.update();
        this.panel.replayEditor.setReplay(replay);
        this.updateFilmEditor();
        this.openFormEditor(replay.form, false, null);
    }

    private void updateFilmEditor() {
        this.panel.getController().createEntities();
        this.panel.replayEditor.updateChannelsList();
    }

    private void dupeReplay() {
        if (this.isDeselected()) {
            return;
        }
        Replay last = null;
        for (Replay replay : this.getCurrent()) {
            Film film = (Film)this.panel.getData();
            Replay newReplay = film.replays.addReplay();
            newReplay.copy(replay);
            last = newReplay;
        }
        if (last != null) {
            this.update();
            this.panel.replayEditor.setReplay(last);
            this.updateFilmEditor();
        }
    }

    private void removeReplay() {
        if (this.isDeselected()) {
            return;
        }
        Film film = (Film)this.panel.getData();
        int index = this.getIndex();
        for (Replay replay : this.getCurrent()) {
            film.replays.remove(replay);
        }
        int size = this.list.size();
        index = MathUtils.clamp(index, 0, size - 1);
        this.update();
        this.panel.replayEditor.setReplay(size == 0 ? null : (Replay)this.list.get(index));
        this.updateFilmEditor();
    }

    @Override
    public void renderList(UIContext context) {
        if (this.isFiltering() || !this.hasAnyGroup()) {
            super.renderList(context);
            return;
        }
        this.buildGroupedRows();
        int itemH = this.scroll.scrollItemSize;
        int start = Math.max(0, (int)(this.scroll.getScroll() / (double)itemH));
        int visible = Math.max(0, this.area.h / itemH + 2);
        int end = Math.min(this.groupedRows.size(), start + visible);
        int y = this.area.y - (int)(this.scroll.getScroll() % (double)itemH);
        for (int i = start; i < end; ++i) {
            boolean hover;
            Row row = this.groupedRows.get(i);
            int x = this.area.x;
            boolean bl = hover = this.area.isInside(context) && context.mouseY >= y && context.mouseY < y + itemH;
            if (row.header) {
                context.batcher.textCard(row.group, x + 26, y + 6);
                boolean expanded = this.expandedGroups.getOrDefault(row.group, true);
                context.batcher.icon(expanded ? Icons.MOVE_DOWN : Icons.MOVE_UP, x + 16, y + (expanded ? 5 : 4), 0.5f, 0.0f);
            } else {
                boolean selected;
                int indexInList = this.identityIndex(row.replay);
                boolean bl2 = selected = indexInList >= 0 && this.current.contains(indexInList);
                if (selected) {
                    context.batcher.box(x, y, x + this.area.w, y + itemH, 0x88000000 | (Integer)BBSSettings.primaryColor.get());
                }
                this.renderElementPart(context, row.replay, indexInList, x, y, hover, selected);
            }
            y += itemH;
        }
    }

    @Override
    public void render(UIContext context) {
        super.render(context);
        if (this.isGroupedDragging(context) && this.exists(this.groupedDragFrom)) {
            this.renderListElement(context, (Replay)this.list.get(this.groupedDragFrom), this.groupedDragFrom, context.mouseX + 6, context.mouseY - this.scroll.scrollItemSize / 2, true, true);
        }
    }

    @Override
    protected String elementToString(UIContext context, int i, Replay element) {
        String name = element.getName();
        return context.batcher.getFont().limitToWidth(name, this.area.w - 20);
    }

    @Override
    protected void renderElementPart(UIContext context, Replay element, int i, int x, int y, boolean hover, boolean selected) {
        if (((Boolean)element.enabled.get()).booleanValue()) {
            super.renderElementPart(context, element, i, x, y, hover, selected);
        } else {
            context.batcher.textShadow(this.elementToString(context, i, element), x + 4, y + (this.scroll.scrollItemSize - context.batcher.getFont().getHeight()) / 2, hover ? Colors.mulRGB(0xDDDDFF, 0.75f) : -7829368);
        }
        Form form = (Form)element.form.get();
        if (form != null) {
            context.batcher.clip(x += this.area.w - 30, y, 40, 20, context);
            FormUtilsClient.renderUI(form, context, x, y -= 10, x + 40, y + 40);
            context.batcher.unclip(context);
            if (((Boolean)element.fp.get()).booleanValue()) {
                context.batcher.outlinedIcon(Icons.ARROW_UP, x, y + 20, 0.5f, 0.5f);
            }
        }
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (!this.isFiltering() && this.hasAnyGroup() && this.area.isInside(context)) {
            if (context.mouseButton != 0) {
                return super.subMouseClicked(context);
            }
            int itemH = this.scroll.scrollItemSize;
            int localY = context.mouseY - this.area.y + (int)this.scroll.getScroll();
            int rowIndex = localY / itemH;
            this.buildGroupedRows();
            if (rowIndex >= 0 && rowIndex < this.groupedRows.size()) {
                int indexInList;
                Row row = this.groupedRows.get(rowIndex);
                if (row.header) {
                    boolean expanded = this.expandedGroups.getOrDefault(row.group, true);
                    this.expandedGroups.put(row.group, !expanded);
                    this.update();
                    return true;
                }
                if (row.replay != null && (indexInList = this.identityIndex(row.replay)) >= 0) {
                    if (Window.isCtrlPressed()) {
                        this.toggleIndex(indexInList);
                    } else if (this.multi && Window.isShiftPressed() && this.isSelected()) {
                        int first = (Integer)this.current.get(0);
                        int increment = first > indexInList ? -1 : 1;
                        for (int i = first + increment; i != indexInList + increment; i += increment) {
                            this.addIndex(i);
                        }
                    } else {
                        this.setIndex(indexInList);
                    }
                    if (this.callback != null) {
                        this.callback.accept(this.getCurrent());
                    }
                    if (this.sorting && this.current.size() == 1) {
                        this.groupedDragFrom = indexInList;
                        this.groupedDragTime = System.currentTimeMillis();
                        this.groupedDragStartX = context.mouseX;
                        this.groupedDragStartY = context.mouseY;
                        this.groupedDragHolding = true;
                    }
                    return true;
                }
            }
        }
        return super.subMouseClicked(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        if (!this.isFiltering() && this.hasAnyGroup() && this.sorting && this.isGroupedDragging(context)) {
            int itemH = this.scroll.scrollItemSize;
            int localY = context.mouseY - this.area.y + (int)this.scroll.getScroll();
            int rowIndex = localY / itemH;
            this.buildGroupedRows();
            int to = this.listIndexFromMouse(context);
            boolean changeGroup = false;
            String targetGroup = null;
            if (rowIndex >= 0 && rowIndex < this.groupedRows.size()) {
                Row targetRow = this.groupedRows.get(rowIndex);
                if (targetRow.header) {
                    targetGroup = EMPTY_GROUP_LABEL.equals(targetRow.group) ? "" : targetRow.group;
                    changeGroup = true;
                    to = this.lastIndexOfGroup(targetRow.group);
                } else if (targetRow.replay != null) {
                    targetGroup = EMPTY_GROUP_LABEL.equals(targetRow.group) ? "" : targetRow.group;
                    changeGroup = true;
                    to = this.identityIndex(targetRow.replay);
                }
            }
            if (to == -2) {
                to = this.getList().size() - 1;
            } else if (to == -1) {
                to = 0;
            }
            if (changeGroup && this.groupedDragFrom >= 0 && this.groupedDragFrom < this.list.size()) {
                Replay moved = (Replay)this.list.get(this.groupedDragFrom);
                String currentGroup = (String)moved.group.get();
                String string = currentGroup = currentGroup == null ? "" : currentGroup;
                if (targetGroup != null && !currentGroup.equals(targetGroup)) {
                    moved.group.set(targetGroup);
                }
            }
            if (to >= 0 && to < this.getList().size() && to != this.groupedDragFrom) {
                this.handleSwap(this.groupedDragFrom, to);
            }
            this.groupedDragFrom = -1;
            this.groupedDragHolding = false;
            return true;
        }
        this.groupedDragHolding = false;
        this.groupedDragFrom = -1;
        return super.subMouseReleased(context);
    }

    private int listIndexFromMouse(UIContext context) {
        int itemH = this.scroll.scrollItemSize;
        int localY = context.mouseY - this.area.y + (int)this.scroll.getScroll();
        int rowIndex = localY / itemH;
        if (rowIndex < 0) {
            return -1;
        }
        this.buildGroupedRows();
        if (rowIndex >= this.groupedRows.size()) {
            return -2;
        }
        Row row = this.groupedRows.get(rowIndex);
        if (row.replay != null) {
            return this.identityIndex(row.replay);
        }
        return this.firstIndexOfGroup(row.group);
    }

    private int identityIndex(Replay r) {
        if (r == null) {
            return -1;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i) != r) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setCurrentScroll(Replay element) {
        this.setCurrent(element);
        if (!this.current.isEmpty()) {
            this.scroll.setScroll((Integer)this.current.get(0) * this.scroll.scrollItemSize);
        }
    }

    @Override
    public void setCurrent(Replay element) {
        this.current.clear();
        int index = this.identityIndex(element);
        if (this.exists(index)) {
            this.current.add(index);
        }
    }

    @Override
    public void setCurrent(List<Replay> elements) {
        this.current.clear();
        if (elements == null || elements.isEmpty()) {
            return;
        }
        for (Replay r : elements) {
            int idx = this.identityIndex(r);
            if (!this.exists(idx)) continue;
            this.current.add(idx);
        }
    }

    private int lastIndexOfGroup(String group) {
        int last = -1;
        for (int i = 0; i < this.list.size(); ++i) {
            Replay r = (Replay)this.list.get(i);
            String g = (String)r.group.get();
            if (g == null || !g.equals(group)) continue;
            last = i;
        }
        return last == -1 ? this.list.size() - 1 : last;
    }

    private int firstIndexOfGroup(String group) {
        for (int i = 0; i < this.list.size(); ++i) {
            Replay r = (Replay)this.list.get(i);
            String g = (String)r.group.get();
            if (g == null || !g.equals(group)) continue;
            return i;
        }
        return 0;
    }

    private boolean isGroupedDragging(UIContext context) {
        if (this.groupedDragFrom < 0 || !this.groupedDragHolding) {
            return false;
        }
        long elapsed = System.currentTimeMillis() - this.groupedDragTime;
        int dx = Math.abs(context.mouseX - this.groupedDragStartX);
        int dy = Math.abs(context.mouseY - this.groupedDragStartY);
        return elapsed >= 150L && (dx >= 3 || dy >= 3);
    }

    private void buildGroupedRows() {
        this.groupedRows.clear();
        HashMap<String, List> byGroup = new HashMap<String, List>();
        for (Object r : this.list) {
            String g = (String)((Replay)r).group.get();
            String key = g == null || g.isEmpty() ? EMPTY_GROUP_LABEL : g;
            byGroup.computeIfAbsent(key, k -> new ArrayList()).add(r);
            this.expandedGroups.putIfAbsent(key, true);
        }
        ArrayList groups = new ArrayList(byGroup.keySet());
        groups.sort(String::compareToIgnoreCase);
        for (String g : groups) {
            this.groupedRows.add(new Row(g, true, null));
            if (!this.expandedGroups.getOrDefault(g, true).booleanValue()) continue;
            for (Replay r : (List)byGroup.get(g)) {
                this.groupedRows.add(new Row(g, false, r));
            }
        }
        int total = this.groupedRows.size();
        this.scroll.setSize(total);
    }

    @Override
    public void update() {
        super.update();
        if (!this.isFiltering() && this.hasAnyGroup()) {
            this.buildGroupedRows();
            this.scroll.setSize(this.groupedRows.size());
            this.scroll.clamp();
        }
    }

    private boolean hasAnyGroup() {
        for (Replay r : this.list) {
            String g = (String)r.group.get();
            if (g == null || g.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private List<String> collectGroups() {
        ArrayList<String> groups = new ArrayList<String>();
        if (this.panel == null || this.panel.getData() == null) {
            return groups;
        }
        Replays replays = ((Film)this.panel.getData()).replays;
        if (replays == null) {
            return groups;
        }
        List list = replays.getList();
        for (Replay r : list) {
            String g = (String)r.group.get();
            if (g == null || g.isEmpty() || groups.contains(g)) continue;
            groups.add(g);
        }
        groups.sort(String::compareToIgnoreCase);
        return groups;
    }

    private void openGroupPickerPanel(IKey title, Consumer<String> callback) {
        List<String> groups = this.collectGroups();
        UISearchList<String> search = new UISearchList<String>(new UIStringList(null));
        UIList<String> list = search.list;
        UIConfirmOverlayPanel panel = new UIConfirmOverlayPanel(title, UIKeys.SCENE_REPLAYS_GROUP_PICK_DESCRIPTION, b -> {
            int index;
            String g;
            if (b.booleanValue() && (g = (String)CollectionUtils.getSafe(groups, index = list.getIndex())) != null) {
                callback.accept(g);
            }
        });
        for (String g : groups) {
            list.add(g);
        }
        list.background();
        search.relative(panel.confirm).y(-5).w(1.0f).h(164).anchor(0.0f, 1.0f);
        panel.confirm.w(1.0f, -10);
        panel.content.add((IUIElement)search);
        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 240, 300);
    }

    private void renameGroup(String oldName, String newName) {
        if (oldName == null || oldName.isEmpty()) {
            return;
        }
        if (this.panel == null || this.panel.getData() == null || ((Film)this.panel.getData()).replays == null) {
            return;
        }
        List list = ((Film)this.panel.getData()).replays.getList();
        for (Replay r : list) {
            if (!oldName.equals(r.group.get())) continue;
            r.group.set(newName == null ? "" : newName);
        }
        this.update();
    }

    private void deleteGroupOnly(String group) {
        if (group == null || group.isEmpty()) {
            return;
        }
        if (this.panel == null || this.panel.getData() == null || ((Film)this.panel.getData()).replays == null) {
            return;
        }
        List list = ((Film)this.panel.getData()).replays.getList();
        for (Replay r : list) {
            if (!group.equals(r.group.get())) continue;
            r.group.set("");
        }
        this.update();
    }

    private void deleteGroupWithReplays(String group) {
        if (group == null || group.isEmpty()) {
            return;
        }
        if (this.panel == null || this.panel.getData() == null || ((Film)this.panel.getData()).replays == null) {
            return;
        }
        Film film = (Film)this.panel.getData();
        ArrayList list = new ArrayList(film.replays.getList());
        for (Replay r : list) {
            if (!group.equals(r.group.get())) continue;
            film.replays.remove(r);
        }
        this.update();
        this.panel.replayEditor.updateChannelsList();
    }

    @Environment(value=EnvType.CLIENT)
    private static class Row {
        final boolean header;
        final String group;
        final Replay replay;

        Row(String group, boolean header, Replay replay) {
            this.group = group;
            this.header = header;
            this.replay = replay;
        }
    }
}

