/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.replays;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.audio.SoundBuffer;
import mchorse.bbs_mod.audio.Waveform;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.camera.CameraUtils;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.camera.utils.TimeUtils;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.data.animation.Animation;
import mchorse.bbs_mod.cubic.data.animation.AnimationPart;
import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.film.replays.ReplayKeyframes;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.ModelForm;
import mchorse.bbs_mod.forms.forms.StructureForm;
import mchorse.bbs_mod.forms.renderers.ModelFormRenderer;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.molang.expressions.MolangExpression;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIClipsPanel;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.clips.renderer.IUIClipRenderer;
import mchorse.bbs_mod.ui.film.replays.UIReplaysEditorUtils;
import mchorse.bbs_mod.ui.film.replays.overlays.UIAnimationToPoseOverlayPanel;
import mchorse.bbs_mod.ui.film.replays.overlays.UIKeyframeSheetFilterOverlayPanel;
import mchorse.bbs_mod.ui.film.replays.overlays.UIReplaysOverlayPanel;
import mchorse.bbs_mod.ui.film.utils.keyframes.UIFilmKeyframes;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeEditor;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIPoseKeyframeFactory;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.graphs.UIKeyframeDopeSheet;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIPromptOverlayPanel;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.Gizmo;
import mchorse.bbs_mod.ui.utils.Scale;
import mchorse.bbs_mod.ui.utils.StencilFormFramebuffer;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icon;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.CollectionUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.PlayerUtils;
import mchorse.bbs_mod.utils.RayTracing;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Vector3d;

@Environment(value=EnvType.CLIENT)
public class UIReplaysEditor
extends UIElement {
    private static final Map<String, Integer> COLORS = new HashMap<String, Integer>();
    private static final Map<String, Icon> ICONS = new HashMap<String, Icon>();
    private static String lastFilm = "";
    private static int lastReplay;
    public UIReplaysOverlayPanel replays;
    public UIKeyframeEditor keyframeEditor;
    private UIFilmPanel filmPanel;
    private Film film;
    private Replay replay;
    private Set<String> keys = new LinkedHashSet<String>();

    public static Icon getIcon(String key) {
        String topLevel = StringUtils.fileName(key);
        return ICONS.getOrDefault(topLevel, Icons.NONE);
    }

    public static int getColor(String key) {
        String topLevel = StringUtils.fileName(key);
        if (topLevel.startsWith("pose_overlay")) {
            return COLORS.get("pose_overlay");
        }
        if (topLevel.startsWith("transform_overlay")) {
            return COLORS.get("transform_overlay");
        }
        return COLORS.getOrDefault(topLevel, 35071);
    }

    public static void offerAdjacent(UIContext context, Form form, String bone, Consumer<String> consumer) {
        if (!bone.isEmpty() && form instanceof ModelForm) {
            ModelForm modelForm = (ModelForm)form;
            ModelInstance model = ModelFormRenderer.getModel(modelForm);
            if (model == null) {
                return;
            }
            context.replaceContextMenu(menu -> {
                for (String modelGroup : model.model.getAdjacentGroups(bone)) {
                    menu.action(Icons.LIMB, IKey.constant(modelGroup), () -> consumer.accept(modelGroup));
                }
                menu.autoKeys();
            });
        }
    }

    public static void offerHierarchy(UIContext context, Form form, String bone, Consumer<String> consumer) {
        if (!bone.isEmpty() && form instanceof ModelForm) {
            ModelForm modelForm = (ModelForm)form;
            ModelInstance model = ModelFormRenderer.getModel(modelForm);
            if (model == null) {
                return;
            }
            context.replaceContextMenu(menu -> {
                for (String modelGroup : model.model.getHierarchyGroups(bone)) {
                    menu.action(Icons.LIMB, IKey.constant(modelGroup), () -> consumer.accept(modelGroup));
                }
                menu.autoKeys();
            });
        }
    }

    public static boolean renderBackground(UIContext context, UIKeyframes keyframes, Clips camera, int clipOffset) {
        if (!((Boolean)BBSSettings.audioWaveformVisible.get()).booleanValue()) {
            return false;
        }
        Scale scale = keyframes.getXAxis();
        boolean renderedOnce = false;
        for (Clip clip : camera.get()) {
            Waveform wave;
            SoundBuffer buffer;
            if (!(clip instanceof AudioClip)) continue;
            AudioClip audioClip = (AudioClip)clip;
            Link link = (Link)audioClip.audio.get();
            if (link == null || (buffer = BBSModClient.getSounds().get(link, true)) == null || buffer.getWaveform() == null || (wave = buffer.getWaveform()) == null) continue;
            int audioOffset = (Integer)audioClip.offset.get();
            float offset = (Integer)audioClip.tick.get() - clipOffset;
            int duration = Math.min((int)(wave.getDuration() * 20.0f), (Integer)clip.duration.get());
            int x1 = (int)scale.to(offset);
            int x2 = (int)scale.to(offset + (float)duration);
            wave.render(context.batcher, -1, x1, keyframes.area.y + 15, x2 - x1, 20, TimeUtils.toSeconds(audioOffset), TimeUtils.toSeconds(audioOffset + duration));
            renderedOnce = true;
        }
        return renderedOnce;
    }

    public UIReplaysEditor(UIFilmPanel filmPanel) {
        this.filmPanel = filmPanel;
        this.replays = new UIReplaysOverlayPanel(filmPanel, replay -> this.setReplay((Replay)replay, false, true));
        this.markContainer();
    }

    public void setFilm(Film film) {
        this.film = film;
        if (film != null) {
            int index;
            List replays = film.replays.getList();
            int n = index = film.getId().equals(lastFilm) ? lastReplay : 0;
            if (!CollectionUtils.inRange(replays, index)) {
                index = 0;
            }
            this.replays.replays.setList(replays);
            this.setReplay(replays.isEmpty() ? null : (Replay)replays.get(index));
        }
    }

    public Replay getReplay() {
        return this.replay;
    }

    public void setReplay(Replay replay) {
        this.setReplay(replay, true, true);
    }

    public void setReplay(Replay replay, boolean select, boolean resetOrbit) {
        this.replay = replay;
        if (resetOrbit) {
            this.filmPanel.getController().orbit.reset();
        }
        this.replays.setReplay(replay);
        this.filmPanel.actionEditor.setClips(replay == null ? null : replay.actions);
        this.updateChannelsList();
        if (select) {
            this.replays.replays.setCurrentScroll(replay);
        }
    }

    public void moveReplay(double x, double y, double z) {
        if (this.replay != null) {
            int cursor = this.filmPanel.getCursor();
            this.replay.keyframes.x.insert(cursor, x);
            this.replay.keyframes.y.insert(cursor, y);
            this.replay.keyframes.z.insert(cursor, z);
        }
    }

    public void updateChannelsList() {
        Object sheet;
        String customTitle;
        UIKeyframes lastEditor = null;
        if (this.keyframeEditor != null) {
            this.keyframeEditor.removeFromParent();
            lastEditor = this.keyframeEditor.view;
        }
        if (this.replay == null) {
            return;
        }
        ArrayList<UIKeyframeSheet> sheets = new ArrayList<UIKeyframeSheet>();
        for (String key : ReplayKeyframes.CURATED_CHANNELS) {
            BaseValue value = this.replay.keyframes.get(key);
            KeyframeChannel channel = (KeyframeChannel)value;
            customTitle = this.replay.getCustomSheetTitle(key);
            Object object = sheet = customTitle != null && !customTitle.isEmpty() ? new UIKeyframeSheet(key, IKey.constant(customTitle), UIReplaysEditor.getColor(key), false, channel, null) : new UIKeyframeSheet(UIReplaysEditor.getColor(key), false, channel, null);
            if (customTitle != null && !customTitle.isEmpty() && channel.getFactory() == KeyframeFactories.POSE) {
                ((UIKeyframeSheet)sheet).anchoredBone = customTitle;
            }
            sheets.add(((UIKeyframeSheet)sheet).icon(ICONS.get(key)));
        }
        for (String key : FormUtils.collectPropertyPaths((Form)this.replay.form.get())) {
            KeyframeChannel property;
            if (key.endsWith("tint_block_entities") || (property = this.replay.properties.getOrCreate((Form)this.replay.form.get(), key)) == null) continue;
            BaseValueBasic formProperty = FormUtils.getProperty((Form)this.replay.form.get(), key);
            customTitle = this.replay.getCustomSheetTitle(key);
            Object object = sheet = customTitle != null && !customTitle.isEmpty() ? new UIKeyframeSheet(key, IKey.constant(customTitle), UIReplaysEditor.getColor(key), false, property, formProperty) : new UIKeyframeSheet(UIReplaysEditor.getColor(key), false, property, formProperty);
            if (customTitle != null && !customTitle.isEmpty() && property.getFactory() == KeyframeFactories.POSE) {
                ((UIKeyframeSheet)sheet).anchoredBone = customTitle;
            }
            sheets.add(((UIKeyframeSheet)sheet).icon(UIReplaysEditor.getIcon(key)));
        }
        HashMap<Object, List> groupIndices = new HashMap<Object, List>();
        HashMap<Object, List> groupSheets = new HashMap<Object, List>();
        for (int i = 0; i < sheets.size(); ++i) {
            Form form;
            UIKeyframeSheet sheet2 = (UIKeyframeSheet)sheets.get(i);
            Form form2 = form = sheet2.property == null ? null : FormUtils.getForm(sheet2.property);
            if (!(form instanceof StructureForm)) continue;
            groupIndices.computeIfAbsent(form, k -> new ArrayList()).add(i);
            groupSheets.computeIfAbsent(form, k -> new ArrayList()).add(sheet2);
        }
        if (!groupSheets.isEmpty()) {
            HashMap<String, Integer> nonTransformOrder = new HashMap<String, Integer>();
            nonTransformOrder.put("anchor", 0);
            nonTransformOrder.put("structure_file", 1);
            nonTransformOrder.put("pivot", 2);
            nonTransformOrder.put("biome_id", 3);
            nonTransformOrder.put("structure_light", 4);
            nonTransformOrder.put("color", 5);
            HashMap<String, Integer> topOrder = new HashMap<String, Integer>();
            topOrder.put("visible", 0);
            topOrder.put("lighting", 1);
            Function<String, Integer> toIndex = id -> {
                Integer v = (Integer)nonTransformOrder.get(id);
                return v == null ? 1000 : v;
            };
            for (Map.Entry entry : groupSheets.entrySet()) {
                Object s22;
                Object form = entry.getKey();
                List group = (List)entry.getValue();
                List indices = (List)groupIndices.get(form);
                if (indices == null || indices.isEmpty()) continue;
                ArrayList<UIKeyframeSheet> top = new ArrayList<UIKeyframeSheet>();
                ArrayList<UIKeyframeSheet> transforms = new ArrayList<UIKeyframeSheet>();
                ArrayList<Object> overlays = new ArrayList<Object>();
                ArrayList<UIKeyframeSheet> nonTransforms = new ArrayList<UIKeyframeSheet>();
                for (Object s22 : group) {
                    if ("visible".equals(((UIKeyframeSheet)s22).id) || "lighting".equals(((UIKeyframeSheet)s22).id)) {
                        top.add((UIKeyframeSheet)s22);
                        continue;
                    }
                    if ("transform".equals(((UIKeyframeSheet)s22).id)) {
                        transforms.add((UIKeyframeSheet)s22);
                        continue;
                    }
                    if (((UIKeyframeSheet)s22).id != null && ((UIKeyframeSheet)s22).id.startsWith("transform_overlay")) {
                        overlays.add(s22);
                        continue;
                    }
                    nonTransforms.add((UIKeyframeSheet)s22);
                }
                top.sort((a, b) -> Integer.compare(topOrder.getOrDefault(a.id, 1000), topOrder.getOrDefault(b.id, 1000)));
                overlays.sort((a, b) -> {
                    ToIntFunction<String> parseIndex = id -> {
                        String suffix = id.substring("transform_overlay".length());
                        if (suffix.isEmpty()) {
                            return -1;
                        }
                        try {
                            return Integer.parseInt(suffix);
                        }
                        catch (Exception e) {
                            return 999;
                        }
                    };
                    return Integer.compare(parseIndex.applyAsInt(a.id), parseIndex.applyAsInt(b.id));
                });
                nonTransforms.sort((a, b) -> Integer.compare((Integer)toIndex.apply(a.id), (Integer)toIndex.apply(b.id)));
                int start = (Integer)indices.stream().min(Integer::compareTo).get();
                indices.sort(Collections.reverseOrder());
                s22 = indices.iterator();
                while (s22.hasNext()) {
                    int idx = (Integer)s22.next();
                    sheets.remove(idx);
                }
                ArrayList<Object> newGroup = new ArrayList<Object>();
                newGroup.addAll(top);
                newGroup.addAll(transforms);
                newGroup.addAll(overlays);
                newGroup.addAll(nonTransforms);
                for (int j = 0; j < newGroup.size(); ++j) {
                    sheets.add(start + j, (UIKeyframeSheet)newGroup.get(j));
                }
            }
        }
        this.keys.clear();
        for (UIKeyframeSheet sheet2 : sheets) {
            this.keys.add(StringUtils.fileName(sheet2.id));
        }
        sheets.removeIf(v -> {
            for (String s : (Set)BBSSettings.disabledSheets.get()) {
                if (!v.id.equals(s) && !v.id.endsWith("/" + s)) continue;
                return true;
            }
            return false;
        });
        Form lastForm = null;
        for (UIKeyframeSheet sheet3 : sheets) {
            Form form;
            Form form3 = form = sheet3.property == null ? null : FormUtils.getForm(sheet3.property);
            if (!Objects.equals(lastForm, form)) {
                sheet3.separator = true;
            }
            lastForm = form;
        }
        if (!sheets.isEmpty()) {
            this.keyframeEditor = new UIKeyframeEditor(consumer -> new UIFilmKeyframes(this.filmPanel.cameraEditor, (Consumer<Keyframe>)consumer).absolute()).target(this.filmPanel.editArea);
            this.keyframeEditor.full(this);
            this.keyframeEditor.setUndoId("replay_keyframe_editor");
            if (lastEditor != null) {
                this.keyframeEditor.view.copyViewport(lastEditor);
            }
            this.keyframeEditor.view.backgroundRenderer(context -> {
                UIKeyframes view = this.keyframeEditor.view;
                boolean yes = UIReplaysEditor.renderBackground(context, view, this.film.camera, 0);
                int shift = yes ? 35 : 15;
                UIClipsPanel cameraEditor = this.filmPanel.cameraEditor;
                Clip clip = cameraEditor.getClip();
                if (clip != null && ((Boolean)BBSSettings.editorClipPreview.get()).booleanValue()) {
                    IUIClipRenderer<Clip> renderer = cameraEditor.clips.getRenderers().get(clip);
                    Scale scale = view.getXAxis();
                    Area area = new Area();
                    float offset = ((Integer)clip.tick.get()).intValue();
                    int duration = (Integer)clip.duration.get();
                    int x1 = (int)scale.to(offset);
                    int x2 = (int)scale.to(offset + (float)duration);
                    area.setPoints(x1, view.area.y + shift, x2, view.area.y + shift + 20);
                    renderer.renderClip((UIContext)context, cameraEditor.clips, clip, area, true, true);
                }
            });
            this.keyframeEditor.view.duration(() -> this.film.camera.calculateDuration());
            this.keyframeEditor.view.context((ContextMenuManager menu) -> {
                Object patt0$temp = this.replay.form.get();
                if (patt0$temp instanceof ModelForm) {
                    ModelForm modelForm = (ModelForm)patt0$temp;
                    int mouseY = this.getContext().mouseY;
                    UIKeyframeSheet sheet = this.keyframeEditor.view.getGraph().getSheet(mouseY);
                    if (sheet != null && sheet.channel.getFactory() == KeyframeFactories.POSE && sheet.id.equals("pose")) {
                        menu.action(Icons.POSE, UIKeys.FILM_REPLAY_CONTEXT_ANIMATION_TO_KEYFRAMES, () -> this.animationToPoses(modelForm, sheet));
                    }
                }
                int mouseY2 = this.getContext().mouseY;
                UIKeyframeSheet clickedSheet = this.keyframeEditor.view.getGraph().getSheet(mouseY2);
                if (clickedSheet != null) {
                    menu.action(Icons.FONT, UIKeys.FILM_REPLAY_RENAME_SHEET, () -> {
                        UIPromptOverlayPanel panel = new UIPromptOverlayPanel(UIKeys.FILM_REPLAY_RENAME_SHEET_TITLE, UIKeys.FILM_REPLAY_RENAME_SHEET_MESSAGE, str -> {
                            this.replay.setCustomSheetTitle(clickedSheet.id, (String)str);
                            this.updateChannelsList();
                        });
                        panel.text.setText(clickedSheet.title.get());
                        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 300, 0.25f);
                    });
                }
                if (this.keyframeEditor.view.getGraph() instanceof UIKeyframeDopeSheet) {
                    menu.action(Icons.FILTER, UIKeys.FILM_REPLAY_FILTER_SHEETS, () -> {
                        UIKeyframeSheetFilterOverlayPanel panel = new UIKeyframeSheetFilterOverlayPanel((Set)BBSSettings.disabledSheets.get(), this.keys);
                        UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)panel, 240, 0.9f);
                        panel.onClose(e -> {
                            this.updateChannelsList();
                            BBSSettings.disabledSheets.set((Set)BBSSettings.disabledSheets.get());
                        });
                    });
                }
            });
            for (UIKeyframeSheet sheet3 : sheets) {
                this.keyframeEditor.view.addSheet(sheet3);
            }
            this.add((IUIElement)this.keyframeEditor);
        }
        this.resize();
        if (this.keyframeEditor != null && lastEditor == null) {
            this.keyframeEditor.view.resetView();
        }
    }

    private void animationToPoses(ModelForm modelForm, UIKeyframeSheet sheet) {
        ModelInstance model = ModelFormRenderer.getModel(modelForm);
        if (model != null) {
            UIAnimationToPoseOverlayPanel.IUIAnimationPoseCallback cb = (animationKey, onlyKeyframes, length, step) -> this.animationToPoseKeyframes(modelForm, sheet, animationKey, onlyKeyframes, length, step);
            UIOverlay.addOverlay(this.getContext(), (UIOverlayPanel)new UIAnimationToPoseOverlayPanel(cb, modelForm, sheet), 200, 197);
        }
    }

    public void animationToPoseKeyframes(ModelForm modelForm, UIKeyframeSheet sheet, String animationKey, boolean onlyKeyframes, int length, int step) {
        ModelInstance model = ModelFormRenderer.getModel(modelForm);
        Animation animation = model.animations.get(animationKey);
        if (animation != null) {
            int current = this.filmPanel.getCursor();
            IEntity entity = this.filmPanel.getController().getCurrentEntity();
            this.keyframeEditor.view.getDopeSheet().clearSelection();
            if (onlyKeyframes) {
                List<Float> list = this.getTicks(animation);
                for (float i : list) {
                    this.fillAnimationPose(sheet, i, model, entity, animation, current);
                }
            } else {
                for (int i = 0; i < length; i += step) {
                    this.fillAnimationPose(sheet, i, model, entity, animation, current);
                }
            }
            this.keyframeEditor.view.getDopeSheet().pickSelected();
        }
    }

    private List<Float> getTicks(Animation animation) {
        HashSet<Float> integers = new HashSet<Float>();
        for (AnimationPart value : animation.parts.values()) {
            for (KeyframeChannel<MolangExpression> channel : value.channels) {
                for (Keyframe<MolangExpression> keyframe : channel.getKeyframes()) {
                    integers.add(Float.valueOf(keyframe.getTick()));
                }
            }
        }
        ArrayList<Float> ticks = new ArrayList<Float>(integers);
        Collections.sort(ticks);
        return ticks;
    }

    private void fillAnimationPose(UIKeyframeSheet sheet, float i, ModelInstance model, IEntity entity, Animation animation, int current) {
        model.model.resetPose();
        model.model.apply(entity, animation, i, 1.0f, 0.0f, false);
        int insert = sheet.channel.insert((float)current + i, model.model.createPose());
        sheet.selection.add(insert);
    }

    public void pickForm(Form form, String bone) {
        String id;
        int index;
        String path = FormUtils.getPath(form);
        if (this.keyframeEditor == null || bone.isEmpty()) {
            return;
        }
        Keyframe selected = this.keyframeEditor.view.getGraph().getSelected();
        String type = "pose";
        if (selected != null && (index = (id = selected.getParent().getId()).indexOf("pose_overlay")) >= 0) {
            type = id.substring(index);
        }
        this.pickProperty(bone, StringUtils.combinePaths(path, type), false);
    }

    public void pickFormProperty(Form form, String bone) {
        String path = FormUtils.getPath(form);
        boolean shift = Window.isShiftPressed();
        ContextMenuManager manager = new ContextMenuManager();
        manager.autoKeys();
        for (BaseValueBasic formProperty : form.getAllMap().values()) {
            if (!formProperty.isVisible()) continue;
            manager.action(UIReplaysEditor.getIcon(formProperty.getId()), IKey.constant(formProperty.getId()), () -> this.pickProperty(bone, StringUtils.combinePaths(path, formProperty.getId()), shift));
        }
        this.getContext().replaceContextMenu(manager.create());
    }

    private void pickProperty(String bone, String key, boolean insert) {
        if (bone != null && !bone.isEmpty() && ((Boolean)BBSSettings.boneAnchoringEnabled.get()).booleanValue() && !((Boolean)BBSSettings.anchorOverrideEnabled.get()).booleanValue()) {
            for (UIKeyframeSheet s : this.keyframeEditor.view.getGraph().getSheets()) {
                if (s.anchoredBone == null || !s.anchoredBone.equals(bone)) continue;
                this.pickProperty(bone, s, insert);
                return;
            }
        }
        for (UIKeyframeSheet sheet : this.keyframeEditor.view.getGraph().getSheets()) {
            BaseValueBasic property = sheet.property;
            if (property == null || !FormUtils.getPropertyPath(property).equals(key)) continue;
            this.pickProperty(bone, sheet, insert);
            break;
        }
    }

    private void pickProperty(String bone, UIKeyframeSheet sheet, boolean insert) {
        int tick = this.filmPanel.getRunner().ticks;
        if (insert) {
            Keyframe keyframe = this.keyframeEditor.view.getGraph().addKeyframe(sheet, tick, null);
            this.keyframeEditor.view.getGraph().selectKeyframe(keyframe);
            return;
        }
        KeyframeSegment segment = sheet.channel.find(tick);
        if (segment != null) {
            UIKeyframeFactory uIKeyframeFactory;
            Keyframe closest = segment.getClosest();
            if (this.keyframeEditor.view.getGraph().getSelected() != closest) {
                this.keyframeEditor.view.getGraph().selectKeyframe(closest);
            }
            if ((uIKeyframeFactory = this.keyframeEditor.editor) instanceof UIPoseKeyframeFactory) {
                UIPoseKeyframeFactory poseFactory = (UIPoseKeyframeFactory)uIKeyframeFactory;
                String targetBone = bone;
                if (((Boolean)BBSSettings.boneAnchoringEnabled.get()).booleanValue() && sheet.anchoredBone != null) {
                    targetBone = sheet.anchoredBone;
                }
                poseFactory.poseEditor.selectBone(targetBone);
            }
            this.filmPanel.setCursor((int)closest.getTick());
        }
    }

    public boolean clickViewport(UIContext context, Area area) {
        if (this.filmPanel.isFlying()) {
            return false;
        }
        StencilFormFramebuffer stencil = this.filmPanel.getController().getStencil();
        if (stencil.hasPicked()) {
            Pair<Form, String> pair = stencil.getPicked();
            if (pair != null && context.mouseButton < 2) {
                if (!this.isVisible()) {
                    this.filmPanel.showPanel(this);
                }
                if (Gizmo.INSTANCE.start(stencil.getIndex(), context.mouseX, context.mouseY, UIReplaysEditorUtils.getEditableTransform(this.keyframeEditor))) {
                    return true;
                }
                if (context.mouseButton == 0) {
                    if (Window.isCtrlPressed()) {
                        UIReplaysEditor.offerAdjacent(this.getContext(), (Form)pair.a, (String)pair.b, bone -> this.pickForm((Form)pair.a, (String)bone));
                    } else if (Window.isShiftPressed()) {
                        UIReplaysEditor.offerHierarchy(this.getContext(), (Form)pair.a, (String)pair.b, bone -> this.pickForm((Form)pair.a, (String)bone));
                    } else {
                        this.pickForm((Form)pair.a, (String)pair.b);
                    }
                    return true;
                }
                if (context.mouseButton == 1) {
                    this.pickFormProperty((Form)pair.a, (String)pair.b);
                    return true;
                }
            }
        } else if (context.mouseButton == 1 && this.isVisible()) {
            class_638 world = class_310.method_1551().field_1687;
            Camera camera = this.filmPanel.getCamera();
            class_3965 blockHitResult = RayTracing.rayTrace((class_1937)world, RayTracing.fromVector3d(camera.position), RayTracing.fromVector3f(CameraUtils.getMouseDirection(camera.projection, camera.view, context.mouseX, context.mouseY, area.x, area.y, area.w, area.h)), 256.0);
            if (blockHitResult.method_17783() != class_239.class_240.field_1333) {
                Vector3d vec = new Vector3d(blockHitResult.method_17784().field_1352, blockHitResult.method_17784().field_1351, blockHitResult.method_17784().field_1350);
                if (Window.isShiftPressed()) {
                    vec = new Vector3d(Math.floor(vec.x) + 0.5, (double)Math.round(vec.y), Math.floor(vec.z) + 0.5);
                }
                Vector3d finalVec = vec;
                context.replaceContextMenu(menu -> {
                    float pitch = 0.0f;
                    float yaw = MathUtils.toDeg(camera.rotation.y);
                    menu.action(Icons.ADD, UIKeys.FILM_REPLAY_CONTEXT_ADD, () -> this.replays.replays.addReplay(finalVec, pitch, yaw));
                    menu.action(Icons.POINTER, UIKeys.FILM_REPLAY_CONTEXT_MOVE_HERE, () -> this.moveReplay(finalVec.x, finalVec.y, finalVec.z));
                });
                return true;
            }
        }
        if (area.isInside(context) && this.filmPanel.getController().orbit.enabled) {
            this.filmPanel.getController().orbit.start(context);
            return true;
        }
        return false;
    }

    public void close() {
        if (this.film != null) {
            lastFilm = this.film.getId();
            lastReplay = this.replays.replays.getIndex();
        }
    }

    public void teleport() {
        if (this.filmPanel.getData() == null) {
            return;
        }
        Replay replay = this.getReplay();
        if (replay != null) {
            int tick = this.filmPanel.getCursor();
            double x = replay.keyframes.x.interpolate(tick);
            double y = replay.keyframes.y.interpolate(tick);
            double z = replay.keyframes.z.interpolate(tick);
            float yaw = replay.keyframes.yaw.interpolate(tick).floatValue();
            float headYaw = replay.keyframes.headYaw.interpolate(tick).floatValue();
            float bodyYaw = replay.keyframes.bodyYaw.interpolate(tick).floatValue();
            float pitch = replay.keyframes.pitch.interpolate(tick).floatValue();
            class_746 player = class_310.method_1551().field_1724;
            PlayerUtils.teleport(x, y, z, headYaw, pitch);
            player.method_36456(yaw);
            player.method_5847(headYaw);
            player.method_5636(bodyYaw);
            player.method_36457(pitch);
        }
    }

    @Override
    public void applyUndoData(MapType data) {
        super.applyUndoData(data);
        List<Integer> selection = DataStorageUtils.intListFromData(data.getList("selection"));
        List<Integer> currentIndices = this.replays.replays.getCurrentIndices();
        this.setReplay((Replay)CollectionUtils.getSafe(this.film.replays.getList(), data.getInt("replay")), true, false);
        currentIndices.clear();
        currentIndices.addAll(selection);
        this.replays.replays.update();
    }

    @Override
    public void collectUndoData(MapType data) {
        super.collectUndoData(data);
        int index = this.film.replays.getList().indexOf(this.getReplay());
        data.putInt("replay", index);
        data.put("selection", DataStorageUtils.intListToData(this.replays.replays.getCurrentIndices()));
    }

    static {
        COLORS.put("x", 0xFF3333);
        COLORS.put("y", 0x33FF33);
        COLORS.put("z", 0x3366FF);
        COLORS.put("vX", 0xFF3333);
        COLORS.put("vY", 0x33FF33);
        COLORS.put("vZ", 0x3366FF);
        COLORS.put("yaw", 0xFFFF33);
        COLORS.put("pitch", 0x33FFFF);
        COLORS.put("bodyYaw", 0xFF66FF);
        COLORS.put("stick_lx", 0xFF3333);
        COLORS.put("stick_ly", 0x33FF33);
        COLORS.put("stick_rx", 0xFF3333);
        COLORS.put("stick_ry", 0x33FF33);
        COLORS.put("trigger_l", 0xFF3333);
        COLORS.put("trigger_r", 0x33FF33);
        COLORS.put("extra1_x", 0xFF3333);
        COLORS.put("extra1_y", 0x33FF33);
        COLORS.put("extra2_x", 0xFF3333);
        COLORS.put("extra2_y", 0x33FF33);
        COLORS.put("visible", 0xFFFFFF);
        COLORS.put("pose", 0xFF3333);
        COLORS.put("pose_overlay", 0xFF8822);
        COLORS.put("transform", 0x33FF33);
        COLORS.put("transform_overlay", 0xAAFF00);
        COLORS.put("color", 0xFFBB00);
        COLORS.put("lighting", 0xFFFF33);
        COLORS.put("structure_light", 0xFFFF33);
        COLORS.put("shape_keys", 16752033);
        COLORS.put("actions", 0xFF66FF);
        COLORS.put("item_main_hand", 0xFF8822);
        COLORS.put("item_off_hand", 0xFF8822);
        COLORS.put("item_head", 0xFF8822);
        COLORS.put("item_chest", 0xFF8822);
        COLORS.put("item_legs", 0xFF8822);
        COLORS.put("item_feet", 0xFF8822);
        COLORS.put("user1", 0xFF3333);
        COLORS.put("user2", 0xFF8822);
        COLORS.put("user3", 0x33FF33);
        COLORS.put("user4", 0x3366FF);
        COLORS.put("user5", 0xFF3333);
        COLORS.put("user6", 0xFF8822);
        COLORS.put("frequency", 0xFF3333);
        COLORS.put("count", 0x33FF33);
        COLORS.put("settings", 0xFF66FF);
        COLORS.put("offset_x", 0xFF3333);
        COLORS.put("offset_y", 0x33FF33);
        COLORS.put("offset_z", 0x3366FF);
        ICONS.put("x", Icons.X);
        ICONS.put("y", Icons.Y);
        ICONS.put("z", Icons.Z);
        ICONS.put("visible", Icons.VISIBLE);
        ICONS.put("texture", Icons.MATERIAL);
        ICONS.put("pose", Icons.POSE);
        ICONS.put("transform", Icons.ALL_DIRECTIONS);
        ICONS.put("color", Icons.BUCKET);
        ICONS.put("lighting", Icons.LIGHT);
        ICONS.put("structure_light", Icons.LIGHT);
        ICONS.put("actions", Icons.CONVERT);
        ICONS.put("shape_keys", Icons.HEART_ALT);
        ICONS.put("text", Icons.FONT);
        ICONS.put("stick_lx", Icons.LEFT_STICK);
        ICONS.put("stick_rx", Icons.RIGHT_STICK);
        ICONS.put("trigger_l", Icons.TRIGGER);
        ICONS.put("extra1_x", Icons.CURVES);
        ICONS.put("extra2_x", Icons.CURVES);
        ICONS.put("item_main_hand", Icons.LIMB);
        ICONS.put("user1", Icons.PARTICLE);
        ICONS.put("paused", Icons.TIME);
        ICONS.put("frequency", Icons.STOPWATCH);
        ICONS.put("count", Icons.BUCKET);
        ICONS.put("settings", Icons.GEAR);
        ICONS.put("structure_file", Icons.FILE);
    }
}

