/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.utils;

import java.util.HashSet;
import java.util.Set;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.network.ClientNetwork;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.forms.editors.UIFormUndoHandler;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.clips.Clips;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIFilmUndoHandler
extends UIFormUndoHandler {
    private Timer actionsTimer = new Timer(100L);
    private Set<BaseValue> syncData = new HashSet<BaseValue>();

    public UIFilmUndoHandler(UIFilmPanel panel) {
        super(panel);
    }

    @Override
    protected void handleValue(BaseValue value) {
        super.handleValue(value);
        if (this.isReplayActions(value)) {
            this.syncData.add(value);
            this.actionsTimer.mark();
        }
    }

    @Override
    protected void handleTimers() {
        super.handleTimers();
        if (this.actionsTimer.checkReset()) {
            for (BaseValue syncData : this.syncData) {
                ClientNetwork.sendSyncData(((Film)((UIFilmPanel)this.uiElement).getData()).getId(), syncData);
            }
            this.syncData.clear();
        }
    }

    private boolean isReplayActions(BaseValue value) {
        String path = value.getPath().toString();
        if (path.endsWith("/replays") || path.endsWith("/keyframes") || path.contains("/keyframes/x") || path.contains("/keyframes/y") || path.contains("/keyframes/z") || path.contains("/keyframes/item_main_hand") || path.contains("/keyframes/item_off_hand") || path.contains("/keyframes/item_head") || path.contains("/keyframes/item_chest") || path.contains("/keyframes/item_legs") || path.contains("/keyframes/item_feet") || path.endsWith("/actor") || path.endsWith("/enabled") || path.endsWith("/form")) {
            return true;
        }
        if (value.getParent() != null && value.getParent().getId().equals("replays")) {
            return true;
        }
        while (value != null) {
            Clips clips;
            if (value instanceof Clips && (clips = (Clips)value).getFactory() == BBSMod.getFactoryActionClips()) {
                return true;
            }
            value = value.getParent();
        }
        return false;
    }
}

