/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories;

import io.netty.util.collection.IntObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.bbs_mod.film.Film;
import mchorse.bbs_mod.film.replays.Replay;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.FormUtilsClient;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.utils.Anchor;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframes;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.factories.UIKeyframeFactory;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class UIAnchorKeyframeFactory
extends UIKeyframeFactory<Anchor> {
    private UIButton actor = new UIButton(UIKeys.GENERIC_KEYFRAMES_ANCHOR_PICK_ACTOR, b -> this.displayActors());
    private UIButton attachment = new UIButton(UIKeys.GENERIC_KEYFRAMES_ANCHOR_PICK_ATTACHMENT, b -> UIAnchorKeyframeFactory.displayAttachments(this.getPanel(), ((Anchor)this.keyframe.getValue()).replay, ((Anchor)this.keyframe.getValue()).attachment, this::setAttachment));
    private UIToggle translate = new UIToggle(UIKeys.TRANSFORMS_TRANSLATE, b -> this.setTranslate(b.getValue()));
    private UIToggle scale;

    public static void displayActors(UIContext context, IntObjectMap<IEntity> entities, int value, Consumer<Integer> callback) {
        List<UIFilmPanel> children = context.menu.main.getChildren(UIFilmPanel.class);
        UIFilmPanel panel = children.isEmpty() ? null : children.get(0);
        List replays = panel != null ? ((Film)panel.getData()).replays.getList() : null;
        context.replaceContextMenu(menu -> {
            menu.action(Icons.CLOSE, UIKeys.GENERAL_NONE, 0xFF3333, () -> callback.accept(-1));
            for (int i = 0; i < entities.size(); ++i) {
                int actor = i;
                IEntity entity = (IEntity)entities.get(i);
                if (entity == null) continue;
                Replay replay = replays == null ? null : (Replay)replays.get(i);
                Form form = entity.getForm();
                String stringLabel = i + (String)(replay != null ? " - " + replay.getName() : (form == null ? "" : " - " + form.getFormIdOrName()));
                IKey label = IKey.constant(stringLabel);
                menu.action(Icons.CLOSE, label, actor == value, () -> callback.accept(actor));
            }
        });
    }

    public static void displayAttachments(UIFilmPanel panel, int index, String value, Consumer<String> consumer) {
        IEntity entity = (IEntity)panel.getController().getEntities().get(index);
        if (entity == null || entity.getForm() == null) {
            return;
        }
        Form form = entity.getForm();
        Map<String, Matrix4f> map = FormUtilsClient.getRenderer(form).collectMatrices(entity, null, 0.0f);
        ArrayList<String> attachments = new ArrayList<String>(map.keySet());
        attachments.sort(String::compareToIgnoreCase);
        ArrayList<String> labels = new ArrayList<String>(attachments);
        for (int i = 0; i < labels.size(); ++i) {
            String label = (String)labels.get(i);
            Form path = FormUtils.getForm(form, label);
            if (path == null) continue;
            labels.set(i, path.getTrackName(label));
        }
        if (attachments.isEmpty()) {
            return;
        }
        panel.getContext().replaceContextMenu(menu -> {
            for (int i = 0; i < attachments.size(); ++i) {
                String attachment = (String)attachments.get(i);
                String label = (String)labels.get(i);
                menu.action(Icons.LIMB, IKey.constant(label), attachment.equals(value), () -> consumer.accept(attachment));
            }
        });
    }

    public UIAnchorKeyframeFactory(Keyframe<Anchor> keyframe, UIKeyframes editor) {
        super(keyframe, editor);
        this.translate.setValue(keyframe.getValue().translate);
        this.scale = new UIToggle(UIKeys.TRANSFORMS_SCALE, b -> this.setScale(b.getValue()));
        this.scale.setValue(keyframe.getValue().scale);
        this.scroll.add(this.actor, this.attachment, this.translate, this.scale);
    }

    private void displayActors() {
        UIFilmPanel panel = this.getPanel();
        UIAnchorKeyframeFactory.displayActors(this.getContext(), panel.getController().getEntities(), ((Anchor)this.keyframe.getValue()).replay, this::setActor);
    }

    private void setActor(int actor) {
        BaseValue.edit(this.keyframe, value -> {
            ((Anchor)value.getValue()).replay = actor;
        });
    }

    private void setAttachment(String attachment) {
        BaseValue.edit(this.keyframe, value -> {
            ((Anchor)value.getValue()).attachment = attachment;
        });
    }

    private void setTranslate(boolean translate) {
        BaseValue.edit(this.keyframe, value -> {
            ((Anchor)value.getValue()).translate = translate;
        });
    }

    private void setScale(boolean scale) {
        BaseValue.edit(this.keyframe, value -> {
            ((Anchor)value.getValue()).scale = scale;
        });
    }

    private UIFilmPanel getPanel() {
        return this.getParent(UIFilmPanel.class);
    }
}

