/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.sections;

import java.util.Map;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.Variable;
import mchorse.bbs_mod.particles.ParticleCurve;
import mchorse.bbs_mod.particles.ParticleMolangParser;
import mchorse.bbs_mod.particles.ParticleScheme;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSection;
import mchorse.bbs_mod.ui.particles.utils.UICurveEditor;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemeCurvesSection
extends UIParticleSchemeSection {
    public UIElement curves = UI.column(new UIElement[0]);
    public UIIcon add = new UIIcon(Icons.ADD, b -> this.addCurve());

    public UIParticleSchemeCurvesSection(UIParticleSchemePanel parent) {
        super(parent);
        this.add.tooltip(UIKeys.SNOWSTORM_CURVES_ADD);
        this.fields.add(this.curves, this.add);
    }

    private void addCurve() {
        Object name = "curve1";
        int i = 1;
        while (this.scheme.curves.containsKey(name)) {
            name = "curve" + i++;
        }
        ParticleMolangParser parser = this.scheme.parser;
        ParticleCurve curve = new ParticleCurve();
        UICurveEditor curveEditor = new UICurveEditor(this);
        if (!parser.variables.containsKey(name)) {
            parser.variables.put(name, new Variable((String)name, 0.0));
        }
        try {
            curve.input = parser.parseExpression("variable.particle_age");
            curve.range = parser.parseExpression("variable.particle_lifetime");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        curve.variable = (Variable)parser.variables.get(name);
        this.scheme.curves.put((String)name, curve);
        curveEditor.fill(curve);
        this.curves.add((IUIElement)curveEditor);
        this.editor.resize();
    }

    @Override
    public IKey getTitle() {
        return UIKeys.SNOWSTORM_CURVES_TITLE;
    }

    @Override
    public void setScheme(ParticleScheme scheme) {
        super.setScheme(scheme);
        this.curves.removeAll();
        for (Map.Entry<String, ParticleCurve> entry : scheme.curves.entrySet()) {
            UICurveEditor curve = new UICurveEditor(this);
            curve.fill(entry.getValue());
            this.curves.add((IUIElement)curve);
        }
    }
}

