/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.sections;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentInitialSpeed;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentInitialSpin;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentMotion;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentMotionDynamic;
import mchorse.bbs_mod.particles.components.motion.ParticleComponentMotionParametric;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UICirculate;
import mchorse.bbs_mod.ui.particles.UIParticleSchemePanel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeModeSection;
import mchorse.bbs_mod.ui.utils.UI;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIParticleSchemeMotionSection
extends UIParticleSchemeModeSection<ParticleComponentMotion> {
    public UIElement position;
    public UIButton positionSpeed = new UIButton(UIKeys.SNOWSTORM_MOTION_POSITION_SPEED, b -> this.editMoLang("motion.speed", str -> {
        this.speed.speed = this.parse((String)str, this.speed.speed);
    }, this.speed.speed));
    public UIButton positionX = new UIButton(UIKeys.GENERAL_X, str -> this.updatePosition(0));
    public UIButton positionY = new UIButton(UIKeys.GENERAL_Y, str -> this.updatePosition(1));
    public UIButton positionZ = new UIButton(UIKeys.GENERAL_Z, str -> this.updatePosition(2));
    public UIButton positionDrag = new UIButton(UIKeys.SNOWSTORM_MOTION_POSITION_DRAG, b -> {
        ParticleComponentMotionDynamic component = (ParticleComponentMotionDynamic)this.component;
        this.editMoLang("motion.drag", str -> {
            component.motionDrag = this.parse((String)str, component.motionDrag);
        }, component.motionDrag);
    });
    public UIElement rotation;
    public UIButton rotationAngle = new UIButton(UIKeys.SNOWSTORM_MOTION_ROTATION_ANGLE, b -> this.editMoLang("motion.angle", str -> {
        this.spin.rotation = this.parse((String)str, this.spin.rotation);
    }, this.spin.rotation));
    public UIButton rotationRate = new UIButton(UIKeys.SNOWSTORM_MOTION_ROTATION_SPEED, b -> this.editMoLang("motion.angle_speed", str -> {
        this.spin.rate = this.parse((String)str, this.spin.rate);
    }, this.spin.rate));
    public UIButton rotationAcceleration = new UIButton(UIKeys.SNOWSTORM_MOTION_ROTATION_ACCELERATION, b -> {
        if (this.component instanceof ParticleComponentMotionDynamic) {
            ParticleComponentMotionDynamic component = (ParticleComponentMotionDynamic)this.component;
            this.editMoLang("motion.angle_acceleration", str -> {
                component.rotationAcceleration = this.parse((String)str, component.rotationAcceleration);
            }, component.rotationAcceleration);
        } else {
            ParticleComponentMotionParametric component = (ParticleComponentMotionParametric)this.component;
            this.editMoLang("motion.angle_expression", str -> {
                component.rotation = this.parse((String)str, component.rotation);
            }, component.rotation);
        }
    });
    public UIButton rotationDrag = new UIButton(UIKeys.SNOWSTORM_MOTION_ROTATION_DRAG, b -> {
        ParticleComponentMotionDynamic component = (ParticleComponentMotionDynamic)this.component;
        this.editMoLang("motion.angle_drag", str -> {
            component.rotationDrag = this.parse((String)str, component.rotationDrag);
        }, component.rotationDrag);
    });
    private ParticleComponentInitialSpeed speed;
    private ParticleComponentInitialSpin spin;

    public UIParticleSchemeMotionSection(UIParticleSchemePanel parent) {
        super(parent);
        this.position = new UIElement();
        this.position.column(5).vertical().stretch();
        this.position.add(UI.label(UIKeys.SNOWSTORM_MOTION_POSITION, 20).labelAnchor(0.0f, 1.0f), this.positionSpeed);
        this.position.add((IUIElement)UI.row(this.positionX, this.positionY, this.positionZ));
        this.rotation = new UIElement();
        this.rotation.column(5).vertical().stretch();
        this.rotation.add(UI.label(UIKeys.SNOWSTORM_MOTION_ROTATION, 20).labelAnchor(0.0f, 1.0f), this.rotationAngle, this.rotationRate);
        this.rotation.add((IUIElement)this.rotationAcceleration);
        this.fields.add(this.position, this.rotation);
    }

    private void updatePosition(int index) {
        if (this.component instanceof ParticleComponentMotionDynamic) {
            ParticleComponentMotionDynamic component = (ParticleComponentMotionDynamic)this.component;
            this.editMoLang("motion.acceleration_" + index, str -> {
                component.motionAcceleration[index] = this.parse((String)str, component.motionAcceleration[index]);
            }, component.motionAcceleration[index]);
        } else {
            ParticleComponentMotionParametric component = (ParticleComponentMotionParametric)this.component;
            this.editMoLang("motion.position_" + index, str -> {
                component.position[index] = this.parse((String)str, component.position[index]);
            }, component.position[index]);
        }
    }

    @Override
    public IKey getTitle() {
        return UIKeys.SNOWSTORM_MOTION_TITLE;
    }

    @Override
    protected void fillModes(UICirculate button) {
        button.addLabel(UIKeys.SNOWSTORM_MOTION_DYNAMIC);
        button.addLabel(UIKeys.SNOWSTORM_MOTION_PARAMETRIC);
    }

    @Override
    protected Class<ParticleComponentMotion> getBaseClass() {
        return ParticleComponentMotion.class;
    }

    @Override
    protected Class getDefaultClass() {
        return ParticleComponentMotionDynamic.class;
    }

    @Override
    protected Class getModeClass(int value) {
        if (value == 1) {
            return ParticleComponentMotionParametric.class;
        }
        return ParticleComponentMotionDynamic.class;
    }

    @Override
    protected void fillData() {
        super.fillData();
        this.speed = this.scheme.getOrCreate(ParticleComponentInitialSpeed.class);
        this.spin = this.scheme.getOrCreate(ParticleComponentInitialSpin.class);
        this.positionDrag.removeFromParent();
        this.rotationDrag.removeFromParent();
        if (this.component instanceof ParticleComponentMotionDynamic) {
            this.position.add((IUIElement)this.positionDrag);
            this.rotation.add((IUIElement)this.rotationDrag);
        }
        this.resizeParent();
    }
}

