/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.particles.utils;

import java.util.Map;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.math.Variable;
import mchorse.bbs_mod.particles.ParticleCurve;
import mchorse.bbs_mod.particles.ParticleCurveType;
import mchorse.bbs_mod.particles.ParticleMolangParser;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UICirculate;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIPromptOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.particles.sections.UIParticleSchemeSection;
import mchorse.bbs_mod.ui.particles.utils.UICurve;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UICurveEditor
extends UIElement {
    private UIParticleSchemeSection section;
    public UILabel name;
    public UIIcon rename;
    public UIIcon delete;
    public UICirculate type;
    public UICurve curve;
    public UIButton input;
    public UIButton range;
    private ParticleCurve particleCurve;

    public UICurveEditor(UIParticleSchemeSection section) {
        this.section = section;
        this.name = UI.label(IKey.EMPTY, 20).labelAnchor(0.0f, 0.5f).background();
        this.rename = new UIIcon(Icons.EDIT, this::rename);
        this.rename.tooltip(UIKeys.SNOWSTORM_CURVES_RENAME);
        this.delete = new UIIcon(Icons.REMOVE, this::remove);
        this.delete.tooltip(UIKeys.SNOWSTORM_CURVES_REMOVE);
        this.type = new UICirculate(b -> this.changeType(b.getValue()));
        for (ParticleCurveType type : ParticleCurveType.values()) {
            this.type.addLabel(UIKeys.C_CURVE_TYPE.get(type.id));
        }
        this.curve = new UICurve(section);
        this.input = new UIButton(UIKeys.SNOWSTORM_CURVES_INPUT, b -> this.section.editMoLang("curve." + this.particleCurve.variable.getName() + ".input", str -> {
            this.particleCurve.input = this.section.parse((String)str, this.particleCurve.input);
        }, this.particleCurve.input));
        this.range = new UIButton(UIKeys.SNOWSTORM_CURVES_RANGE, b -> this.section.editMoLang("curve." + this.particleCurve.variable.getName() + ".range", str -> {
            this.particleCurve.range = this.section.parse((String)str, this.particleCurve.range);
        }, this.particleCurve.range));
        this.curve.h(100);
        this.column().vertical().stretch();
        this.add((IUIElement)UI.row(0, this.name, this.rename, this.delete));
        this.add((IUIElement)UI.row(UI.label(UIKeys.SNOWSTORM_CURVES_TYPE, 20).labelAnchor(0.0f, 0.5f), this.type));
        this.add(this.curve, UI.row(this.input, this.range));
    }

    private void rename(UIIcon b) {
        String oldName = this.particleCurve.variable.getName();
        UIPromptOverlayPanel panel = new UIPromptOverlayPanel(UIKeys.GENERAL_RENAME, UIKeys.SNOWSTORM_CURVES_RENAME_OVERLAY, newName -> {
            if (newName.isEmpty() || newName.contains(" ")) {
                return;
            }
            Map<String, ParticleCurve> curves = this.section.getScheme().curves;
            ParticleMolangParser parser = this.section.getScheme().parser;
            if (!parser.variables.containsKey(newName)) {
                parser.variables.put(newName, new Variable((String)newName, 0.0));
            }
            curves.put((String)newName, curves.remove(oldName));
            this.particleCurve.variable = (Variable)parser.variables.get(newName);
            this.name.label = IKey.constant(newName);
            this.section.dirty();
        });
        panel.text.setText(oldName);
        UIOverlay.addOverlay(this.getContext(), panel);
    }

    private void remove(UIIcon b) {
        this.removeFromParent();
        this.section.getScheme().curves.remove(this.particleCurve.variable.getName());
        this.section.getEditor().resize();
        this.section.dirty();
    }

    private void changeType(int value) {
        this.particleCurve.type = ParticleCurveType.values()[value];
        this.section.dirty();
    }

    public void fill(ParticleCurve curve) {
        this.particleCurve = curve;
        this.name.label = IKey.constant(curve.variable.getName());
        this.type.setValue(curve.type.ordinal());
        this.curve.fill(curve);
    }
}

