/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utility;

import java.io.File;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.data.DataToString;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.L10n;
import mchorse.bbs_mod.l10n.L10nUtils;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.l10n.keys.LangKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIIcon;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.framework.elements.overlay.UILabelOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UITextareaOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.UILabel;
import mchorse.bbs_mod.ui.framework.elements.utils.UIRenderable;
import mchorse.bbs_mod.ui.utility.UILanguageKey;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.IOUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class UILanguageEditorOverlayPanel
extends UIOverlayPanel {
    private static String referenceLanguage = "en_us";
    public UIIcon save;
    public UIIcon folder;
    public UIIcon changeReference;
    public UIIcon copy;
    public UIIcon paste;
    public UILabel completion;
    public UIIcon missing;
    public UITextbox search;
    public UIScrollView keysView;
    private File target;
    private List<UILanguageKey> keys = new ArrayList<UILanguageKey>();
    private boolean viewMissing;
    private long updateCompletion;
    private File markedFile;
    private MapType markedKeys = new MapType();

    public static File getLangEditorFolder() {
        return BBSMod.getAssetsPath("lang_editor/" + (String)BBSSettings.language.get());
    }

    public UILanguageEditorOverlayPanel() {
        super(UIKeys.LANGUAGE_EDITOR_TITLE.format(BBSSettings.language.get()));
        this.target = UILanguageEditorOverlayPanel.getLangEditorFolder();
        this.target.mkdirs();
        this.markedFile = new File(UILanguageEditorOverlayPanel.getLangEditorFolder(), "marked.json");
        this.save = new UIIcon(Icons.SAVED, b -> this.save());
        this.save.tooltip(UIKeys.LANGUAGE_EDITOR_SAVE);
        this.folder = new UIIcon(Icons.FOLDER, b -> UIUtils.openFolder(this.target));
        this.folder.tooltip(UIKeys.LANGUAGE_EDITOR_FOLDER);
        this.changeReference = new UIIcon(Icons.REFRESH, b -> this.changeReference());
        this.changeReference.tooltip(UIKeys.LANGUAGE_EDITOR_REFERENCE);
        this.copy = new UIIcon(Icons.COPY, b -> this.copy());
        this.copy.tooltip(UIKeys.LANGUAGE_EDITOR_COPY);
        this.paste = new UIIcon(Icons.PASTE, b -> this.paste());
        this.paste.tooltip(UIKeys.LANGUAGE_EDITOR_PASTE);
        this.completion = UI.label(IKey.EMPTY);
        this.completion.background(0x88000000 | (Integer)BBSSettings.primaryColor.get()).labelAnchor(1.0f, 0.55f);
        this.completion.relative(this.icons).x(-8).wh(160, 20).anchorX(1.0f);
        this.missing = new UIIcon(Icons.SEARCH, b -> this.viewOnlyMissing());
        this.missing.tooltip(UIKeys.LANGUAGE_EDITOR_MISSING);
        this.search = new UITextbox(this::search);
        this.search.placeholder(UIKeys.GENERAL_SEARCH);
        this.keysView = UI.scrollView(10, 6, new UIElement[0]);
        this.missing.relative(this.content).x(1.0f, -26);
        this.search.relative(this.content).x(6).w(1.0f, -12);
        this.keysView.relative(this.content).y(20).w(1.0f).h(1.0f, -20);
        this.icons.add(this.save, this.folder, this.changeReference, this.paste, this.copy);
        this.content.add(this.search, new UIRenderable(this::renderMissingBackground), this.missing, this.keysView);
        this.add((IUIElement)this.completion);
        this.buildEditor();
        this.readMarkedStrings();
        this.updateCompletionLabel();
        this.keys().register(Keys.SAVE, () -> this.save.clickItself());
    }

    public boolean hasMarked(String key) {
        return this.markedKeys.has(key);
    }

    public void setMarked(String key, boolean marked) {
        if (marked) {
            this.markedKeys.putBool(key, true);
        } else {
            this.markedKeys.remove(key);
        }
        this.dirty();
        DataToString.writeSilently(this.markedFile, this.markedKeys, true);
    }

    private void readMarkedStrings() {
        try {
            this.markedKeys = DataToString.mapFromString(IOUtils.readText(this.markedFile));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void rebuildEditor() {
        this.keys.clear();
        this.keysView.removeAll();
        this.buildEditor();
        this.keysView.resize();
    }

    private void buildEditor() {
        L10n l10n = BBSModClient.getL10n();
        MapType base = this.compile(l10n, "en_us");
        MapType reference = referenceLanguage.equals("en_us") ? null : this.compile(l10n, referenceLanguage);
        ArrayList<LangKey> keys = new ArrayList<LangKey>(l10n.getStrings().values());
        L10nUtils.sortList(keys);
        for (LangKey key : keys) {
            String referenceString = reference == null ? "" : reference.getString(key.key);
            UILanguageKey ui = new UILanguageKey(this, key, base.getString(key.key, key.key), referenceString, this::dirty);
            this.keys.add(ui);
            this.keysView.add((IUIElement)ui);
        }
    }

    private MapType compile(L10n l10n, String lang) {
        MapType base = new MapType();
        for (Link link : l10n.getAllLinks(lang)) {
            if (Link.isAssets(link) && link.path.startsWith("lang_editor/")) continue;
            try {
                InputStream asset = BBSMod.getProvider().getAsset(link);
                try {
                    String string = IOUtils.readText(asset);
                    base.combine(DataToString.mapFromString(string));
                }
                finally {
                    if (asset == null) continue;
                    asset.close();
                }
            }
            catch (Exception exception) {}
        }
        return base;
    }

    private void dirty() {
        this.save.both(Icons.SAVE);
        this.updateCompletion = this.getContext().getTick() + 20L;
    }

    private void updateCompletionLabel() {
        int i = 0;
        for (UILanguageKey key : this.keys) {
            if (key.isStillSame()) continue;
            ++i;
        }
        float p = (float)i / (float)this.keys.size();
        String percentage = UITrackpad.format(p * 100.0f) + "% (" + i + "/" + this.keys.size() + ")";
        this.completion.label = IKey.constant(percentage);
        this.updateCompletion = 0L;
    }

    private void save() {
        HashMap<String, LangKey> keyMap = new HashMap<String, LangKey>();
        for (UILanguageKey key : this.keys) {
            if (key.isStillSame() || this.markedKeys.has(key.getLangKey().key)) continue;
            LangKey langKey = key.getLangKey();
            keyMap.put(langKey.key, langKey);
        }
        L10nUtils.compile(this.target, keyMap);
        this.save.both(Icons.SAVED);
    }

    private void changeReference() {
        List labels = BBSModClient.getL10n().getSupportedLanguageLabels();
        UILabelOverlayPanel<String> panel = new UILabelOverlayPanel<String>(UIKeys.LANGUAGE_EDITOR_REFERENCE_TITLE, labels, str -> {
            referenceLanguage = (String)str.value;
            this.rebuildEditor();
            this.updateCompletionLabel();
            this.search("");
        });
        panel.set(referenceLanguage);
        UIOverlay.addOverlay(this.getContext(), panel);
    }

    private void copy() {
        ArrayList<LangKey> keys = new ArrayList<LangKey>();
        MapType translated = new MapType(false);
        for (UILanguageKey uILanguageKey : this.keys) {
            if (uILanguageKey.isStillSame()) continue;
            keys.add(uILanguageKey.getLangKey());
        }
        L10nUtils.sortList(keys);
        for (LangKey langKey : keys) {
            translated.putString(langKey.key, langKey.content);
        }
        String string = DataToString.toString(translated, true);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = MemoryUtil.memAlloc((int)(byArray.length + 1));
        buffer.put(byArray);
        buffer.put((byte)0);
        buffer.flip();
        GLFW.glfwSetClipboardString((long)Window.getWindow(), (ByteBuffer)buffer);
        MemoryUtil.memFree((Buffer)buffer);
    }

    private void paste() {
        UITextareaOverlayPanel panel = new UITextareaOverlayPanel(UIKeys.GENERAL_PASTE, UIKeys.LANGUAGE_EDITOR_PASTE_DESCRIPTION, t -> {
            MapType map = DataToString.mapFromString(t);
            if (map == null) {
                return;
            }
            BBSModClient.getL10n().overwrite(map);
            this.rebuildEditor();
            this.updateCompletionLabel();
            this.dirty();
        });
        UIOverlay.addOverlay(this.getContext(), panel);
    }

    private void viewOnlyMissing() {
        this.viewMissing = !this.viewMissing;
        this.search(this.search.getText());
    }

    private void search(String s) {
        boolean all = s.isEmpty();
        this.keysView.removeAll();
        for (UILanguageKey ui : this.keys) {
            LangKey langKey = ui.getLangKey();
            if (this.viewMissing && !ui.isStillSame() || !all && !langKey.key.contains(s) && !langKey.content.contains(s)) continue;
            this.keysView.add((IUIElement)ui);
        }
        this.keysView.resize();
    }

    private void renderMissingBackground(UIContext context) {
        if (this.viewMissing) {
            this.missing.area.render(context.batcher, 0x88000000 | (Integer)BBSSettings.primaryColor.get(), 1);
        }
    }

    @Override
    protected void renderBackground(UIContext context) {
        if (this.updateCompletion > 0L && this.updateCompletion <= context.getTick()) {
            this.updateCompletionLabel();
        }
        super.renderBackground(context);
    }
}

