/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.Draw;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.utils.StencilMap;
import mchorse.bbs_mod.utils.Axis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;

@Environment(value=EnvType.CLIENT)
public class Gizmo {
    public static final int STENCIL_X = 1;
    public static final int STENCIL_Y = 2;
    public static final int STENCIL_Z = 3;
    public static final int STENCIL_XZ = 4;
    public static final int STENCIL_XY = 5;
    public static final int STENCIL_ZY = 6;
    public static final Gizmo INSTANCE = new Gizmo();
    private Mode mode = Mode.TRANSLATE;
    private int index;
    private int mouseX;
    private int mouseY;
    private UIPropTransform currentTransform;

    private Gizmo() {
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean setMode(Mode mode) {
        if (!((Boolean)BBSSettings.gizmos.get()).booleanValue()) {
            return false;
        }
        boolean same = this.mode == mode;
        this.mode = mode;
        return !same;
    }

    public boolean start(int index, int mouseX, int mouseY, UIPropTransform transform) {
        if (!((Boolean)BBSSettings.gizmos.get()).booleanValue()) {
            return false;
        }
        if (index >= 1 && index <= 6) {
            this.index = index;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.currentTransform = transform;
            if (transform != null) {
                if (this.index == 1) {
                    transform.enableMode(this.mode.ordinal(), Axis.X);
                } else if (this.index == 2) {
                    transform.enableMode(this.mode.ordinal(), Axis.Y);
                } else if (this.index == 3) {
                    transform.enableMode(this.mode.ordinal(), Axis.Z);
                }
            }
            return true;
        }
        return false;
    }

    public void stop() {
        this.index = -1;
        if (this.currentTransform != null) {
            this.currentTransform.acceptChanges();
        }
        this.currentTransform = null;
    }

    public void render(class_4587 stack) {
        if (((Boolean)BBSSettings.gizmos.get()).booleanValue()) {
            this.drawAxes(stack, 0.25f, 0.015f, 0.26f, 0.025f);
        } else {
            Draw.coolerAxes(stack, 0.25f, 0.015f, 0.26f, 0.025f);
        }
    }

    private void drawAxes(class_4587 stack, float axisSize, float axisOffset, float outlineSize, float outlineOffset) {
        float scale = ((Float)BBSSettings.axesScale.get()).floatValue();
        axisSize *= scale;
        axisOffset *= scale;
        outlineSize *= scale;
        outlineOffset *= scale;
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        if (this.mode == Mode.ROTATE) {
            float outlinePad = 0.015f * scale;
            float radius = 0.22f * scale;
            float thicknessRing = 0.025f * scale;
            Draw.arc3D(builder, stack, Axis.Z, radius, thicknessRing + outlinePad, 0.0f, 0.0f, 0.0f);
            Draw.arc3D(builder, stack, Axis.Z, radius, thicknessRing, 0.0f, 0.0f, 1.0f);
            Draw.arc3D(builder, stack, Axis.X, radius, thicknessRing + outlinePad, 0.0f, 0.0f, 0.0f);
            Draw.arc3D(builder, stack, Axis.X, radius, thicknessRing, 1.0f, 0.0f, 0.0f);
            Draw.arc3D(builder, stack, Axis.Y, radius, thicknessRing + outlinePad, 0.0f, 0.0f, 0.0f);
            Draw.arc3D(builder, stack, Axis.Y, radius, thicknessRing, 0.0f, 1.0f, 0.0f);
            Draw.fillBox(builder, stack, -outlineOffset, -outlineOffset, -outlineOffset, outlineOffset, outlineOffset, outlineOffset, 0.0f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -axisOffset, -axisOffset, -axisOffset, axisOffset, axisOffset, axisOffset, 1.0f, 1.0f, 1.0f);
        } else {
            Draw.fillBox(builder, stack, 0.0f, -outlineOffset, -outlineOffset, outlineSize, outlineOffset, outlineOffset, 0.0f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -outlineOffset, 0.0f, -outlineOffset, outlineOffset, outlineSize, outlineOffset, 0.0f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -outlineOffset, -outlineOffset, 0.0f, outlineOffset, outlineOffset, outlineSize, 0.0f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -outlineOffset, -outlineOffset, -outlineOffset, outlineOffset, outlineOffset, outlineOffset, 0.0f, 0.0f, 0.0f);
            if (this.mode == Mode.SCALE) {
                float scaleStart = axisSize + axisOffset / 2.0f - outlineOffset / 2.0f;
                float scaleEnd = axisSize + axisOffset / 2.0f + outlineOffset / 2.0f;
                float offset = axisOffset * 2.75f;
                Draw.fillBox(builder, stack, scaleStart, -offset, -offset, scaleEnd, offset, offset, 0.0f, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -offset, scaleStart, -offset, offset, scaleEnd, offset, 0.0f, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -offset, -offset, scaleStart, offset, offset, scaleEnd, 0.0f, 0.0f, 0.0f);
            }
            Draw.fillBox(builder, stack, 0.0f, -axisOffset, -axisOffset, axisSize, axisOffset, axisOffset, 1.0f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -axisOffset, 0.0f, -axisOffset, axisOffset, axisSize, axisOffset, 0.0f, 1.0f, 0.0f);
            Draw.fillBox(builder, stack, -axisOffset, -axisOffset, 0.0f, axisOffset, axisOffset, axisSize, 0.0f, 0.0f, 1.0f);
            Draw.fillBox(builder, stack, -axisOffset, -axisOffset, -axisOffset, axisOffset, axisOffset, axisOffset, 1.0f, 1.0f, 1.0f);
            if (this.mode == Mode.SCALE) {
                float scaleEnd = axisSize + axisOffset;
                Draw.fillBox(builder, stack, axisSize, -axisOffset * 2.0f, -axisOffset * 2.0f, scaleEnd, axisOffset * 2.0f, axisOffset * 2.0f, 1.0f, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -axisOffset * 2.0f, axisSize, -axisOffset * 2.0f, axisOffset * 2.0f, scaleEnd, axisOffset * 2.0f, 0.0f, 1.0f, 0.0f);
                Draw.fillBox(builder, stack, -axisOffset * 2.0f, -axisOffset * 2.0f, axisSize, axisOffset * 2.0f, axisOffset * 2.0f, scaleEnd, 0.0f, 0.0f, 1.0f);
            }
        }
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.depthFunc((int)519);
        class_286.method_43433((class_9801)builder.method_60800());
        RenderSystem.depthFunc((int)515);
    }

    public void renderStencil(class_4587 stack, StencilMap map) {
        if (((Boolean)BBSSettings.gizmos.get()).booleanValue()) {
            this.drawAxes(stack, map, 0.25f, 0.015f);
        }
    }

    private void drawAxes(class_4587 stack, StencilMap map, float axisSize, float axisOffset) {
        float scale = ((Float)BBSSettings.axesScale.get()).floatValue();
        axisSize *= scale;
        axisOffset *= scale;
        class_287 builder = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        if (this.mode == Mode.ROTATE) {
            float outlinePad = 0.015f * scale;
            float radius = 0.22f * scale;
            float thicknessRing = 0.025f * scale;
            Draw.arc3D(builder, stack, Axis.Z, radius, thicknessRing + outlinePad, 0.011764706f, 0.0f, 0.0f);
            Draw.arc3D(builder, stack, Axis.X, radius, thicknessRing + outlinePad, 0.003921569f, 0.0f, 0.0f);
            Draw.arc3D(builder, stack, Axis.Y, radius, thicknessRing + outlinePad, 0.007843138f, 0.0f, 0.0f);
        } else {
            Draw.fillBox(builder, stack, 0.0f, -axisOffset, -axisOffset, axisSize, axisOffset, axisOffset, 0.003921569f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -axisOffset, 0.0f, -axisOffset, axisOffset, axisSize, axisOffset, 0.007843138f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -axisOffset, -axisOffset, 0.0f, axisOffset, axisOffset, axisSize, 0.011764706f, 0.0f, 0.0f);
            Draw.fillBox(builder, stack, -axisOffset, -axisOffset, -axisOffset, axisOffset, axisOffset, axisOffset, 0.0f, 0.0f, 0.0f);
            if (this.mode == Mode.SCALE) {
                float scaleEnd = axisSize + axisOffset;
                Draw.fillBox(builder, stack, axisSize, -axisOffset * 2.0f, -axisOffset * 2.0f, scaleEnd, axisOffset * 2.0f, axisOffset * 2.0f, 0.003921569f, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -axisOffset * 2.0f, axisSize, -axisOffset * 2.0f, axisOffset * 2.0f, scaleEnd, axisOffset * 2.0f, 0.007843138f, 0.0f, 0.0f);
                Draw.fillBox(builder, stack, -axisOffset * 2.0f, -axisOffset * 2.0f, axisSize, axisOffset * 2.0f, axisOffset * 2.0f, scaleEnd, 0.011764706f, 0.0f, 0.0f);
            }
        }
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        class_286.method_43433((class_9801)builder.method_60800());
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Mode {
        TRANSLATE,
        SCALE,
        ROTATE;

    }
}

