/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.utils.renderers;

import mchorse.bbs_mod.graphics.line.LineBuilder;
import mchorse.bbs_mod.graphics.line.SolidColorLineRenderer;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.tooltips.styles.TooltipStyle;
import mchorse.bbs_mod.ui.utils.Area;
import mchorse.bbs_mod.ui.utils.InterpolationUtils;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.interps.IInterp;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class InterpolationRenderer {
    private static Color color = new Color();

    public static void renderInterpolationPreview(IInterp interp, UIContext context, int x, int y, float anchorX, float anchorY, int duration) {
        if (interp == null) {
            return;
        }
        int w = 140;
        int h = 130;
        TooltipStyle style = TooltipStyle.get();
        y = MathUtils.clamp(y, 0, context.menu.height - h);
        x = MathUtils.clamp(x - (int)((float)w * anchorX), 0, context.menu.width - w);
        y = MathUtils.clamp(y - (int)((float)h * anchorY), 0, context.menu.height - h);
        Area.SHARED.set(x, y, w, h);
        style.renderBackground(context, Area.SHARED);
        Color fg = color.set(style.getForegroundColor(), false);
        int fontColor = style.getTextColor();
        fg.a = 0.2f;
        String name = InterpolationUtils.getName(interp).get();
        int fh = context.batcher.getFont().getHeight() + 2;
        context.batcher.textShadow(name, x + 10, y + 10, fontColor);
        InterpolationRenderer.renderInterpolationGraph(interp, context, fg, fontColor, x + 10, y + 10 + fh, w - 20, h - 20 - fh, duration, 10);
    }

    public static void renderInterpolationGraph(IInterp interp, UIContext context, Color fg, int fontColor, int x, int y, int w, int h, int duration, int padding) {
        float factor;
        if (interp == null) {
            return;
        }
        float iterations = 40.0f;
        LineBuilder grid = new LineBuilder(0.25f);
        grid.add(x, y);
        grid.add(x, y + h);
        grid.add(x + w, y + h);
        grid.add(x + w, y);
        grid.add(x, y);
        grid.push();
        grid.add(x + w / 2, y);
        grid.add(x + w / 2, y + h);
        grid.push();
        grid.add(x, y + h / 2);
        grid.add(x + w, y + h / 2);
        grid.push();
        grid.add(x, y + h - padding);
        grid.add(x + w, y + h - padding);
        grid.push();
        grid.add(x, y + padding);
        grid.add(x + w, y + padding);
        grid.render(context.batcher, SolidColorLineRenderer.get(fg));
        fg.a = 1.0f;
        context.batcher.clip(x - 1, y, w + 10, h, context);
        LineBuilder line = new LineBuilder(0.75f);
        int i = 0;
        while ((float)i <= 40.0f) {
            factor = (float)i / 40.0f;
            float value = 1.0f - interp.interpolate(0.0f, 1.0f, factor);
            float x1 = (float)x + factor * (float)w;
            float y1 = (float)(y + padding) + value * ((float)h - (float)padding * 2.0f);
            line.add(x1, y1);
            ++i;
        }
        line.render(context.batcher, SolidColorLineRenderer.get(fg));
        context.batcher.text("A", x + 4, y + h - padding + 4, fontColor);
        context.batcher.text("B", x + w - 9, y + padding - context.batcher.getFont().getHeight() - 4, fontColor);
        float tick = context.getTickTransition() % (float)(duration + 20);
        factor = MathUtils.clamp(tick / (float)duration, 0.0f, 1.0f);
        int px = x + w + 5;
        int py = y + padding + (int)((1.0f - interp.interpolate(0.0f, 1.0f, factor)) * ((float)h - (float)padding * 2.0f));
        context.batcher.box(px - 2, py - 2, px + 2, py + 2, -16777216 + fg.getRGBColor());
        context.batcher.unclip(context);
    }
}

