/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.util.ArrayList;
import java.util.List;

public class DataPath {
    public static final DataPath EMPTY = new DataPath(true);
    public List<String> strings = new ArrayList<String>();
    public boolean folder;

    public DataPath(List<String> strings) {
        this.strings.addAll(strings);
    }

    public DataPath(String path) {
        this.set(path);
    }

    public DataPath(boolean folder) {
        this.folder = folder;
    }

    public int size() {
        return this.strings.size();
    }

    public void set(String path) {
        this.strings.clear();
        if (path.isEmpty()) {
            this.folder = true;
            return;
        }
        for (String string : path.split("/")) {
            if (string.trim().isEmpty()) continue;
            this.strings.add(string);
        }
        this.folder = path.trim().endsWith("/");
    }

    public void combine(DataPath path) {
        this.strings.addAll(path.strings);
        this.folder = path.folder;
    }

    public DataPath copy() {
        DataPath dataPath = new DataPath(this.folder);
        dataPath.strings.addAll(this.strings);
        return dataPath;
    }

    public DataPath copy(DataPath path) {
        this.strings.clear();
        this.strings.addAll(path.strings);
        this.folder = path.folder;
        return this;
    }

    public DataPath getParent() {
        DataPath dataPath = this.copy();
        if (!dataPath.strings.isEmpty()) {
            dataPath.strings.remove(dataPath.strings.size() - 1);
        }
        dataPath.folder = true;
        return dataPath;
    }

    public DataPath getChild(String name) {
        DataPath dataPath = this.copy();
        DataPath child = new DataPath(name);
        dataPath.combine(child);
        return dataPath;
    }

    public DataPath getTo(int levels) {
        DataPath dataPath = this.copy();
        while (dataPath.strings.size() > levels) {
            dataPath.strings.remove(dataPath.strings.size() - 1);
            dataPath.folder = true;
        }
        return dataPath;
    }

    public boolean startsWith(DataPath path, int levels) {
        if (this.startsWith(path)) {
            return this.strings.size() - path.strings.size() == levels;
        }
        return false;
    }

    public boolean startsWith(DataPath path) {
        if (this.strings.size() < path.strings.size()) {
            return false;
        }
        int c = path.strings.size();
        for (int i = 0; i < c; ++i) {
            if (this.strings.get(i).equals(path.strings.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof DataPath) {
            DataPath dataPath = (DataPath)obj;
            return this.toString().equals(dataPath.toString());
        }
        return false;
    }

    public String toString() {
        return String.join((CharSequence)"/", this.strings);
    }

    public String getLast() {
        if (this.strings.isEmpty()) {
            return "";
        }
        return this.strings.get(this.strings.size() - 1);
    }

    public int hashCode() {
        int code = 5;
        for (String string : this.strings) {
            code = 37 * code + string.hashCode();
        }
        return code;
    }
}

