/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.colors;

import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.colors.Color;
import mchorse.bbs_mod.utils.interps.Lerps;

public class Colors {
    public static final int RGB = 0xFFFFFF;
    public static final int A100 = -16777216;
    public static final int A90 = -301989888;
    public static final int A75 = -1157627904;
    public static final int A50 = -2013265920;
    public static final int A25 = 0x44000000;
    public static final int A12 = 0x22000000;
    public static final int A6 = 0x11000000;
    public static final int WHITE = -1;
    public static final int LIGHTEST_GRAY = -3355444;
    public static final int LIGHTER_GRAY = -5592406;
    public static final int GRAY = -7829368;
    public static final int DARKER_GRAY = -12303292;
    public static final int DARKEST_GRAY = -14540254;
    public static final int RED = 0xFF3333;
    public static final int GREEN = 0x33FF33;
    public static final int BLUE = 0x3366FF;
    public static final int YELLOW = 0xFFFF33;
    public static final int CYAN = 0x33FFFF;
    public static final int MAGENTA = 0xFF66FF;
    public static final int DEEP_PINK = 16716947;
    public static final int PINK = 16752033;
    public static final int ORANGE = 0xFF8822;
    public static final int CONTROL_BAR = -15461353;
    public static final int ACTIVE = 35071;
    public static final int POSITIVE = 0x33FF33;
    public static final int NEGATIVE = 0xFF3333;
    public static final int INACTIVE = 0xFFBB00;
    public static final int HIGHLIGHT = 0xDDDDFF;
    public static final int CURSOR = -11012822;
    public static final Color COLOR = new Color();

    public static int mulRGB(int color, float factor) {
        COLOR.set(color);
        Colors.COLOR.r *= factor;
        Colors.COLOR.g *= factor;
        Colors.COLOR.b *= factor;
        return COLOR.getARGBColor();
    }

    public static float getA(int color) {
        COLOR.set(color);
        return Colors.COLOR.a;
    }

    public static int setA(int color, float alpha) {
        COLOR.set(color);
        Colors.COLOR.a = alpha;
        return COLOR.getARGBColor();
    }

    public static int mulA(int color, float factor) {
        COLOR.set(color);
        Colors.COLOR.a *= factor;
        return COLOR.getARGBColor();
    }

    public static int a(float alpha) {
        return Colors.setA(0, alpha);
    }

    public static void interpolate(Color target, int a, int b, float x) {
        Colors.interpolate(target, a, b, x, true);
    }

    public static void interpolate(Color target, int a, int b, float x, boolean alpha) {
        target.set(a, alpha);
        COLOR.set(b, alpha);
        target.r = Lerps.lerp(target.r, Colors.COLOR.r, x);
        target.g = Lerps.lerp(target.g, Colors.COLOR.g, x);
        target.b = Lerps.lerp(target.b, Colors.COLOR.b, x);
        if (alpha) {
            target.a = Lerps.lerp(target.a, Colors.COLOR.a, x);
        }
    }

    public static int parse(String color) {
        return Colors.parse(color, 0);
    }

    public static int parse(String color, int orDefault) {
        try {
            return Colors.parseWithException(color);
        }
        catch (Exception exception) {
            return orDefault;
        }
    }

    public static int parseWithException(String color) throws Exception {
        if (color.startsWith("#")) {
            color = color.substring(1);
        }
        if (color.length() == 6 || color.length() == 8) {
            return StringUtils.parseHex(color);
        }
        throw new Exception("Given color \"" + color + "\" can't be parsed!");
    }

    public static Color HSVtoRGB(float h, float s, float v) {
        return Colors.HSVtoRGB(new Color(), h, s, v);
    }

    public static Color HSVtoRGB(Color color, float h, float s, float v) {
        h *= 360.0f;
        float c = v * s;
        float x = c * (1.0f - Math.abs((h %= 360.0f) / 60.0f % 2.0f - 1.0f));
        float m = v - c;
        if (h >= 0.0f && h < 60.0f) {
            color.set(c, x, 0.0f);
        } else if (h >= 60.0f && h < 120.0f) {
            color.set(x, c, 0.0f);
        } else if (h >= 120.0f && h < 180.0f) {
            color.set(0.0f, c, x);
        } else if (h >= 180.0f && h < 240.0f) {
            color.set(0.0f, x, c);
        } else if (h >= 240.0f && h < 300.0f) {
            color.set(x, 0.0f, c);
        } else {
            color.set(c, 0.0f, x);
        }
        color.r += m;
        color.g += m;
        color.b += m;
        return color;
    }

    public static Color RGBtoHSV(float r, float g, float b) {
        return Colors.RGBtoHSV(new Color(), r, g, b);
    }

    public static Color RGBtoHSV(Color color, float r, float g, float b) {
        float min;
        float max = Math.max(r, Math.max(g, b));
        float delta = max - (min = Math.min(r, Math.min(g, b)));
        if (delta == 0.0f) {
            color.r = 0.0f;
        } else if (max == r) {
            color.r = 60.0f * ((g - b) / delta % 6.0f);
        } else if (max == g) {
            color.r = 60.0f * ((b - r) / delta + 2.0f);
        } else if (max == b) {
            color.r = 60.0f * ((r - g) / delta + 4.0f);
        }
        color.r /= 360.0f;
        if (color.r < 0.0f) {
            color.r += 1.0f;
        }
        color.g = max == 0.0f ? 0.0f : delta / max;
        color.b = max;
        return color;
    }
}

