/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.cubic.model.loaders;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.cubic.ModelInstance;
import mchorse.bbs_mod.cubic.data.animation.Animations;
import mchorse.bbs_mod.cubic.data.model.Model;
import mchorse.bbs_mod.cubic.geo.GeoAnimationParser;
import mchorse.bbs_mod.cubic.geo.GeoModelParser;
import mchorse.bbs_mod.cubic.model.ModelManager;
import mchorse.bbs_mod.cubic.model.loaders.IModelLoader;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.utils.IOUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class GeoCubicModelLoader
implements IModelLoader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ModelInstance load(String id, ModelManager models, Link model, Collection<Link> links, MapType config) {
        Collection<Link> recursiveLinks = BBSMod.getProvider().getLinksFromPath(model, true);
        List<Link> modelGeo = IModelLoader.getLinks(links, ".geo.json");
        List<Link> modelAnimation = IModelLoader.getLinks(recursiveLinks, ".animation.json");
        Link modelTexture = IModelLoader.getLink(model.combine("model.png"), recursiveLinks, ".png");
        if (modelGeo.isEmpty()) {
            return null;
        }
        try (InputStream geoStream = BBSMod.getProvider().getAsset(modelGeo.get(0));){
            ModelInstance modelInstance;
            JsonObject modelJson = JsonParser.parseString((String)IOUtils.readText(geoStream)).getAsJsonObject();
            Animations modelAnimations = new Animations(models.parser);
            for (Link link : modelAnimation) {
                try {
                    InputStream stream = BBSMod.getProvider().getAsset(link);
                    try {
                        JsonObject jsonObject = JsonParser.parseString((String)IOUtils.readText(stream)).getAsJsonObject();
                        JsonObject animationsJson = jsonObject.get("animations").getAsJsonObject();
                        for (String key : animationsJson.keySet()) {
                            JsonObject animation = animationsJson.getAsJsonObject(key);
                            modelAnimations.animations.put(key, GeoAnimationParser.parse(models.parser, key, animation));
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to load Bedrock entity .animation.json for model: " + String.valueOf(model) + " in " + String.valueOf(link));
                }
            }
            Model modelModel = GeoModelParser.parse(modelJson, models.parser);
            ModelInstance newModel = new ModelInstance(id, modelModel, modelAnimations, modelTexture);
            if (modelModel.topGroups.isEmpty()) {
                modelInstance = null;
                return modelInstance;
            }
            newModel.applyConfig(config);
            modelInstance = newModel;
            return modelInstance;
        }
        catch (Exception e) {
            System.err.println("Failed to load Bedrock entity .geo.json for model: " + String.valueOf(model));
            e.printStackTrace();
            return null;
        }
    }
}

