/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics.texture;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public enum TextureFormat {
    RGBA_U8(32856, 6408, 5121, 36064),
    RGB_U8(32849, 6407, 5121, 36064),
    RGBA_F16(34842, 6408, 5126, 36064),
    DEPTH_F24(33190, 6402, 5126, 36096);

    public final int internal;
    public final int format;
    public final int type;
    public final int attachment;

    public static TextureFormat getByName(String name) {
        try {
            return TextureFormat.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            e.printStackTrace();
            return RGBA_U8;
        }
    }

    private TextureFormat(int internal, int format, int type, int attachment) {
        this.internal = internal;
        this.format = format;
        this.type = type;
        this.attachment = attachment;
    }

    public boolean isDepth() {
        return this.format == 6402;
    }

    public boolean isColor() {
        return this.attachment == 36064;
    }
}

