/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.audio;

import java.io.File;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.audio.wav.WaveWriter;
import mchorse.bbs_mod.camera.clips.misc.AudioClientClip;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.UIFilmPanel;
import mchorse.bbs_mod.ui.film.audio.OpenALRecorder;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIPromptOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.utils.EventPropagation;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.interps.Lerps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UIAudioRecorder
extends UIElement {
    private static String lastInput = "";
    private final OpenALRecorder recorder;
    private float volume;

    public UIAudioRecorder(OpenALRecorder recorder) {
        this.recorder = recorder;
        this.eventPropagataion(EventPropagation.BLOCK);
    }

    public static void addOption(UIFilmPanel filmPanel, ContextMenuManager menu) {
        UIContext context = filmPanel.getContext();
        String timestampFilename = StringUtils.createTimestampFilename();
        String value = lastInput.isEmpty() ? timestampFilename : lastInput;
        menu.action(Icons.SOUND, UIKeys.CAMERA_TIMELINE_CONTEXT_RECORD_MICROPHONE, () -> {
            UIPromptOverlayPanel panel = new UIPromptOverlayPanel(UIKeys.CAMERA_TIMELINE_CONTEXT_RECORD_MICROPHONE_TITLE, UIKeys.CAMERA_TIMELINE_CONTEXT_RECORD_MICROPHONE_DESCRIPTION, t -> {
                String newT = t.isEmpty() ? timestampFilename : t;
                UIElement overlay = context.menu.overlay;
                OpenALRecorder recorder = new OpenALRecorder(wave -> {
                    try {
                        File file = new File(BBSMod.getAudioFolder(), newT + ".wav");
                        AudioClientClip clip = new AudioClientClip();
                        Clips clips = filmPanel.cameraEditor.clips.getClips();
                        file.getParentFile().mkdirs();
                        WaveWriter.write(file, wave);
                        clip.audio.set(Link.assets("audio/" + newT + ".wav"));
                        clip.duration.set((int)(wave.getDuration() * 20.0f));
                        clip.layer.set(clips.getTopLayer() + 1);
                        clips.addClip(clip);
                        filmPanel.cameraEditor.clips.clearSelection();
                        filmPanel.cameraEditor.clips.pickClip(clip);
                        lastInput = newT.equals(value) ? "" : newT;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                UIAudioRecorder audioRecorder = new UIAudioRecorder(recorder);
                audioRecorder.full(overlay);
                audioRecorder.resize();
                overlay.add((IUIElement)audioRecorder);
                Thread thread = new Thread((Runnable)recorder, "\u0421\u0443\u043f\u0435\u0440 \u043a\u043b\u0430\u0441\u0441\u043d\u044b\u0439, \u044f \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u0442\u0432\u043e\u0439 \u043c\u0438\u043a\u0440\u043e\u0444\u043e\u043d \u0445\u0438\u0445\u0438\u0445\u0438 :3");
                thread.start();
            });
            panel.text.setText(value);
            panel.text.path();
            UIOverlay.addOverlay(context, panel);
        });
    }

    @Override
    protected boolean subKeyPressed(UIContext context) {
        if (context.isPressed(256)) {
            this.recorder.stop();
            context.render.postRunnable(this::removeFromParent);
            return true;
        }
        return super.subKeyPressed(context);
    }

    @Override
    public void render(UIContext context) {
        this.volume = Lerps.lerp(this.volume, Interpolations.CUBIC_OUT.interpolate(0.0f, 1.0f, this.recorder.getVolume()), 0.5f);
        String label = UIKeys.CAMERA_TIMELINE_CONTEXT_RECORD_MICROPHONE_LABEL.format(Float.valueOf((float)this.recorder.getTime() / 1000.0f)).get();
        int x = this.area.mx();
        int y = this.area.my();
        int w = context.batcher.getFont().getWidth(label);
        double volume = Interpolations.EXP_OUT.interpolate(0.0f, 1.0f, this.volume);
        context.batcher.box(this.area.x, this.area.y, this.area.ex(), this.area.ey(), -2013265920);
        context.batcher.icon(Icons.SPHERE, -52429, x - w / 2 - 12, y + context.batcher.getFont().getHeight() / 2, 0.5f, 0.5f);
        context.batcher.textShadow(label, x - w / 2, y);
        label = UIKeys.CAMERA_TIMELINE_CONTEXT_RECORD_MICROPHONE_SUBLABEL.get();
        w = context.batcher.getFont().getWidth(label);
        context.batcher.textShadow(label, x - w / 2, this.area.y(0.75f));
        context.batcher.box(x -= w / 2, y + 16, x + w, y + 20, -16777216);
        context.batcher.box(x, y + 16, x + (int)((double)w * volume), y + 20, -1);
        super.render(context);
    }
}

