/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.film.clips;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.camera.clips.misc.CurveClip;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.film.IUIClipsDelegate;
import mchorse.bbs_mod.ui.film.clips.UIClip;
import mchorse.bbs_mod.ui.film.replays.UIReplaysEditor;
import mchorse.bbs_mod.ui.film.utils.keyframes.UIFilmKeyframes;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeEditor;
import mchorse.bbs_mod.ui.framework.elements.input.keyframes.UIKeyframeSheet;
import mchorse.bbs_mod.ui.framework.elements.overlay.UILabelListOverlayPanel;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlay;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.Label;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.clips.Clips;
import mchorse.bbs_mod.utils.iris.ShaderCurves;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class UICurveClip
extends UIClip<CurveClip> {
    public UIKeyframeEditor keyframes;
    public UIButton edit;

    public UICurveClip(CurveClip clip, IUIClipsDelegate editor) {
        super(clip, editor);
    }

    public static void offerCurveKeys(UIContext context, List<String> existing, Consumer<String> callback) {
        ArrayList<Label<String>> list = new ArrayList<Label<String>>();
        String language = BBSModClient.getLanguageKey();
        Map<String, String> languageMap = BBSRendering.getShadersLanguageMap(language);
        for (ShaderCurves.ShaderVariable value : ShaderCurves.variableMap.values()) {
            if (existing.contains(value.name)) continue;
            Object key = value.name;
            String newKey = languageMap.get("option." + (String)key);
            if (newKey != null) {
                key = newKey + " (" + (String)key + ")";
            }
            list.add(new Label<CallSite>(IKey.constant((String)key), (CallSite)((Object)("curve." + value.name))));
        }
        if (!existing.contains("brightness")) {
            list.add(new Label<String>(UIKeys.CAMERA_PANELS_CURVES_BRIGHTNESS, "brightness"));
        }
        if (!existing.contains("sun_rotation")) {
            list.add(new Label<String>(UIKeys.CAMERA_PANELS_CURVES_SUN_ROTATION, "sun_rotation"));
        }
        if (!existing.contains("weather")) {
            list.add(new Label<String>(UIKeys.CAMERA_PANELS_CURVES_WEATHER, "weather"));
        }
        UILabelListOverlayPanel panel = new UILabelListOverlayPanel(UIKeys.CAMERA_PANELS_PICK_KEY, list, callback);
        panel.strings.list.sort();
        UIOverlay.addOverlay(context, (UIOverlayPanel)panel, 0.9f, 0.5f);
    }

    @Override
    protected void registerUI() {
        super.registerUI();
        this.keyframes = new UIKeyframeEditor(consumer -> new UIFilmKeyframes(this.editor, (Consumer<Keyframe>)consumer));
        this.keyframes.view.backgroundRenderer(context -> UIReplaysEditor.renderBackground(context, this.keyframes.view, (Clips)((CurveClip)this.clip).getParent(), (Integer)((CurveClip)this.clip).tick.get()));
        this.keyframes.view.duration(() -> (Integer)((CurveClip)this.clip).duration.get());
        this.keyframes.setUndoId("curve_keyframes");
        this.keyframes.view.context((ContextMenuManager menu) -> {
            menu.action(Icons.ADD, UIKeys.CAMERA_PANELS_CURVE_ADD, () -> {
                ArrayList<String> existing = new ArrayList<String>();
                for (KeyframeChannel<Double> channel : ((CurveClip)this.clip).channels.getChannels()) {
                    existing.add(channel.getId());
                }
                UICurveClip.offerCurveKeys(this.getContext(), existing, s -> {
                    ((CurveClip)this.clip).channels.addChannel((String)s);
                    this.fillData();
                });
            }).order(-3);
            UIKeyframeSheet sheet = this.keyframes.view.getDopeSheet().getSheet(this.getContext().mouseY);
            if (sheet != null) {
                menu.action(Icons.REMOVE, UIKeys.CAMERA_PANELS_CURVE_REMOVE, 0xFF3333, () -> {
                    ((CurveClip)this.clip).channels.removeChannel(sheet.channel);
                    this.fillData();
                });
            }
        });
        this.edit = new UIButton(UIKeys.CAMERA_PANELS_EDIT_KEYFRAMES, b -> {
            this.editor.embedView(this.keyframes);
            this.keyframes.view.resetView();
            this.keyframes.view.getGraph().clearSelection();
        });
        this.edit.keys().register(Keys.FORMS_EDIT, () -> this.edit.clickItself());
    }

    private void addChannel(KeyframeChannel<Double> channel) {
        this.keyframes.view.addSheet(new UIKeyframeSheet(channel.getId(), IKey.constant(channel.getId()), channel.getId().hashCode() & 0xFFFFFF, false, channel, null));
    }

    @Override
    protected void registerPanels() {
        super.registerPanels();
        this.panels.add(UIClip.label(UIKeys.C_CLIP.get("bbs:curve")).marginTop(12), this.edit);
    }

    @Override
    public void fillData() {
        super.fillData();
        this.keyframes.view.removeAllSheets();
        for (KeyframeChannel<Double> channel : ((CurveClip)this.clip).channels.getChannels()) {
            this.addChannel(channel);
        }
    }

    @Override
    public void updateDuration(int duration) {
        super.updateDuration(duration);
        this.keyframes.updateConverter();
    }

    @Override
    public void applyUndoData(MapType data) {
        if (data.getString("embed").equals("curve")) {
            this.editor.embedView(this.keyframes);
            this.keyframes.view.resetView();
        }
        super.applyUndoData(data);
    }

    @Override
    public void collectUndoData(MapType data) {
        if (this.keyframes.hasParent()) {
            data.putString("embed", "curve");
        }
        super.collectUndoData(data);
    }
}

