/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.forms.editors.panels;

import java.io.InputStream;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.StructureForm;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.resources.Link;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.forms.editors.forms.UIForm;
import mchorse.bbs_mod.ui.forms.editors.panels.UIFormPanel;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIButton;
import mchorse.bbs_mod.ui.framework.elements.buttons.UIToggle;
import mchorse.bbs_mod.ui.framework.elements.input.UIKeybind;
import mchorse.bbs_mod.ui.framework.elements.input.UIPropTransform;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.text.UITextbox;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.keys.KeyCombo;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;

@Environment(value=EnvType.CLIENT)
public class UIGeneralFormPanel
extends UIFormPanel {
    public UIKeybind hotkey = new UIKeybind(combo -> this.form.hotkey.set(combo.keys.isEmpty() ? 0 : combo.keys.get(0)));
    public UIToggle visible;
    public UIToggle animatable;
    public UITextbox trackName;
    public UIToggle lighting;
    public UIToggle shaderShadow;
    public UITrackpad uiScale;
    public UITextbox name;
    public UIPropTransform transform;
    public UIButton calcCenter;
    public UIToggle hitbox;
    public UITrackpad hitboxWidth;
    public UITrackpad hitboxHeight;
    public UITrackpad hitboxSneakMultiplier;
    public UITrackpad hitboxEyeHeight;
    public UITrackpad hp;
    public UITrackpad speed;
    public UITrackpad stepHeight;

    public UIGeneralFormPanel(UIForm editor) {
        super(editor);
        this.hotkey.single().tooltip(UIKeys.FORMS_EDITORS_GENERAL_HOTKEY);
        this.visible = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_VISIBLE, b -> this.form.visible.set(b.getValue()));
        this.animatable = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_ANIMATABLE, b -> this.form.animatable.set(b.getValue()));
        this.animatable.tooltip(UIKeys.FORMS_EDITORS_GENERAL_ANIMATABLE_TOOLTIP);
        this.trackName = new UITextbox(120, t -> this.form.trackName.set(t));
        this.trackName.tooltip(UIKeys.FORMS_EDITORS_GENERAL_TRACK_NAME_TOOLTIP);
        this.lighting = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_LIGHTING, b -> this.form.lighting.set(Float.valueOf(b.getValue() ? 1.0f : 0.0f)));
        this.lighting.tooltip(UIKeys.FORMS_EDITORS_GENERAL_LIGHTING_TOOLTIP);
        this.shaderShadow = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_SHADER_SHADOW, b -> this.form.shaderShadow.set(b.getValue()));
        this.uiScale = new UITrackpad(v -> this.form.uiScale.set(Float.valueOf(v.floatValue())));
        this.uiScale.limit(0.01, 100.0);
        this.name = new UITextbox(120, t -> this.form.name.set(t));
        this.transform = new UIPropTransform().callbacks(() -> this.form.transform);
        this.transform.enableHotkeys().relative(this).x(0.5f).y(1.0f, -10).anchor(0.5f, 1.0f);
        this.hitbox = new UIToggle(UIKeys.FORMS_EDITORS_GENERAL_HITBOX, b -> this.form.hitbox.set(b.getValue()));
        this.hitboxWidth = new UITrackpad(v -> this.form.hitboxWidth.set(Float.valueOf(v.floatValue())));
        this.hitboxWidth.limit(0.0).tooltip(UIKeys.FORMS_EDITORS_GENERAL_HITBOX_WIDTH);
        this.hitboxHeight = new UITrackpad(v -> this.form.hitboxHeight.set(Float.valueOf(v.floatValue())));
        this.hitboxHeight.limit(0.0).tooltip(UIKeys.FORMS_EDITORS_GENERAL_HITBOX_HEIGHT);
        this.hitboxSneakMultiplier = new UITrackpad(v -> this.form.hitboxSneakMultiplier.set(Float.valueOf(v.floatValue())));
        this.hitboxSneakMultiplier.limit(0.0, 1.0);
        this.hitboxEyeHeight = new UITrackpad(v -> this.form.hitboxEyeHeight.set(Float.valueOf(v.floatValue())));
        this.hitboxEyeHeight.limit(0.0, 1.0);
        this.hp = new UITrackpad(v -> this.form.hp.set(Float.valueOf(v.floatValue())));
        this.hp.limit(1.0);
        this.speed = new UITrackpad(v -> this.form.speed.set(Float.valueOf(v.floatValue())));
        this.speed.limit(0.0);
        this.stepHeight = new UITrackpad(v -> this.form.stepHeight.set(Float.valueOf(v.floatValue())));
        this.stepHeight.limit(0.0);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_DISPLAY), this.name);
        this.options.add(this.hotkey, this.visible, this.animatable, this.trackName, this.lighting, this.shaderShadow);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_UI_SCALE), this.uiScale);
        this.options.add((IUIElement)this.transform.marginTop(8));
        this.options.add(this.hitbox.marginTop(12), UI.row(this.hitboxWidth, this.hitboxHeight));
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_HITBOX_SNEAK_MULTIPLIER), this.hitboxSneakMultiplier);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_HITBOX_EYE_HEIGHT), this.hitboxEyeHeight);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_HP).marginTop(12), this.hp);
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_MOVEMENT_SPEED), this.speed.tooltip(UIKeys.FORMS_EDITORS_GENERAL_MOVEMENT_SPEED_TOOLTIP));
        this.options.add(UI.label(UIKeys.FORMS_EDITORS_GENERAL_STEP_HEIGHT), this.stepHeight);
    }

    public void startEdit(Form form) {
        super.startEdit(form);
        this.hotkey.setKeyCombo(new KeyCombo(IKey.EMPTY, (Integer)form.hotkey.get()));
        this.visible.setValue((Boolean)form.visible.get());
        this.animatable.setValue((Boolean)form.animatable.get());
        this.trackName.setText((String)form.trackName.get());
        this.lighting.setValue(((Float)form.lighting.get()).floatValue() > 0.0f);
        this.shaderShadow.setValue((Boolean)form.shaderShadow.get());
        this.uiScale.setValue(((Float)form.uiScale.get()).floatValue());
        this.name.setText((String)form.name.get());
        this.transform.setTransform((Transform)form.transform.get());
        if (form instanceof StructureForm) {
            if (this.calcCenter == null) {
                this.calcCenter = new UIButton(UIKeys.FORMS_EDITORS_STRUCTURE_CALCULATE_CENTER, b -> this.calculateCenterForStructure((StructureForm)form));
            }
            if (!this.calcCenter.hasParent()) {
                this.options.add((IUIElement)this.calcCenter);
            }
        } else if (this.calcCenter != null && this.calcCenter.hasParent()) {
            this.calcCenter.removeFromParent();
        }
        this.hitbox.setValue((Boolean)form.hitbox.get());
        this.hitboxWidth.setValue(((Float)form.hitboxWidth.get()).floatValue());
        this.hitboxHeight.setValue(((Float)form.hitboxHeight.get()).floatValue());
        this.hitboxSneakMultiplier.setValue(((Float)form.hitboxSneakMultiplier.get()).floatValue());
        this.hitboxEyeHeight.setValue(((Float)form.hitboxEyeHeight.get()).floatValue());
        this.hp.setValue(((Float)form.hp.get()).floatValue());
        this.speed.setValue(((Float)form.speed.get()).floatValue());
        this.stepHeight.setValue(((Float)form.stepHeight.get()).floatValue());
    }

    private void calculateCenterForStructure(StructureForm s) {
        String path = (String)s.structureFile.get();
        if (path == null || path.isEmpty()) {
            return;
        }
        try (InputStream is = BBSMod.getProvider().getAsset(Link.assets(path));){
            class_2487 root = class_2507.method_10629((InputStream)is);
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            if (root.method_10573("blocks", 9)) {
                class_2499 list = root.method_10554("blocks", 10);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 be = list.method_10602(i);
                    class_2499 pos = be.method_10554("pos", 3);
                    if (pos == null || pos.size() < 3) continue;
                    int x = pos.method_10600(0);
                    int y = pos.method_10600(1);
                    int z = pos.method_10600(2);
                    if (x < minX) {
                        minX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (z < minZ) {
                        minZ = z;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                    if (z <= maxZ) continue;
                    maxZ = z;
                }
            }
            if (minX != Integer.MAX_VALUE) {
                float cx = (float)(minX + maxX) / 2.0f;
                float cy = (float)(minY + maxY) / 2.0f;
                float cz = (float)(minZ + maxZ) / 2.0f;
                int widthX = maxX - minX + 1;
                int widthY = maxY - minY + 1;
                int widthZ = maxZ - minZ + 1;
                float parityX = widthX % 2 == 1 ? -0.5f : 0.0f;
                float parityY = widthY % 2 == 1 ? -0.5f : 0.0f;
                float parityZ = widthZ % 2 == 1 ? -0.5f : 0.0f;
                s.pivotX.set(Float.valueOf(cx - parityX));
                s.pivotY.set(Float.valueOf(cy - parityY));
                s.pivotZ.set(Float.valueOf(cz - parityZ));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

