/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input;

import java.util.function.Supplier;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.gizmos.BoneGizmoSystem;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.settings.values.IValueNotifier;
import mchorse.bbs_mod.ui.Keys;
import mchorse.bbs_mod.ui.UIKeys;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.IUIElement;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.input.UITrackpad;
import mchorse.bbs_mod.ui.framework.elements.input.UITransform;
import mchorse.bbs_mod.ui.framework.elements.utils.FontRenderer;
import mchorse.bbs_mod.ui.utils.Gizmo;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import mchorse.bbs_mod.utils.Axis;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.Timer;
import mchorse.bbs_mod.utils.pose.Transform;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class UIPropTransform
extends UITransform {
    private static final double[] CURSOR_X = new double[1];
    private static final double[] CURSOR_Y = new double[1];
    private Transform transform;
    private Runnable preCallback;
    private Runnable postCallback;
    private boolean editing;
    private int mode;
    private Axis axis = Axis.X;
    private int lastX;
    private Transform cache = new Transform();
    private Timer checker = new Timer(30L);
    private boolean model;
    private boolean local;
    private UITransformHandler handler = new UITransformHandler(this);

    public UIPropTransform() {
        this.context((ContextMenuManager menu) -> {
            menu.action(this.local ? Icons.FULLSCREEN : Icons.MINIMIZE, this.local ? UIKeys.TRANSFORMS_CONTEXT_SWITCH_GLOBAL : UIKeys.TRANSFORMS_CONTEXT_SWITCH_LOCAL, this::toggleLocal);
            menu.actions.add(0, menu.actions.remove(menu.actions.size() - 1));
        });
        this.iconT.callback = b -> this.toggleLocal();
        this.iconT.hoverColor = -3355444;
        this.iconT.setEnabled(true);
        this.iconT.tooltip(this.local ? UIKeys.TRANSFORMS_CONTEXT_SWITCH_GLOBAL : UIKeys.TRANSFORMS_CONTEXT_SWITCH_LOCAL);
        this.noCulling();
    }

    public UIPropTransform callbacks(Supplier<IValueNotifier> notifier) {
        return this.callbacks(() -> ((IValueNotifier)notifier.get()).preNotify(), () -> ((IValueNotifier)notifier.get()).postNotify());
    }

    public UIPropTransform callbacks(Runnable pre, Runnable post) {
        this.preCallback = pre;
        this.postCallback = post;
        return this;
    }

    public void preCallback() {
        if (this.preCallback != null) {
            this.preCallback.run();
        }
    }

    public void postCallback() {
        if (this.postCallback != null) {
            this.postCallback.run();
        }
    }

    public void setModel() {
        this.model = true;
    }

    public boolean isLocal() {
        return this.local;
    }

    private void toggleLocal() {
        boolean bl = this.local = !this.local;
        if (!this.local) {
            this.fillT(this.transform.translate.x, this.transform.translate.y, this.transform.translate.z);
        }
        this.tx.forcedLabel(this.local ? UIKeys.GENERAL_X : null);
        this.ty.forcedLabel(this.local ? UIKeys.GENERAL_Y : null);
        this.tz.forcedLabel(this.local ? UIKeys.GENERAL_Z : null);
        this.tx.relative(this.local);
        this.ty.relative(this.local);
        this.tz.relative(this.local);
        this.iconT.tooltip(this.local ? UIKeys.TRANSFORMS_CONTEXT_SWITCH_GLOBAL : UIKeys.TRANSFORMS_CONTEXT_SWITCH_LOCAL);
    }

    private Vector3f calculateLocalVector(double factor, Axis axis) {
        Vector3f vector3f = new Vector3f((float)(axis == Axis.X ? factor : 0.0), (float)(axis == Axis.Y ? factor : 0.0), (float)(axis == Axis.Z ? factor : 0.0));
        Matrix3f matrix = new Matrix3f().rotateX(this.model ? (float)Math.PI : 0.0f).mul((Matrix3fc)this.transform.createRotationMatrix());
        matrix.transform(vector3f);
        return vector3f;
    }

    public UIPropTransform enableHotkeys() {
        IKey category = UIKeys.GIZMOS_KEYS_CATEGORY;
        Supplier<Boolean> active = () -> this.editing;
        this.keys().register(Keys.GIZMOS_TRANSLATE, () -> {
            if (((Boolean)BBSSettings.gizmos.get()).booleanValue() && (Integer)BBSSettings.gizmoDesign.get() != 0) {
                BoneGizmoSystem.get().setMode(BoneGizmoSystem.Mode.TRANSLATE);
            } else {
                this.enableMode(0);
            }
        }).category(category);
        this.keys().register(Keys.GIZMOS_SCALE, () -> {
            if (((Boolean)BBSSettings.gizmos.get()).booleanValue() && (Integer)BBSSettings.gizmoDesign.get() != 0) {
                BoneGizmoSystem.get().setMode(BoneGizmoSystem.Mode.SCALE);
            } else {
                this.enableMode(1);
            }
        }).category(category);
        this.keys().register(Keys.GIZMOS_ROTATE, () -> {
            if (((Boolean)BBSSettings.gizmos.get()).booleanValue() && (Integer)BBSSettings.gizmoDesign.get() != 0) {
                BoneGizmoSystem.get().setMode(BoneGizmoSystem.Mode.ROTATE);
            } else {
                this.enableMode(2);
            }
        }).category(category);
        this.keys().register(Keys.GIZMOS_TOGGLE_ENABLED, () -> {
            if (((Boolean)BBSSettings.gizmos.get()).booleanValue() && (Integer)BBSSettings.gizmoDesign.get() != 0) {
                BoneGizmoSystem.get().cycleMode(true);
            } else {
                this.enableMode((this.mode + 1) % 3);
            }
        }).category(category);
        this.keys().register(Keys.GIZMOS_PIVOT, () -> {
            if (((Boolean)BBSSettings.gizmos.get()).booleanValue() && (Integer)BBSSettings.gizmoDesign.get() != 0) {
                BoneGizmoSystem.get().setMode(BoneGizmoSystem.Mode.PIVOT);
            }
        }).active(() -> (Boolean)BBSSettings.gizmos.get() != false && (Integer)BBSSettings.gizmoDesign.get() != 0).category(UIKeys.GIZMOS_KEYS_CATEGORY);
        this.keys().register(Keys.GIZMOS_TOGGLE_ROTATION_CHANNEL, () -> {
            if (((Boolean)BBSSettings.gizmos.get()).booleanValue() && (Integer)BBSSettings.gizmoDesign.get() != 0) {
                BoneGizmoSystem.get().toggleRotationChannel();
            }
        }).active(() -> (Boolean)BBSSettings.gizmos.get() != false && (Integer)BBSSettings.gizmoDesign.get() != 0).category(UIKeys.GIZMOS_KEYS_CATEGORY);
        Supplier<Boolean> axisActive = () -> this.editing && ((Boolean)BBSSettings.gizmos.get() == false || (Integer)BBSSettings.gizmoDesign.get() == 0);
        this.keys().register(Keys.TRANSFORMATIONS_X, () -> {
            this.axis = Axis.X;
        }).active(axisActive).category(UIKeys.TRANSFORMS_KEYS_CATEGORY);
        this.keys().register(Keys.TRANSFORMATIONS_Y, () -> {
            this.axis = Axis.Y;
        }).active(axisActive).category(UIKeys.TRANSFORMS_KEYS_CATEGORY);
        this.keys().register(Keys.TRANSFORMATIONS_Z, () -> {
            this.axis = Axis.Z;
        }).active(axisActive).category(UIKeys.TRANSFORMS_KEYS_CATEGORY);
        this.keys().register(Keys.TRANSFORMATIONS_TRANSLATE, () -> this.enableMode(0)).category(category);
        this.keys().register(Keys.TRANSFORMATIONS_SCALE, () -> this.enableMode(1)).category(category);
        this.keys().register(Keys.TRANSFORMATIONS_ROTATE, () -> this.enableMode(2)).category(category);
        this.keys().register(Keys.TRANSFORMATIONS_X, () -> {
            this.axis = Axis.X;
        }).active(active).category(category);
        this.keys().register(Keys.TRANSFORMATIONS_Y, () -> {
            this.axis = Axis.Y;
        }).active(active).category(category);
        this.keys().register(Keys.TRANSFORMATIONS_Z, () -> {
            this.axis = Axis.Z;
        }).active(active).category(category);
        this.keys().register(Keys.TRANSFORMATIONS_TOGGLE_LOCAL, () -> {
            this.toggleLocal();
            UIUtils.playClick();
        }).category(category);
        return this;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void refillTransform() {
        this.setTransform(this.getTransform());
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        float minScale = Math.min(transform.scale.x, Math.min(transform.scale.y, transform.scale.z));
        float maxScale = Math.max(transform.scale.x, Math.max(transform.scale.y, transform.scale.z));
        if (((Boolean)BBSSettings.uniformScale.get()).booleanValue() && (minScale == maxScale && !this.isUniformScale() || minScale != maxScale && this.isUniformScale())) {
            this.toggleUniformScale();
        }
        this.fillT(transform.translate.x, transform.translate.y, transform.translate.z);
        this.fillS(transform.scale.x, transform.scale.y, transform.scale.z);
        this.fillR(MathUtils.toDeg(transform.rotate.x), MathUtils.toDeg(transform.rotate.y), MathUtils.toDeg(transform.rotate.z));
        this.fillR2(MathUtils.toDeg(transform.rotate2.x), MathUtils.toDeg(transform.rotate2.y), MathUtils.toDeg(transform.rotate2.z));
        this.fillP(transform.pivot.x, transform.pivot.y, transform.pivot.z);
    }

    public void enableMode(int mode) {
        this.enableMode(mode, null);
    }

    public void enableMode(int mode, Axis axis) {
        if (Gizmo.INSTANCE.setMode(Gizmo.Mode.values()[mode]) && axis == null) {
            return;
        }
        UIContext context = this.getContext();
        if (this.editing) {
            Axis[] values = Axis.values();
            this.axis = values[MathUtils.cycler(this.axis.ordinal() + 1, 0, values.length - 1)];
            this.restore(true);
        } else {
            this.axis = axis == null ? Axis.X : axis;
            this.lastX = context.mouseX;
        }
        this.editing = true;
        this.mode = mode;
        this.cache.copy(this.transform);
        if (!this.handler.hasParent()) {
            context.menu.overlay.add((IUIElement)this.handler);
        }
    }

    private Vector3f getValue() {
        if (this.mode == 1) {
            return this.transform.scale;
        }
        if (this.mode == 2) {
            return this.local && (Boolean)BBSSettings.gizmos.get() != false && (Integer)BBSSettings.gizmoDesign.get() != 0 ? this.transform.rotate2 : this.transform.rotate;
        }
        return this.transform.translate;
    }

    private void restore(boolean fully) {
        if (this.mode == 0 || fully) {
            this.setT(null, this.cache.translate.x, this.cache.translate.y, this.cache.translate.z);
        }
        if (this.mode == 1 || fully) {
            this.setS(null, this.cache.scale.x, this.cache.scale.y, this.cache.scale.z);
        }
        if (this.mode == 2 || fully) {
            this.setR(null, MathUtils.toDeg(this.cache.rotate.x), MathUtils.toDeg(this.cache.rotate.y), MathUtils.toDeg(this.cache.rotate.z));
            this.setR2(null, MathUtils.toDeg(this.cache.rotate2.x), MathUtils.toDeg(this.cache.rotate2.y), MathUtils.toDeg(this.cache.rotate2.z));
        }
    }

    private void disable() {
        this.editing = false;
        if (this.handler.hasParent()) {
            this.handler.removeFromParent();
        }
    }

    public void acceptChanges() {
        this.disable();
        this.setTransform(this.transform);
    }

    public void rejectChanges() {
        this.disable();
        this.restore(true);
        this.setTransform(this.transform);
    }

    @Override
    protected void internalSetT(double x, Axis axis) {
        if (this.local) {
            try {
                Vector3f vector3f = this.calculateLocalVector(x, axis);
                this.setT(null, this.transform.translate.x + vector3f.x, this.transform.translate.y + vector3f.y, this.transform.translate.z + vector3f.z);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.internalSetT(x, axis);
        }
    }

    @Override
    public void setT(Axis axis, double x, double y, double z) {
        this.preCallback();
        this.transform.translate.set((float)x, (float)y, (float)z);
        this.postCallback();
    }

    @Override
    public void setS(Axis axis, double x, double y, double z) {
        this.preCallback();
        this.transform.scale.set((float)x, (float)y, (float)z);
        this.postCallback();
    }

    @Override
    public void setR(Axis axis, double x, double y, double z) {
        this.preCallback();
        this.transform.rotate.set(MathUtils.toRad((float)x), MathUtils.toRad((float)y), MathUtils.toRad((float)z));
        this.postCallback();
    }

    @Override
    public void setR2(Axis axis, double x, double y, double z) {
        this.preCallback();
        this.transform.rotate2.set(MathUtils.toRad((float)x), MathUtils.toRad((float)y), MathUtils.toRad((float)z));
        this.postCallback();
    }

    @Override
    public void setP(Axis axis, double x, double y, double z) {
        this.preCallback();
        this.transform.pivot.set((float)x, (float)y, (float)z);
        this.postCallback();
    }

    @Override
    protected boolean subKeyPressed(UIContext context) {
        if (this.editing) {
            if (context.isPressed(257)) {
                this.acceptChanges();
                return true;
            }
            if (context.isPressed(256)) {
                this.rejectChanges();
                return true;
            }
        }
        return super.subKeyPressed(context);
    }

    @Override
    public void render(UIContext context) {
        if (this.editing && this.checker.isTime()) {
            GLFW.glfwGetCursorPos((long)Window.getWindow(), (double[])CURSOR_X, (double[])CURSOR_Y);
            class_310 mc = class_310.method_1551();
            int w = mc.method_22683().method_4480();
            double rawX = CURSOR_X[0];
            double fx = Math.ceil((double)w / (double)context.menu.width);
            int border = 5;
            int borderPadding = border + 1;
            if (rawX <= (double)border) {
                Window.moveCursor(w - borderPadding, (int)mc.field_1729.method_1604());
                this.lastX = context.menu.width - (int)((double)borderPadding / fx);
                this.checker.mark();
            } else if (rawX >= (double)(w - border)) {
                Window.moveCursor(borderPadding, (int)mc.field_1729.method_1604());
                this.lastX = (int)((double)borderPadding / fx);
                this.checker.mark();
            } else {
                boolean all;
                int dx = context.mouseX - this.lastX;
                Vector3f vector = this.getValue();
                boolean bl = all = this.mode == 1 && Window.isCtrlPressed();
                UITrackpad reference = this.mode == 0 ? this.tx : (this.mode == 1 ? this.sx : this.rx);
                float factor = (float)reference.getValueModifier();
                if (this.local && this.mode == 0) {
                    Vector3f vector3f = this.calculateLocalVector(factor * (float)dx, this.axis);
                    this.setT(null, vector.x + vector3f.x, vector.y + vector3f.y, vector.z + vector3f.z);
                } else {
                    Vector3f vector3f = new Vector3f((Vector3fc)vector);
                    if (this.mode == 2) {
                        vector3f.mul(57.295776f);
                    }
                    if (this.axis == Axis.X || all) {
                        vector3f.x += factor * (float)dx;
                    }
                    if (this.axis == Axis.Y || all) {
                        vector3f.y += factor * (float)dx;
                    }
                    if (this.axis == Axis.Z || all) {
                        vector3f.z += factor * (float)dx;
                    }
                    if (this.mode == 0) {
                        this.setT(null, vector3f.x, vector3f.y, vector3f.z);
                    }
                    if (this.mode == 1) {
                        this.setS(null, vector3f.x, vector3f.y, vector3f.z);
                    }
                    if (this.mode == 2) {
                        if (this.local && ((Boolean)BBSSettings.gizmos.get()).booleanValue()) {
                            this.setR2(null, vector3f.x, vector3f.y, vector3f.z);
                        } else {
                            this.setR(null, vector3f.x, vector3f.y, vector3f.z);
                        }
                    }
                }
                this.setTransform(this.transform);
                this.lastX = context.mouseX;
            }
        }
        super.render(context);
        if (this.editing) {
            String label = UIKeys.TRANSFORMS_EDITING.get();
            FontRenderer font = context.batcher.getFont();
            int x = this.area.mx(font.getWidth(label));
            int y = this.area.my(font.getHeight());
            context.batcher.textCard(label, x, y, -1, BBSSettings.primaryColor(-2013265920));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class UITransformHandler
    extends UIElement {
        private UIPropTransform transform;

        public UITransformHandler(UIPropTransform transform) {
            this.transform = transform;
        }

        @Override
        protected boolean subMouseClicked(UIContext context) {
            if (this.transform.editing) {
                if (context.mouseButton == 0) {
                    this.transform.acceptChanges();
                    return true;
                }
                if (context.mouseButton == 1) {
                    this.transform.rejectChanges();
                    return true;
                }
            }
            return super.subMouseClicked(context);
        }

        @Override
        protected boolean subMouseScrolled(UIContext context) {
            UITrackpad.updateAmplifier(context);
            return true;
        }
    }
}

