/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.input.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.utils.Scroll;
import mchorse.bbs_mod.ui.utils.keys.KeyCodes;
import mchorse.bbs_mod.utils.Pair;
import mchorse.bbs_mod.utils.colors.Colors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UIList<T>
extends UIElement {
    protected List<T> list = new ArrayList<T>();
    private List<T> copy = new ArrayList<T>();
    public Scroll scroll;
    public Consumer<List<T>> callback;
    public List<Integer> current = new ArrayList<Integer>();
    public boolean multi;
    public boolean sorting;
    public int background;
    private String filter = "";
    private List<Pair<T, Integer>> filtered = new ArrayList<Pair<T, Integer>>();
    private int dragging = -1;
    private long dragTime;

    public UIList(Consumer<List<T>> callback) {
        this.callback = callback;
        this.scroll = new Scroll(this.area, 20);
    }

    public UIList<T> background() {
        return this.background(-2013265920);
    }

    public UIList<T> background(int color) {
        this.background = color;
        return this;
    }

    public UIList<T> multi() {
        this.multi = true;
        return this;
    }

    public UIList<T> sorting() {
        this.sorting = true;
        return this;
    }

    public UIList<T> cancelScrollEdge() {
        this.scroll.cancelScrollEdge = true;
        return this;
    }

    public void filter(String filter) {
        if (this.filter.equals(filter = filter.toLowerCase())) {
            return;
        }
        this.filter = filter;
        this.filtered.clear();
        if (filter.isEmpty()) {
            this.update();
            return;
        }
        String qwerty = KeyCodes.cyrillicToQwerty(filter);
        for (int i = 0; i < this.list.size(); ++i) {
            T element = this.list.get(i);
            String target = this.elementToString(this.getContext(), i, element).toLowerCase();
            if (!target.contains(filter) && !target.contains(qwerty)) continue;
            this.filtered.add(new Pair<T, Integer>(element, i));
        }
        this.update();
        this.scroll.updateTarget();
    }

    public boolean isFiltering() {
        return !this.filter.isEmpty();
    }

    protected T getElementAt(int visibleIndex) {
        if (visibleIndex < 0) {
            return null;
        }
        if (!this.isFiltering()) {
            return this.exists(visibleIndex) ? (T)this.list.get(visibleIndex) : null;
        }
        return this.exists(this.filtered, visibleIndex) ? (T)this.filtered.get((int)visibleIndex).a : null;
    }

    public boolean isSelected() {
        return !this.isDeselected();
    }

    public boolean isDeselected() {
        if (this.current.isEmpty()) {
            return true;
        }
        for (Integer index : this.current) {
            if (!this.exists(index)) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getCurrentIndices() {
        return this.current;
    }

    public List<T> getCurrent() {
        this.copy.clear();
        for (Integer integer : this.current) {
            if (!this.exists(integer)) continue;
            this.copy.add(this.list.get(integer));
        }
        return this.copy;
    }

    public T getCurrentFirst() {
        int index;
        if (!this.current.isEmpty() && this.exists(index = this.current.get(0).intValue())) {
            return this.list.get(index);
        }
        return null;
    }

    public int getIndex() {
        if (this.current.isEmpty()) {
            return -1;
        }
        int index = this.current.get(0);
        return this.exists(index) ? index : -1;
    }

    public int getHoveredIndex(UIContext context) {
        if (!this.area.isInside(context)) {
            return -1;
        }
        return (context.mouseY - this.area.y + (int)this.scroll.getScroll()) / this.scroll.scrollItemSize;
    }

    public void deselect() {
        this.setIndex(-1);
    }

    public void setIndex(int index) {
        this.current.clear();
        this.addIndex(index);
    }

    public void addIndex(int index) {
        if (this.exists(index) && !this.current.contains(index)) {
            this.current.add(index);
        }
    }

    public void toggleIndex(int index) {
        if (this.exists(index)) {
            int i = this.current.indexOf(index);
            if (i == -1) {
                this.current.add(index);
            } else {
                this.current.remove(i);
            }
        }
    }

    public void setCurrent(T element) {
        this.current.clear();
        int index = this.list.indexOf(element);
        if (this.exists(index)) {
            this.current.add(index);
        }
    }

    public void setCurrentDirect(T element) {
        this.current.clear();
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i) != element) continue;
            this.current.add(i);
            return;
        }
    }

    public void setCurrent(List<T> elements) {
        if (!this.multi && !elements.isEmpty()) {
            this.setCurrent(elements.get(0));
            return;
        }
        this.current.clear();
        for (T element : elements) {
            int index = this.list.indexOf(element);
            if (!this.exists(index)) continue;
            this.current.add(index);
        }
    }

    public void setCurrentScroll(T element) {
        this.setCurrent(element);
        if (!this.current.isEmpty()) {
            this.scroll.setScroll(this.current.get(0) * this.scroll.scrollItemSize);
        }
    }

    public boolean pick(int index) {
        if (index < 0 || index >= this.list.size()) {
            return false;
        }
        this.setIndex(index);
        if (this.callback != null) {
            this.callback.accept(this.getCurrent());
        }
        return true;
    }

    public void selectAll() {
        if (!this.multi) {
            return;
        }
        this.current.clear();
        for (int i = 0; i < this.list.size(); ++i) {
            this.current.add(i);
        }
    }

    public List<T> getList() {
        return this.list;
    }

    public void clear() {
        this.filter("");
        this.current.clear();
        this.list.clear();
        this.update();
    }

    public void add(T element) {
        this.list.add(element);
        this.update();
    }

    public void add(Collection<T> elements) {
        this.list.addAll(elements);
        this.update();
    }

    public void replace(T element) {
        int index;
        int n = index = this.current.size() == 1 ? this.current.get(0) : -1;
        if (this.exists(index)) {
            this.list.set(index, element);
        }
    }

    public void setList(List<T> list) {
        if (list == null) {
            return;
        }
        this.list = list;
        this.update();
    }

    public void remove(T element) {
        this.list.remove(element);
        this.update();
    }

    public final void sort() {
        List<T> current = this.getCurrent();
        if (this.sortElements()) {
            this.current.clear();
            for (T element : current) {
                this.current.add(this.list.indexOf(element));
            }
        }
    }

    protected boolean sortElements() {
        return false;
    }

    public void update() {
        this.scroll.setSize(this.isFiltering() ? this.filtered.size() : this.list.size());
        this.scroll.clamp();
    }

    public boolean exists(int index) {
        return this.exists(this.list, index);
    }

    public boolean exists(List list, int index) {
        return index >= 0 && index < list.size();
    }

    public boolean isDragging() {
        return this.exists(this.dragging) && System.currentTimeMillis() - this.dragTime > 100L;
    }

    public int getDraggingIndex() {
        return this.dragging;
    }

    @Override
    public void resize() {
        super.resize();
        this.scroll.clamp();
        this.scroll.updateTarget();
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (this.scroll.mouseClicked(context)) {
            return true;
        }
        if (this.area.isInside(context) && context.mouseButton == 0) {
            int index = this.scroll.getIndex(context.mouseX, context.mouseY);
            boolean filtering = this.isFiltering();
            if (filtering) {
                int n = index = this.exists(this.filtered, index) ? (Integer)this.filtered.get((int)index).b : -1;
            }
            if (this.exists(index)) {
                if (this.multi && Window.isShiftPressed() && this.isSelected()) {
                    int first = this.current.get(0);
                    int increment = first > index ? -1 : 1;
                    for (int i = first + increment; i != index + increment; i += increment) {
                        this.addIndex(i);
                    }
                } else if (this.multi && Window.isCtrlPressed()) {
                    this.toggleIndex(index);
                } else {
                    this.setIndex(index);
                }
                if (!filtering && this.sorting && this.current.size() == 1) {
                    this.dragging = index;
                    this.dragTime = System.currentTimeMillis();
                }
                List<T> current = this.getCurrent();
                if (this.callback != null) {
                    this.callback.accept(current);
                    return true;
                }
            }
        }
        return super.subMouseClicked(context);
    }

    @Override
    public boolean subMouseScrolled(UIContext context) {
        return this.scroll.mouseScroll(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        if (this.sorting && !this.isFiltering()) {
            if (this.isDragging()) {
                int index = this.scroll.getIndex(context.mouseX, context.mouseY);
                if (index == -2) {
                    index = this.getList().size() - 1;
                }
                if (index != this.dragging && this.exists(index)) {
                    this.handleSwap(this.dragging, index);
                }
            }
            this.dragging = -1;
        }
        this.scroll.mouseReleased(context);
        return super.subMouseReleased(context);
    }

    protected void handleSwap(int from, int to) {
        T value = this.list.remove(this.dragging);
        this.list.add(to, value);
        this.setIndex(to);
    }

    @Override
    public void render(UIContext context) {
        this.scroll.drag(context);
        if (Colors.getA(this.background) > 0.0f) {
            this.area.render(context.batcher, this.background);
        }
        context.batcher.clip(this.area, context);
        this.renderList(context);
        this.scroll.renderScrollbar(context.batcher);
        context.batcher.unclip(context);
        this.renderLockedArea(context);
        super.render(context);
        if (this.exists(this.dragging) && this.isDragging()) {
            this.renderListElement(context, this.list.get(this.dragging), this.dragging, context.mouseX + 6, context.mouseY - this.scroll.scrollItemSize / 2, true, true);
        }
    }

    public void renderList(UIContext context) {
        int i = 0;
        if (this.isFiltering()) {
            for (Pair<T, Integer> element : this.filtered) {
                if ((i = this.renderElement(context, element.a, i, (Integer)element.b, false)) != -1) continue;
                break;
            }
        } else {
            T element;
            Iterator<T> iterator = this.list.iterator();
            while (iterator.hasNext() && (i = this.renderElement(context, element = iterator.next(), i, i, false)) != -1) {
            }
        }
    }

    public int renderElement(UIContext context, T element, int i, int index, boolean postDraw) {
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        int s = this.scroll.scrollItemSize;
        int xSide = this.area.w;
        int ySide = this.scroll.scrollItemSize;
        int x = this.area.x;
        int y = this.area.y + i * s - (int)this.scroll.getScroll();
        int low = this.area.y;
        int high = this.area.ey();
        if (y + s < low || !this.isFiltering() && this.isDragging() && this.dragging == i) {
            return i + 1;
        }
        if (y >= high) {
            return -1;
        }
        boolean hover = mouseX >= x && mouseY >= y && mouseX < x + xSide && mouseY < y + ySide;
        boolean selected = this.current.contains(index);
        if (postDraw) {
            this.renderPostListElement(context, element, index, x, y, hover, selected);
        } else {
            this.renderListElement(context, element, index, x, y, hover, selected);
        }
        return i + 1;
    }

    public void renderPostListElement(UIContext context, T element, int i, int x, int y, boolean hover, boolean selected) {
    }

    public void renderListElement(UIContext context, T element, int i, int x, int y, boolean hover, boolean selected) {
        if (selected) {
            context.batcher.box(x, y, x + this.area.w, y + this.scroll.scrollItemSize, 0x88000000 | (Integer)BBSSettings.primaryColor.get());
        }
        this.renderElementPart(context, element, i, x, y, hover, selected);
    }

    protected void renderElementPart(UIContext context, T element, int i, int x, int y, boolean hover, boolean selected) {
        context.batcher.textShadow(this.elementToString(context, i, element), x + 4, y + (this.scroll.scrollItemSize - context.batcher.getFont().getHeight()) / 2, hover ? 0xDDDDFF : -1);
    }

    protected String elementToString(UIContext context, int i, T element) {
        return element.toString();
    }
}

