/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.overlay;

import mchorse.bbs_mod.l10n.keys.IKey;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.ui.framework.elements.UIScrollView;
import mchorse.bbs_mod.ui.framework.elements.input.list.UIList;
import mchorse.bbs_mod.ui.framework.elements.overlay.UIOverlayPanel;
import mchorse.bbs_mod.ui.utils.UI;
import mchorse.bbs_mod.ui.utils.context.ContextMenuManager;
import mchorse.bbs_mod.ui.utils.icons.Icons;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UIEditorOverlayPanel<T>
extends UIOverlayPanel {
    public UIList<T> list = this.createList();
    public UIScrollView editor;
    protected T item;

    public UIEditorOverlayPanel(IKey title) {
        super(title);
        this.list.context((ContextMenuManager menu) -> {
            menu.action(Icons.ADD, this.getAddLabel(), this::addItem);
            if (!this.list.getList().isEmpty()) {
                menu.action(Icons.REMOVE, this.getRemoveLabel(), 0xFF3333, this::removeItem);
            }
        });
        this.editor = UI.scrollView(5, 10, new UIElement[0]);
        this.list.relative(this.content).w(120).h(1.0f);
        this.editor.relative(this.content).x(120).w(1.0f, -120).h(1.0f);
        this.content.add(this.editor, this.list);
        this.content.x(6).y(26).w(1.0f, -32);
    }

    protected abstract UIList<T> createList();

    protected IKey getAddLabel() {
        return IKey.EMPTY;
    }

    protected IKey getRemoveLabel() {
        return IKey.EMPTY;
    }

    protected void addItem() {
        this.addNewItem();
        this.list.update();
    }

    protected void addNewItem() {
    }

    protected void removeItem() {
        int index = this.list.getIndex();
        this.list.getList().remove(index);
        index = Math.max(index - 1, 0);
        T item = this.list.getList().isEmpty() ? null : (T)this.list.getList().get(index);
        this.pickItem(item, true);
        this.list.update();
    }

    protected void pickItem(T item, boolean select) {
        this.item = item;
        this.editor.setVisible(item != null);
        if (item != null) {
            this.fillData(item);
            if (select) {
                this.list.setCurrentScroll(item);
            }
            this.resize();
        }
    }

    protected abstract void fillData(T var1);
}

