/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.ui.framework.elements.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import mchorse.bbs_mod.BBSModClient;
import mchorse.bbs_mod.camera.Camera;
import mchorse.bbs_mod.forms.entities.IEntity;
import mchorse.bbs_mod.forms.entities.StubEntity;
import mchorse.bbs_mod.graphics.window.Window;
import mchorse.bbs_mod.ui.framework.UIContext;
import mchorse.bbs_mod.ui.framework.elements.UIElement;
import mchorse.bbs_mod.utils.Factor;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.MatrixStackUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import org.joml.Intersectiond;
import org.joml.Matrix3d;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public abstract class UIModelRenderer
extends UIElement {
    private static Vector3d vec = new Vector3d();
    private static Matrix3d mat = new Matrix3d();
    protected IEntity entity = new StubEntity();
    protected int timer;
    protected int dragging;
    public Camera camera = new Camera();
    public Vector3f pos = new Vector3f();
    public Factor distance = new Factor(0, 0, 100, x -> Math.pow(x.intValue(), 2.0) / 100.0);
    public boolean grid = true;
    private Vector3d cachedPlaneIntersection = new Vector3d();
    private Vector3f cachedPos = new Vector3f();
    private Camera cachedCamera = new Camera();
    private Vector3d plane = new Vector3d();
    private float lastX;
    private float lastY;
    private long tick;
    private Matrix4f transform = new Matrix4f();

    public UIModelRenderer() {
        this.reset();
    }

    public void setTransform(Matrix4f transform) {
        this.transform = transform;
    }

    public void setRotation(float yaw, float pitch) {
        this.camera.rotation.y = MathUtils.toRad(yaw);
        this.camera.rotation.x = MathUtils.toRad(pitch);
    }

    public void setPosition(float x, float y, float z) {
        this.pos.set(x, y, z);
    }

    public void setDistance(int distanceX) {
        this.distance.setX(distanceX);
    }

    public void setEntity(IEntity entity) {
        this.entity = entity;
    }

    public IEntity getEntity() {
        return this.entity;
    }

    public void reset() {
        this.setDistance(15);
        this.setPosition(0.0f, 1.0f, 0.0f);
        this.setRotation(0.0f, 0.0f);
    }

    public boolean isDragging() {
        return this.dragging != 0;
    }

    public boolean isDraggingPosition() {
        return this.dragging == 2;
    }

    @Override
    public boolean subMouseClicked(UIContext context) {
        if (!this.isDragging() && this.area.isInside(context) && (context.mouseButton == 0 || context.mouseButton == 2)) {
            this.dragging = Window.isShiftPressed() || context.mouseButton == 2 ? 2 : 1;
            this.lastX = context.mouseX;
            this.lastY = context.mouseY;
            this.cachedPos.set((Vector3fc)this.pos);
            this.cachedCamera.copy(this.camera);
            this.plane.set(0.0, 0.0, 1.0);
            this.rotateVector(this.plane);
            this.cachedPlaneIntersection = this.calculateOnPlane(context);
        }
        return false;
    }

    @Override
    public boolean subMouseScrolled(UIContext context) {
        if (this.area.isInside(context) && !this.isDragging()) {
            int x = Integer.compare(-((int)context.mouseWheel), 0);
            if (Window.isCtrlPressed()) {
                x *= 8;
            }
            this.distance.setX(this.distance.getX() + x);
        }
        return super.subMouseScrolled(context);
    }

    @Override
    public boolean subMouseReleased(UIContext context) {
        this.dragging = 0;
        return super.subMouseReleased(context);
    }

    @Override
    public void render(UIContext context) {
        this.updateLogic(context);
        context.batcher.clip(this.area, context);
        this.renderModel(context);
        context.batcher.unclip(context);
        super.render(context);
    }

    private void updateLogic(UIContext context) {
        long tick = context.getTick();
        long i = tick - this.tick;
        if (i > 10L) {
            i = 10L;
        }
        while (i > 0L) {
            this.update();
            --i;
        }
        this.tick = tick;
    }

    protected void update() {
        ++this.timer;
        this.entity.setAge(this.timer);
    }

    private void renderModel(UIContext context) {
        RenderSystem.depthFunc((int)515);
        this.setupPosition();
        this.setupViewport(context);
        class_4587 stack = context.render.batcher.getContext().method_51448();
        MatrixStackUtils.cacheMatrices();
        RenderSystem.setProjectionMatrix((Matrix4f)this.camera.projection, (class_8251)class_8251.field_43361);
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)new Matrix3f((Matrix4fc)this.camera.view).invert());
        stack.method_22903();
        MatrixStackUtils.multiply(stack, this.camera.view);
        stack.method_22904(-this.camera.position.x, -this.camera.position.y, -this.camera.position.z);
        MatrixStackUtils.multiply(stack, this.transform);
        RenderSystem.setupLevelDiffuseLighting((Vector3f)new Vector3f(0.0f, 0.85f, -1.0f).normalize(), (Vector3f)new Vector3f(0.0f, 0.85f, 1.0f).normalize(), (Matrix4f)this.camera.view);
        if (this.grid) {
            this.renderGrid(context);
        }
        this.renderUserModel(context);
        class_308.method_24210();
        stack.method_22909();
        class_310 mc = class_310.method_1551();
        RenderSystem.viewport((int)0, (int)0, (int)mc.method_22683().method_4489(), (int)mc.method_22683().method_4506());
        MatrixStackUtils.restoreMatrices();
        RenderSystem.depthFunc((int)519);
        this.processInputs(context);
    }

    protected void processInputs(UIContext context) {
        int mouseX = context.mouseX;
        int mouseY = context.mouseY;
        if (this.isDragging()) {
            if (this.isDraggingPosition()) {
                if (this.lastX != (float)context.mouseX || this.lastY != (float)context.mouseY) {
                    Vector3d newPoint = this.calculateOnPlane(context);
                    this.pos.set((Vector3fc)this.cachedPos);
                    this.pos.sub((float)newPoint.x, (float)newPoint.y, (float)newPoint.z);
                    this.pos.add((float)this.cachedPlaneIntersection.x, (float)this.cachedPlaneIntersection.y, (float)this.cachedPlaneIntersection.z);
                    this.lastX = mouseX;
                    this.lastY = mouseY;
                }
            } else {
                this.camera.rotation.y -= MathUtils.toRad(this.lastX - (float)mouseX);
                this.camera.rotation.x -= MathUtils.toRad(this.lastY - (float)mouseY);
                this.lastX = mouseX;
                this.lastY = mouseY;
            }
        }
    }

    public void setupPosition() {
        this.camera.position.set((Vector3fc)this.pos);
        vec.set(0.0, 0.0, -this.distance.getValue());
        this.rotateVector(vec);
        this.camera.position.x += UIModelRenderer.vec.x;
        this.camera.position.y += UIModelRenderer.vec.y;
        this.camera.position.z += UIModelRenderer.vec.z;
    }

    private Vector3d calculateOnPlane(UIContext context) {
        Vector3d vector = new Vector3d();
        Vector3d origin = new Vector3d((Vector3dc)this.cachedCamera.position).sub((Vector3fc)this.cachedPos);
        Vector3d destination = new Vector3d((Vector3fc)this.cachedCamera.getMouseDirection(context.mouseX, context.mouseY, this.area.x, this.area.y, this.area.w, this.area.h)).mul(this.distance.getValue() * 2.0).add((Vector3dc)origin);
        Intersectiond.intersectLineSegmentPlane((double)origin.x, (double)origin.y, (double)origin.z, (double)destination.x, (double)destination.y, (double)destination.z, (double)this.plane.x, (double)this.plane.y, (double)this.plane.z, (double)0.0, (Vector3d)vector);
        return vector;
    }

    private void rotateVector(Vector3d vec) {
        mat.identity().rotateX((double)this.camera.rotation.x);
        mat.transform(vec);
        mat.identity().rotateY((double)((float)Math.PI - this.camera.rotation.y));
        mat.transform(vec);
    }

    protected void setupViewport(UIContext context) {
        GL11.glClear((int)256);
        class_310 mc = class_310.method_1551();
        float rx = Math.round((double)mc.method_22683().method_4480() / (double)context.menu.width);
        float ry = Math.round((double)mc.method_22683().method_4507() / (double)context.menu.height);
        float size = BBSModClient.getOriginalFramebufferScale();
        int vx = (int)((float)this.area.x * rx);
        int vy = (int)((float)mc.method_22683().method_4507() - (float)(this.area.y + this.area.h) * ry);
        int vw = (int)((float)this.area.w * rx);
        int vh = (int)((float)this.area.h * ry);
        RenderSystem.viewport((int)((int)((float)vx * size)), (int)((int)((float)vy * size)), (int)((int)((float)vw * size)), (int)((int)((float)vh * size)));
        this.camera.updatePerspectiveProjection(vw, vh);
        this.camera.updateView();
    }

    protected abstract void renderUserModel(UIContext var1);

    protected void renderGrid(UIContext context) {
        int x;
        Matrix4f matrix4f = context.batcher.getContext().method_51448().method_23760().method_23761();
        class_287 builder = class_289.method_1348().method_1349();
        RenderSystem.setShader(class_757::method_34540);
        builder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        for (x = 0; x <= 10; ++x) {
            if (x == 0) {
                builder.method_22918(matrix4f, (float)(x - 5), 0.0f, -5.0f).method_22915(0.0f, 0.0f, 1.0f, 1.0f).method_1344();
                builder.method_22918(matrix4f, (float)(x - 5), 0.0f, 5.0f).method_22915(0.0f, 0.0f, 1.0f, 1.0f).method_1344();
                continue;
            }
            builder.method_22918(matrix4f, (float)(x - 5), 0.0f, -5.0f).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
            builder.method_22918(matrix4f, (float)(x - 5), 0.0f, 5.0f).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
        }
        for (x = 0; x <= 10; ++x) {
            if (x == 0) {
                builder.method_22918(matrix4f, -5.0f, 0.0f, (float)(x - 5)).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_1344();
                builder.method_22918(matrix4f, 5.0f, 0.0f, (float)(x - 5)).method_22915(1.0f, 0.0f, 0.0f, 1.0f).method_1344();
                continue;
            }
            builder.method_22918(matrix4f, -5.0f, 0.0f, (float)(x - 5)).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
            builder.method_22918(matrix4f, 5.0f, 0.0f, (float)(x - 5)).method_22915(0.25f, 0.25f, 0.25f, 1.0f).method_1344();
        }
        class_286.method_43433((class_287.class_7433)builder.method_1326());
    }
}

