/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.utils.OS;

public class FFMpegUtils {
    private static final Set<String> SKIP_DIRS = Set.of("Windows", "Program Files", "Program Files (x86)", "$Recycle.Bin", "System Volume Information", "AppData");

    private static File findFFMPEG(String path) {
        File exe;
        boolean isWin;
        File file = new File(path);
        boolean bl = isWin = OS.CURRENT == OS.WINDOWS;
        if (file.isDirectory()) {
            String subpath = isWin ? "ffmpeg.exe" : "ffmpeg";
            File bin = new File(file, subpath);
            if (bin.isFile()) {
                return bin;
            }
            bin = new File(file, "bin" + File.pathSeparator + subpath);
            if (bin.isFile()) {
                return bin;
            }
        } else if (isWin && !file.exists() && (exe = new File(path + ".exe")).exists()) {
            return exe;
        }
        return file;
    }

    public static String getFFMPEG() {
        String encoder = (String)BBSSettings.videoEncoderPath.get();
        File encoderPath = FFMpegUtils.findFFMPEG((String)BBSSettings.videoEncoderPath.get());
        if (encoderPath.isFile()) {
            encoder = encoderPath.getAbsolutePath();
        }
        return encoder;
    }

    public static boolean checkFFMPEG() {
        return FFMpegUtils.execute(BBSMod.getGameFolder(), "-version");
    }

    public static boolean execute(File folder, String ... arguments) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(FFMpegUtils.getFFMPEG());
        for (String arg : arguments) {
            args.add(arg);
        }
        ProcessBuilder builder = new ProcessBuilder(args);
        File log = BBSMod.getSettingsPath("converter.log");
        builder.directory(folder);
        builder.redirectErrorStream(true);
        builder.redirectOutput(log);
        try {
            Process start = builder.start();
            return start.waitFor() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Optional<Path> findFFMpeg(Path root) {
        Visitor visitor = new Visitor();
        try {
            Files.walkFileTree(root, EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, visitor);
        }
        catch (FFMpegFoundException found) {
            return Optional.of(found.foundPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private Visitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path name = dir.getFileName();
            if (name != null && SKIP_DIRS.contains(name.toString())) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            Path parentName;
            Path parent;
            Path fileName = file.getFileName();
            if (fileName != null && fileName.toString().equalsIgnoreCase("ffmpeg.exe") && (parent = file.getParent()) != null && (parentName = parent.getFileName()) != null && parentName.toString().equalsIgnoreCase("bin")) {
                throw new FFMpegFoundException(file.toAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }

    private static class FFMpegFoundException
    extends RuntimeException {
        final Path foundPath;

        public FFMpegFoundException(Path foundPath) {
            this.foundPath = foundPath;
        }
    }
}

