/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import mchorse.bbs_mod.graphics.texture.Texture;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.utils.PNGEncoder;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.resources.Pixels;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

@Environment(value=EnvType.CLIENT)
public class ScreenshotRecorder {
    public File screenshots;
    public boolean take;
    public boolean toBuffer;

    public ScreenshotRecorder(File screenshots) {
        this.screenshots = screenshots;
        this.screenshots.mkdirs();
    }

    public File getScreenshots() {
        return this.screenshots;
    }

    public void takeScreenshot(File output, Texture texture) {
        this.takeScreenshot(output, texture.id, texture.width, texture.height);
    }

    public void takeScreenshot(File output, int texture, int width, int height) {
        FloatBuffer pixelData = BufferUtils.createFloatBuffer((int)(width * height * 4));
        GlStateManager._bindTexture((int)texture);
        GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5126, (FloatBuffer)pixelData);
        pixelData.rewind();
        this.saveScreenshot(pixelData, output, width, height);
    }

    public void takeScreenshot(File output, int width, int height) {
        FloatBuffer pixelData = BufferUtils.createFloatBuffer((int)(width * height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5126, (FloatBuffer)pixelData);
        pixelData.rewind();
        this.saveScreenshot(pixelData, output, width, height);
    }

    private void saveScreenshot(FloatBuffer pixelData, File output, int width, int height) {
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float r = pixelData.get() * 255.0f;
                float g = pixelData.get() * 255.0f;
                float b = pixelData.get() * 255.0f;
                float a = pixelData.get() * 255.0f;
                int i = (height - 1 - y) * width + x;
                pixels[i] = ((int)a << 24) + ((int)r << 16) + ((int)g << 8) + (int)b;
            }
        }
        ScreenshotRunner runner = new ScreenshotRunner(width, height, pixels, output);
        new Thread(runner).start();
    }

    public File getScreenshotFile() {
        return new File(this.screenshots, StringUtils.createTimestampFilename() + ".png");
    }

    @Environment(value=EnvType.CLIENT)
    public static class ScreenshotRunner
    implements Runnable,
    ClipboardOwner {
        public int width;
        public int height;
        public int[] data;
        public File destination;

        public ScreenshotRunner(int width, int height, int[] data, File destination) {
            this.width = width;
            this.height = height;
            this.data = data;
            this.destination = destination;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        @Override
        public void run() {
            try {
                if (this.destination == null) {
                    BufferedImage image = new BufferedImage(this.width, this.height, 2);
                    image.setRGB(0, 0, this.width, this.height, this.data, 0, this.width);
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferableImage(image), this);
                } else {
                    Pixels pixels = Pixels.fromIntArray(this.width, this.height, this.data);
                    PNGEncoder.writeToFile(pixels, this.destination);
                    pixels.delete();
                }
                UIUtils.playClick();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class TransferableImage
    implements Transferable {
        private Image image;
        private DataFlavor flavor = DataFlavor.imageFlavor;

        public TransferableImage(Image image) {
            this.image = image;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (this.flavor.equals(flavor)) {
                return this.image;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavor.equals(flavor);
        }
    }
}

