/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import mchorse.bbs_mod.BBSMod;
import mchorse.bbs_mod.BBSSettings;
import mchorse.bbs_mod.client.BBSRendering;
import mchorse.bbs_mod.ui.utils.UIUtils;
import mchorse.bbs_mod.utils.FFMpegUtils;
import mchorse.bbs_mod.utils.StringUtils;
import mchorse.bbs_mod.utils.UnsafeUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

@Environment(value=EnvType.CLIENT)
public class VideoRecorder {
    private Process process;
    private WritableByteChannel channel;
    private boolean recording;
    private ByteBuffer buffer;
    private int textureId = -1;
    private int textureWidth;
    private int textureHeight;
    private int counter;
    public int serverTicks;
    public int lastServerTicks;
    private int[] pbos;
    private int pboIndex;

    public boolean isRecording() {
        return this.recording;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public int getCounter() {
        return this.counter;
    }

    public void startRecording(File audioFile, int textureId, int width, int height) {
        if (this.recording) {
            return;
        }
        this.counter = 0;
        this.textureId = textureId;
        this.textureWidth = width;
        this.textureHeight = height;
        int size = width * height * 3;
        if (this.buffer == null) {
            this.buffer = MemoryUtil.memAlloc((int)size);
        }
        try {
            File movies = BBSRendering.getVideoFolder();
            movies.mkdirs();
            Path path = Paths.get(movies.toString(), new String[0]);
            String movieName = StringUtils.createTimestampFilename();
            String params = audioFile == null ? (String)BBSSettings.videoSettings.arguments.get() : (String)BBSSettings.videoSettings.argumentsAudio.get();
            StringBuilder filters = new StringBuilder("vflip");
            float frameRate = BBSRendering.getVideoFrameRate();
            int motionBlur = BBSRendering.getMotionBlur();
            for (int i = 0; i < motionBlur; ++i) {
                filters.append(",tblend=all_mode=average,framestep=2");
            }
            params = params.replace("%WIDTH%", String.valueOf(width));
            params = params.replace("%HEIGHT%", String.valueOf(height));
            params = params.replace("%FPS%", String.valueOf(frameRate));
            params = params.replace("%NAME%", movieName);
            params = params.replace("%FILTERS%", filters.toString());
            if (audioFile != null) {
                params = params.replace("%AUDIO_TRACK%", "\"" + audioFile.getAbsolutePath() + "\"");
            }
            ArrayList<String> args = new ArrayList<String>();
            String encoder = FFMpegUtils.getFFMPEG();
            args.add(encoder);
            args.addAll(Arrays.asList(params.split(" ")));
            System.out.println("Recording video with following arguments: " + String.valueOf(args));
            this.pbos = new int[2];
            this.pboIndex = 0;
            for (int i = 0; i < 2; ++i) {
                this.pbos[i] = GL30.glGenBuffers();
                GL30.glBindBuffer((int)35051, (int)this.pbos[i]);
                GL30.glBufferData((int)35051, (long)size, (int)35041);
            }
            GL30.glBindBuffer((int)35051, (int)0);
            ProcessBuilder builder = new ProcessBuilder(args);
            File log = path.resolve(movieName.concat(".log")).toFile();
            if (!((Boolean)BBSSettings.videoEncoderLog.get()).booleanValue()) {
                log = BBSMod.getSettingsPath("video.log");
            }
            builder.directory(path.toFile());
            builder.redirectErrorStream(true);
            builder.redirectOutput(log);
            this.process = builder.start();
            OutputStream os = this.process.getOutputStream();
            Unsafe unsafe = UnsafeUtils.getUnsafe();
            if (os instanceof FilterOutputStream) {
                try {
                    Field outField = FilterOutputStream.class.getDeclaredField("out");
                    os = (OutputStream)unsafe.getObject(os, unsafe.objectFieldOffset(outField));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.channel = Channels.newChannel(os);
            this.recording = true;
            UIUtils.playClick(2.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.lastServerTicks = 0;
        this.serverTicks = 0;
    }

    public void stopRecording() {
        if (!this.recording) {
            return;
        }
        if (this.pbos != null) {
            for (int pbo : this.pbos) {
                GL30.glDeleteBuffers((int)pbo);
            }
        }
        this.pbos = null;
        this.textureId = -1;
        if (this.buffer != null) {
            MemoryUtil.memFree((Buffer)this.buffer);
            this.buffer = null;
        }
        try {
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            this.channel = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (this.process != null) {
                this.process.waitFor(1L, TimeUnit.MINUTES);
                this.process.destroy();
            }
            this.process = null;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        this.recording = false;
        UIUtils.playClick(0.5f);
        this.lastServerTicks = 0;
        this.serverTicks = 0;
    }

    public void recordFrame() {
        if (!this.recording) {
            return;
        }
        try {
            int pbo = this.pboIndex;
            int nextPbo = (this.pboIndex + 1) % this.pbos.length;
            GL30.glPixelStorei((int)3333, (int)1);
            GL30.glBindBuffer((int)35051, (int)this.pbos[pbo]);
            GL30.glBindTexture((int)3553, (int)this.textureId);
            GL30.glGetTexImage((int)3553, (int)0, (int)32992, (int)5121, (long)0L);
            GL30.glBindBuffer((int)35051, (int)this.pbos[nextPbo]);
            ByteBuffer mappedBuffer = GL30.glMapBuffer((int)35051, (int)35000);
            if (mappedBuffer != null && this.counter != 0) {
                this.channel.write(mappedBuffer);
            }
            GL30.glUnmapBuffer((int)35051);
            GL30.glBindBuffer((int)35051, (int)0);
            this.pboIndex = nextPbo;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.counter;
    }

    public void toggleRecording(int textureId, int textureWidth, int textureHeight) {
        if (this.recording) {
            this.stopRecording();
        } else {
            this.startRecording(null, textureId, textureWidth, textureHeight);
        }
        UIUtils.playClick();
    }
}

