/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.clips;

import java.util.function.Predicate;
import mchorse.bbs_mod.camera.clips.misc.AudioClip;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipData;
import mchorse.bbs_mod.utils.clips.Clips;

public abstract class ClipContext<T extends Clip, E> {
    public int ticks;
    public int relativeTick;
    public float transition;
    public int currentLayer;
    public Clips clips;
    public boolean playing = true;
    public int count;
    public double distance;
    public double velocity;
    public final ClipData clipData = new ClipData();

    public ClipContext setup(int ticks, float transition) {
        return this.setup(ticks, ticks, transition);
    }

    public ClipContext setup(int ticks, int relativeTick, float transition) {
        return this.setup(ticks, relativeTick, transition, 0);
    }

    public ClipContext setup(int ticks, int relativeTick, float transition, int currentLayer) {
        this.count = 0;
        this.ticks = ticks;
        this.relativeTick = relativeTick;
        this.transition = transition;
        this.currentLayer = currentLayer;
        return this;
    }

    public abstract boolean apply(Clip var1, E var2);

    public boolean applyUnderneath(int ticks, float transition, E position) {
        return this.applyUnderneath(ticks, transition, position, AudioClip.NO_AUDIO);
    }

    public boolean applyUnderneath(int ticks, float transition, E position, Predicate<Clip> filter) {
        if (this.currentLayer > 0) {
            int lastLayer = this.currentLayer;
            int lastTicks = this.ticks;
            int lastRelativeTicks = this.relativeTick;
            float lastTransition = this.transition;
            this.ticks = ticks;
            this.transition = transition;
            boolean applied = false;
            for (Clip clip : this.clips.getClips(ticks, lastLayer)) {
                boolean allowed = filter == null || filter.test(clip);
                if (!allowed || !this.apply(clip, position)) continue;
                applied = true;
            }
            this.currentLayer = lastLayer;
            this.ticks = lastTicks;
            this.relativeTick = lastRelativeTicks;
            this.transition = lastTransition;
            return applied;
        }
        return false;
    }
}

