/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.factory;

import java.util.Collection;
import java.util.HashSet;
import mchorse.bbs_mod.data.IDataSerializable;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.resources.Link;

public interface IFactory<T, D> {
    public Link getType(T var1);

    public T create(Link var1);

    default public MapType toData(T object) {
        MapType data = new MapType();
        if (object instanceof IDataSerializable) {
            Object baseData = ((IDataSerializable)object).toData();
            if (((BaseType)baseData).isMap()) {
                data = ((BaseType)baseData).asMap();
            }
            this.appendId(object, data);
        }
        return data;
    }

    default public void appendId(T object, MapType data) {
        data.putString(this.getTypeKey(), this.getType(object).toString());
    }

    default public T fromData(MapType data) {
        if (data == null) {
            return null;
        }
        Link type = Link.create(data.getString(this.getTypeKey()));
        T object = this.create(type);
        if (object instanceof IDataSerializable) {
            ((IDataSerializable)object).fromData(data);
        }
        return object;
    }

    default public String getTypeKey() {
        return "type";
    }

    public D getData(T var1);

    public D getData(Link var1);

    public Collection<Link> getKeys();

    default public Collection<String> getStringKeys() {
        HashSet<String> keys = new HashSet<String>();
        for (Link link : this.getKeys()) {
            keys.add(link.toString());
        }
        return keys;
    }
}

