/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.utils.keyframes.factories;

import mchorse.bbs_mod.data.DataStorageUtils;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.forms.utils.PivotSettings;
import mchorse.bbs_mod.utils.interps.IInterp;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class PivotSettingsKeyframeFactory
implements IKeyframeFactory<PivotSettings> {
    private final PivotSettings i = new PivotSettings();

    @Override
    public PivotSettings fromData(BaseType data) {
        PivotSettings settings = new PivotSettings();
        if (data.isMap()) {
            settings.fromData(data.asMap());
        } else if (data.isList()) {
            Vector4f vec = DataStorageUtils.vector4fFromData(data.asList());
            settings.auto = false;
            settings.pivot.set((Vector4fc)vec);
        }
        return settings;
    }

    @Override
    public BaseType toData(PivotSettings value) {
        MapType map = new MapType();
        value.toData(map);
        return map;
    }

    @Override
    public PivotSettings createEmpty() {
        return new PivotSettings();
    }

    @Override
    public PivotSettings copy(PivotSettings value) {
        PivotSettings copy = new PivotSettings();
        copy.auto = value.auto;
        copy.pivot.set((Vector4fc)value.pivot);
        return copy;
    }

    @Override
    public PivotSettings interpolate(PivotSettings preA, PivotSettings a, PivotSettings b, PivotSettings postB, IInterp interpolation, float x) {
        this.i.auto = a.auto;
        float ax = a.pivot.x;
        float ay = a.pivot.y;
        float az = a.pivot.z;
        float bx = b.pivot.x;
        float by = b.pivot.y;
        float bz = b.pivot.z;
        if (!a.auto && !b.auto) {
            this.i.pivot.x = (float)interpolation.interpolate(IInterp.context.set(preA.pivot.x, ax, bx, postB.pivot.x, x));
            this.i.pivot.y = (float)interpolation.interpolate(IInterp.context.set(preA.pivot.y, ay, by, postB.pivot.y, x));
            this.i.pivot.z = (float)interpolation.interpolate(IInterp.context.set(preA.pivot.z, az, bz, postB.pivot.z, x));
        } else {
            this.i.pivot.set(ax, ay, az, 0.0f);
        }
        return this.i;
    }
}

