/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.camera.clips.misc;

import mchorse.bbs_mod.camera.clips.misc.CurveClip;
import mchorse.bbs_mod.camera.data.Position;
import mchorse.bbs_mod.utils.clips.Clip;
import mchorse.bbs_mod.utils.clips.ClipContext;
import mchorse.bbs_mod.utils.iris.ShaderCurves;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class CurveClientClip
extends CurveClip {
    @Override
    protected void breakDownClip(Clip original, int offset) {
        super.breakDownClip(original, offset);
        for (KeyframeChannel<Double> channel : this.channels.getChannels()) {
            channel.moveX(-offset);
            KeyframeSegment<Double> segment = channel.find(0.0f);
            if (segment == null) continue;
            while (segment.a != channel.get(0)) {
                channel.remove(0);
            }
        }
        CurveClip curveClip = (CurveClip)original;
        for (KeyframeChannel<Double> channel : curveClip.channels.getChannels()) {
            KeyframeSegment<Double> segment = channel.find(offset);
            if (segment == null) continue;
            while (segment.b != channel.get(channel.getKeyframes().size() - 1)) {
                channel.remove(channel.getKeyframes().size() - 1);
            }
        }
    }

    @Override
    protected void applyClip(ClipContext context, Position position) {
        super.applyClip(context, position);
        for (KeyframeChannel<Double> channel : this.channels.getChannels()) {
            ShaderCurves.ShaderVariable variable;
            String id;
            if (channel.isEmpty() || !(id = channel.getId()).startsWith("curve.") || (variable = ShaderCurves.variableMap.get(id.substring("curve.".length()))) == null) continue;
            variable.value = Float.valueOf(channel.interpolate((float)context.relativeTick + context.transition).floatValue());
        }
    }

    @Override
    protected Clip create() {
        return new CurveClientClip();
    }
}

