/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.film.replays;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import mchorse.bbs_mod.data.types.BaseType;
import mchorse.bbs_mod.data.types.MapType;
import mchorse.bbs_mod.forms.FormUtils;
import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.utils.StructureLightSettings;
import mchorse.bbs_mod.settings.values.base.BaseKeyframeFactoryValue;
import mchorse.bbs_mod.settings.values.base.BaseValue;
import mchorse.bbs_mod.settings.values.base.BaseValueBasic;
import mchorse.bbs_mod.settings.values.core.ValueGroup;
import mchorse.bbs_mod.utils.MathUtils;
import mchorse.bbs_mod.utils.interps.Interpolations;
import mchorse.bbs_mod.utils.keyframes.Keyframe;
import mchorse.bbs_mod.utils.keyframes.KeyframeChannel;
import mchorse.bbs_mod.utils.keyframes.KeyframeSegment;
import mchorse.bbs_mod.utils.keyframes.factories.IKeyframeFactory;
import mchorse.bbs_mod.utils.keyframes.factories.KeyframeFactories;

public class FormProperties
extends ValueGroup {
    public final Map<String, KeyframeChannel> properties = new HashMap<String, KeyframeChannel>();

    public FormProperties(String id) {
        super(id);
    }

    public void shift(float tick) {
        for (KeyframeChannel value : this.properties.values()) {
            for (Keyframe keyframe : value.getKeyframes()) {
                keyframe.setTick(keyframe.getTick() + tick);
            }
        }
    }

    public KeyframeChannel getOrCreate(Form form, String key) {
        BaseValue value = this.get(key);
        BaseValueBasic property = FormUtils.getProperty(form, key);
        if (value instanceof KeyframeChannel) {
            KeyframeChannel channel = (KeyframeChannel)value;
            return channel;
        }
        return property != null ? this.create(property) : null;
    }

    public KeyframeChannel create(BaseValue property) {
        if (property.isVisible() && property instanceof BaseKeyframeFactoryValue) {
            BaseKeyframeFactoryValue keyframeFactoryValue = (BaseKeyframeFactoryValue)property;
            String key = FormUtils.getPropertyPath(property);
            KeyframeChannel channel = new KeyframeChannel(key, keyframeFactoryValue.getFactory());
            this.properties.put(key, channel);
            this.add(channel);
            return channel;
        }
        return null;
    }

    public void applyProperties(Form form, float tick) {
        this.applyProperties(form, tick, 1.0f);
    }

    public void applyProperties(Form form, float tick, float blend) {
        if (form == null) {
            return;
        }
        for (KeyframeChannel value : this.properties.values()) {
            this.applyProperty(tick, form, value, blend);
        }
    }

    private void applyProperty(float tick, Form form, KeyframeChannel value, float blend) {
        BaseValueBasic property = FormUtils.getProperty(form, value.getId());
        if (property == null) {
            return;
        }
        KeyframeSegment segment = value.find(tick);
        if (segment != null) {
            if (blend < 1.0f) {
                IKeyframeFactory factory = value.getFactory();
                Object v = factory.copy(property.get());
                Object a = factory.copy(segment.createInterpolated());
                Object interpolated = factory.interpolate(v, v, a, a, Interpolations.LINEAR, MathUtils.clamp(blend, 0.0f, 1.0f));
                property.setRuntimeValue(factory.copy(interpolated));
            } else {
                property.setRuntimeValue(segment.createInterpolated());
            }
        } else {
            property.setRuntimeValue(null);
        }
    }

    public void resetProperties(Form form) {
        if (form == null) {
            return;
        }
        for (KeyframeChannel value : this.properties.values()) {
            BaseValueBasic property = FormUtils.getProperty(form, value.getId());
            if (property == null) {
                return;
            }
            property.setRuntimeValue(null);
        }
    }

    public void cleanUp() {
        Iterator<KeyframeChannel> it = this.properties.values().iterator();
        while (it.hasNext()) {
            KeyframeChannel next = it.next();
            if (!next.isEmpty()) continue;
            it.remove();
            this.remove(next);
        }
    }

    @Override
    public void fromData(BaseType data) {
        Iterator<Keyframe<Object>> iterator;
        super.fromData(data);
        this.properties.clear();
        if (!data.isMap()) {
            return;
        }
        MapType map = data.asMap();
        for (String key : map.keys()) {
            MapType mapType = map.getMap(key);
            if (mapType.isEmpty()) continue;
            KeyframeChannel<Object> property = new KeyframeChannel(key, null);
            property.fromData(mapType);
            if (key.endsWith("lighting") && property.getFactory() == KeyframeFactories.BOOLEAN) {
                KeyframeChannel<Float> newProperty = new KeyframeChannel<Float>(key, KeyframeFactories.FLOAT);
                iterator = property.getKeyframes().iterator();
                while (iterator.hasNext()) {
                    Keyframe<Object> keyframe;
                    Keyframe<Object> kf = keyframe = iterator.next();
                    Boolean v = (Boolean)kf.getValue();
                    newProperty.insert(kf.getTick(), Float.valueOf(v != false ? 1.0f : 0.0f));
                }
                property = newProperty;
            }
            if (property.getFactory() == null) continue;
            this.properties.put(key, property);
            this.add(property);
        }
        try {
            KeyframeChannel emit = this.properties.get("emit_light");
            KeyframeChannel intensity = this.properties.get("light_intensity");
            if (emit != null || intensity != null) {
                KeyframeChannel<Object> merged;
                KeyframeChannel<Object> mergedAny = this.properties.get("structure_light");
                KeyframeChannel<Object> keyframeChannel = merged = mergedAny != null ? mergedAny : new KeyframeChannel<StructureLightSettings>("structure_light", KeyframeFactories.STRUCTURE_LIGHT_SETTINGS);
                if (mergedAny == null) {
                    this.properties.put("structure_light", merged);
                    this.add(merged);
                }
                TreeSet<Float> ticks = new TreeSet<Float>();
                if (emit != null) {
                    for (Keyframe<Object> keyframe : emit.getKeyframes()) {
                        ticks.add(Float.valueOf(keyframe.getTick()));
                    }
                }
                if (intensity != null) {
                    for (Keyframe<Object> keyframe : intensity.getKeyframes()) {
                        ticks.add(Float.valueOf(keyframe.getTick()));
                    }
                }
                iterator = ticks.iterator();
                while (iterator.hasNext()) {
                    Object v;
                    KeyframeSegment seg;
                    float f = ((Float)((Object)iterator.next())).floatValue();
                    boolean enabled = false;
                    int value = 0;
                    if (emit != null && (seg = emit.find(f)) != null) {
                        v = seg.createInterpolated();
                        if (v instanceof Boolean) {
                            Boolean b = (Boolean)v;
                            enabled = b;
                        } else if (v instanceof Number) {
                            Number n = (Number)v;
                            boolean bl = enabled = n.floatValue() >= 0.5f;
                        }
                    }
                    if (intensity != null && (seg = intensity.find(f)) != null && (v = seg.createInterpolated()) instanceof Number) {
                        Number n = (Number)v;
                        value = Math.round(n.floatValue());
                    }
                    StructureLightSettings payload = new StructureLightSettings(enabled, Math.max(0, Math.min(15, value)));
                    merged.insert(f, payload);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected boolean canPersist(BaseValue value) {
        if (value instanceof KeyframeChannel) {
            KeyframeChannel channel = (KeyframeChannel)value;
            return !channel.isEmpty();
        }
        return super.canPersist(value);
    }
}

