/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.forms.forms;

import mchorse.bbs_mod.forms.forms.Form;
import mchorse.bbs_mod.forms.forms.utils.PivotSettings;
import mchorse.bbs_mod.forms.forms.utils.StructureLightSettings;
import mchorse.bbs_mod.settings.values.core.ValueColor;
import mchorse.bbs_mod.settings.values.core.ValueString;
import mchorse.bbs_mod.settings.values.misc.ValuePivotSettings;
import mchorse.bbs_mod.settings.values.misc.ValueStructureLightSettings;
import mchorse.bbs_mod.settings.values.numeric.ValueBoolean;
import mchorse.bbs_mod.settings.values.numeric.ValueFloat;
import mchorse.bbs_mod.settings.values.numeric.ValueInt;
import mchorse.bbs_mod.utils.colors.Color;

public class StructureForm
extends Form {
    public final ValueString structureFile = new ValueString("structure_file", "");
    public final ValueColor color = new ValueColor("color", Color.white());
    public final ValueString biomeId = new ValueString("biome_id", "");
    public final ValueBoolean emitLight = new ValueBoolean("emit_light", false);
    public final ValueInt lightIntensity = new ValueInt("light_intensity", 15);
    public final ValueStructureLightSettings structureLight = new ValueStructureLightSettings("structure_light", new StructureLightSettings(false, 15));
    public final ValueBoolean tintBlockEntities = new ValueBoolean("tint_block_entities", false);
    public final ValueFloat pivotX = new ValueFloat("pivot_x", Float.valueOf(0.0f));
    public final ValueFloat pivotY = new ValueFloat("pivot_y", Float.valueOf(0.0f));
    public final ValueFloat pivotZ = new ValueFloat("pivot_z", Float.valueOf(0.0f));
    public final ValuePivotSettings pivot = new ValuePivotSettings("pivot", new PivotSettings(true, 0.0f, 0.0f, 0.0f));
    public final ValueBoolean autoPivot = new ValueBoolean("auto_pivot", true);

    public StructureForm() {
        this.add(this.structureFile);
        this.add(this.color);
        this.add(this.biomeId);
        this.add(this.emitLight);
        this.add(this.lightIntensity);
        this.tintBlockEntities.invisible();
        this.add(this.tintBlockEntities);
        this.add(this.structureLight);
        this.pivotX.invisible();
        this.pivotY.invisible();
        this.pivotZ.invisible();
        this.add(this.pivotX);
        this.add(this.pivotY);
        this.add(this.pivotZ);
        this.emitLight.invisible();
        this.lightIntensity.invisible();
        this.pivot.invisible();
        this.add(this.pivot);
        this.autoPivot.invisible();
        this.add(this.autoPivot);
    }

    @Override
    protected String getDefaultDisplayName() {
        String path = (String)this.structureFile.get();
        if (path == null || path.isEmpty()) {
            return super.getDefaultDisplayName();
        }
        int slash = Math.max(path.lastIndexOf(47), path.lastIndexOf(92));
        String prefix = slash >= 0 ? path.substring(0, slash + 1) : "";
        String name = slash >= 0 ? path.substring(slash + 1) : path;
        String base = name.toLowerCase().endsWith(".nbt") ? name.substring(0, name.length() - 4) : name;
        return prefix + base;
    }

    @Override
    public String getTrackName(String property) {
        String last;
        int slash = property.lastIndexOf(47);
        String prefix = slash == -1 ? "" : property.substring(0, slash + 1);
        String mapped = last = slash == -1 ? property : property.substring(slash + 1);
        if ("structure_file".equals(last)) {
            mapped = "structure";
        } else if ("biome_id".equals(last)) {
            mapped = "biome";
        } else if ("structure_light".equals(last)) {
            mapped = "structure_light";
        }
        return super.getTrackName(prefix + mapped);
    }
}

