/*
 * Decompiled with CFR 0.152.
 */
package mchorse.bbs_mod.graphics;

import java.util.ArrayList;
import java.util.List;
import mchorse.bbs_mod.graphics.Renderbuffer;
import mchorse.bbs_mod.graphics.texture.Texture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@Environment(value=EnvType.CLIENT)
public class Framebuffer {
    private static final float[] CLEAR_COLOR = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private static final float[] CLEAR_DEPTH = new float[]{1.0f};
    public int id;
    public List<Texture> textures = new ArrayList<Texture>();
    public final List<Renderbuffer> renderbuffers = new ArrayList<Renderbuffer>();
    private boolean deleteTextures;
    private boolean advancedClearing;

    public Framebuffer() {
        this.id = GL30.glGenFramebuffers();
    }

    public Framebuffer enableAdvancedClearing() {
        this.advancedClearing = true;
        return this;
    }

    public Framebuffer deleteTextures() {
        this.deleteTextures = true;
        return this;
    }

    public Texture getMainTexture() {
        return this.textures.get(0);
    }

    public Framebuffer attach(Texture texture, int attachment) {
        this.textures.add(texture);
        this.bind();
        texture.bind();
        GL30.glFramebufferTexture2D((int)36160, (int)attachment, (int)texture.target, (int)texture.id, (int)0);
        return this;
    }

    public void attach(Renderbuffer renderbuffer) {
        this.renderbuffers.add(renderbuffer);
        renderbuffer.bind();
        GL30.glFramebufferRenderbuffer((int)36160, (int)renderbuffer.target, (int)36161, (int)renderbuffer.id);
    }

    public void attachments(int count) {
        int[] attachments = new int[count];
        for (int i = 0; i < count; ++i) {
            attachments[i] = 36064 + i;
        }
        this.attachments(attachments);
    }

    public void attachments(int ... attachments) {
        GL30.glDrawBuffers((int[])attachments);
    }

    public void applyClear() {
        this.apply();
        this.clear();
    }

    public void apply() {
        Texture texture = this.getMainTexture();
        GL11.glViewport((int)0, (int)0, (int)texture.width, (int)texture.height);
        this.bind();
    }

    public void clear() {
        if (this.advancedClearing) {
            int i = 0;
            for (Texture texture : this.textures) {
                if (texture.getFormat().isColor()) {
                    if (texture.isClearable()) {
                        GL30.glClearBufferfv((int)6144, (int)i, (float[])CLEAR_COLOR);
                    }
                    ++i;
                    continue;
                }
                if (!texture.isClearable()) continue;
                GL30.glClearBufferfv((int)6145, (int)0, (float[])CLEAR_DEPTH);
            }
        } else {
            GL11.glClear((int)16640);
        }
    }

    public void bind() {
        GL30.glBindFramebuffer((int)36160, (int)this.id);
    }

    public void unbind() {
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    public void resize(int w, int h) {
        for (Texture texture : this.textures) {
            texture.bind();
            texture.setSize(w, h);
        }
        for (Renderbuffer renderbuffer : this.renderbuffers) {
            renderbuffer.bind();
            renderbuffer.resize(w, h);
            renderbuffer.unbind();
        }
    }

    public void delete() {
        GL30.glDeleteFramebuffers((int)this.id);
        if (this.deleteTextures) {
            for (Texture texture : this.textures) {
                texture.delete();
            }
            this.textures.clear();
        }
        for (Renderbuffer renderbuffer : this.renderbuffers) {
            renderbuffer.delete();
        }
        this.renderbuffers.clear();
    }
}

